/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.object.KeyValueObject;
import com.activetree.common.resource.AtCommonResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class PageHandlingPane
extends JPanel {
    protected JLabel copiesLabel;
    protected JSpinner spinControl;
    protected JCheckBox collateCheck;
    protected JCheckBox fitToPageCheck;
    protected JCheckBox usePrinterMarginsCheck;
    protected JCheckBox choosePaperSourceByPageSizeCheck;
    protected JLabel pageScalingLabel;
    protected JComboBox pageScalingCombo;
    protected Vector pageScalingComboModel;
    protected JCheckBox autoRotateAndCenterCheck;

    public PageHandlingPane() {
        this.setupContentPane();
        this.postInit();
    }

    protected void setupContentPane() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_PROPERTIES"), 1, 2, null));
        JPanel row1Top = new JPanel(new GridBagLayout());
        this.copiesLabel = new JLabel();
        this.copiesLabel.setVerticalAlignment(0);
        this.copiesLabel.setText(AtCommonResource.MESSAGE_RESOURCE.getText("COPIES"));
        this.copiesLabel.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("COPIES_TOOLTIP"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        row1Top.add((Component)this.copiesLabel, gridBagConstraints);
        SpinnerNumberModel copySpinModel = new SpinnerNumberModel(1, 1, 100, 1);
        this.spinControl = new JSpinner();
        this.spinControl.setModel(copySpinModel);
        this.copiesLabel.setLabelFor(this.spinControl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        row1Top.add((Component)this.spinControl, gridBagConstraints);
        this.collateCheck = new JCheckBox();
        this.collateCheck.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("COLLATE"));
        this.collateCheck.setText(AtCommonResource.MESSAGE_RESOURCE.getText("COLLATE"));
        this.collateCheck.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("COLLATE_COPIES"));
        this.collateCheck.setActionCommand("COLLATE");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        row1Top.add((Component)this.collateCheck, gridBagConstraints);
        this.usePrinterMarginsCheck = new JCheckBox();
        this.usePrinterMarginsCheck.setSelected(true);
        this.usePrinterMarginsCheck.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("IS_USE_PRINTER_MARGINS"));
        this.usePrinterMarginsCheck.setText(AtCommonResource.MESSAGE_RESOURCE.getText("IS_USE_PRINTER_MARGINS"));
        this.usePrinterMarginsCheck.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("IS_USE_PRINTER_MARGINS_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        row1Top.add((Component)this.usePrinterMarginsCheck, gridBagConstraints);
        this.fitToPageCheck = new JCheckBox();
        this.fitToPageCheck.setSelected(true);
        this.fitToPageCheck.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("FIT_TO_PAGE"));
        this.fitToPageCheck.setText(AtCommonResource.MESSAGE_RESOURCE.getText("FIT_TO_PAGE"));
        this.fitToPageCheck.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("FIT_TO_PAGE_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        row1Top.add((Component)this.fitToPageCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)row1Top, gridBagConstraints);
        JPanel row2Top = new JPanel(new GridBagLayout());
        this.choosePaperSourceByPageSizeCheck = new JCheckBox();
        this.choosePaperSourceByPageSizeCheck.setSelected(false);
        this.choosePaperSourceByPageSizeCheck.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("IS_CHOOSE_PAPER_SOURCE_BY_PAGE_SIZE"));
        this.choosePaperSourceByPageSizeCheck.setText(AtCommonResource.MESSAGE_RESOURCE.getText("IS_CHOOSE_PAPER_SOURCE_BY_PAGE_SIZE"));
        this.choosePaperSourceByPageSizeCheck.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("IS_CHOOSE_PAPER_SOURCE_BY_PAGE_SIZE_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        row2Top.add((Component)this.choosePaperSourceByPageSizeCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)row2Top, gridBagConstraints);
        JPanel row3Top = new JPanel(new GridBagLayout());
        KeyValueObject scaleNone = new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("None"), 10.0);
        KeyValueObject scaleFit = new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("FitToPrintableArea"), 11.0);
        KeyValueObject scaleShrinkFit = new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("ShrinkToPrintableArea"), 12.0);
        this.pageScalingComboModel = new Vector();
        this.pageScalingComboModel.add(scaleNone);
        this.pageScalingComboModel.add(scaleFit);
        this.pageScalingComboModel.add(scaleShrinkFit);
        this.pageScalingCombo = new JComboBox(this.pageScalingComboModel);
        String pageScalingText = AtCommonResource.MESSAGE_RESOURCE.getText("PageScaling");
        char mnemonic = AtCommonResource.MESSAGE_RESOURCE.getMnemonic("PageScaling");
        String tooltip = AtCommonResource.MESSAGE_RESOURCE.getTooltip("PageScaling");
        this.pageScalingLabel = new JLabel(pageScalingText);
        this.pageScalingLabel.setVerticalAlignment(0);
        this.pageScalingLabel.setLabelFor(this.pageScalingCombo);
        this.pageScalingLabel.setDisplayedMnemonic(mnemonic);
        this.pageScalingLabel.setToolTipText(tooltip);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        row3Top.add((Component)this.pageScalingLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        row3Top.add((Component)this.pageScalingCombo, gridBagConstraints);
        this.autoRotateAndCenterCheck = new JCheckBox();
        this.autoRotateAndCenterCheck.setSelected(true);
        this.autoRotateAndCenterCheck.setText(AtCommonResource.MESSAGE_RESOURCE.getText("AutoRotateAndCenter"));
        this.autoRotateAndCenterCheck.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("AutoRotateAndCenter"));
        this.autoRotateAndCenterCheck.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getTooltip("AutoRotateAndCenter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        row3Top.add((Component)this.autoRotateAndCenterCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)row3Top, gridBagConstraints);
    }

    protected void postInit() {
        this.setPageScaling(11);
        this.setAutoRotateAndCenterSelected(true);
    }

    public void refresh() {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.copiesLabel.setEnabled(enabled);
        this.spinControl.setEnabled(enabled);
        this.collateCheck.setEnabled(enabled);
        this.fitToPageCheck.setEnabled(enabled);
        this.usePrinterMarginsCheck.setEnabled(enabled);
        this.choosePaperSourceByPageSizeCheck.setEnabled(enabled);
        this.pageScalingLabel.setEnabled(enabled);
        this.pageScalingCombo.setEnabled(enabled);
        this.autoRotateAndCenterCheck.setEnabled(enabled);
    }

    public void setCopiesLable(String label) {
        this.copiesLabel.setText(label);
    }

    public void setCopiesLabelVisible(boolean visible) {
        this.copiesLabel.setVisible(visible);
    }

    public void setCopiesLabelEnabled(boolean enabled) {
        this.copiesLabel.setEnabled(enabled);
    }

    public void setCopies(int copies) {
        this.spinControl.setValue(new Integer(copies));
    }

    public void setSpinControlVisible(boolean visible) {
        this.spinControl.setVisible(visible);
    }

    public void setSpinControlEnabled(boolean enabled) {
        this.spinControl.setEnabled(enabled);
    }

    public void setCopiesSpinControlEnabled(boolean enabled) {
        this.setSpinControlEnabled(enabled);
        this.setCopiesLabelEnabled(enabled);
    }

    public int getCopies() {
        try {
            Integer obj = (Integer)this.spinControl.getValue();
            return obj;
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    public String getCollateLabel() {
        return this.collateCheck.getText();
    }

    public void setCollateLabel(String label) {
        this.collateCheck.setText(label);
    }

    public void setCollateVisible(boolean visible) {
        this.collateCheck.setVisible(visible);
    }

    public void setCollateEnabled(boolean enabled) {
        this.collateCheck.setEnabled(enabled);
    }

    public boolean isCollateEnabled() {
        return this.collateCheck.isSelected();
    }

    public boolean isCollate() {
        return this.collateCheck.isSelected();
    }

    public void setCollate(boolean collate) {
        this.collateCheck.setSelected(collate);
    }

    public String getFitToPageLabel() {
        return this.fitToPageCheck.getText();
    }

    public void setFitToPageLabel(String label) {
        this.fitToPageCheck.setText(label);
    }

    public void setFitToPageVisible(boolean visible) {
        this.fitToPageCheck.setVisible(visible);
    }

    public void setFitToPageEnabled(boolean enabled) {
        this.fitToPageCheck.setEnabled(enabled);
    }

    public void setFitToPage(boolean fitToPage) {
        this.fitToPageCheck.setSelected(fitToPage);
    }

    public boolean isFitToPage() {
        return this.fitToPageCheck.isSelected();
    }

    public void setUsePrinterMarginsEnabled(boolean enabled) {
        this.usePrinterMarginsCheck.setEnabled(enabled);
    }

    public boolean isUsePrinterMargins() {
        return this.usePrinterMarginsCheck.isSelected();
    }

    public void setUsePrinterMargins(boolean usePrinterMargins) {
        this.usePrinterMarginsCheck.setSelected(usePrinterMargins);
    }

    public void setUsePrinterMarginsLabel(String label) {
        this.usePrinterMarginsCheck.setText(label);
    }

    public String getUsePrinterMarginsLabel() {
        return this.usePrinterMarginsCheck.getText();
    }

    public void setUsePrinterMarginsVisible(boolean visible) {
        this.usePrinterMarginsCheck.setVisible(visible);
    }

    public void setChoosePaperSourceByPageSizeLabel(String label) {
        this.choosePaperSourceByPageSizeCheck.setText(label);
    }

    public String getChoosePaperSourceByPageSizeLabel() {
        return this.choosePaperSourceByPageSizeCheck.getText();
    }

    public boolean isChoosePaperSourceByPageSize() {
        return this.choosePaperSourceByPageSizeCheck.isSelected();
    }

    public void setChoosePaperSourceByPageSize(boolean selected) {
        this.choosePaperSourceByPageSizeCheck.setSelected(selected);
    }

    public void setChoosePaperSourceByPageSizeEnabled(boolean enabled) {
        this.choosePaperSourceByPageSizeCheck.setEnabled(enabled);
    }

    public void setChoosePaperSourceByPageSizeVisible(boolean visible) {
        this.choosePaperSourceByPageSizeCheck.setVisible(visible);
    }

    public void setPageScalingLabel(String label) {
        this.pageScalingLabel.setText(label);
    }

    public boolean setPageScaling(int pageScaling) {
        for (int i = 0; i < this.pageScalingComboModel.size(); ++i) {
            KeyValueObject item = (KeyValueObject)this.pageScalingComboModel.get(i);
            if (item.getValue() != (double)pageScaling) continue;
            this.pageScalingCombo.setSelectedItem(item);
            return true;
        }
        return false;
    }

    public int getPageScaling() {
        KeyValueObject item = (KeyValueObject)this.pageScalingCombo.getSelectedItem();
        return (int)item.getValue();
    }

    public void setAutoRotateAndCenterEnabled(boolean enabled) {
        this.autoRotateAndCenterCheck.setEnabled(enabled);
    }

    public void setAutoRotateAndCenterVisible(boolean visible) {
        this.autoRotateAndCenterCheck.setVisible(visible);
    }

    public void setAutoRotateAndCenterSelected(boolean selected) {
        this.autoRotateAndCenterCheck.setSelected(selected);
    }

    public boolean isAutoRotateAndCenter() {
        return this.autoRotateAndCenterCheck.isSelected();
    }

    public JLabel getCopiesLabel() {
        return this.copiesLabel;
    }

    public JLabel getPageScalingLabel() {
        return this.pageScalingLabel;
    }

    public JSpinner getSpinControl() {
        return this.spinControl;
    }

    public JCheckBox getCollateCheck() {
        return this.collateCheck;
    }

    public JCheckBox getFitToPageCheck() {
        return this.fitToPageCheck;
    }

    public JCheckBox getUsePrinterMarginsCheck() {
        return this.usePrinterMarginsCheck;
    }

    public JCheckBox getChoosePaperSourceByPageSizeCheck() {
        return this.choosePaperSourceByPageSizeCheck;
    }

    public JComboBox getPageScalingCombo() {
        return this.pageScalingCombo;
    }

    public Vector getPageScalingComboModel() {
        return this.pageScalingComboModel;
    }

    public JCheckBox getAutoRotateAndCenterCheck() {
        return this.autoRotateAndCenterCheck;
    }
}

