/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtInsetsPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PageSelectionDialog
extends JDialog
implements ActionListener {
    static final String OK_CMD = "OK_CMD";
    static final String CANCEL_CMD = "CANCEL_CMD";
    protected boolean okPressed = false;
    protected JScrollPane listScroll;
    protected JList list;
    protected JButton okButton;
    protected JButton cancelButton;
    protected Vector listData;
    protected JCheckBox allPages;

    public PageSelectionDialog(Frame owner, String title, boolean modal, Vector listData) {
        super(owner, title, modal);
        this.listData = listData;
        this.setupContentPane();
    }

    public PageSelectionDialog(Dialog owner, String title, boolean modal, Vector listData) {
        super(owner, title, modal);
        this.listData = listData;
        this.setupContentPane();
    }

    protected void setupContentPane() {
        this.list = new JList(this.listData);
        this.list.setVisibleRowCount(8);
        this.list.setEnabled(false);
        this.listScroll = new JScrollPane(this.list);
        this.allPages = new JCheckBox(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_APPLY_TO_ALL_PAGES"), true);
        this.allPages.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_APPLY_TO_ALL_PAGES"));
        this.allPages.addActionListener(this);
        this.okButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_DONE"));
        this.okButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_DONE"));
        this.okButton.setActionCommand(OK_CMD);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Cancel"));
        this.cancelButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_Cancel"));
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.cancelButton.addActionListener(this);
        JPanel buttonPane = new JPanel(new FlowLayout(4, 5, 0));
        buttonPane.add(this.okButton);
        buttonPane.add(this.cancelButton);
        AtInsetsPanel top = new AtInsetsPanel(new GridBagLayout());
        top.setInsets(new Insets(5, 5, 5, 5));
        top.add((Component)new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_APPLY_WATERMARK_TO_SELECTED_PAGES")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        top.add((Component)this.listScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        top.add((Component)this.allPages, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        top.add((Component)buttonPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setContentPane(top);
    }

    public int[] getSelectedIndexes() {
        if (this.allPages.isSelected() && this.listData != null) {
            int[] idxs = new int[this.listData.size()];
            for (int i = 0; i < this.listData.size(); ++i) {
                idxs[i] = i;
            }
            return idxs;
        }
        return this.list.getSelectedIndices();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(OK_CMD)) {
            this.okPressed = true;
            this.setVisible(false);
        } else if (cmd.equals(CANCEL_CMD)) {
            this.okPressed = false;
            this.setVisible(false);
            this.dispose();
        } else if (evt.getSource() == this.allPages) {
            this.list.setEnabled(true);
        }
    }
}

