/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.print.dialog.PageComponent;
import com.activetree.common.print.dialog.PaperSelectionPane;
import com.activetree.common.print.dialog.RangeSelectionPane;
import com.activetree.common.resource.AtImageList;
import com.activetree.common.swing.AtInsetsPanel;
import com.activetree.common.swing.OkCancelButtonPane;
import com.activetree.common.utils.MediaUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class PaperSelectionDialog
extends JDialog {
    protected PageComponent pageComponent;

    public PaperSelectionDialog(Dialog dialog, String title, boolean modal) {
        this(dialog, title, modal, (MediaSizeName)null);
    }

    public PaperSelectionDialog(Dialog dialog, String title, boolean modal, MediaSizeName defaultMedia) {
        super(dialog, title, modal);
        this.setupContentPane(dialog, defaultMedia);
    }

    public PaperSelectionDialog(Frame frame, String title, boolean modal) {
        this(frame, title, modal, (MediaSizeName)null);
    }

    public PaperSelectionDialog(Frame frame, String title, boolean modal, MediaSizeName defaultMedia) {
        super(frame, title, modal);
        this.setupContentPane(frame, defaultMedia);
    }

    public void setupContentPane(Component owner, MediaSizeName defaultMedia) {
        this.pageComponent = this.createPageComponent(owner, defaultMedia);
        AtInsetsPanel insetPane = new AtInsetsPanel(new GridBagLayout());
        insetPane.setInsets(new Insets(5, 5, 5, 5));
        insetPane.add((Component)this.pageComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        Container c = this.getContentPane();
        c.removeAll();
        c.setLayout(new GridBagLayout());
        c.add((Component)insetPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        this.addOkCancelActionListener();
        this.addWindowCloseListener();
    }

    protected PageComponent createPageComponent(Component owner, MediaSizeName defaultMedia) {
        PageComponent paperComponent = new PageComponent(owner, defaultMedia);
        return paperComponent;
    }

    protected void addWindowCloseListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PaperSelectionDialog.this.pageComponent.getOkCancelButtonPane().cancel();
            }
        });
    }

    protected void addOkCancelActionListener() {
        ActionListener l2 = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaperSelectionDialog.this.makeInvisible();
            }
        };
        this.pageComponent.getOkCancelButtonPane().addActionListener(l2);
    }

    private void makeInvisible() {
        this.hide();
    }

    public void refresh() {
        this.pageComponent.refresh();
    }

    public PageComponent getPageComponent() {
        return this.pageComponent;
    }

    public boolean showPageDialog() {
        return this.showPageDialog(true);
    }

    public boolean showPageDialog(boolean visible) {
        OkCancelButtonPane okCancelButtonPane = this.pageComponent.getOkCancelButtonPane();
        okCancelButtonPane.setOkPressed(false);
        super.setVisible(visible);
        boolean okPressed = okCancelButtonPane.isOkPressed();
        return okPressed;
    }

    public void setVisible(boolean visible) {
    }

    public AtMediaSizeObject getSelectedPaper() {
        PaperSelectionPane paperPane = this.pageComponent.getPaperSelectionPane();
        AtMediaSizeObject mso = paperPane.getSelectedPaper();
        return mso;
    }

    public PageFormat getSelectedPageFormat() {
        PaperSelectionPane paperPane = this.pageComponent.getPaperSelectionPane();
        PageFormat pf = paperPane.getSelectedPageFormat();
        return pf;
    }

    public int[] getSelectedPages() {
        RangeSelectionPane rangePane = this.pageComponent.getRangeSelectionPane();
        int[] rangeOfPages = rangePane.getRangeOfPages();
        return rangeOfPages;
    }

    public static void main(String[] args) {
        JFrame dummy = new JFrame();
        dummy.setIconImage(AtImageList.IMAGE_LIST.ACTIVETREE_ICON_SMALL.getImage());
        PaperSelectionDialog d = new PaperSelectionDialog(dummy, "Paper Selection", true);
        boolean accepted = d.showPageDialog(true);
        System.out.println("accepted=" + accepted);
        System.out.println("selected paper: " + d.getSelectedPaper());
        System.out.println("selected page format: " + MediaUtil.getDebugString(d.getSelectedPageFormat()));
        System.exit(0);
    }
}

