/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.media.AtPrintServiceObject;
import com.activetree.common.media.StandardPapers;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtAbstractDocument;
import com.activetree.common.swing.AtTextField;
import com.activetree.common.swing.ComboPane;
import com.activetree.common.utils.AtDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class PaperSelectionPane
extends ComboPane {
    protected final Vector paperOrientationListeners = new Vector();
    protected final Vector paperComboModel = new Vector();
    protected final Vector sourceComboModel = new Vector();
    protected Component owner;
    protected boolean showStandardPapers = false;
    protected JLabel paperNameLabel;
    protected MediaSizeName defaultMedia = MediaSizeName.NA_LETTER;
    protected JComboBox paperCombo;
    protected JLabel paperSourceNameLabel;
    protected JComboBox paperSourceCombo;
    protected JLabel leftMargin;
    protected AtTextField leftMarginEntry;
    protected JLabel topMargin;
    protected AtTextField topMarginEntry;
    protected JLabel rightMargin;
    protected AtTextField rightMarginEntry;
    protected JLabel bottomMargin;
    protected AtTextField bottomMarginEntry;
    protected JRadioButton portraitRadio;
    protected JRadioButton landscapeRadio;
    protected ButtonGroup orientationButtonGroup;
    protected AtMediaSizeObject lastMediaSizeObject;
    protected final Vector paperMarginChangeListeners = new Vector();

    public PaperSelectionPane() {
        this((Component)null);
    }

    public PaperSelectionPane(Component owner) {
        this(owner, false);
    }

    public PaperSelectionPane(Component owner, boolean showStandardPapersOnly) {
        this(owner, showStandardPapersOnly, MediaSizeName.NA_LETTER);
    }

    public PaperSelectionPane(Component owner, boolean showStandardPapersOnly, MediaSizeName defaultMediaSizeName) {
        this.owner = owner;
        this.showStandardPapers = showStandardPapersOnly;
        this.defaultMedia = defaultMediaSizeName;
        if (this.defaultMedia == null) {
            this.defaultMedia = this.createDefaultMediaSizeName();
        }
        this.populateStandardPapers();
        this.setupContentPane();
        this.selectPaper(this.getDefaultMediaSizeName());
        this.addPaperSelectionChangeListener();
        this.addMarginChangeListener();
        this.addPageFormatButtonActionListeners();
        this.postInit();
    }

    protected MediaSizeName createDefaultMediaSizeName() {
        PageFormat pf = new PageFormat();
        Rectangle2D.Double area = new Rectangle2D.Double(0.0, 0.0, pf.getWidth(), pf.getHeight());
        AtMediaSizeObject mso = StandardPapers.getMatchedMediaSizeObject(area, 0.0, 0.0, pf.getOrientation());
        MediaSizeName msn = null;
        msn = mso != null ? mso.getMediaSizeName() : MediaSizeName.NA_LETTER;
        return msn;
    }

    protected void setupContentPane() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, AtCommonResource.MESSAGE_RESOURCE.getText("PAPER"), 1, 2, null));
        GridBagConstraints gridBagConstraints = null;
        this.paperNameLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("NAME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.paperNameLabel, gridBagConstraints);
        this.paperCombo = new JComboBox(this.paperComboModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.paperCombo, gridBagConstraints);
        this.paperSourceNameLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("Paper_Source"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.paperSourceNameLabel, gridBagConstraints);
        this.paperSourceCombo = new JComboBox(this.sourceComboModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.paperSourceCombo, gridBagConstraints);
        this.leftMargin = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("LEFT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.leftMargin, gridBagConstraints);
        this.leftMarginEntry = new AtTextField(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"), 4);
        this.leftMarginEntry.setDocument(new DoubleTypeDocument());
        this.leftMarginEntry.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.leftMarginEntry, gridBagConstraints);
        this.topMargin = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("TOP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.topMargin, gridBagConstraints);
        this.topMarginEntry = new AtTextField(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"), 4);
        this.topMarginEntry.setDocument(new DoubleTypeDocument());
        this.topMarginEntry.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.topMarginEntry, gridBagConstraints);
        this.rightMargin = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("RIGHT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.rightMargin, gridBagConstraints);
        this.rightMarginEntry = new AtTextField(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"), 4);
        this.rightMarginEntry.setDocument(new DoubleTypeDocument());
        this.rightMarginEntry.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.rightMarginEntry, gridBagConstraints);
        this.bottomMargin = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("BOTTOM"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.bottomMargin, gridBagConstraints);
        this.bottomMarginEntry = new AtTextField(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"), 4);
        this.bottomMarginEntry.setDocument(new DoubleTypeDocument());
        this.bottomMarginEntry.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.bottomMarginEntry, gridBagConstraints);
        this.orientationButtonGroup = new ButtonGroup();
        this.portraitRadio = new JRadioButton();
        this.portraitRadio.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("PORTRAIT"));
        this.portraitRadio.setSelected(true);
        this.portraitRadio.setText(AtCommonResource.MESSAGE_RESOURCE.getText("PORTRAIT"));
        this.portraitRadio.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("PORTRAIT_TOOLTIP"));
        this.orientationButtonGroup.add(this.portraitRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.portraitRadio, gridBagConstraints);
        this.landscapeRadio = new JRadioButton();
        this.landscapeRadio.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("LANDSCAPE"));
        this.landscapeRadio.setText(AtCommonResource.MESSAGE_RESOURCE.getText("LANDSCAPE"));
        this.landscapeRadio.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("LANDSCAPE_TOOLTIP"));
        this.orientationButtonGroup.add(this.landscapeRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.landscapeRadio, gridBagConstraints);
    }

    protected void postInit() {
        this.setPaperSourceVisible(false);
        this.portraitRadio.setSelected(true);
    }

    protected void addPageFormatButtonActionListeners() {
        ActionListener orientationChangeListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaperSelectionPane.this.notifyOrientationChangeListeners(evt);
            }
        };
        this.portraitRadio.addActionListener(orientationChangeListener);
        this.landscapeRadio.addActionListener(orientationChangeListener);
    }

    protected void addPaperSelectionChangeListener() {
        this.paperCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                AtMediaSizeObject selectedMedia = PaperSelectionPane.this.getSelectedPaper();
                if (PaperSelectionPane.this.lastMediaSizeObject == selectedMedia) {
                    return;
                }
                PaperSelectionPane.this.notifySelectionChangeListeners(evt);
                PaperSelectionPane.this.lastMediaSizeObject = selectedMedia;
            }
        });
    }

    protected void populateStandardPapers() {
        if (this.isShowStandardMediaPapers()) {
            this.paperComboModel.clear();
            Media[] media = StandardPapers.getStandardMedia();
            this.populateMedia(media);
        }
    }

    public void updatePaper(AtPrintServiceObject psObj) {
        this.paperComboModel.clear();
        Media[] media = this.getMediaForPrintService(psObj);
        this.populateMedia(media);
        this.selectPaper(this.getDefaultMediaSizeName());
    }

    private void populateMedia(Media[] media) {
        int i = 0;
        for (i = 0; media != null && i < media.length; ++i) {
            Media m = media[i];
            if (m instanceof MediaSizeName) {
                if (!this.isFound((MediaSizeName)m)) continue;
                MediaSizeName mediaSizeName = (MediaSizeName)m;
                AtMediaSizeObject mediaSizeObject = new AtMediaSizeObject(mediaSizeName);
                String mediaNameString = mediaSizeObject.getMediaName();
                if (mediaNameString != null) {
                    this.paperComboModel.add(mediaSizeObject);
                    continue;
                }
                AtDebug.debug("[" + mediaSizeObject + "] -- did not have a name to display. Not showing it.");
                continue;
            }
            if (!(m instanceof MediaTray)) continue;
            MediaTray tray = (MediaTray)m;
            String trayName = tray.getName();
            int trayNumber = tray.getValue();
        }
    }

    private void selectPaper(MediaSizeName newMedia) {
        AtMediaSizeObject defaultSelMediaName = null;
        int selIdx = -1;
        for (int i = 0; newMedia != null && this.paperComboModel != null && i < this.paperComboModel.size(); ++i) {
            AtMediaSizeObject aMedia = (AtMediaSizeObject)this.paperComboModel.get(i);
            MediaSizeName sizeName = aMedia.getMediaSizeName();
            if (sizeName != newMedia) continue;
            defaultSelMediaName = aMedia;
            selIdx = i;
            break;
        }
        if (defaultSelMediaName == null && this.paperComboModel != null && this.paperComboModel.size() > 0) {
            defaultSelMediaName = (AtMediaSizeObject)this.paperComboModel.get(0);
            selIdx = 0;
        }
        if (selIdx >= 0) {
            this.paperCombo.setSelectedIndex(selIdx);
        }
    }

    protected void addMarginChangeListener() {
        MarginChangeListener marginChangeListener = new MarginChangeListener(this);
        this.leftMarginEntry.getDocument().addDocumentListener(marginChangeListener);
        this.rightMarginEntry.getDocument().addDocumentListener(marginChangeListener);
        this.topMarginEntry.getDocument().addDocumentListener(marginChangeListener);
        this.bottomMarginEntry.getDocument().addDocumentListener(marginChangeListener);
        MarginFocusListener marginFocusListener = new MarginFocusListener();
        this.leftMarginEntry.addFocusListener(marginFocusListener);
        this.rightMarginEntry.addFocusListener(marginFocusListener);
        this.topMarginEntry.addFocusListener(marginFocusListener);
        this.bottomMarginEntry.addFocusListener(marginFocusListener);
    }

    public void refresh() {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.paperNameLabel.setEnabled(enabled);
        this.paperCombo.setEnabled(enabled);
        this.paperSourceNameLabel.setEnabled(enabled);
        this.paperSourceCombo.setEnabled(enabled);
        this.leftMargin.setEnabled(enabled);
        this.leftMarginEntry.setEnabled(enabled);
        this.topMargin.setEnabled(enabled);
        this.topMarginEntry.setEnabled(enabled);
        this.rightMargin.setEnabled(enabled);
        this.rightMarginEntry.setEnabled(enabled);
        this.bottomMargin.setEnabled(enabled);
        this.bottomMarginEntry.setEnabled(enabled);
        this.portraitRadio.setEnabled(enabled);
        this.landscapeRadio.setEnabled(enabled);
    }

    public void setOwner(Component owner) {
        this.owner = owner;
    }

    public Component getOwner() {
        return this.owner;
    }

    public boolean addPaperOrientationChangeListener(ActionListener l2) {
        if (!this.paperOrientationListeners.contains(l2)) {
            return this.paperOrientationListeners.add(l2);
        }
        return false;
    }

    public boolean removePaperOrientationListener(ActionListener l2) {
        boolean removed = this.paperOrientationListeners.remove(l2);
        return removed;
    }

    public void removeAllPaperOrientationChangeListener() {
        this.paperOrientationListeners.removeAllElements();
    }

    protected void notifyOrientationChangeListeners(ActionEvent evt) {
        for (int i = 0; i < this.paperOrientationListeners.size(); ++i) {
            ActionListener l2 = (ActionListener)this.paperOrientationListeners.get(i);
            l2.actionPerformed(evt);
        }
    }

    public boolean addPaperMarginChangeListener(PropertyChangeListener l2) {
        if (!this.paperMarginChangeListeners.contains(l2)) {
            boolean added = this.paperMarginChangeListeners.add(l2);
            return added;
        }
        return false;
    }

    public boolean removePaperMarginChangeListener(PropertyChangeListener l2) {
        boolean removed = this.paperMarginChangeListeners.remove(l2);
        return removed;
    }

    public void removeAllPaperMarginChangeListeners() {
        this.paperMarginChangeListeners.removeAllElements();
    }

    protected void notifyPaperMarginChangeListeners(Double[] oldMargins, Double[] newMargins) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "PaperMargins", oldMargins, newMargins);
        for (int i = 0; i < this.paperMarginChangeListeners.size(); ++i) {
            PropertyChangeListener l2 = (PropertyChangeListener)this.paperMarginChangeListeners.get(i);
            l2.propertyChange(pce);
        }
    }

    public void setDefaultMediaSizeName(MediaSizeName defaultMedia) {
        this.defaultMedia = defaultMedia;
    }

    public MediaSizeName getDefaultMediaSizeName() {
        return this.defaultMedia;
    }

    public MediaSizeName getSelectedMediaSizeName() {
        AtMediaSizeObject mso = (AtMediaSizeObject)this.paperCombo.getSelectedItem();
        if (mso != null) {
            return mso.getMediaSizeName();
        }
        return null;
    }

    public MediaSize getSelectedMediaSize() {
        AtMediaSizeObject mso = (AtMediaSizeObject)this.paperCombo.getSelectedItem();
        if (mso != null) {
            return mso.getMediaSize();
        }
        return null;
    }

    public void setMediaSizeSelected(MediaSize mediaSize) {
        double mediaHeight;
        double mediaWidth = mediaSize.getX(1);
        int foundMediaIndex = this.getMatchingMediaIndexBySize(mediaWidth, mediaHeight = (double)mediaSize.getY(1));
        if (foundMediaIndex != -1) {
            this.paperCombo.setSelectedIndex(foundMediaIndex);
        }
    }

    public void setMediaSizeSelected(PageFormat pf) {
        double mediaHeight;
        double mediaWidth = pf.getPaper().getWidth();
        int foundMediaIndex = this.getMatchingMediaIndexBySize(mediaWidth, mediaHeight = pf.getPaper().getHeight());
        if (foundMediaIndex != -1) {
            this.paperCombo.setSelectedIndex(foundMediaIndex);
        }
    }

    public int getMatchingMediaIndexBySize(double width, double height) {
        double mediaWidth = width;
        double mediaHeight = height;
        int selectionIndex = -1;
        int mCount = this.paperCombo.getModel().getSize();
        for (int i = 0; i < mCount; ++i) {
            AtMediaSizeObject aMedia = (AtMediaSizeObject)this.paperCombo.getModel().getElementAt(i);
            if (aMedia == null || aMedia.getMediaWidthPixel() != mediaWidth || aMedia.getMediaHeightPixel() != mediaHeight) continue;
            selectionIndex = i;
            break;
        }
        return selectionIndex;
    }

    public void setMediaSizeNameSelected(MediaSizeName mediaSizeName) {
        if (mediaSizeName == null) {
            return;
        }
        this.lastMediaSizeObject = new AtMediaSizeObject(mediaSizeName);
        this.selectPaper(mediaSizeName);
    }

    public double getSelectedPaperWidth() {
        int selectedIndex = this.paperCombo.getSelectedIndex();
        AtMediaSizeObject pso = (AtMediaSizeObject)this.paperCombo.getSelectedItem();
        if (pso == null && selectedIndex >= 0) {
            pso = (AtMediaSizeObject)this.paperComboModel.get(selectedIndex);
        }
        double paperWidth = -1.0;
        if (pso != null) {
            paperWidth = pso.getMediaWidthPixel();
        }
        return paperWidth;
    }

    public double getSelectedPaperHeight() {
        int selectedIndex = this.paperCombo.getSelectedIndex();
        AtMediaSizeObject pso = (AtMediaSizeObject)this.paperCombo.getSelectedItem();
        if (pso == null && selectedIndex >= 0) {
            pso = (AtMediaSizeObject)this.paperComboModel.get(selectedIndex);
        }
        double paperHeight = -1.0;
        if (pso != null) {
            paperHeight = pso.getMediaHeightPixel();
        }
        return paperHeight;
    }

    public void setPaperComboEnabled(boolean enabled) {
        this.paperCombo.setEnabled(enabled);
    }

    public boolean isPaperComboEnabled() {
        return this.paperCombo.isEnabled();
    }

    public AtMediaSizeObject getSelectedPaper() {
        AtMediaSizeObject mso = (AtMediaSizeObject)this.paperCombo.getSelectedItem();
        return mso;
    }

    public void setPaperSelectionIndex(int idx) {
        this.paperCombo.setSelectedIndex(idx);
    }

    public void setPaperSourceVisible(boolean visible) {
        this.paperSourceNameLabel.setVisible(false);
        this.paperSourceCombo.setVisible(false);
    }

    public double getLeftMargin() {
        double leftMargin = 72.0;
        String leftMarginStr = this.leftMarginEntry.getText();
        try {
            leftMargin = Double.parseDouble(leftMarginStr);
            leftMargin *= 72.0;
        }
        catch (Throwable t) {
            // empty catch block
        }
        return leftMargin;
    }

    public void setLeftMargin(double leftMargin) {
        if (leftMargin < 0.0) {
            leftMargin = 0.0;
        }
        this.leftMarginEntry.setText(String.valueOf(leftMargin));
    }

    public PageFormat getSelectedPageFormat() {
        AtMediaSizeObject mObj = this.getSelectedPaper();
        double paperWidth = mObj.getMediaWidthPixel();
        double paperHeight = mObj.getMediaHeightPixel();
        double leftMargin = this.getLeftMargin();
        double rightMargin = this.getRightMargin();
        double topMargin = this.getTopMargin();
        double bottomMargin = this.getBottomMargin();
        int orientation = this.getPaperOrientation();
        Paper paper = new Paper();
        paper.setSize(paperWidth, paperHeight);
        double imageableWidth = paperWidth - (leftMargin + rightMargin);
        double imageableHeight = paperHeight - (topMargin + bottomMargin);
        if (orientation == 0) {
            imageableWidth = paperWidth - (topMargin + bottomMargin);
            imageableHeight = paperHeight - (leftMargin + rightMargin);
        }
        if (orientation == 0) {
            paper.setImageableArea(topMargin, rightMargin, imageableWidth, imageableHeight);
        } else {
            paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        }
        AtDebug.debug("AtPrintDialog.getSelectedPageFormat(): (" + leftMargin + "," + topMargin + "," + imageableWidth + "," + imageableHeight + ")");
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public double getTopMargin() {
        double topMargin = 72.0;
        String topMarginStr = this.topMarginEntry.getText();
        try {
            topMargin = Double.parseDouble(topMarginStr);
            topMargin *= 72.0;
        }
        catch (Throwable t) {
            // empty catch block
        }
        return topMargin;
    }

    public void setTopMargin(double topMargin) {
        if (topMargin < 0.0) {
            topMargin = 0.0;
        }
        this.topMarginEntry.setText(String.valueOf(topMargin));
    }

    public double getRightMargin() {
        double rightMargin = 72.0;
        String rightMarginStr = this.rightMarginEntry.getText();
        try {
            rightMargin = Double.parseDouble(rightMarginStr);
            rightMargin *= 72.0;
        }
        catch (Throwable t) {
            // empty catch block
        }
        return rightMargin;
    }

    public void setRightMargin(double rightMargin) {
        if (rightMargin < 0.0) {
            rightMargin = 0.0;
        }
        this.rightMarginEntry.setText(String.valueOf(rightMargin));
    }

    public double getBottomMargin() {
        double bottomMargin = 72.0;
        String bottomMarginStr = this.bottomMarginEntry.getText();
        try {
            bottomMargin = Double.parseDouble(bottomMarginStr);
            bottomMargin *= 72.0;
        }
        catch (Throwable t) {
            // empty catch block
        }
        return bottomMargin;
    }

    public void setBottomMargin(double bottomMargin) {
        if (bottomMargin < 0.0) {
            bottomMargin = 0.0;
        }
        this.bottomMarginEntry.setText(String.valueOf(bottomMargin));
    }

    public void setOrientationRadioButtonsEnabled(boolean enabled) {
        this.portraitRadio.setEnabled(enabled);
        this.landscapeRadio.setEnabled(enabled);
    }

    public void setPortraitOrientationRadioButtonEnabled(boolean enabled) {
        this.portraitRadio.setEnabled(enabled);
    }

    public void setPaperOrientation(int orientation) {
        if (orientation == 0) {
            this.orientationButtonGroup.setSelected(this.landscapeRadio.getModel(), true);
        } else if (orientation == 1) {
            this.orientationButtonGroup.setSelected(this.portraitRadio.getModel(), true);
        }
    }

    public int getPaperOrientation() {
        int orientation = 1;
        ButtonModel sm = this.orientationButtonGroup.getSelection();
        if (sm == this.portraitRadio.getModel()) {
            orientation = 1;
        } else if (sm == this.landscapeRadio.getModel()) {
            orientation = 0;
        }
        return orientation;
    }

    public void setLandscapeOrientationEnabled(boolean enabled) {
        this.landscapeRadio.setEnabled(enabled);
    }

    public boolean isFound(MediaSizeName msn) {
        MediaSize ms = MediaSize.getMediaSizeForName(msn);
        return ms != null;
    }

    public Media[] getMediaForPrintService(AtPrintServiceObject psObj) {
        if (psObj == null) {
            return StandardPapers.getStandardMedia();
        }
        if (this.isShowStandardMediaPapers()) {
            return StandardPapers.getStandardMedia();
        }
        PrintService ps = psObj.getPrintService();
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        Media[] media = null;
        try {
            media = (Media[])ps.getSupportedAttributeValues(Media.class, flavor, null);
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        return media;
    }

    public boolean isShowStandardMediaPapers() {
        return this.showStandardPapers;
    }

    public void setShowStandardPapers(boolean showStandardPapers) {
        this.showStandardPapers = showStandardPapers;
    }

    public void setMarginsEnabled(boolean enabled) {
        this.setLeftMarginLabelEnabled(enabled);
        this.setLeftMarginEntryEnabled(enabled);
        this.setRightMarginLabelEnabled(enabled);
        this.setRightMarginEntryEnabled(enabled);
        this.setTopMarginLabelEnabled(enabled);
        this.setTopMarginEntryEnabled(enabled);
        this.setBottomMarginLabelEnabled(enabled);
        this.setBottomMarginEntryEnabled(enabled);
    }

    public void setMarginsVisible(boolean visible) {
        this.setLeftMarginLabelVisible(visible);
        this.setLeftMarginEntryVisible(visible);
        this.setRightMarginLabelVisible(visible);
        this.setRightMarginEntryVisible(visible);
        this.setTopMarginLabelVisible(visible);
        this.setTopMarginEntryVisible(visible);
        this.setBottomMarginLabelVisible(visible);
        this.setBottomMarginEntryVisible(visible);
    }

    public void setMargins(double lm, double rm, double tm, double bm) {
        this.setLeftMargin(lm);
        this.setRightMargin(rm);
        this.setTopMargin(tm);
        this.setBottomMargin(bm);
    }

    public void setPaperNameLabel(String newLabel) {
        this.paperNameLabel.setText(newLabel);
    }

    public String getPaperNameLabel() {
        return this.paperNameLabel.getText();
    }

    public void setPaperNameLabelEnabled(boolean enabled) {
        this.paperNameLabel.setEnabled(enabled);
    }

    public void setPaperNameLabelVisible(boolean visible) {
        this.paperNameLabel.setVisible(visible);
    }

    public void setLaftMarginLabel(String leftMarginLabel) {
        this.leftMargin.setText(leftMarginLabel);
    }

    public String getLeftMarginLabel() {
        return this.leftMargin.getText();
    }

    public void setLeftMarginLabelEnabled(boolean enabled) {
        this.leftMargin.setEnabled(enabled);
    }

    public void setLeftMarginLabelVisible(boolean visible) {
        this.leftMargin.setVisible(visible);
    }

    public double getLeftMarginValue() {
        return Double.parseDouble(this.leftMarginEntry.getText());
    }

    public void setLeftMarginEntryEnabled(boolean enabled) {
        this.leftMarginEntry.setEnabled(enabled);
    }

    public void setLeftMarginEntryVisible(boolean visible) {
        this.leftMarginEntry.setVisible(visible);
    }

    public void setTopMarginLabel(String label) {
        this.topMargin.setText(label);
    }

    public String getTopMarginLabel() {
        return this.topMargin.getText();
    }

    public void setTopMarginLabelEnabled(boolean enabled) {
        this.topMargin.setEnabled(enabled);
    }

    public void setTopMarginLabelVisible(boolean visible) {
        this.topMargin.setVisible(visible);
    }

    public double getTopMarginValue() {
        return Double.parseDouble(this.topMarginEntry.getText());
    }

    public void setTopMarginEntryEnabled(boolean enabled) {
        this.topMarginEntry.setEnabled(enabled);
    }

    public void setTopMarginEntryVisible(boolean visible) {
        this.topMarginEntry.setVisible(visible);
    }

    public void setRightMarginLabel(String label) {
        this.rightMargin.setText(label);
    }

    public String getRightMarginLabel() {
        return this.rightMargin.getText();
    }

    public void setRightMarginLabelEnabled(boolean enabled) {
        this.rightMargin.setEnabled(enabled);
    }

    public void setRightMarginLabelVisible(boolean visible) {
        this.rightMargin.setVisible(visible);
    }

    public double getRightMarginValue() {
        return Double.parseDouble(this.rightMarginEntry.getText());
    }

    public void setRightMarginEntryEnabled(boolean enabled) {
        this.rightMarginEntry.setEnabled(enabled);
    }

    public void setRightMarginEntryVisible(boolean visible) {
        this.rightMarginEntry.setVisible(visible);
    }

    public void setBottomMarginLabel(String label) {
        this.bottomMargin.setText(label);
    }

    public String getBottomMarginLabel() {
        return this.bottomMargin.getText();
    }

    public void setBottomMarginLabelEnabled(boolean enabled) {
        this.bottomMargin.setEnabled(enabled);
    }

    public void setBottomMarginLabelVisible(boolean visible) {
        this.bottomMargin.setVisible(visible);
    }

    public double getBottomMarginValue() {
        return Double.parseDouble(this.bottomMarginEntry.getText());
    }

    public void setBottomMarginEntryEnabled(boolean enabled) {
        this.bottomMarginEntry.setEnabled(enabled);
    }

    public void setBottomMarginEntryVisible(boolean visible) {
        this.bottomMarginEntry.setVisible(visible);
    }

    public AtMediaSizeObject getLastSelectedMediaSizeObject() {
        return this.lastMediaSizeObject;
    }

    class DoubleTypeDocument
    extends AtAbstractDocument
    implements DocumentListener {
        public DoubleTypeDocument() {
            this.addDocumentListener(this);
        }

        public void insertString(int offs, String str, AttributeSet attrs) throws BadLocationException {
            int length = super.getLength();
            String text = super.getText(0, length);
            if (this.hasNonDigits(str)) {
                if (this.hasDot(str)) {
                    if (this.hasDot(text)) {
                        this.bell();
                        return;
                    }
                } else {
                    this.bell();
                    return;
                }
            }
            super.insertString(offs, str, attrs);
        }

        public void insertUpdate(DocumentEvent e) {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void removeUpdate(DocumentEvent e) {
            int length = super.getLength();
            try {
                String text = super.getText(0, length);
                if (text != null && text.length() > 0) return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    class MarginFocusListener
    implements FocusListener {
        MarginFocusListener() {
        }

        public void focusLost(FocusEvent evt) {
            String bottomValue;
            Object source = evt.getSource();
            if (source == PaperSelectionPane.this.leftMarginEntry) {
                String leftValue = PaperSelectionPane.this.leftMarginEntry.getText();
                if (leftValue == null || leftValue.equals("")) {
                    PaperSelectionPane.this.leftMarginEntry.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"));
                }
            } else if (source == PaperSelectionPane.this.rightMarginEntry) {
                String rightValue = PaperSelectionPane.this.rightMarginEntry.getText();
                if (rightValue == null || rightValue.equals("")) {
                    PaperSelectionPane.this.rightMarginEntry.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"));
                }
            } else if (source == PaperSelectionPane.this.topMarginEntry) {
                String topValue = PaperSelectionPane.this.topMarginEntry.getText();
                if (topValue == null || topValue.equals("")) {
                    PaperSelectionPane.this.topMarginEntry.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"));
                }
            } else if (source == PaperSelectionPane.this.bottomMarginEntry && ((bottomValue = PaperSelectionPane.this.bottomMarginEntry.getText()) == null || bottomValue.equals(""))) {
                PaperSelectionPane.this.bottomMarginEntry.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_POINT_ZERO"));
            }
        }

        public void focusGained(FocusEvent e) {
        }
    }

    class MarginChangeListener
    implements DocumentListener {
        PaperSelectionPane paperPane;
        double lastLeftMargin = -1.0;
        double lastRightMargin = -1.0;
        double lastTopMargin = -1.0;
        double lastBottomMargin = -1.0;

        MarginChangeListener(PaperSelectionPane paperPane) {
            this.paperPane = paperPane;
        }

        public void changedUpdate(DocumentEvent e) {
            this.notifyMarginChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.notifyMarginChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.notifyMarginChange();
        }

        protected void notifyMarginChange() {
            double currBottomMargin;
            double currTopMargin;
            double currRightMargin;
            double currLeftMargin = PaperSelectionPane.this.getLeftMargin();
            if (!this.isValidMargins(currLeftMargin, currRightMargin = PaperSelectionPane.this.getRightMargin(), currTopMargin = PaperSelectionPane.this.getTopMargin(), currBottomMargin = PaperSelectionPane.this.getBottomMargin())) {
                return;
            }
            if (currLeftMargin != this.lastLeftMargin || currRightMargin != this.lastRightMargin || currTopMargin != this.lastTopMargin || currBottomMargin != this.lastBottomMargin) {
                Double[] newMargins = new Double[]{new Double(currLeftMargin), new Double(currRightMargin), new Double(currTopMargin), new Double(currBottomMargin)};
                Double[] oldMargins = new Double[]{new Double(this.lastLeftMargin), new Double(this.lastRightMargin), new Double(this.lastTopMargin), new Double(this.lastBottomMargin)};
                this.paperPane.notifyPaperMarginChangeListeners(oldMargins, newMargins);
                this.lastLeftMargin = currLeftMargin;
                this.lastRightMargin = currRightMargin;
                this.lastTopMargin = currTopMargin;
                this.lastBottomMargin = currBottomMargin;
            }
        }

        protected boolean isValidMargins(double left, double right, double top, double bottom) {
            double paperWidth = PaperSelectionPane.this.getSelectedPaperWidth();
            double paperHeight = PaperSelectionPane.this.getSelectedPaperHeight();
            double imageableWidth = paperWidth - (left + right);
            double imageableHeight = paperHeight - (top + bottom);
            return !(imageableWidth <= 0.0) && !(imageableHeight <= 0.0);
        }
    }
}

