/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.MediaUtil;
import com.activetree.common.utils.PrintUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class PrintRequestAttributePane
extends JPanel {
    protected final Vector printQualityComboModel = new Vector();
    private final Vector printSideComboModel = new Vector();
    protected JLabel printQualityLabel;
    protected JComboBox printQualityCombo;
    protected JLabel printSideLabel;
    protected JComboBox printSideCombo;

    public PrintRequestAttributePane() {
        this.setupContentPane();
        this.postInit();
    }

    protected void postInit() {
    }

    protected void setupContentPane() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_ATTRIBUTES"), 1, 2, null));
        JPanel psetPane = new JPanel(new GridBagLayout());
        this.printQualityLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_QUALITY"));
        this.printQualityLabel.setVerticalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        psetPane.add((Component)this.printQualityLabel, gridBagConstraints);
        this.printQualityComboModel.add("HIGH");
        this.printQualityComboModel.add("NORMAL");
        this.printQualityComboModel.add("DRAFT");
        this.printQualityCombo = new JComboBox(this.printQualityComboModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        psetPane.add((Component)this.printQualityCombo, gridBagConstraints);
        this.printSideLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("SIDE_TO_PRINT"));
        this.printSideLabel.setVerticalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        psetPane.add((Component)this.printSideLabel, gridBagConstraints);
        this.printSideComboModel.add("ONE_SIDED");
        this.printSideComboModel.add("DUPLEX");
        this.printSideComboModel.add("TUMBLE");
        this.printSideComboModel.add("TWO_SIDED_LONG_EDGE");
        this.printSideComboModel.add("TWO_SIDED_SHORT_EDGE");
        this.printSideCombo = new JComboBox(this.printSideComboModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        psetPane.add((Component)this.printSideCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)psetPane, gridBagConstraints);
    }

    public void refresh() {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.printQualityLabel.setEnabled(enabled);
        this.printQualityCombo.setEnabled(enabled);
        this.printSideLabel.setEnabled(enabled);
        this.printSideCombo.setEnabled(enabled);
    }

    public void setPrintQualityEnabled(boolean enabled) {
        this.printQualityLabel.setEnabled(enabled);
        this.printQualityCombo.setEnabled(enabled);
    }

    public void setPrintSideEnabled(boolean enabled) {
        this.printSideLabel.setEnabled(enabled);
        this.printSideCombo.setEnabled(enabled);
    }

    public void setPrintQualityVisible(boolean visible) {
        this.printQualityLabel.setVisible(visible);
        this.printQualityCombo.setVisible(visible);
    }

    public void setPrintSideVisible(boolean visible) {
        this.printSideLabel.setVisible(visible);
        this.printSideCombo.setVisible(visible);
    }

    public void setPrintQuality(PrintQuality printQuality) {
        String pqStr = PrintUtil.getPrintQuality(printQuality);
        this.setPrintQuality(pqStr);
    }

    public void setPrintQuality(String printQuality) {
        this.printQualityCombo.setSelectedItem(printQuality);
    }

    public PrintQuality getPrintQuality() {
        String selectedQuality = (String)this.printQualityCombo.getSelectedItem();
        PrintQuality pq = PrintUtil.getPrintQuality(selectedQuality);
        return pq;
    }

    public void setMediaSide(String side) {
        this.printSideCombo.setSelectedItem(side);
    }

    public void setMediaSide(Sides side) {
        String sideStr = MediaUtil.getMediaSide(side);
        this.setMediaSide(sideStr);
    }

    public Sides getMediaSide() {
        String side = (String)this.printSideCombo.getSelectedItem();
        Sides ps = MediaUtil.getMediaSide(side);
        return ps;
    }
}

