/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.media.AtPrintServiceObject;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.ComboPane;
import com.activetree.common.utils.AtDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.QueuedJobCount;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class PrinterSelectionPane
extends ComboPane {
    protected Component owner;
    protected PrintRequestAttributeSet printerDiscoveryAttributeSet;
    protected DocFlavor flavor = null;
    protected final Vector printServiceObjects = new Vector();
    protected JLabel nameLabel;
    protected JComboBox printerCombo;
    protected boolean printerSelectionEnabled = true;
    protected JButton printerPropertiesButton;
    protected JLabel statusLabel;
    protected JLabel statusValue;
    protected JLabel typeLabel;
    protected JLabel typeValue;
    protected JLabel qJobCountLabel;
    protected JLabel qJobCountValue;
    protected JLabel printerMakeAndModelLabel;
    protected JLabel printerMakeAndModelValue;
    protected AtPrintServiceObject lastPrintService;

    public PrinterSelectionPane() {
        this(null, DocFlavor.SERVICE_FORMATTED.PAGEABLE, new HashPrintRequestAttributeSet(), true);
    }

    public PrinterSelectionPane(Component owner, DocFlavor flavor, PrintRequestAttributeSet pAttrs, boolean printerSelectionEnabled) {
        this.owner = owner;
        this.flavor = flavor;
        this.printerDiscoveryAttributeSet = pAttrs;
        this.printerSelectionEnabled = printerSelectionEnabled;
        this.initModelData();
        this.setupContentPane();
        this.addRefreshListeners();
        this.selectDefaultPrinter();
        this.postInit();
    }

    protected void setupContentPane() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, AtCommonResource.MESSAGE_RESOURCE.getText("PRINTER"), 1, 2, null));
        GridBagConstraints gridBagConstraints = null;
        this.nameLabel = new JLabel();
        this.nameLabel.setText(AtCommonResource.MESSAGE_RESOURCE.getText("NAME"));
        this.nameLabel.setEnabled(this.isPrinterSelectionEnabled());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.printerCombo = new JComboBox(this.printServiceObjects);
        this.printerCombo.setEnabled(this.isPrinterSelectionEnabled());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.printerCombo, gridBagConstraints);
        this.printerPropertiesButton = new JButton();
        this.printerPropertiesButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("PROPERTIES"));
        this.printerPropertiesButton.setText(AtCommonResource.MESSAGE_RESOURCE.getText("PROPERTIES"));
        this.printerPropertiesButton.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("PROPERTIES_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.printerPropertiesButton, gridBagConstraints);
        this.statusLabel = new JLabel();
        this.statusLabel.setText(AtCommonResource.MESSAGE_RESOURCE.getText("STATUS"));
        this.statusLabel.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("STATUS_OF_PRINTER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.statusLabel, gridBagConstraints);
        this.statusValue = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.statusValue, gridBagConstraints);
        this.typeLabel = new JLabel();
        this.typeLabel.setText(AtCommonResource.MESSAGE_RESOURCE.getText("TYPE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.typeLabel, gridBagConstraints);
        this.typeValue = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.typeValue, gridBagConstraints);
        this.qJobCountLabel = new JLabel();
        this.qJobCountLabel.setText(AtCommonResource.MESSAGE_RESOURCE.getText("JOBS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.qJobCountLabel, gridBagConstraints);
        this.qJobCountValue = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.qJobCountValue, gridBagConstraints);
        this.printerMakeAndModelLabel = new JLabel();
        this.printerMakeAndModelLabel.setText(AtCommonResource.MESSAGE_RESOURCE.getText("MAKE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.printerMakeAndModelLabel, gridBagConstraints);
        this.printerMakeAndModelValue = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.printerMakeAndModelValue, gridBagConstraints);
    }

    protected void postInit() {
        this.setPrinterPropertiesButtonVisible(false);
        this.setPrinterMakeAndModelVisible(false);
        this.setPrinterTypeVisible(false);
    }

    protected void initModelData() {
        this.printServiceObjects.clear();
        try {
            DocFlavor flavor = this.getDocFlavor();
            PrintRequestAttributeSet pAttrs = this.getPrintRequestAttributeSet();
            PrintService[] ps = PrintServiceLookup.lookupPrintServices(flavor, pAttrs);
            for (int i = 0; ps != null && i < ps.length; ++i) {
                PrintService aPs = ps[i];
                AtPrintServiceObject aPsObject = new AtPrintServiceObject(aPs);
                this.printServiceObjects.add(aPsObject);
            }
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        AtDebug.debug("PrintService count: " + this.printServiceObjects.size());
    }

    protected void addRefreshListeners() {
        this.printerCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                AtPrintServiceObject selectedPs = PrinterSelectionPane.this.getSelectedPrintServiceObject();
                if (PrinterSelectionPane.this.lastPrintService == selectedPs) {
                    return;
                }
                if (selectedPs == null) {
                    return;
                }
                PrinterSelectionPane.this.updatePrinterState(selectedPs);
                PrinterSelectionPane.this.updateJobStatusControl(selectedPs);
                PrinterSelectionPane.this.updatePrinterLocation(selectedPs);
                PrinterSelectionPane.this.updateJobCountControl(selectedPs);
                PrinterSelectionPane.this.updatePrinterMakeAndModel(selectedPs);
                PrinterSelectionPane.this.updatePrinterURI(selectedPs);
                PrinterSelectionPane.this.notifySelectionChangeListeners(evt);
                PrinterSelectionPane.this.lastPrintService = selectedPs;
            }
        });
    }

    private void testSupportedAttributeValues(AtPrintServiceObject pso) {
        PrintService ps = pso.getPrintService();
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        Class<?>[] categoriesSupported = ps.getSupportedAttributeCategories();
        for (int i = 0; categoriesSupported != null && i < categoriesSupported.length; ++i) {
            Class<?> category = categoriesSupported[i];
            System.out.println(category.getClass().getName());
            Object categoryValues = ps.getSupportedAttributeValues(category, flavor, null);
            int x = 10;
            ++x;
        }
    }

    protected void updatePrinterState(AtPrintServiceObject selectedPs) {
        Object state = selectedPs.getPrintService().getAttribute(PrinterState.class);
        AtDebug.debug("state=" + state);
        if (state != null) {
            this.statusValue.setText("Ready");
        }
    }

    protected void updatePrinterLocation(AtPrintServiceObject selectedPs) {
        Object location = selectedPs.getPrintService().getAttribute(PrinterLocation.class);
        AtDebug.debug("location=" + location);
        if (location != null) {
            this.typeValue.setText(location.toString());
        }
    }

    protected void updatePrinterURI(AtPrintServiceObject selectedPs) {
        Object printerUri = selectedPs.getPrintService().getAttribute(PrinterURI.class);
        AtDebug.debug("printerUri=" + printerUri);
    }

    protected void updateJobStatusControl(AtPrintServiceObject selectedPs) {
        Object acceptingJobs = selectedPs.getPrintService().getAttribute(PrinterIsAcceptingJobs.class);
        if (acceptingJobs != null && acceptingJobs instanceof PrinterIsAcceptingJobs) {
            PrinterIsAcceptingJobs jobs = (PrinterIsAcceptingJobs)acceptingJobs;
            int value = jobs.getValue();
            if (value == PrinterIsAcceptingJobs.ACCEPTING_JOBS.getValue()) {
                this.statusValue.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ACCEPTING_JOBS"));
            } else if (value == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS.getValue()) {
                this.statusValue.setText(AtCommonResource.MESSAGE_RESOURCE.getText("NOT_ACCEPTING_JOBS"));
            } else {
                this.statusValue.setText(AtCommonResource.MESSAGE_RESOURCE.getText("UNKNOWN"));
            }
        } else {
            this.statusValue.setText(AtCommonResource.MESSAGE_RESOURCE.getText("UNKNOWN"));
        }
    }

    protected void updateJobCountControl(AtPrintServiceObject selectedPs) {
        Object qJobCount = selectedPs.getPrintService().getAttribute(QueuedJobCount.class);
        AtDebug.debug("qJobCount=" + qJobCount);
        if (qJobCount != null && qJobCount instanceof QueuedJobCount) {
            QueuedJobCount retJbCount = (QueuedJobCount)qJobCount;
            int count = retJbCount.getValue();
            this.qJobCountValue.setText(String.valueOf(count));
        } else {
            this.qJobCountValue.setText(AtCommonResource.MESSAGE_RESOURCE.getText("UNKNOWN"));
        }
    }

    protected void updatePrinterMakeAndModel(AtPrintServiceObject selectedPs) {
        Object printerMakeAndModel = selectedPs.getPrintService().getAttribute(PrinterMakeAndModel.class);
        AtDebug.debug("printerMakeAndModel=" + printerMakeAndModel);
        if (printerMakeAndModel != null && printerMakeAndModel instanceof PrinterMakeAndModel) {
            PrinterMakeAndModel m = (PrinterMakeAndModel)printerMakeAndModel;
            String makeAndModelLanel = m.getName();
            String makeAndModel = m.getValue();
            this.printerMakeAndModelValue.setText(makeAndModel);
        }
    }

    protected void selectDefaultPrinter() {
        try {
            PrintService defaultPs = PrintServiceLookup.lookupDefaultPrintService();
            for (int i = 0; defaultPs != null && i < this.printServiceObjects.size(); ++i) {
                AtPrintServiceObject psObject = (AtPrintServiceObject)this.printServiceObjects.get(i);
                if (psObject.getPrintService() != defaultPs) continue;
                this.printerCombo.setSelectedIndex(i);
                AtDebug.debug("Default PrintService selected: " + psObject);
                break;
            }
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
    }

    public void refresh() {
        AtPrintServiceObject selectedPs = this.getSelectedPrintServiceObject();
        AtDebug.debug(this.getClass().getName() + ": refresh() selectedPs=" + selectedPs);
        if (selectedPs == null) {
            return;
        }
        this.updatePrinterState(selectedPs);
        this.updateJobStatusControl(selectedPs);
        this.updatePrinterLocation(selectedPs);
        this.updateJobCountControl(selectedPs);
        this.updatePrinterMakeAndModel(selectedPs);
        this.updatePrinterURI(selectedPs);
    }

    public void setOwner(Component owner) {
        this.owner = owner;
    }

    public Component getOwner() {
        return this.owner;
    }

    public void setPrintRequestAttributeSet(PrintRequestAttributeSet newPrintAttrs) {
        this.printerDiscoveryAttributeSet = newPrintAttrs;
        this.initModelData();
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.printerDiscoveryAttributeSet;
    }

    public DocFlavor getDocFlavor() {
        return this.flavor;
    }

    public void setDocFlavor(DocFlavor docFlavor) {
        this.flavor = docFlavor;
    }

    public AtPrintServiceObject getSelectedPrintServiceObject() {
        AtPrintServiceObject pso = (AtPrintServiceObject)this.printerCombo.getSelectedItem();
        return pso;
    }

    public boolean isPrinterSelectionEnabled() {
        return this.printerSelectionEnabled;
    }

    public void setPrinterSelectionEnabled(boolean enabled) {
        this.printerSelectionEnabled = enabled;
        if (!this.isPrinterSelectionEnabled()) {
            this.printerCombo.setEnabled(false);
        } else {
            this.printerCombo.setEnabled(true);
        }
    }

    public void setPrintServiceSelected(PrintService ps) {
        for (int i = 0; ps != null && this.printServiceObjects != null && i < this.printServiceObjects.size(); ++i) {
            String aPsName;
            AtPrintServiceObject aPs = (AtPrintServiceObject)this.printServiceObjects.get(i);
            if (aPs == null || (aPsName = aPs.getName()) == null || !aPsName.equals(ps.getName())) continue;
            this.printerCombo.setSelectedIndex(i);
            return;
        }
    }

    public void setPrintServiceSelected(String ps) {
        for (int i = 0; ps != null && this.printServiceObjects != null && i < this.printServiceObjects.size(); ++i) {
            String aPsName;
            AtPrintServiceObject aPs = (AtPrintServiceObject)this.printServiceObjects.get(i);
            if (aPs == null || (aPsName = aPs.getName()) == null || !aPsName.equals(ps)) continue;
            this.printerCombo.setSelectedIndex(i);
            return;
        }
    }

    public boolean hasPrintServices() {
        return this.printServiceObjects != null && this.printServiceObjects.size() != 0;
    }

    public void setStatusPropertyEnabled(boolean enabled) {
        this.statusLabel.setEnabled(enabled);
        this.statusValue.setEnabled(enabled);
    }

    public String getPrinterStatus() {
        return this.statusValue.getText();
    }

    public int getQueueJobCount() {
        try {
            String s = this.qJobCountValue.getText();
            int jobCount = Integer.parseInt(s);
            return jobCount;
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
            return 0;
        }
    }

    public void setJobsPropertyEnabled(boolean enabled) {
        this.qJobCountLabel.setEnabled(enabled);
        this.qJobCountValue.setEnabled(enabled);
    }

    public void setPrinterPropertiesButtonVisible(boolean visible) {
        this.printerPropertiesButton.setVisible(false);
    }

    public void setPrinterMakeAndModelVisible(boolean visible) {
        this.printerMakeAndModelLabel.setVisible(false);
        this.printerMakeAndModelValue.setVisible(false);
    }

    public void setPrinterTypeVisible(boolean visible) {
        this.typeLabel.setVisible(false);
        this.typeValue.setVisible(false);
    }
}

