/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.generic;

import com.activetree.common.doc.DocEvent;
import com.activetree.common.doc.DocListener;
import com.activetree.common.doc.DocPageable;
import com.activetree.common.object.DefaultPasswordProvider;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.print.AbstractPrinter;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.JreUtil;
import com.activetree.common.utils.MediaUtil;
import com.activetree.common.utils.PrintUtil;
import com.activetree.common.utils.StringPattern;
import com.activetree.common.utils.StringUtil;
import com.activetree.common.web.CallBackReply;
import com.activetree.common.web.WebDoc;
import com.activetree.common.web.WebDocAttributeParser;
import com.activetree.common.web.WebDocContext;
import com.activetree.common.web.WebPrintContext;
import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;
import javax.swing.JOptionPane;

public abstract class AbstractBrowserPrintThread {
    protected PrintService[] pServices;
    private WebPrintContext context;

    public AbstractBrowserPrintThread(WebPrintContext context) {
        this.context = context;
        this.pServices = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
    }

    public WebPrintContext getPrintContext() {
        return this.context;
    }

    public void run() {
        int docCount;
        DocListener docListener;
        String docListStr;
        List docList;
        WebDoc webDoc;
        long t1;
        block12: {
            t1 = System.currentTimeMillis();
            this.context.showMessage("START []");
            webDoc = (WebDoc)this.context.getWebDoc();
            docList = (List)webDoc.getAttribute("DOC_LIST_OBJ");
            String docObj = docListStr = this.getDocListString(docList);
            String docId = this.context.getWebDoc().getStringAttribute("DOC_ID");
            if (docId != null) {
                docObj = "[" + docId + "]";
            }
            this.context.showMessage("DOC_LIST " + docObj);
            boolean printCancelled = this.context.isJobCancelled();
            try {
                if (!printCancelled) {
                    PrinterJob pj = this.getPrinterJob();
                    PrintService printService = null;
                    if (pj != null) {
                        printService = pj.getPrintService();
                    }
                    String printerToPrint = "";
                    if (printService != null) {
                        printerToPrint = printService.getName();
                    }
                    this.context.showMessage("PRINTER_NAME [" + printerToPrint + "]");
                    this.startPrint(pj);
                } else {
                    this.processJobCancelled(docListStr);
                }
            }
            catch (Throwable t) {
                DocListener docListener2;
                String errMsg = t.getMessage();
                webDoc.setAttribute("JOB_ERROR_MESSAGE", errMsg);
                String stack = StringUtil.getStackTrace(t);
                webDoc.setAttribute("JOB_ERROR_STACK", stack);
                webDoc.setAttribute("JOB_STATUS", "FAILED");
                this.context.debug(9, t);
                boolean showPrintErrDialog = this.context.getWebDoc().getPrimitiveBooleanAttribute("SHOW_PRINT_ERROR_DIALOG");
                this.context.debug("startPrint() - showPrintErrDialog=" + showPrintErrDialog);
                if (showPrintErrDialog) {
                    Component owner = this.context.getContextOwner();
                    String title = AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_ERROR");
                    JOptionPane.showMessageDialog(owner, errMsg, title, 0);
                }
                if ((docListener2 = (DocListener)webDoc.getAttribute("DOC_LISTENER")) == null) break block12;
                Object aDoc = webDoc.getAttribute("DOC_LIST");
                String format = webDoc.getStringAttribute("JOB_NAME");
                DocEvent evt = new DocEvent(aDoc, 24, -1, format + ": " + t.getMessage());
                evt.setWebDoc(webDoc);
                docListener2.activityPerformed(evt);
            }
        }
        boolean jobFailed = this.context.isJobFailed();
        if (!jobFailed && (docListener = (DocListener)webDoc.getAttribute("DOC_LISTENER")) != null) {
            DocEvent evt = new DocEvent(docListStr, 30, webDoc.getPrimitiveIntegerAttribute("PAGE_COUNT"), webDoc.getStringAttribute("JOB_NAME"));
            evt.setWebDoc(webDoc);
            docListener.activityPerformed(evt);
        }
        boolean singlePrintJob = webDoc.getPrimitiveBooleanAttribute("SINGLE_PRINT_JOB");
        int n = docCount = docList != null ? docList.size() : 0;
        if (docCount == 0 && !singlePrintJob) {
            this.context.showMessage("PAGE_COUNT [0]");
        }
        if (singlePrintJob || docCount == 0) {
            String overallJobStatus = this.getOverallJobStatus();
            this.context.showMessage(overallJobStatus);
        }
        if (jobFailed) {
            String jobErrMsg = webDoc.getStringAttribute("JOB_ERROR_MESSAGE");
            String jobErrStack = webDoc.getStringAttribute("JOB_ERROR_STACK");
            this.context.debug("JOB_ERROR_MESSAGE: " + jobErrMsg);
        }
        this.context.onSuccessShowPage();
        this.context.onFailureShowPage();
        long t2 = System.currentTimeMillis();
        long delta = t2 - t1;
        this.context.showMessage("DURATION [" + delta + "]");
        this.context.showMessage("END []");
    }

    private void processJobCancelled(String docListStr) {
        this.context.debug("print thread...printing was cancelled.");
        WebDoc webDoc = (WebDoc)this.context.getWebDoc();
        DocListener docListener = (DocListener)webDoc.getAttribute("DOC_LISTENER");
        if (docListener != null) {
            DocEvent evt = new DocEvent(docListStr, 35, webDoc.getPrimitiveIntegerAttribute("PAGE_COUNT"), webDoc.getStringAttribute("JOB_NAME"));
            evt.setWebDoc(webDoc);
            docListener.activityPerformed(evt);
        }
    }

    private String getOverallJobStatus() {
        boolean jobFailed = this.context.isJobFailed();
        WebDoc webDoc = (WebDoc)this.context.getWebDoc();
        StringBuffer buf = new StringBuffer();
        buf.append("JOB_STATUS");
        buf.append(" [");
        buf.append(webDoc.getStringAttribute("JOB_STATUS"));
        buf.append("]");
        if (jobFailed) {
            String jobErrMsg = webDoc.getStringAttribute("JOB_ERROR_MESSAGE");
            buf.append(" [" + jobErrMsg + "]");
        }
        String overallJobStatus = buf.toString();
        return overallJobStatus;
    }

    private PrinterJob getPrinterJob() {
        PrinterJob pj = null;
        try {
            pj = this.setupPrinterJob();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (pj == null) {
            this.context.debug("NO_PRINTER_JOB");
            this.context.getWebDoc().setAttribute("JOB_STATUS", "FAILED");
            this.context.getWebDoc().setAttribute("JOB_ERROR_MESSAGE", "NO_PRINTER_JOB");
            return null;
        }
        PrintService printService = pj.getPrintService();
        if (printService == null) {
            this.context.debug("NO_PRINT_SERVICE");
            this.context.getWebDoc().setAttribute("JOB_STATUS", "FAILED");
            this.context.getWebDoc().setAttribute("JOB_ERROR_MESSAGE", "NO_PRINT_SERVICE");
            return null;
        }
        return pj;
    }

    private void startPrint(PrinterJob pj) throws Throwable {
        List docListObj;
        PrintService printService = null;
        if (pj != null) {
            printService = pj.getPrintService();
        }
        if (printService == null) {
            // empty if block
        }
        if ((docListObj = (List)this.context.getWebDoc().getAttribute("DOC_LIST_OBJ")) == null || docListObj.size() == 0) {
            this.context.getWebDoc().setAttribute("JOB_STATUS", "FAILED");
            this.context.getWebDoc().setAttribute("JOB_ERROR_MESSAGE", "NO_DOCUMENTS");
        }
        this.context.debug("Printer to print: " + (printService != null ? printService.getName() : null) + "");
        this.debugInput();
        String paperName = (String)this.context.getWebDoc().getAttribute("PAPER");
        PageFormat userPageFormat = WebDocAttributeParser.getPageFormatForSelectedMediaName(paperName, this.context);
        this.print(pj, printService, userPageFormat);
    }

    private PrinterJob setupPrinterJob() throws Throwable {
        PrinterJob pj = PrinterJob.getPrinterJob();
        PrintService printService = null;
        boolean autoMatchPaper = this.context.getWebDoc().getPrimitiveBooleanAttribute("AUTO_MATCH_PAPER");
        boolean showPrintDialog = this.context.getWebDoc().getPrimitiveBooleanAttribute("SHOW_PRINT_DIALOG");
        String printerNameExcludePattern = this.context.getWebDoc().getStringAttribute("PRINTER_NAME_EXCLUDE_PATTERN");
        this.context.debug("PRINTER_NAME_EXCLUDE_PATTERN=" + printerNameExcludePattern);
        PrintService[] orgPrintServices = this.pServices;
        PrintService[] pServicesCopy = this.pServices;
        boolean defaultExcluded = false;
        if (printerNameExcludePattern != null && printerNameExcludePattern.length() > 0) {
            String[] parsedSegments = this.getExcludePatternSegments(printerNameExcludePattern);
            String excludePattern = parsedSegments[0];
            String wildCardChars = parsedSegments[1];
            boolean caseSensitive = new Boolean(parsedSegments[2]);
            if (excludePattern != null) {
                int i;
                int i2;
                Hashtable<String, PrintService> pServicesMap = null;
                String[] pServiceNames = orgPrintServices != null ? new String[orgPrintServices.length] : null;
                for (i2 = 0; pServiceNames != null && i2 < pServiceNames.length; ++i2) {
                    if (pServicesMap == null) {
                        pServicesMap = new Hashtable<String, PrintService>();
                    }
                    pServiceNames[i2] = orgPrintServices[i2].getName();
                    pServicesMap.put(pServiceNames[i2], orgPrintServices[i2]);
                }
                this.context.debug("-- All printer names --");
                for (i2 = 0; pServiceNames != null && i2 < pServiceNames.length; ++i2) {
                    this.context.debug(i2 + 1 + ". " + pServiceNames[i2]);
                }
                StringPattern pattern = new StringPattern();
                List availablePrinters = pattern.getUnmatchedList(pServiceNames, excludePattern, wildCardChars, caseSensitive);
                this.context.debug("Available Printers List (after exclude pattern applied): " + availablePrinters);
                PrintService defaultPs = PrintServiceLookup.lookupDefaultPrintService();
                if (defaultPs != null) {
                    String defaultPsName = defaultPs.getName();
                    if (availablePrinters != null && !availablePrinters.contains(defaultPsName)) {
                        defaultExcluded = true;
                    }
                }
                pServicesCopy = availablePrinters != null ? new PrintService[availablePrinters.size()] : null;
                for (i = 0; availablePrinters != null && i < availablePrinters.size(); ++i) {
                    PrintService ps;
                    String aAvailablePrinter = (String)availablePrinters.get(i);
                    pServicesCopy[i] = ps = (PrintService)pServicesMap.get(aAvailablePrinter);
                }
                this.context.debug("# print services (after printer name exclude filter applied): " + (pServicesCopy != null ? pServicesCopy.length : 0));
                this.context.debug("-- All filtered out printer names --");
                for (i = 0; pServicesCopy != null && i < pServicesCopy.length; ++i) {
                    this.context.debug(i + 1 + ". " + pServicesCopy[i].getName());
                }
            }
        }
        this.context.debug("Default printer excluded? " + defaultExcluded);
        String printerName = this.context.getWebDoc().getStringAttribute("PRINTER_NAME");
        boolean printerNameSubstringMatch = this.context.getWebDoc().getPrimitiveBooleanAttribute("PRINTER_NAME_SUBSTRING_MATCH");
        this.context.debug("PRINTER_NAME=" + printerName + ", paperName=[" + this.context.getWebDoc().getStringAttribute("PAPER") + "] autoMatchPaper=[" + autoMatchPaper + "]");
        if (!showPrintDialog) {
            printService = PrintUtil.getPrintServiceForPrinterName(pServicesCopy, printerName, printerNameSubstringMatch);
            if (printService == null && !defaultExcluded) {
                this.context.debug(7, "WARNING: Matching printer for user selected printer name \"" + printerName + "\" not found. Will use default printer.");
                printService = PrintServiceLookup.lookupDefaultPrintService();
            }
        } else {
            printService = (PrintService)this.context.getWebDoc().getAttribute("ATTR_PRINT_SERVICE");
            this.context.debug("setupPrinterJob()....showPrintDialog=" + showPrintDialog + ", printService=" + printService);
        }
        this.pServices = orgPrintServices;
        try {
            pj.setPrintService(printService);
        }
        catch (Throwable t) {
            pj = null;
            this.context.debug(9, "No print service found. (pj=" + pj + ")");
        }
        return pj;
    }

    private String[] getExcludePatternSegments(String pattern) {
        String excludePattern = null;
        String wildCardChars = null;
        boolean caseSensitive = false;
        StringTokenizer tk = new StringTokenizer(pattern, ";");
        int elmIdx = 0;
        while (tk.hasMoreTokens()) {
            String elm = tk.nextToken();
            elm = elm.trim();
            if (elmIdx == 0) {
                excludePattern = elm;
            } else if (elmIdx == 1) {
                wildCardChars = elm;
            } else if (elmIdx == 2 && elm.equalsIgnoreCase("true")) {
                caseSensitive = true;
            }
            ++elmIdx;
        }
        if (wildCardChars == null) {
            wildCardChars = "*";
        }
        this.context.debug("excludePattern=[" + excludePattern + "] [wildCardChars=" + wildCardChars + "] [caseSensitive=" + caseSensitive + "]");
        String[] arry = new String[]{excludePattern, wildCardChars, caseSensitive + ""};
        return arry;
    }

    protected String getCurrentString() {
        List docList = (List)this.context.getWebDoc().getAttribute("DOC_LIST_OBJ");
        StringBuffer b = new StringBuffer();
        String msgPostfix = AtCommonResource.MESSAGE_RESOURCE.getText("documents_as_single_print_job");
        b.append(docList.size() + " " + msgPostfix + " ");
        return b.toString();
    }

    protected String[] getDocumentsListMessage() {
        ArrayList<String> docs = new ArrayList<String>();
        List docList = (List)this.context.getWebDoc().getAttribute("DOC_LIST_OBJ");
        for (int i = 0; docList != null && i < docList.size(); ++i) {
            Object aDoc = docList.get(i);
            String s = "";
            if (aDoc instanceof String) {
                s = (String)aDoc;
            } else if (aDoc instanceof URL) {
                s = ((URL)aDoc).toExternalForm();
            }
            docs.add(s);
        }
        String[] docsStr = docs.size() == 0 ? null : new String[docs.size()];
        for (int i = 0; docsStr != null && i < docs.size(); ++i) {
            docsStr[i] = (String)docs.get(i);
        }
        return docsStr;
    }

    private void debugInput() {
        List docList = (List)this.context.getWebDoc().getAttribute("DOC_LIST_OBJ");
        this.context.debug("DOC_LIST to print (count: " + docList.size() + ")");
        for (int i = 0; i < docList.size(); ++i) {
            this.context.debug(docList.get(i));
        }
        String s = this.context.getDebugString();
        this.context.debug(s);
    }

    protected void printPageable(PrinterJob pj, Pageable pages, String currJobName, String[] currDocs, String docsMsg) throws Throwable {
        block9: {
            if (pages == null || pages.getNumberOfPages() == 0) {
                WebDoc webDoc = (WebDoc)this.getPrintContext().getWebDoc();
                boolean isShowPrintPreview = webDoc.getPrimitiveBooleanAttribute("IS_SHOW_PRINT_PREVIEW");
                if (isShowPrintPreview) {
                    this.context.debug("isShowPrintPreview - will silent print it.");
                    return;
                }
                String jobStatus = webDoc.getStringAttribute("JOB_STATUS");
                String jobErrorMsg = webDoc.getStringAttribute("JOB_ERROR_MESSAGE");
                String jobErrStack = webDoc.getStringAttribute("JOB_ERROR_STACK");
                ArrayList<String> docs = new ArrayList<String>();
                for (int i = 0; currDocs != null && i < currDocs.length; ++i) {
                    docs.add(currDocs[i]);
                }
                this.context.debug("JOB_ERROR_STACK: " + jobErrStack);
                DocListener docListener = (DocListener)webDoc.getAttribute("DOC_LISTENER");
                if (docListener != null) {
                    Object aDoc = webDoc.getAttribute("DOC_LIST");
                    String format = webDoc.getStringAttribute("JOB_ERROR_MESSAGE");
                    DocEvent evt = new DocEvent(aDoc, 24, -1, format + ": " + jobErrorMsg);
                    evt.setWebDoc(webDoc);
                    docListener.activityPerformed(evt);
                }
                boolean showPrintErrDialog = this.context.getWebDoc().getPrimitiveBooleanAttribute("SHOW_PRINT_ERROR_DIALOG");
                this.context.debug("startPrint() - showPrintErrDialog=" + showPrintErrDialog);
                if (showPrintErrDialog) {
                    Component owner = this.context.getContextOwner();
                    String title = AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_ERROR");
                    JOptionPane.showMessageDialog(owner, jobErrorMsg, title, 0);
                }
                return;
            }
            pj.setJobName(currJobName);
            pj.setPageable(pages);
            String documentsMsg = AtCommonResource.MESSAGE_RESOURCE.getText("Documents");
            String totalMsg = AtCommonResource.MESSAGE_RESOURCE.getText("Total");
            String pagesMsg = AtCommonResource.MESSAGE_RESOURCE.getText("PAGES_MSG");
            String totalPagesMsg = totalMsg + " " + pagesMsg;
            this.context.debug(documentsMsg + ": " + docsMsg + " [total pages: " + pages.getNumberOfPages() + "]");
            this.context.debug(totalPagesMsg);
            String docId = this.context.getWebDoc().getStringAttribute("DOC_ID");
            if (docId == null) {
                ArrayList<String> docs = new ArrayList<String>();
                for (int i = 0; currDocs != null && i < currDocs.length; ++i) {
                    docs.add(currDocs[i]);
                }
            }
            PrintRequestAttributeSet pSet = this.getPrintRequestAttributeSet();
            WebDoc webDoc = (WebDoc)this.context.getWebDoc();
            webDoc.setAttribute("PAGE_COUNT", new Integer(pages.getNumberOfPages()));
            webDoc.setAttribute("JOB_NAME", currJobName);
            webDoc.setAttribute("PRINTER_NAME", pj.getPrintService().getName());
            this.context.debug("currJobName=" + currJobName + " vs. printService.jobName=" + pj.getJobName());
            try {
                this.context.debug("B4 - print(pSet)");
                pj.print(pSet);
                this.context.debug("AFTER - print(pSet)");
                webDoc.setAttribute("JOB_STATUS", "SUCCESS");
                webDoc.setAttribute("JOB_ERROR_MESSAGE", null);
                webDoc.setAttribute("JOB_ERROR_STACK", null);
                webDoc.setAttribute("DATE_TIME", new Date().toString());
            }
            catch (Throwable t) {
                String errMsg = t.getMessage();
                webDoc.setAttribute("JOB_ERROR_MESSAGE", errMsg);
                String stack = StringUtil.getStackTrace(t);
                webDoc.setAttribute("JOB_ERROR_STACK", stack);
                webDoc.setAttribute("JOB_STATUS", "FAILED");
                this.context.debug(9, t);
                boolean showPrintDialog = this.context.getWebDoc().getPrimitiveBooleanAttribute("SHOW_PRINT_ERROR_DIALOG");
                this.context.debug(9, "B4 pj.print()showPrintDialog=" + showPrintDialog);
                String printError = AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_ERROR");
                if (!showPrintDialog) break block9;
                Component owner = this.context.getContextOwner();
                JOptionPane.showMessageDialog(owner, errMsg, printError, 0);
            }
        }
        CallBackReply replyAfter = this.context.callServer("POST", "FINISHED");
        this.context.processCallBackReplyAfter(replyAfter);
    }

    protected String getDocListString(List docList) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; docList != null && i < docList.size(); ++i) {
            Object doc = docList.get(i);
            String aDoc = doc instanceof String ? (String)doc : doc.toString();
            buf.append('[');
            buf.append(aDoc);
            buf.append(']');
        }
        if (buf.length() == 0) {
            buf.append("[]");
        }
        return buf.toString();
    }

    protected boolean canPrint(CallBackReply reply) {
        if (reply == null) {
            return true;
        }
        String s = reply.getParameter("SERVER_ERROR_MESSAGE");
        return s == null || s.length() <= 0;
    }

    private PrintRequestAttributeSet getPrintRequestAttributeSet() {
        Object obj = this.context.getWebDoc().getAttribute("PRINT_REQUEST_ATTRIBUTE_SET");
        PrintRequestAttributeSet pSet = null;
        if (obj != null && !(obj instanceof PrintRequestAttributeSet)) {
            this.context.debug(9, "PRINT_REQUEST_ATTRIBUTE_SET must be instance of PrintRequestAttributeSet");
        } else {
            pSet = (PrintRequestAttributeSet)obj;
        }
        if (pSet == null) {
            pSet = new HashPrintRequestAttributeSet();
        }
        PrintQuality printQuality = PrintUtil.getPrintQuality((String)this.context.getWebDoc().getAttribute("PRINT_QUALITY"));
        pSet.add(printQuality);
        Sides sideName = MediaUtil.getMediaSide((String)this.context.getWebDoc().getAttribute("SIDE_TO_PRINT"));
        pSet.add(sideName);
        Attribute[] attrs = pSet.toArray();
        StringBuffer b = new StringBuffer();
        b.append("PrintRequestAttributeSet [");
        for (int i = 0; attrs != null && i < attrs.length; ++i) {
            b.append(attrs[i].getClass().getName() + " ");
        }
        this.context.debug(b.toString());
        return pSet;
    }

    protected Pageable getPageable(Object source, AbstractPrinter printer, PageFormat userPageFormat) throws Throwable {
        DocListener docListener;
        String srvProxySet;
        String srvProxyPort;
        String srvProxyHost;
        String serverSuppliedUrlAuthPassword;
        String serverSuppliedUrlAuthId;
        Object doc = source;
        WebDoc webDoc = (WebDoc)this.context.getWebDoc();
        this.context.debug("");
        webDoc.setAttribute("JOB_STATUS", "WILL_START");
        webDoc.setAttribute("DOC_LIST", doc);
        String password = webDoc.getStringAttribute("PASSWORD");
        String urlAuthId = webDoc.getStringAttribute("URL_AUTH_ID");
        String urlAuthPassword = webDoc.getStringAttribute("URL_AUTH_PASSWORD");
        String proxyHost = webDoc.getStringAttribute("PROXY_HOST");
        String proxyPort = webDoc.getStringAttribute("PROXY_PORT");
        String proxySet = webDoc.getStringAttribute("PROXY_SET");
        CallBackReply replyBefore = this.context.callServer("POST", "WILL_START");
        this.context.processCallBackReplyBefore(replyBefore);
        String serverSuppliedPassword = webDoc.getStringAttribute("PASSWORD");
        if (serverSuppliedPassword != null) {
            password = serverSuppliedPassword;
        }
        if ((serverSuppliedUrlAuthId = webDoc.getStringAttribute("URL_AUTH_ID")) != null) {
            urlAuthId = serverSuppliedUrlAuthId;
        }
        if ((serverSuppliedUrlAuthPassword = webDoc.getStringAttribute("URL_AUTH_PASSWORD")) != null) {
            urlAuthPassword = serverSuppliedUrlAuthPassword;
        }
        if ((srvProxyHost = webDoc.getStringAttribute("PROXY_HOST")) != null) {
            proxyHost = srvProxyHost;
        }
        if ((srvProxyPort = webDoc.getStringAttribute("PROXY_PORT")) != null) {
            proxyPort = srvProxyPort;
        }
        if ((srvProxySet = webDoc.getStringAttribute("PROXY_SET")) != null) {
            proxySet = srvProxySet;
        }
        DefaultPasswordProvider auth = new DefaultPasswordProvider(password, urlAuthId, urlAuthPassword);
        auth.setProxyHost(proxyHost);
        auth.setProxyPort(proxyPort);
        auth.setProxySet(proxySet);
        printer.setPasswordProvider(auth);
        Object ghostDocUrl = this.getGhostDoc(replyBefore);
        if (ghostDocUrl != null) {
            doc = ghostDocUrl;
        }
        Pageable pages = null;
        boolean canPrint = this.canPrint(replyBefore);
        boolean jobCancelled = this.context.isJobCancelled();
        boolean isShowPrintPreview = webDoc.getPrimitiveBooleanAttribute("IS_SHOW_PRINT_PREVIEW");
        this.context.debug("canPrint() " + canPrint + ", isShowPrintPreview=" + isShowPrintPreview);
        if (jobCancelled) {
            String docListStr = doc instanceof String ? (String)doc : doc.toString();
            this.processJobCancelled(docListStr);
        } else if (canPrint && !isShowPrintPreview) {
            block22: {
                this.context.debug("getPageable()");
                try {
                    pages = printer.getPageable(doc, userPageFormat);
                    this.processPrinterError(pages, printer);
                }
                catch (Throwable t) {
                    DocListener docListener2 = (DocListener)webDoc.getAttribute("DOC_LISTENER");
                    if (docListener2 != null) {
                        String format = webDoc.getStringAttribute("JOB_NAME");
                        DocEvent evt = new DocEvent(doc, 24, -1, format + ": " + t.getMessage());
                        evt.setWebDoc(webDoc);
                        docListener2.activityPerformed(evt);
                    }
                    webDoc.setAttribute("JOB_STATUS", "FAILED");
                    webDoc.setAttribute("JOB_ERROR_MESSAGE", t.getMessage());
                    String stack = this.context.getStackTrace(t);
                    webDoc.setAttribute("JOB_ERROR_STACK", stack);
                    webDoc.setAttribute("CURRENT_DOC", doc);
                    CallBackReply errCallback = this.context.callServer("POST", "FAILED");
                    if (errCallback == null) break block22;
                    String reply = errCallback.getParameter("JOB_STATUS");
                    if (reply != null && reply.equalsIgnoreCase("ATTR_JOB_DISCARD")) {
                        throw t;
                    }
                    if (reply == null || reply.equalsIgnoreCase("ATTR_JOB_CONTINUE")) {
                        // empty if block
                    }
                }
            }
            this.context.debug(doc + " [pages: " + (pages != null ? pages.getNumberOfPages() : 0) + "]");
        } else {
            String err = webDoc.getStringAttribute("SERVER_ERROR_MESSAGE");
            if (err != null) {
                String serverErrMsg = doc + " [server error message: " + err + "]";
                this.context.debug(9, serverErrMsg);
                this.context.showMessage("SERVER_ERROR_MESSAGE: [" + doc + "][" + err + "]");
            }
        }
        if (isShowPrintPreview) {
            this.context.debug("showing preview window");
            String documentsMsg = AtCommonResource.MESSAGE_RESOURCE.getText("Documents");
            this.context.showMessage(documentsMsg);
            Object docObj = doc;
            String docId = this.context.getWebDoc().getStringAttribute("DOC_ID");
            if (docId != null) {
                docObj = docId;
            }
            this.context.showMessage(docObj + "");
            String printPreviewMsg = AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_PREVIEW");
            this.context.showMessage(printPreviewMsg);
            Object docList = webDoc.getAttribute("DOC_LIST");
            this.context.debug("DOC_LIST=" + (docList == null ? null : docList.getClass().getName()));
            Object document = source;
            if (source instanceof URL) {
                document = ((URL)source).toExternalForm();
            }
            webDoc.setAttribute("DOCUMENT", document);
            String viewerUrl = webDoc.getStringAttribute("VIEWER_URL");
            this.context.debug("viewerUrl=" + viewerUrl);
            String qString = this.getPreviewQueryString();
            this.context.debug("qString=" + qString);
            String qStringId = String.valueOf(System.currentTimeMillis());
            WebDocContext.getInstance().setAttribute(qStringId, qString);
            String previewPage = viewerUrl + "?" + "DOC_ID" + "=" + qStringId + "";
            this.context.debug("previewPage=" + previewPage);
            String viewerWindowTarget = webDoc.getStringAttribute("ON_SUCCESS_PAGE_TARGET");
            this.context.showPage(previewPage, viewerWindowTarget);
            this.context.showMessage(previewPage);
        }
        if ((docListener = (DocListener)webDoc.getAttribute("DOC_LISTENER")) != null) {
            DocEvent evt = new DocEvent(doc, 40, pages != null ? pages.getNumberOfPages() : 0, pages);
            evt.setWebDoc(webDoc);
            docListener.activityPerformed(evt);
            pages = (Pageable)evt.getDetails();
        }
        if (printer != null) {
            int pageCount = pages != null ? pages.getNumberOfPages() : 0;
            printer.notifyPageCount(pageCount, source);
        }
        return pages;
    }

    protected String getPreviewQueryString() {
        WebDoc webDoc = (WebDoc)this.getPrintContext().getWebDoc();
        StringBuffer buf = new StringBuffer();
        Iterator paramNames = webDoc.getParameterNames();
        while (paramNames != null && paramNames.hasNext()) {
            String aParam = (String)paramNames.next();
            if ((aParam = aParam.trim()).equalsIgnoreCase("IS_SHOW_PRINT_PREVIEW") || aParam.equalsIgnoreCase("SILENT_PRINT_PARAMS") || aParam == null) continue;
            Object o = webDoc.getAttribute(aParam);
            String aValue = "";
            if (o != null) {
                if (o instanceof String) {
                    aValue = (String)o;
                    if (aValue.equalsIgnoreCase("null")) {
                        aValue = "";
                    }
                } else if (o instanceof Boolean) {
                    aValue = webDoc.valueOf((Boolean)o);
                } else if (o instanceof Integer) {
                    aValue = webDoc.valueOf((Integer)o);
                } else if (o instanceof URL) {
                    aValue = webDoc.valueOf((URL)o);
                } else {
                    this.context.debug("NOT USED: " + o.getClass().getName() + ":[" + o + "]");
                    continue;
                }
            }
            buf.append(aParam + '=' + aValue + '|');
        }
        if (buf.charAt(buf.length() - 1) == '|') {
            buf.deleteCharAt(buf.length() - 1);
        }
        String qString = buf.toString();
        return qString;
    }

    protected Object getGhostDoc(CallBackReply reply) {
        if (reply == null) {
            return null;
        }
        String ghostDoc = reply.getParameter("DOC_LIST");
        if (ghostDoc instanceof byte[]) {
            return ghostDoc;
        }
        URL url = null;
        try {
            url = new URL(ghostDoc);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return url;
    }

    public void processPrinterError(Pageable pages, AbstractPrinter printer) {
        if (pages == null || pages.getNumberOfPages() == 0 || printer.hasError()) {
            String errMsg = printer.getErrorMessage();
            throw new RuntimeException(errMsg);
        }
    }

    protected void print(PrinterJob pj, PrintService printService, PageFormat userPageFormat) throws Throwable {
        WebPrintContext context = this.getPrintContext();
        WebDoc webDoc = (WebDoc)this.getPrintContext().getWebDoc();
        boolean singlePrintJob = webDoc.getPrimitiveBooleanAttribute("SINGLE_PRINT_JOB");
        List overallDocList = (List)webDoc.getAttribute("DOC_LIST_OBJ");
        String jobName = webDoc.getStringAttribute("JOB_NAME");
        context.showMessage("SINGLE_PRINT_JOB [" + singlePrintJob + "]");
        int docCount = overallDocList != null ? overallDocList.size() : 0;
        context.showMessage("DOC_COUNT [" + docCount + "]");
        if (singlePrintJob) {
            context.debug("Printing as single print job");
            String s = JreUtil.getMemoryInfo();
            context.debug("--- Memory before  print is done --- " + s);
            ArrayList printerList = new ArrayList();
            Pageable pages = null;
            try {
                pages = this.getDocPages(printerList, overallDocList, pj, userPageFormat);
            }
            catch (Throwable t) {
                String errMsg = t.getMessage();
                context.getWebDoc().setAttribute("JOB_STATUS", "FAILED");
                context.getWebDoc().setAttribute("JOB_ERROR_MESSAGE", errMsg);
            }
            int pageCount = pages != null ? pages.getNumberOfPages() : 0;
            context.showMessage("PAGE_COUNT [" + pageCount + "]");
            if (pages != null && pages.getNumberOfPages() > 0 && pj != null && printService != null) {
                String pdfListStr = this.getCurrentString();
                String[] docsMsg = this.getDocumentsListMessage();
                this.printPageable(pj, pages, jobName, docsMsg, pdfListStr);
            }
            for (int i = 0; printerList != null && i < printerList.size(); ++i) {
                AbstractPrinter printer = (AbstractPrinter)printerList.get(i);
                printer.close();
                context.debug("Printer " + i + ".close()");
            }
            s = JreUtil.getMemoryInfo();
            context.debug("--- Memory after  print is done --- " + s);
            context.debug("End print as single print job.");
        } else {
            context.debug("Printing as multiple print job [each doc one print job].");
            for (int i = 0; i < overallDocList.size(); ++i) {
                Object aDocUrl = overallDocList.get(i);
                String newJobName = webDoc.getJobName(aDocUrl, jobName, i);
                Vector singleDoc = new Vector();
                singleDoc.add(aDocUrl);
                String s = JreUtil.getMemoryInfo();
                context.debug("Printing doc: [" + aDocUrl + "]");
                context.debug("--- Memory before  print is done --- " + s);
                AbstractPrinter printer = this.getPrinter();
                this.setPrinterProperties(printer);
                Pageable pages = null;
                try {
                    pages = this.getDocPages(printer, singleDoc, pj, userPageFormat);
                }
                catch (Throwable t) {
                    String errMsg = t.getMessage();
                    context.getWebDoc().setAttribute("JOB_STATUS", "FAILED");
                    context.getWebDoc().setAttribute("JOB_ERROR_MESSAGE", errMsg);
                }
                int pageCount = pages != null ? pages.getNumberOfPages() : 0;
                Object docObj = aDocUrl;
                String docId = context.getWebDoc().getStringAttribute("DOC_ID");
                if (docId != null) {
                    docObj = docId;
                }
                context.showMessage("CURRENT_DOC [" + docObj + "]");
                context.showMessage("PAGE_COUNT [" + pageCount + "]");
                if (pages != null && pages.getNumberOfPages() > 0 && pj != null && printService != null) {
                    String msgPostfix = AtCommonResource.MESSAGE_RESOURCE.getText("documents_as_multiple_print_job");
                    String oneDocMsg = "1 " + msgPostfix + " ";
                    this.printPageable(pj, pages, newJobName, new String[]{"" + aDocUrl}, oneDocMsg);
                } else {
                    context.getWebDoc().setAttribute("JOB_STATUS", "FAILED");
                    if (pj == null || printService == null) {
                        context.getWebDoc().setAttribute("JOB_ERROR_MESSAGE", "NO_PRINT_SERVICE");
                    }
                }
                boolean jobFailed = context.isJobFailed();
                String jobStatus = (String)context.getWebDoc().getAttribute("JOB_STATUS");
                context.debug("[" + aDocUrl + "] jobFailed[" + jobFailed + "] jobStatus[" + jobStatus + "]");
                StringBuffer buf = new StringBuffer();
                buf.append("JOB_STATUS [" + jobStatus + "]");
                if (jobFailed) {
                    String jobErrMsg = webDoc.getStringAttribute("JOB_ERROR_MESSAGE");
                    buf.append(" [" + jobErrMsg + "]");
                }
                String statusMsg = buf.toString();
                context.showMessage(statusMsg);
                printer.close();
                context.debug("Printer " + i + ".close()");
                s = JreUtil.getMemoryInfo();
                context.debug("--- Memory after  print is done --- " + s);
            }
            context.debug("End print as multiple print job");
        }
        boolean isShowPrintPreview = webDoc.getPrimitiveBooleanAttribute("IS_SHOW_PRINT_PREVIEW");
        if (isShowPrintPreview) {
            // empty if block
        }
        context.debug("Printing...Done");
        context.debug("");
    }

    private void setPrinterProperties(AbstractPrinter printer) {
        printer.setChoosePaperSourceByPageSize(false);
        printer.setUsePrinterMargins(false);
        WebDoc webDoc = (WebDoc)this.getPrintContext().getWebDoc();
        DocListener docListener = (DocListener)webDoc.getAttribute("DOC_LISTENER");
        if (docListener != null) {
            printer.addDocListener(docListener);
        }
    }

    protected Pageable getDocPages(Object printers, List docList, PrinterJob pj, PageFormat userPageFormat) throws Throwable {
        WebPrintContext context = this.getPrintContext();
        WebDoc webDoc = (WebDoc)context.getWebDoc();
        boolean autoMatchPaper = webDoc.getPrimitiveBooleanAttribute("AUTO_MATCH_PAPER");
        boolean isUsePrinterMargins = webDoc.getPrimitiveBooleanAttribute("IS_USE_PRINTER_MARGINS");
        boolean autoRotateAndCenter = webDoc.getPrimitiveBooleanAttribute("AUTO_ROTATE_AND_CENTER");
        boolean collateCopies = webDoc.getPrimitiveBooleanAttribute("COLLATE_COPIES");
        int copies = webDoc.getPrimitiveIntegerAttribute("COPIES");
        int pageScaling = webDoc.getPrimitiveIntegerAttribute("PAGE_SCALING");
        DocPageable allPages = new DocPageable();
        for (int i = 0; docList != null && i < docList.size(); ++i) {
            AbstractPrinter printerToUse = null;
            if (printers instanceof AbstractPrinter) {
                printerToUse = (AbstractPrinter)printers;
            } else if (printers instanceof List) {
                printerToUse = this.getPrinter();
                ((List)printers).add(printerToUse);
            } else {
                throw new RuntimeException("No printer class to print.");
            }
            if (printerToUse == null) {
                printerToUse = this.getPrinter();
            }
            Object o = docList.get(i);
            Pageable pages = this.getPageable(o, printerToUse, userPageFormat);
            for (int page = 0; pages != null && page < pages.getNumberOfPages(); ++page) {
                Printable aPage = pages.getPrintable(page);
                PageFormat aPf = pages.getPageFormat(page);
                allPages.append(aPage, aPf);
            }
        }
        context.debug("Start -- applying print properties to each pages before printing.");
        Book retPages = new DocPageable();
        for (int page = 0; allPages != null && page < allPages.getNumberOfPages(); ++page) {
            Rectangle2D printableArea;
            PageFormat autoMatchedPf;
            AbstractPage aPage = (AbstractPage)allPages.getPrintable(page);
            AbstractPage clonedPage = aPage.newInstance();
            clonedPage.setZoom(1.0);
            PageFormat pfToUse = userPageFormat;
            if (autoMatchPaper && (autoMatchedPf = AbstractPrinter.getPaperSourceByPageSize(printableArea = clonedPage.getPrintableArea())) != null) {
                pfToUse = autoMatchedPf;
            }
            PageFormat validatedPf = AbstractPrinter.getPrinterValidatedPageFormat(pj, pfToUse, isUsePrinterMargins);
            pfToUse = MediaUtil.getClonedPageFormat(validatedPf);
            clonedPage.setPrinterPageFormat(pfToUse);
            clonedPage.setPageScaling(pageScaling);
            clonedPage.setAutoRotateAndCenter(autoRotateAndCenter);
            clonedPage.setRenderingReason("PageRenderingReasonPrinting");
            retPages.append(clonedPage, pfToUse);
        }
        retPages = MediaUtil.createCollatedCopiesForPrint(retPages, collateCopies, copies);
        context.debug("End -- applying print properties to each pages before printing.");
        return retPages;
    }

    protected abstract AbstractPrinter getPrinter();
}

