/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report;

import com.activetree.common.internal.DemoShape;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.report.AtElement;
import com.activetree.common.report.AtIconElement;
import com.activetree.common.report.AtStringElement;
import com.activetree.common.report.DefaultPrintableCell;
import com.activetree.common.report.PageHeaderFooterListener;
import com.activetree.common.report.PrintableCell;
import com.activetree.common.report.internal.ElementDescriptor;
import com.activetree.common.report.internal.IconElementDescriptor;
import com.activetree.common.report.internal.LineDescriptor;
import com.activetree.common.report.internal.NewlineElementDescriptor;
import com.activetree.common.report.internal.PageBreakDescriptor;
import com.activetree.common.report.internal.PageDescriptor;
import com.activetree.common.report.internal.PrintMathProvider;
import com.activetree.common.report.internal.SplittedElement;
import com.activetree.common.report.internal.StringElementDescriptor;
import com.activetree.common.report.page.AbstractReportPage;
import com.activetree.common.report.page.Page;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.resource.AtImageList;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AttributeSet;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class AtPrintUtil {
    private static final int INSET = 3;
    private static BufferedImage hiddenBi = new BufferedImage(2, 2, 2);
    private static Graphics2D dummyComp = hiddenBi.createGraphics();
    private static Font defaultFont = new Font("Time New Roman", 0, 11);
    private static PrintMathProvider mathProvider = new PrintMathProvider();
    public static final DefaultPrintableCell defaultPrintableCell = new DefaultPrintableCell();
    public static ImageIcon PLUS_ICON;
    public static ImageIcon MINUS_ICON;

    public static final double getHorizontalAlignedX(Rectangle2D bbox, ElementDescriptor elm) {
        double objectWidth = elm.getWidth();
        double x = bbox.getX();
        if (elm.getHorizontalAlignment() == 10) {
            x = bbox.getX();
        } else if (elm.getHorizontalAlignment() == 12) {
            x = bbox.getX() + bbox.getWidth() - objectWidth;
        } else if (elm.getHorizontalAlignment() == 11) {
            x = bbox.getCenterX() - objectWidth / 2.0;
        }
        return x;
    }

    public static final double getVerticalAlignedY(Rectangle2D bbox, ElementDescriptor elm) {
        double objectHeight = elm.getHeight();
        double y = 0.0;
        if (elm instanceof StringElementDescriptor) {
            double fontHeight = objectHeight;
            if (elm.getVerticalAlignment() == 13) {
                y = bbox.getY() + fontHeight - fontHeight / 4.0;
            } else if (elm.getVerticalAlignment() == 11) {
                double fontBottom = bbox.getCenterY() + fontHeight / 2.0;
                y = fontBottom - fontHeight / 4.0;
            } else if (elm.getVerticalAlignment() == 14) {
                y = bbox.getY() + bbox.getHeight() - fontHeight / 4.0;
            }
        } else if (elm.getVerticalAlignment() == 13) {
            y = bbox.getY();
        } else if (elm.getVerticalAlignment() == 11) {
            y = bbox.getCenterY() - objectHeight / 2.0;
        } else if (elm.getVerticalAlignment() == 14) {
            y = bbox.getY() + bbox.getHeight() - objectHeight;
        }
        return y;
    }

    public static final void drawIconElement(Graphics g, AtIconElement iconElm, Rectangle cellBounds, double zoom) {
        if (iconElm.isImageFitToWidth()) {
            iconElm = iconElm.getZoomedElement(zoom);
        }
        Image image = iconElm.getImage();
        int alignment = iconElm.getHorizontalAlignment();
        double imgx = cellBounds.getCenterX() - (double)image.getWidth(null) / 2.0;
        double imgy = cellBounds.y;
        g.drawImage(image, (int)imgx, (int)imgy, null);
    }

    public static final void drawStringElement(AtStringElement cellValue, Graphics2D g, int maxColWidth, int maxRowHeight, int sx, int sy, double zoom) {
        Font zoomedFont = AtPrintUtil.getFont(cellValue.getFont(), zoom);
        FontMetrics fm = AtStringElement.getFontMetrics(zoomedFont);
        int strWidth = GraphicsUtil.stringWidth(zoomedFont, cellValue.getText());
        int alignment = cellValue.getHorizontalAlignment();
        float strx = sx + 3;
        if (alignment == 11) {
            strx = sx + (maxColWidth - strWidth) / 2;
        } else if (alignment == 12) {
            strx = sx + maxColWidth - 3 - strWidth;
        }
        float fontHeight = fm.getHeight();
        float stry = 0.0f;
        if (fontHeight < (float)maxRowHeight) {
            float deltaY = ((float)maxRowHeight - fontHeight) / 2.0f;
            stry = (float)sy + deltaY + fontHeight / 4.0f * 3.0f;
        } else {
            stry = sy + maxRowHeight / 4 * 3;
        }
        Color orgColor = g.getColor();
        Font orgFont = g.getFont();
        g.setColor(cellValue.getForeground());
        g.setFont(zoomedFont);
        g.drawString(cellValue.getText(), strx, stry);
        if (cellValue.isUnderlined()) {
            g.drawLine((int)strx, (int)stry + 1, (int)(strx + (float)strWidth), (int)stry + 1);
        }
        if (cellValue.isStrikeThrough()) {
            Color strikeThruColor = cellValue.getStrikeThroughColor();
            if (strikeThruColor == null) {
                strikeThruColor = SystemColor.blue.darker().darker();
            }
            g.setColor(strikeThruColor);
            float strikeY = stry - (float)(fm.getHeight() / 4);
            g.drawLine((int)strx, (int)strikeY, (int)(strx + (float)strWidth), (int)strikeY);
        }
        g.setColor(orgColor);
        g.setFont(orgFont);
    }

    public static final Object getCellValue(JTable table, int row, int col) {
        Object cellValue = null;
        cellValue = row < 0 ? table.getColumnModel().getColumn(col).getHeaderValue() : table.getValueAt(row, col);
        return cellValue;
    }

    public static final Component getCellRendererComponent(JTable table, int row, int column, boolean isHeaderRow) {
        TableColumn tc = table.getColumnModel().getColumn(column);
        TableCellRenderer cr = null;
        Component cellComp = null;
        Object cellValue = null;
        if (row == -1) {
            cr = tc.getHeaderRenderer();
            if (cr == null) {
                cr = table.getTableHeader().getDefaultRenderer();
            }
            cellValue = tc.getHeaderValue();
            if (cr != null) {
                cellComp = cr.getTableCellRendererComponent(table, cellValue, false, false, row, column);
            }
        } else {
            cr = table.getCellRenderer(row, column);
            cellValue = table.getValueAt(row, column);
            if (cr != null) {
                cellComp = cr.getTableCellRendererComponent(table, cellValue, false, false, row, column);
            }
        }
        return cellComp;
    }

    public static final int getCellRendererWidth(JTable table, int row, int col, boolean isHeaderCell) {
        int width = defaultPrintableCell.getCellWidth(table, row, col, isHeaderCell);
        return width;
    }

    public static final int getCellRendererHeight(JTable table, int row, int col, boolean isHeaderCell) {
        int height = defaultPrintableCell.getCellHeight(table, row, col, isHeaderCell);
        return height;
    }

    public static Component getViewportComponent(Component parent) {
        JViewport viewport = (JViewport)AtComponentUtil.findComponent((Container)parent, JViewport.class, true);
        if (viewport != null) {
            Component view = viewport.getView();
            return view;
        }
        return null;
    }

    public static double getJLabelWidth(JLabel label, FontMetrics fm) {
        String text;
        if (label == null) {
            return 0.0;
        }
        double maxw = 0.0;
        Icon icon = label.getIcon();
        if (icon != null) {
            maxw += (double)icon.getIconWidth();
        }
        if ((text = label.getText()) != null && text.length() > 0) {
            maxw += (double)label.getIconTextGap();
            maxw += (double)GraphicsUtil.stringWidth(fm.getFont(), text);
        }
        return maxw;
    }

    public static double getToggleButtonWidth(JToggleButton comp, FontMetrics fm) {
        String text;
        if (comp == null) {
            return 0.0;
        }
        int maxw = 0;
        Icon icon = comp.getIcon();
        if (icon != null) {
            maxw += icon.getIconWidth();
        }
        if ((text = comp.getText()) != null && text.length() > 0) {
            maxw += comp.getIconTextGap();
            maxw += GraphicsUtil.stringWidth(fm.getFont(), text);
        }
        return maxw;
    }

    public static Book createCollatedCopiesForPrint(Book book, boolean collate, int numOfCopies) {
        Book collatedCopies = new Book();
        if (collate) {
            for (int copy = 0; copy < numOfCopies; ++copy) {
                for (int i = 0; book != null && i < book.getNumberOfPages(); ++i) {
                    AbstractPage aPage = (AbstractPage)book.getPrintable(i);
                    AbstractPage copiedPage = aPage.newInstance();
                    collatedCopies.append(copiedPage, copiedPage.getPageFormat());
                }
            }
        } else {
            for (int i = 0; book != null && i < book.getNumberOfPages(); ++i) {
                AbstractPage aPage = (AbstractPage)book.getPrintable(i);
                for (int copy = 0; copy < numOfCopies; ++copy) {
                    AbstractPage copiedPage = aPage.newInstance();
                    collatedCopies.append(copiedPage, copiedPage.getPageFormat());
                }
            }
        }
        return collatedCopies;
    }

    public static final Point getTreeCellRendererAlignment(JTree tree, int row, Object cellObject) {
        TreePath rowPath = tree.getPathForRow(row);
        Object lastPathComp = rowPath.getLastPathComponent();
        TreeCellRenderer cellRenderer = tree.getCellRenderer();
        boolean expanded = tree.isExpanded(rowPath);
        boolean leaf = tree.getModel().isLeaf(lastPathComp);
        Component rendererCompAtCell = cellRenderer.getTreeCellRendererComponent(tree, cellObject, false, expanded, leaf, row, false);
        int hAlignment = 10;
        int vAlignment = 11;
        if (rendererCompAtCell instanceof JLabel) {
            JLabel labelRenderer = (JLabel)rendererCompAtCell;
            int alignmentX = labelRenderer.getHorizontalAlignment();
            if (alignmentX == 2 || alignmentX == 10) {
                hAlignment = 10;
            } else if (alignmentX == 0) {
                hAlignment = 11;
            } else if (alignmentX == 11 || alignmentX == 4) {
                hAlignment = 12;
            }
            int alignmentY = labelRenderer.getVerticalAlignment();
            if (alignmentY == 1) {
                vAlignment = 13;
            } else if (alignmentY == 0) {
                vAlignment = 11;
            } else if (alignmentY == 3) {
                vAlignment = 14;
            }
        } else if (rendererCompAtCell != null) {
            float xalign = rendererCompAtCell.getAlignmentX();
            if ((double)xalign == 0.5) {
                hAlignment = 11;
            } else if ((double)xalign < 0.5) {
                hAlignment = 10;
            } else if ((double)xalign > 0.5) {
                hAlignment = 12;
            }
            float yalign = rendererCompAtCell.getAlignmentY();
            if ((double)yalign == 0.5) {
                vAlignment = 11;
            } else if ((double)yalign < 0.5) {
                vAlignment = 13;
            } else if ((double)yalign > 0.5) {
                vAlignment = 14;
            }
        }
        Point alignment = new Point(hAlignment, vAlignment);
        return alignment;
    }

    public static final double getIconWidthForTreeCell(JTree tree, int row, Object cellObject, double zoom) {
        Icon icon;
        boolean leaf;
        boolean expanded;
        double iconWidth = 0.0;
        TreePath rowPath = tree.getPathForRow(row);
        Object lastPathComp = rowPath.getLastPathComponent();
        TreeCellRenderer cellRenderer = tree.getCellRenderer();
        Component rendererCompAtCell = cellRenderer.getTreeCellRendererComponent(tree, cellObject, false, expanded = tree.isExpanded(rowPath), leaf = tree.getModel().isLeaf(lastPathComp), row, false);
        if (rendererCompAtCell instanceof JLabel && (icon = ((JLabel)rendererCompAtCell).getIcon()) != null) {
            iconWidth = icon.getIconWidth();
        }
        return iconWidth *= zoom;
    }

    public static final double getIconHeightForTreeCell(JTree tree, int row, Object cellObject, double zoom) {
        Icon icon;
        boolean leaf;
        boolean expanded;
        double iconHeight = 0.0;
        TreePath rowPath = tree.getPathForRow(row);
        Object lastPathComp = rowPath.getLastPathComponent();
        TreeCellRenderer cellRenderer = tree.getCellRenderer();
        Component rendererCompAtCell = cellRenderer.getTreeCellRendererComponent(tree, cellObject, false, expanded = tree.isExpanded(rowPath), leaf = tree.getModel().isLeaf(lastPathComp), row, false);
        if (rendererCompAtCell instanceof JLabel && (icon = ((JLabel)rendererCompAtCell).getIcon()) != null) {
            iconHeight = icon.getIconHeight();
        }
        return iconHeight *= zoom;
    }

    public static final boolean isLeaf(JTree tree, int row) {
        TreePath rowPath = tree.getPathForRow(row);
        Object lastPathComp = rowPath.getLastPathComponent();
        boolean leaf = tree.getModel().isLeaf(lastPathComp);
        return leaf;
    }

    public static final boolean isExpanded(JTree tree, int row) {
        boolean expanded = tree.isExpanded(row);
        return expanded;
    }

    public static final Image getDefaultTreeCollapsedIcon() {
        return PLUS_ICON.getImage();
    }

    public static final Image getDefaultTreeExpansionIcon() {
        return MINUS_ICON.getImage();
    }

    public static final Image getTreeNodeExpansionIcon(JTree tree, int row, Image expansionIcon, Image collapseIcon) {
        if (row == 0) {
            return null;
        }
        TreePath rowPath = tree.getPathForRow(row);
        Object lastPathComp = rowPath.getLastPathComponent();
        boolean leaf = tree.getModel().isLeaf(lastPathComp);
        if (leaf) {
            return null;
        }
        boolean expanded = tree.isExpanded(rowPath);
        if (expanded) {
            if (expansionIcon != null) {
                return expansionIcon;
            }
            return MINUS_ICON.getImage();
        }
        if (collapseIcon != null) {
            return collapseIcon;
        }
        return PLUS_ICON.getImage();
    }

    public static final int getTreeNodeIconIndentationX(JTree tree, int row, Image expansionIcon, Image collapseIcon, int nodeToNodeGap, double zoom) {
        int h = AtPrintUtil.getNodeHierarchyCount(tree, row);
        Image expCollapseIcon = AtPrintUtil.getTreeNodeExpansionIcon(tree, row, expansionIcon, collapseIcon);
        if (row > 0 && expCollapseIcon == null) {
            expCollapseIcon = expansionIcon;
        }
        double iconWidth = 0.0;
        if (expCollapseIcon != null) {
            iconWidth = expCollapseIcon.getWidth(null);
        }
        double zoomedIconWidth = iconWidth * zoom;
        double deltaX = (double)nodeToNodeGap + (double)(h - 1) * (zoomedIconWidth + (double)nodeToNodeGap);
        return (int)deltaX;
    }

    public static final int getTreeNodeExpIconCenterIndentationX(JTree tree, int row, Image expansionIcon, Image collapseIcon, int nodeToNodeGap, int treeNodeLeftX, double zoom) {
        Image expCollapseIcon = AtPrintUtil.getTreeNodeExpansionIcon(tree, row, expansionIcon, collapseIcon);
        double iconHalfWidth = 0.0;
        if (expCollapseIcon != null) {
            iconHalfWidth = (double)expCollapseIcon.getWidth(null) / 2.0;
            iconHalfWidth *= zoom;
        }
        double deltaX = (double)(treeNodeLeftX - nodeToNodeGap) - iconHalfWidth;
        return (int)deltaX;
    }

    public static Image getIconImageForTreeCell(JTree tree, int row, Object cellObject) {
        Icon icon = null;
        Component rendererCompAtCell = AtPrintUtil.getTreeCellRendererComponent(tree, row);
        if (rendererCompAtCell instanceof JLabel && (icon = ((JLabel)rendererCompAtCell).getIcon()) instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        if (icon != null) {
            int iconw = icon.getIconWidth();
            int iconh = icon.getIconHeight();
            BufferedImage bi = new BufferedImage(iconw, iconh, 1);
            Graphics2D g = bi.createGraphics();
            g.setBackground(SystemColor.white);
            g.fillRect(0, 0, bi.getWidth(), bi.getHeight());
            icon.paintIcon(tree, g, 0, 0);
            return bi;
        }
        return null;
    }

    public static final Component getTreeCellRendererComponent(JTree tree, int row) {
        TreePath rowPath = tree.getPathForRow(row);
        Object lastPathComp = rowPath.getLastPathComponent();
        TreeCellRenderer cellRenderer = tree.getCellRenderer();
        boolean expanded = tree.isExpanded(rowPath);
        boolean leaf = tree.getModel().isLeaf(lastPathComp);
        Object cellValue = null;
        if (rowPath != null) {
            Object nodeObject;
            cellValue = nodeObject = rowPath.getLastPathComponent();
        }
        Component rc = cellRenderer.getTreeCellRendererComponent(tree, cellValue, false, expanded, leaf, row, false);
        return rc;
    }

    public static final Object getTreeCellValue(JTree tree, int row) {
        Component rc = AtPrintUtil.getTreeCellRendererComponent(tree, row);
        if (rc == null) {
            return null;
        }
        if (rc instanceof JLabel) {
            String text = ((JLabel)rc).getText();
            return text;
        }
        BufferedImage img = new BufferedImage(rc.getWidth(), rc.getHeight(), 2);
        Graphics2D g = img.createGraphics();
        g.setColor(SystemColor.white);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        rc.paintAll(g);
        return img;
    }

    public static final double getTreeCellWidth(JTree tree, Object cellObject, JTable table, int row, int col, int nodeToNodeGap, FontMetrics zoomedFm, double zoom, Image expansionIcon, Image collapseIcon, boolean isUseCellRenderer) {
        TreeCellDescriptor tcd = AtPrintUtil.getTreeCellDescriptor(tree, cellObject, table, row, col, nodeToNodeGap, zoomedFm, zoom, expansionIcon, collapseIcon, isUseCellRenderer);
        return tcd.totalCellWidth;
    }

    public static final LineDescriptor getTreeRowLineDescriptor(JTree tree, int row, int nodeToNodeGap, FontMetrics zoomedFm, double zoom, PageFormat pf, Image expansionIcon, Image collapseIcon, boolean isUseCellRenderer) {
        Object value;
        TreeModel tm = tree.getModel();
        TreePath path = tree.getPathForRow(row);
        Object cellValue = null;
        Component rc = AtPrintUtil.getTreeCellRendererComponent(tree, row);
        if (path != null) {
            Object nodeObject;
            cellValue = nodeObject = path.getLastPathComponent();
        }
        JTable table = null;
        int col = -1;
        TreeCellDescriptor tcd = AtPrintUtil.getTreeCellDescriptor(tree, cellValue, table, row, col, nodeToNodeGap, zoomedFm, zoom, expansionIcon, collapseIcon, isUseCellRenderer);
        LineDescriptor ld = new LineDescriptor(pf, isUseCellRenderer);
        ld.setHorizontalGap(3);
        float currImgStartX = ld.getImageStartX();
        Image expCollapseIcon = AtPrintUtil.getTreeNodeExpansionIcon(tree, row, expansionIcon, collapseIcon);
        double expIconIndentX = -1.0;
        if (expCollapseIcon != null) {
            double iconh = expCollapseIcon.getHeight(null);
            double iconw = expCollapseIcon.getWidth(null);
            iconh *= zoom;
            int nodeIconIndentX = (int)tcd.cellStartX;
            double expIconIndentCenterX = AtPrintUtil.getTreeNodeExpIconCenterIndentationX(tree, row, expansionIcon, collapseIcon, nodeToNodeGap, nodeIconIndentX, zoom);
            expIconIndentX = expIconIndentCenterX - (iconw *= zoom) / 2.0;
        }
        Point alignments = AtPrintUtil.getTreeCellRendererAlignment(tree, row, cellValue);
        if (expCollapseIcon != null) {
            ld.setImageStartX(currImgStartX + (float)expIconIndentX);
            IconElementDescriptor expCollapseIconElm = new IconElementDescriptor(expCollapseIcon, 2, null, null, null, false);
            AtPrintUtil.populateElementProperties(expCollapseIconElm, rc, zoom, alignments);
            SplittedElement sp2 = ld.addElement(expCollapseIconElm);
            if (sp2 != null) {
                AtDebug.debug("Node expansion/collapse Image was not added.");
            }
        } else {
            ld.setImageStartX(currImgStartX + (float)tcd.cellStartX);
        }
        Image cellIcon = AtPrintUtil.getIconImageForTreeCell(tree, row, cellValue);
        if (cellIcon != null) {
            IconElementDescriptor iconElm = new IconElementDescriptor(cellIcon, 2, null, null, null, -1, -1, false);
            AtPrintUtil.populateElementProperties(iconElm, rc, zoom, alignments);
            SplittedElement sp3 = ld.addElement(iconElm);
            if (sp3 != null) {
                AtDebug.debug("Tree node Image was not added.");
            }
        }
        if ((value = AtPrintUtil.getTreeCellValue(tree, row)) != null) {
            if (value instanceof String) {
                AttributeSet elmProps = null;
                StringElementDescriptor strElm = new StringElementDescriptor((String)value, 1, zoomedFm.getFont(), zoomedFm, elmProps);
                AtPrintUtil.populateElementProperties(strElm, rc, zoom, alignments);
                SplittedElement sp4 = ld.addElement(strElm);
                if (sp4 != null) {
                    AtDebug.debug("Tree cell value as String was not added.");
                }
            } else if (value instanceof Image) {
                IconElementDescriptor iconElm = new IconElementDescriptor((Image)value, 2, null, null, null, false);
                AtPrintUtil.populateElementProperties(iconElm, rc, zoom, alignments);
                SplittedElement sp5 = ld.addElement(iconElm);
                if (sp5 != null) {
                    AtDebug.debug("Tree cell value as Image was not added.");
                }
            }
        }
        return ld;
    }

    public static final void populateElementProperties(ElementDescriptor elm, Component comp, double zoom, Point alignments) {
        elm.setZoom(zoom);
        if (comp != null) {
            if (comp.getBackground() != null) {
                elm.addStyle("BackgroundColor", comp.getBackground());
            }
            if (comp.getForeground() != null) {
                elm.addStyle("ForegroundColor", comp.getForeground());
            }
        }
        if (alignments != null) {
            int hAlignment = alignments.x;
            int vAlignment = alignments.y;
            elm.setHorizontalAlignment(hAlignment);
            elm.setVerticalAlignment(vAlignment);
        }
    }

    public static final TreeCellDescriptor getTreeCellDescriptor(JTree tree, Object cellObject, JTable table, int row, int col, int nodeToNodeGap, FontMetrics zoomedFm, double zoom, Image expansionIcon, Image collapseIcon, boolean isUseCellRenderer) {
        JTree rendererCompAtCell = tree;
        double totalw = 0.0;
        int indentX = AtPrintUtil.getTreeNodeIconIndentationX(tree, row, expansionIcon, collapseIcon, nodeToNodeGap, zoom);
        int cellIconW = 0;
        Image cellIcon = AtPrintUtil.getIconImageForTreeCell(tree, row, cellObject);
        if (cellIcon != null) {
            cellIconW = (int)((double)cellIcon.getWidth(null) * zoom);
        }
        double cellValueW = 0.0;
        if (cellObject == null) {
            double width = 0.0;
            width = table != null ? (double)table.getColumnModel().getColumn(col).getWidth() : (double)tree.getSize().width;
            cellValueW = width *= zoom;
        } else if (isUseCellRenderer) {
            double width = defaultPrintableCell.getCellWidth(table, row, col, false);
            cellValueW = width *= zoom;
        } else if (table != null && table instanceof PrintableCell) {
            double width = ((PrintableCell)((Object)table)).getCellWidth(table, row, col, false);
            cellValueW = width *= zoom;
        } else if (rendererCompAtCell != null && rendererCompAtCell instanceof JLabel) {
            double w;
            cellValueW = w = AtPrintUtil.getJLabelWidth((JLabel)((Object)rendererCompAtCell), zoomedFm);
        } else if (rendererCompAtCell != null && rendererCompAtCell instanceof JToggleButton) {
            double w;
            cellValueW = w = AtPrintUtil.getToggleButtonWidth((JToggleButton)((Object)rendererCompAtCell), zoomedFm);
        } else if (cellObject != null && cellObject instanceof Number) {
            double w;
            Number num = (Number)cellObject;
            String numValue = num.toString();
            cellValueW = w = (double)GraphicsUtil.stringWidth(zoomedFm.getFont(), numValue);
        } else if (cellObject instanceof String) {
            double w;
            String value = (String)cellObject;
            cellValueW = w = (double)GraphicsUtil.stringWidth(zoomedFm.getFont(), value);
        } else if (cellObject instanceof Icon) {
            double w;
            Icon icon = (Icon)cellObject;
            double iconw = icon.getIconWidth();
            cellValueW = w = iconw * zoom;
        } else if (cellObject instanceof Image) {
            double w;
            Image image = (Image)cellObject;
            double iconw = image.getWidth(tree);
            cellValueW = w = iconw * zoom;
        } else if (cellObject instanceof Boolean) {
            double width;
            String value = cellObject.toString();
            cellValueW = width = (double)GraphicsUtil.stringWidth(zoomedFm.getFont(), value);
        } else if (cellObject instanceof TreeNode) {
            double width;
            String value = cellObject.toString();
            cellValueW = width = (double)GraphicsUtil.stringWidth(zoomedFm.getFont(), value);
        } else {
            double width = 0.0;
            width = table != null ? (double)table.getColumnModel().getColumn(col).getWidth() : (double)tree.getSize().width;
            cellValueW = width *= zoom;
        }
        if (cellValueW > 0.0) {
            cellValueW += (double)nodeToNodeGap;
        }
        totalw = (double)(indentX + cellIconW) + cellValueW;
        TreeCellDescriptor tcd = new TreeCellDescriptor();
        tcd.cellStartX = indentX;
        tcd.cellImage = cellIcon;
        tcd.cellValue = cellObject;
        tcd.hGap = nodeToNodeGap;
        tcd.totalCellWidth = (int)totalw;
        return tcd;
    }

    public static final int getNodeHierarchyCount(JTree tree, int row) {
        TreePath rowPath = tree.getPathForRow(row);
        int pathCount = rowPath.getPathCount();
        return pathCount;
    }

    public static final int getTreeIndentationWidth(JTree tree, int row) {
        Object root = tree.getModel().getRoot();
        Image img = AtPrintUtil.getIconImageForTreeCell(tree, row, root);
        if (img != null) {
            double w = img.getWidth(null);
            double retW = w / 2.0;
            return (int)retW;
        }
        return PLUS_ICON.getIconWidth();
    }

    public static final int getRootIconWidth(JTree tree) {
        Object root = tree.getModel().getRoot();
        Image img = AtPrintUtil.getIconImageForTreeCell(tree, 0, root);
        if (img != null) {
            double w = img.getWidth(null);
            return (int)w;
        }
        return -1;
    }

    public static Pageable createPagesFromImage(Image image, int startPageNo, int pNoLocation, PageFormat pf, PageHeaderFooterListener phfListener, double zoom, DemoShape demoShape) {
        double w = image.getWidth(null);
        double h = image.getHeight(null);
        BufferedImage bi = new BufferedImage((int)(w *= zoom), (int)(h *= zoom), 1);
        Graphics bg = bi.getGraphics();
        bg.drawImage(image, 0, 0, (int)w, (int)h, null);
        Pageable pages = mathProvider.createPagesFromImage(bi, startPageNo, pNoLocation, pf, phfListener, zoom, demoShape);
        return pages;
    }

    public static final Component getTableHeaderCellRenderer(JTable table, int col) {
        JTableHeader tableHeader = table.getTableHeader();
        TableColumnModel colModel = table.getColumnModel();
        TableColumn aColumn = colModel.getColumn(col);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = tableHeader.getDefaultRenderer();
        }
        Component headerRenderer = renderer.getTableCellRendererComponent(table, aColumn.getHeaderValue(), false, false, -1, col);
        return headerRenderer;
    }

    public static void drawMultlineCellValue(Graphics graphics, JTable table, Object cellValue, int row, int col, boolean isHeaderCell, Rectangle cellBbox, double zoom, int horizontalPadding, int verticalPadding) {
        mathProvider.drawMultlineCellValue(graphics, table, cellValue, row, col, isHeaderCell, cellBbox, zoom, horizontalPadding, verticalPadding);
    }

    public static double getMaxCellHeightOfAMultilineCell(JTable table, int row, int column, boolean isHeaderCell, int inset) {
        return mathProvider.getMaxCellHeightOfAMultilineCell(table, row, column, isHeaderCell, inset);
    }

    public static double getMaxCellWidthOfMultilineCell(JTable table, int row, int column, boolean isHeaderCell, int inset) {
        return mathProvider.getMaxCellWidthOfMultilineCell(table, row, column, isHeaderCell, inset);
    }

    public static Color[] getCellBackgroundForeground(JTable table, int row, int col, boolean isHeaderRow) {
        return mathProvider.getCellBackgroundForeground(table, row, col, isHeaderRow);
    }

    public static final Color cloneColor(Color color) {
        if (color == null) {
            return null;
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int alpha = color.getAlpha();
        return new Color(r, g, b, alpha);
    }

    public static final void notifyForHeaderAndFooter(Vector pages) {
        for (int i = 0; pages != null && i < pages.size(); ++i) {
            Object page = pages.get(i);
            if (page == null || !(page instanceof AbstractReportPage)) continue;
            AbstractReportPage p = (AbstractReportPage)page;
            p.setTotalPage(pages.size());
            PageHeaderFooterListener l2 = p.getHeaderFooterListener();
            if (l2 == null) continue;
            l2.setPageHeaderAndFooter(p);
        }
    }

    public static final Font getFont(Font currFont, double zoom) {
        if (currFont == null) {
            return null;
        }
        double currSize = currFont.getSize();
        int newSize = AtPrintUtil.roundToLowerInt(currSize * zoom);
        Font newFont = new Font(currFont.getName(), currFont.getStyle(), newSize);
        return newFont;
    }

    public static final int roundToLowerInt(double value) {
        String str = String.valueOf(value);
        int decimalIdx = str.indexOf(46);
        String leftStr = null;
        leftStr = decimalIdx >= 0 ? str.substring(0, decimalIdx) : str;
        int left = 0;
        if (leftStr != null) {
            left = Integer.parseInt(leftStr);
        }
        return left;
    }

    public static final double getMaxRowNumberWidth(JTable table, double zoom) {
        int headerWidth;
        int rowCount = table.getRowCount();
        Font zoomedFont = AtPrintUtil.getFont(table.getFont(), zoom);
        FontMetrics tableFm = table.getFontMetrics(zoomedFont);
        double width = GraphicsUtil.stringWidth(tableFm.getFont(), String.valueOf(rowCount));
        if (width < (double)(headerWidth = GraphicsUtil.stringWidth(tableFm.getFont(), AtCommonResource.MESSAGE_RESOURCE.getText("ROW_ID")))) {
            width = headerWidth;
        }
        return width;
    }

    public static final double getComponentWidth(Component comp) {
        return ProviderUtil.TheProvider.getComponentWidth(comp);
    }

    public static final double calculateMaxRowHeight(JTable table, Font zoomedFont, double zoom, int row, boolean isHeaderRow) {
        int maxHeight = 0;
        int colCount = table.getColumnCount();
        for (int col = 0; col < colCount; ++col) {
            int h = defaultPrintableCell.getCellHeight(table, row, col, isHeaderRow);
            if (h <= maxHeight) continue;
            maxHeight = h;
        }
        int zoomedHeight = (int)((double)maxHeight * zoom);
        return zoomedHeight;
    }

    public static FontMetrics getFontMetrics(Font font) {
        return dummyComp.getFontMetrics(font);
    }

    public static Font getDefaultFont() {
        return dummyComp.getFont();
    }

    public static final Graphics getDefaultGraphics() {
        BufferedImage img = new BufferedImage(5, 5, 1);
        return img.getGraphics();
    }

    public static final void debugPageFormat(PageFormat pageFormat) {
        double x = pageFormat.getImageableX();
        double y = pageFormat.getImageableY();
        double iw = pageFormat.getImageableWidth();
        double ih = pageFormat.getImageableHeight();
        double w = pageFormat.getWidth();
        double h = pageFormat.getHeight();
        AtDebug.debug("PageFormat: " + pageFormat + "[ix=" + x + ", iy=" + y + ", iw=" + iw + ",ih=" + ih + ", tw=" + w + ", th=" + h + ", orientation=" + pageFormat.getOrientation() + "]");
    }

    public static int getCellAlignment(JTable table, boolean isHeaderCell, int row, int col, Object cellObject) {
        return ProviderUtil.TheProvider.getCellAlignment(table, isHeaderCell, row, col, cellObject);
    }

    public static double getCellHeight(int cellWidth, String text, Font font, FontMetrics fm, double zoom) {
        return AtPrintUtil.getCellHeight(cellWidth, text, font, fm, zoom, 5.0, 5.0, false);
    }

    public static double getCellHeight(double cellWidth, String text, Font font, FontMetrics fm, double zoom, double ipadx, double ipady, boolean isUseCellRenderer) {
        return ProviderUtil.TheProvider.getCellHeight(cellWidth, text, font, fm, zoom, ipadx, ipady, isUseCellRenderer);
    }

    static {
        dummyComp.setFont(defaultFont);
        PLUS_ICON = AtImageList.IMAGE_LIST.PLUS;
        MINUS_ICON = AtImageList.IMAGE_LIST.MINUS;
    }

    static class ProviderUtil
    implements Serializable {
        ProviderUtil() {
        }

        static class TheProvider
        implements Serializable {
            TheProvider() {
            }

            static double getCellHeight(double cellWidth, String text, Font f, FontMetrics fm, double zoom, double ipadx, double ipady, boolean isUseCellRenderer) {
                if (text == null || text.equals("")) {
                    return fm.getHeight();
                }
                Font font = AtPrintUtil.getFont(f, zoom);
                PageFormat pf = new PageFormat();
                pf.setOrientation(1);
                Paper customPaper = new Paper();
                customPaper.setSize(cellWidth, 2.147483647E9);
                customPaper.setImageableArea(ipadx, ipady, cellWidth - 2.0 * ipadx, 2.147483647E9);
                pf.setPaper(customPaper);
                AtStringElement strElm = new AtStringElement(text, font);
                Vector styleElements = TheProvider.createStyleElements(strElm);
                Vector lines = TheProvider.createLineElements(styleElements, pf, isUseCellRenderer);
                Vector pages = TheProvider.createPageElements(lines, pf, zoom, false, false, null);
                PageDescriptor page1 = (PageDescriptor)pages.get(0);
                double height = page1.getImageEnd();
                return height += 2.0 * ipady;
            }

            static Vector createStyleElements(AtStringElement strElm) {
                Color bgColor;
                Vector<StringElementDescriptor> styleElements = new Vector<StringElementDescriptor>();
                if (strElm == null || strElm.getStr() == null) {
                    throw new NullPointerException(AtCommonResource.MESSAGE_RESOURCE.getText("TRYING_TO_ADD_NULL_ELEMENT_TO_PAGEABLE"));
                }
                String elmValue = strElm.getStr();
                StringBuffer buf = new StringBuffer(elmValue.length());
                for (int i = 0; i < elmValue.length(); ++i) {
                    if (elmValue.charAt(i) == '\t') {
                        TheProvider.addTabChars(buf);
                        continue;
                    }
                    if (elmValue.charAt(i) == '\r') continue;
                    buf.append(elmValue.charAt(i));
                }
                Font font = strElm.getFont();
                if (font == null) {
                    font = AtElement.DEFAULT_FONT;
                }
                FontMetrics fm = AtElement.getFontMetrics(font);
                Color fgColor = strElm.getForeground();
                if (fgColor == null) {
                    fgColor = AtElement.DEFAULT_FOREGROUND;
                }
                if ((bgColor = strElm.getBackground()) == null) {
                    bgColor = AtElement.DEFAULT_BACKGROUND;
                }
                StringTokenizer tk = new StringTokenizer(buf.toString(), "\n", true);
                while (tk.hasMoreTokens()) {
                    String token = tk.nextToken();
                    AtDebug.debug("token=" + token);
                    if (token.equals("\n")) {
                        NewlineElementDescriptor nl = new NewlineElementDescriptor("\n", 1, AtElement.DEFAULT_FONT, AtElement.getFontMetrics(AtElement.DEFAULT_FONT), strElm.getAttributeSet());
                        nl.addStyle("Font", nl.getFont());
                        styleElements.add(nl);
                        continue;
                    }
                    StringElementDescriptor printElm = new StringElementDescriptor(token, 1, font, fm, strElm.getAttributeSet());
                    AtDebug.debug("StringElement...adding font: " + font);
                    printElm.addStyle("Font", font);
                    printElm.addStyle("ForegroundColor", fgColor);
                    printElm.addStyle("BackgroundColor", bgColor);
                    if (strElm.isUnderlined()) {
                        Boolean underlined = new Boolean(strElm.isUnderlined());
                        printElm.addStyle("Underline", underlined);
                    }
                    if (strElm.isStrikeThrough()) {
                        printElm.addStyle("StrikeThrough", new Boolean(strElm.isStrikeThrough()));
                        printElm.addStyle("StrikeThroughColor", strElm.getStrikeThroughColor());
                    }
                    styleElements.add(printElm);
                }
                return styleElements;
            }

            static void addTabChars(StringBuffer buf) {
                for (int i = 0; i < 8; ++i) {
                    buf.append(' ');
                }
            }

            static Vector createLineElements(Vector styleElements, PageFormat pageFormat, boolean isUseCellRenderer) {
                Vector<LineDescriptor> lines = new Vector<LineDescriptor>();
                LineDescriptor lineElm = new LineDescriptor(pageFormat, isUseCellRenderer);
                for (int i = 0; i < styleElements.size(); ++i) {
                    Object elmObj = styleElements.get(i);
                    ElementDescriptor elm = (ElementDescriptor)elmObj;
                    if (elm == null) continue;
                    if (elm instanceof NewlineElementDescriptor) {
                        lineElm.lineFilled = true;
                        lines.add(lineElm);
                        lineElm = new LineDescriptor(pageFormat, isUseCellRenderer);
                        continue;
                    }
                    SplittedElement spElm = lineElm.addElement(elm);
                    if (spElm != null) {
                        AtDebug.debug("got the splitted elm, elm1= [" + spElm.element1 + "], elm2=[" + spElm.element2 + "]");
                    }
                    if (spElm == null) continue;
                    if (spElm.elmType == 1) {
                        if (spElm.splitted) {
                            styleElements.setElementAt(spElm.element1, i);
                            styleElements.insertElementAt(spElm.element2, i + 1);
                        } else {
                            styleElements.insertElementAt(spElm.element2, i + 1);
                        }
                    } else if (spElm.elmType == 2 || spElm.elmType == 3) {
                        // empty if block
                    }
                    lines.add(lineElm);
                    lineElm = new LineDescriptor(pageFormat, isUseCellRenderer);
                }
                if (lineElm != null && lineElm.getElementCount() > 0) {
                    lineElm.lineFilled = true;
                    lines.add(lineElm);
                }
                return lines;
            }

            static Vector createPageElements(Vector lines, PageFormat pf, double zoom, boolean antiAliased, boolean isUseCellRenderer, DemoShape demoShape) {
                ArrayList<Page> allPrintables = new ArrayList<Page>();
                Vector<PageDescriptor> pages = new Vector<PageDescriptor>();
                PageFormat pageFormat = pf;
                int pageNoLoc = 4;
                int pageNo = 1;
                LineDescriptor line = null;
                PageDescriptor page = new PageDescriptor((float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getImageableHeight());
                for (int i = 0; i < lines.size(); ++i) {
                    Page aPrintable;
                    Object lineObject = lines.elementAt(i);
                    if (lineObject instanceof PageBreakDescriptor) {
                        if (page.getLineCount() <= 0) continue;
                        page.pageFilled = true;
                        pages.add(page);
                        Page aPrintable2 = new Page(page, pageNo++, pageNoLoc, pageFormat, null, zoom, antiAliased, isUseCellRenderer, demoShape);
                        allPrintables.add(aPrintable2);
                        page = new PageDescriptor((float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getImageableHeight());
                        continue;
                    }
                    line = (LineDescriptor)lineObject;
                    if (page.add(line)) continue;
                    boolean isBiggerThanAvailableHeight = page.isBiggerThanAvailableHeight(line);
                    if (isBiggerThanAvailableHeight) {
                        if (page.getLineCount() == 0) {
                            page.addOnlyElement(line);
                            page.usedImageHeight += line.getMaxHeight();
                            page.usedImageHeight += line.getLineGap();
                            page.pageFilled = true;
                            pages.add(page);
                            aPrintable = new Page(page, pageNo++, pageNoLoc, pageFormat, null, zoom, antiAliased, isUseCellRenderer, demoShape);
                            allPrintables.add(aPrintable);
                            page = new PageDescriptor((float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getImageableHeight());
                            continue;
                        }
                        page.pageFilled = true;
                        pages.add(page);
                        aPrintable = new Page(page, pageNo++, pageNoLoc, pageFormat, null, zoom, antiAliased, isUseCellRenderer, demoShape);
                        allPrintables.add(aPrintable);
                        page = new PageDescriptor((float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getImageableHeight());
                        page.add(line);
                        continue;
                    }
                    pages.add(page);
                    aPrintable = new Page(page, pageNo++, pageNoLoc, pageFormat, null, zoom, antiAliased, isUseCellRenderer, demoShape);
                    allPrintables.add(aPrintable);
                    page = new PageDescriptor((float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getImageableHeight());
                    page.add(line);
                }
                if (!page.pageFilled && page.getLineCount() > 0) {
                    pages.add(page);
                    Page aPrintable = new Page(page, pageNo++, pageNoLoc, pageFormat, null, zoom, antiAliased, isUseCellRenderer, demoShape);
                    allPrintables.add(aPrintable);
                }
                return pages;
            }

            static int getCellAlignment(JTable table, boolean isHeaderCell, int row, int col, Object cellObject) {
                Component rendererComp = null;
                if (isHeaderCell) {
                    JTableHeader tableHeader = table.getTableHeader();
                    TableCellRenderer headerRenderer = tableHeader.getColumnModel().getColumn(col).getHeaderRenderer();
                    if (headerRenderer != null) {
                        rendererComp = headerRenderer.getTableCellRendererComponent(table, cellObject, false, false, 0, col);
                    }
                } else {
                    TableCellRenderer cellRenderer = table.getCellRenderer(row, col);
                    if (cellRenderer != null) {
                        rendererComp = cellRenderer.getTableCellRendererComponent(table, cellObject, false, false, row, col);
                    }
                }
                if (rendererComp != null) {
                    if (rendererComp instanceof JLabel) {
                        JLabel labelRenderer = (JLabel)rendererComp;
                        int alignment = labelRenderer.getHorizontalAlignment();
                        if (alignment == 2 || alignment == 10) {
                            return 10;
                        }
                        if (alignment == 0) {
                            return 11;
                        }
                        if (alignment == 11 || alignment == 4) {
                            return 12;
                        }
                        return 10;
                    }
                    if (rendererComp instanceof JTree) {
                        JTree tree = (JTree)rendererComp;
                        Point alignments = AtPrintUtil.getTreeCellRendererAlignment(tree, row, cellObject);
                        int cellHAlignment = alignments.x;
                        return cellHAlignment;
                    }
                    return 10;
                }
                return 10;
            }

            static double getComponentWidth(Component comp) {
                double compWidth = -1.0;
                if (comp == null) {
                    return -1.0;
                }
                if (comp instanceof JLabel) {
                    compWidth = TheProvider.getJLabelWidth((JLabel)comp);
                } else if (comp instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)comp;
                    JLabel label = new JLabel(button.getText(), button.getIcon(), 10);
                    compWidth = TheProvider.getJLabelWidth(label);
                } else {
                    return comp.getWidth();
                }
                return compWidth;
            }

            static int getJLabelWidth(JLabel comp) {
                String label;
                int compWidth = 6;
                Icon icon = comp.getIcon();
                if (icon != null) {
                    compWidth += 3;
                    compWidth += icon.getIconWidth();
                    compWidth += 3;
                }
                if ((label = comp.getText()) != null) {
                    compWidth += GraphicsUtil.stringWidth(comp.getFont(), label);
                    compWidth += 3;
                }
                return compWidth;
            }
        }
    }

    public static class TreeCellDescriptor
    implements Serializable {
        public double hGap = -1.0;
        public double cellStartX = -1.0;
        public Image cellImage;
        public Object cellValue;
        public double totalCellWidth = -1.0;
    }
}

