/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report;

import com.activetree.common.report.AtElement;
import com.activetree.common.report.AtLineElement;
import com.activetree.common.report.internal.ElementDescriptor;
import com.activetree.common.resource.AtConstants;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class AtShapeElement
extends ElementDescriptor {
    private static final AttributeSet defaultAttrSet = new SimpleAttributeSet();
    protected boolean fitShapeToWidth;
    protected Paint foreground = AtConstants.DEFAULT_FOREGROUND;
    protected Paint background = SystemColor.white;
    protected boolean isFill = false;

    public AtShapeElement(AtElement shape) {
        super(4, shape, AtElement.DEFAULT_FONT, AtElement.getFontMetrics(AtElement.DEFAULT_FONT), defaultAttrSet);
        if (shape instanceof AtLineElement) {
            AtLineElement line = (AtLineElement)shape;
            this.foreground = line.getForeGround();
            this.background = line.getBackground();
            this.fitShapeToWidth = line.isFitToWidth();
            this.fitShapeToWidth = line.isFitToWidth();
        }
    }

    public ElementDescriptor newInstance() {
        AtElement shape = (AtElement)this.value;
        AtShapeElement c = new AtShapeElement(shape);
        c.attrSet = this.attrSet;
        c.bbox = (Rectangle)this.bbox.clone();
        c.borderColor = this.borderColor;
        c.elementType = this.elementType;
        c.font = this.font;
        c.fontMetrics = this.fontMetrics;
        c.value = this.value;
        c.isDrawCellBorder = this.isDrawCellBorder;
        c.fitShapeToWidth = this.fitShapeToWidth;
        c.foreground = this.foreground;
        c.background = this.background;
        c.isFill = this.isFill;
        return c;
    }

    public boolean isFitShapeToWidth() {
        return this.fitShapeToWidth;
    }

    public void setFitShapeToWidth(boolean fitShapeToWidth) {
        this.fitShapeToWidth = fitShapeToWidth;
    }

    public Paint getForeground() {
        return this.foreground;
    }

    public void setForeground(Paint foreground) {
        this.foreground = foreground;
    }

    public Paint getBackground() {
        return this.background;
    }

    public void setBackground(Paint background) {
        this.background = background;
    }

    public boolean isFill() {
        return this.isFill;
    }

    public void setFill(boolean fill) {
        this.isFill = fill;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public float getWidth() {
        AtLineElement shape = (AtLineElement)this.getValue();
        if (shape == null) {
            return 0.0f;
        }
        float leftIndent = this.getLeftIndent();
        float sw = shape.getWidth();
        float w = leftIndent + sw;
        return w;
    }

    public float getHeight() {
        return super.getFontMetrics().getHeight();
    }
}

