/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report;

import com.activetree.common.report.AtElement;
import com.activetree.common.report.AtPrintUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class AtStringElement
extends AtElement {
    protected String str;
    protected Font font = DEFAULT_FONT;
    protected Color foreground = DEFAULT_FOREGROUND;
    protected Color background = DEFAULT_BACKGROUND;
    protected boolean underlined = false;
    protected boolean strikeThrough = false;
    protected Color strikeThroughColor = SystemColor.black;
    protected SimpleAttributeSet attrs = new SimpleAttributeSet();

    public AtStringElement(String str) {
        this(str, DEFAULT_FONT);
    }

    public AtStringElement(String str, Font font) {
        this(str, font, DEFAULT_FOREGROUND);
    }

    public AtStringElement(String str, Font font, Color foreground) {
        this(str, font, foreground, DEFAULT_BACKGROUND);
    }

    public AtStringElement(String str, Font font, Color foreground, Color background) {
        this(str, font, foreground, background, false);
    }

    public AtStringElement(String str, Font font, Color foreground, Color background, boolean underlined) {
        this.str = str;
        this.font = font;
        this.foreground = foreground;
        this.background = background;
        this.underlined = underlined;
        this.setLineSpacing(2.0f);
    }

    public AtStringElement getZoomedStringElement(double zoom) {
        Font zoomedFont = AtPrintUtil.getFont(this.getFont(), zoom);
        AtStringElement newElm = new AtStringElement(this.getText());
        newElm.setAlignment(this.getAlignment());
        newElm.setBackground(this.getBackground());
        newElm.setForeground(this.getForeground());
        newElm.setFont(zoomedFont);
        newElm.setLineSpacing(this.getLineSpacing());
        newElm.setStrikeThrough(this.isStrikeThrough());
        newElm.setStrikeThroughColor(this.getStrikeThroughColor());
        newElm.setUnderslined(this.isUnderlined());
        return newElm;
    }

    public String getText() {
        return this.getStr();
    }

    public void setText(String newText) {
        this.setStr(newText);
    }

    public void setLineSpacing(float lineSpacing) {
        this.attrs.addAttribute(StyleConstants.LineSpacing, new Float(lineSpacing));
    }

    public float getLineSpacing() {
        Object ls = this.attrs.getAttribute(StyleConstants.LineSpacing);
        if (ls != null && ls instanceof Number) {
            Number n = (Number)ls;
            return n.floatValue();
        }
        return 0.0f;
    }

    public AttributeSet getAttributeSet() {
        return this.attrs;
    }

    public String getStr() {
        return this.str;
    }

    public void setStr(String str) {
        this.str = str;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public void setUnderslined(boolean underlined) {
        this.underlined = underlined;
    }

    public void setStrikeThrough(boolean strikeThrough) {
        this.strikeThrough = strikeThrough;
    }

    public boolean isStrikeThrough() {
        return this.strikeThrough;
    }

    public Color getStrikeThroughColor() {
        return this.strikeThroughColor;
    }

    public void setStrikeThroughColor(Color strikeThroughColor) {
        this.strikeThroughColor = strikeThroughColor;
    }
}

