/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.internal;

import com.activetree.common.report.AtElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.text.AttributeSet;

public abstract class ElementDescriptor
implements Serializable {
    public static final String BACKGROUND_COLOR = "BackgroundColor";
    public static final String FOREGROUND_COLOR = "ForegroundColor";
    public static final String FONT = "Font";
    public static final String UNDERLINE = "Underline";
    public static final String STRIKE_THROUGH = "StrikeThrough";
    public static final String STRIKE_THROUGH_COLOR = "StrikeThroughColor";
    public static final String LEFT_INDENT = "LeftIndent";
    public static final int STRING_ELEMENT = 1;
    public static final int ICON_ELEMENT = 2;
    public static final int COMPONENT_ELEMENT = 3;
    public static final int SHAPE_ELEMENT = 4;
    public static final int TABLE_ELEMENT = 5;
    public static final int LEADING = 10;
    public static final int CENTER = 11;
    public static final int TRAILING = 12;
    public static final int TOP = 13;
    public static final int BOTTOM = 14;
    protected Hashtable styles = new Hashtable();
    protected int elementType = -1;
    protected Object value;
    protected Font font;
    protected FontMetrics fontMetrics;
    protected AttributeSet attrSet;
    protected boolean isDrawCellBorder = false;
    protected Rectangle bbox = new Rectangle();
    protected Color borderColor = SystemColor.LIGHT_GRAY;
    protected int hAlignment = 10;
    protected int vAlignment = 14;
    private double zoom = 1.0;

    public ElementDescriptor() {
    }

    public ElementDescriptor(int elementType, Object value, Font elmFont, FontMetrics elmFm, AttributeSet elmProperties) {
        this.elementType = elementType;
        this.value = value;
        this.font = elmFont;
        this.fontMetrics = elmFm;
        this.attrSet = elmProperties;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public int getHorizontalAlignment() {
        return this.hAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        this.hAlignment = alignment;
    }

    public int getVerticalAlignment() {
        return this.vAlignment;
    }

    public void setVerticalAlignment(int vAlignment) {
        this.vAlignment = vAlignment;
    }

    public void setValueType(int valueType) {
        this.elementType = valueType;
    }

    public int getValueType() {
        return this.elementType;
    }

    public Object getValue() {
        return this.value;
    }

    public void setFont(Font elementFont) {
        this.font = elementFont;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFontMetrics(FontMetrics elmFm) {
        this.fontMetrics = elmFm;
    }

    public FontMetrics getFontMetrics() {
        if (this.fontMetrics == null && this.font != null) {
            this.fontMetrics = AtElement.getFontMetrics(this.font);
        }
        return this.fontMetrics;
    }

    public AttributeSet getAttributeSet() {
        return this.attrSet;
    }

    public void setAttributeSet(AttributeSet aSet) {
        this.attrSet = aSet;
    }

    public String toString() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public abstract void setValue(Object var1);

    public abstract float getWidth();

    public abstract float getHeight();

    public abstract ElementDescriptor newInstance();

    public float getLeftIndent() {
        Number li = (Number)this.getStyle(LEFT_INDENT);
        if (li != null) {
            return li.floatValue();
        }
        return 0.0f;
    }

    public boolean isDrawBorder() {
        return this.isDrawCellBorder;
    }

    public void setDrawBorder(boolean drawCellBorder) {
        this.isDrawCellBorder = drawCellBorder;
    }

    public void setX(float x) {
        this.bbox.x = (int)x;
    }

    public void setY(float y) {
        this.bbox.y = (int)y;
    }

    public float getX() {
        return this.bbox.x;
    }

    public float getY() {
        return this.bbox.y;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Rectangle getBounds() {
        return (Rectangle)this.bbox.clone();
    }

    public void setBounds(Rectangle newBounds) {
        this.bbox = newBounds;
    }

    public void setWidth(float width) {
        this.bbox.width = (int)width;
    }

    public void setHeight(float height) {
        this.bbox.height = (int)height;
    }

    public Object getStyle(Object styleKey) {
        Object value = this.styles.get(styleKey);
        if (value == null && styleKey.equals(FONT)) {
            value = this.getFont();
        }
        return value;
    }

    public Hashtable getStyles() {
        return (Hashtable)this.styles.clone();
    }

    public void setStyles(Hashtable styles) {
        this.styles = styles;
    }

    public void addStyle(Object key, Object value) {
        if (key != null && value != null) {
            this.styles.put(key, value);
        }
    }
}

