/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.internal;

import com.activetree.common.report.AtPrintUtil;
import com.activetree.common.report.internal.ElementDescriptor;
import com.activetree.common.report.internal.LineDescriptor;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Vector;

public class PageDescriptor
implements Serializable {
    protected float imageX = 0.0f;
    protected float imageY = 0.0f;
    public float imageableHeight = 0.0f;
    public boolean pageFilled = false;
    public float usedImageHeight = 0.0f;
    Vector lines = new Vector();
    float pageY = 0.0f;

    private PageDescriptor() {
    }

    public PageDescriptor(float imageX, float imageY, float imageableHeight) {
        this.imageX = imageX;
        this.imageY = imageY;
        this.imageableHeight = imageableHeight;
    }

    public PageDescriptor newInstance() {
        PageDescriptor pd = new PageDescriptor();
        pd.imageX = this.imageX;
        pd.imageY = this.imageY;
        pd.imageableHeight = this.imageableHeight;
        pd.pageFilled = this.pageFilled;
        pd.usedImageHeight = this.usedImageHeight;
        if (pd.lines != null) {
            pd.lines = (Vector)this.lines.clone();
        }
        pd.pageY = this.pageY;
        return pd;
    }

    public Vector getLines() {
        return this.lines;
    }

    public int getLineCount() {
        if (this.lines == null) {
            return 0;
        }
        return this.lines.size();
    }

    public void setPageFilled(boolean pageFilled) {
        this.pageFilled = pageFilled;
    }

    public boolean isPageFilled() {
        return this.pageFilled;
    }

    public boolean addOnlyElement(LineDescriptor line) {
        this.lines.add(line);
        this.usedImageHeight = this.imageableHeight;
        return true;
    }

    public boolean add(LineDescriptor line) {
        float linegap;
        float lineTopY = this.imageY + this.usedImageHeight;
        float maxImageableHeight = this.imageableHeight;
        float availablePageHeight = maxImageableHeight - this.usedImageHeight;
        float lineMaxHeight = line.getMaxHeight();
        float spaceabove = line.getSpaceAbove();
        float gap = spaceabove > (linegap = line.getLineSpacing()) ? spaceabove : linegap;
        if ((lineMaxHeight += gap) > availablePageHeight) {
            this.pageFilled = true;
            return false;
        }
        this.lines.add(line);
        this.setBBoxYLocation(line, lineTopY);
        this.usedImageHeight += lineMaxHeight;
        return true;
    }

    public boolean forceAdd(LineDescriptor line) {
        float linegap;
        float lineTopY = this.imageY + this.usedImageHeight;
        float maxImageableHeight = this.imageableHeight;
        float availablePageHeight = maxImageableHeight - this.usedImageHeight;
        float lineMaxHeight = line.getMaxHeight();
        float spaceabove = line.getSpaceAbove();
        float gap = spaceabove > (linegap = line.getLineSpacing()) ? spaceabove : linegap;
        lineMaxHeight += gap;
        boolean retValue = true;
        if (lineMaxHeight > availablePageHeight) {
            this.pageFilled = true;
            retValue = false;
        }
        this.lines.add(line);
        this.setBBoxYLocation(line, lineTopY);
        this.usedImageHeight += lineMaxHeight;
        return retValue;
    }

    private void setBBoxYLocation(LineDescriptor aLine, float lineTopY) {
        if (aLine == null) {
            return;
        }
        ElementDescriptor[] elms = aLine.getElements();
        for (int i = 0; elms != null && i < elms.length; ++i) {
            ElementDescriptor elm = elms[i];
            if (elm == null) continue;
            elm.setY(lineTopY);
        }
    }

    public boolean isBiggerThanAvailableHeight(LineDescriptor line) {
        float maxImageableHeight = this.imageableHeight;
        float availablePageHeight = maxImageableHeight - this.usedImageHeight;
        float lineMaxHeight = line.getMaxHeight();
        return lineMaxHeight > availablePageHeight;
    }

    public float getImageableHeight() {
        return this.imageableHeight;
    }

    public int getImageEnd() {
        this.draw(AtPrintUtil.getDefaultGraphics());
        return (int)this.pageY;
    }

    public double getZoom() {
        if (this.lines != null) {
            int lineCount = this.lines.size();
            for (int line = 0; line < lineCount; ++line) {
                ElementDescriptor ed;
                LineDescriptor aLine = (LineDescriptor)this.lines.elementAt(line);
                if (aLine == null || aLine.getElementCount() <= 0 || (ed = aLine.getElement(0)) == null) continue;
                double zoom = ed.getZoom();
                return zoom;
            }
        }
        return 1.0;
    }

    public void draw(Graphics g) {
        LineDescriptor line = null;
        this.pageY = this.imageY;
        for (int i = 0; i < this.lines.size(); ++i) {
            float linegap;
            line = (LineDescriptor)this.lines.elementAt(i);
            float spaceabove = line.getSpaceAbove();
            float gap = spaceabove > (linegap = line.getLineGap()) ? spaceabove : linegap;
            this.pageY += gap;
            line.previousLineY = this.pageY;
            line.draw(g);
            this.pageY += line.getMaxHeight();
        }
        if (line != null) {
            this.pageY += line.getSpaceBelow();
        }
    }
}

