/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.internal;

import com.activetree.common.internal.DemoShape;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.report.AtPrintUtil;
import com.activetree.common.report.PageHeaderFooterListener;
import com.activetree.common.report.page.AbstractReportPage;
import com.activetree.common.report.page.ImagePage;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PrintMathProvider
implements Serializable {
    public Pageable createPagesFromImage(BufferedImage image, int startPageNo, int pNoLocation, PageFormat pf, PageHeaderFooterListener phfListener, double zoom, DemoShape demoShape) {
        Book pages = new Book();
        if (image == null) {
            return pages;
        }
        int imageHeight = image.getHeight(null);
        int startY = 0;
        AtDebug.debug("doing horizontalBreak()");
        do {
            Pageable hPages = this.horizontalBreak(image, pf, startY, (int)pf.getImageableWidth(), (int)pf.getImageableHeight(), (int)pf.getImageableX(), (int)pf.getImageableY(), startPageNo, pNoLocation, phfListener, zoom, demoShape);
            for (int i = 0; hPages != null && i < hPages.getNumberOfPages(); ++i) {
                AbstractPage aPage = (AbstractPage)hPages.getPrintable(i);
                pages.append(aPage, aPage.getPageFormat());
            }
        } while ((startY = (int)((double)startY + pf.getImageableHeight())) < imageHeight);
        for (int i = 0; pages != null && i < pages.getNumberOfPages(); ++i) {
            AbstractReportPage aPage = (AbstractReportPage)pages.getPrintable(i);
            aPage.setPageNumber(startPageNo++);
            aPage.setPageNumbeLocation(pNoLocation);
        }
        AtDebug.debug("done horizontalBreak()");
        return pages;
    }

    private Pageable horizontalBreak(BufferedImage image, PageFormat pageFormat, int startY, int imageableWidth, int imageableHeight, int imgStartX, int imgStartY, int startPageNo, int pNoLoc, PageHeaderFooterListener phfListener, double zoom, DemoShape demoShape) {
        Book hPages = new Book();
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        int x1 = 0;
        int y1 = startY;
        int x2 = x1 + imageableWidth;
        int y2 = y1 + imageableHeight;
        while (true) {
            if (x2 > imageWidth) {
                x2 = imageWidth;
            }
            if (y2 > imageHeight) {
                y2 = imageHeight;
            }
            BufferedImage pageImage = image.getSubimage(x1, y1, x2 - x1, y2 - y1);
            ImagePage page = new ImagePage(pageImage, imgStartX, imgStartY, pageFormat, startPageNo++, pNoLoc, phfListener, zoom, false, false, demoShape);
            hPages.append(page, page.getPageFormat());
            if (x2 >= imageWidth) break;
            x1 = x2;
            x2 = x1 + imageableWidth;
        }
        return hPages;
    }

    public void drawMultlineCellValue(Graphics graphics, JTable table, Object cellValue, int row, int col, boolean isHeaderCell, Rectangle cellBbox, double zoom, int horizontalPadding, int verticalPadding) {
        Graphics2D g2d = (Graphics2D)graphics;
        Color orgColor = g2d.getColor();
        Font orgFont = g2d.getFont();
        Font currFont = table.getFont();
        Color[] colors = this.getCellBackgroundForeground(table, row, col, isHeaderCell);
        Color cellBg = colors[0];
        Color cellFg = colors[1];
        if (isHeaderCell) {
            currFont = table.getTableHeader().getFont();
            g2d.setColor(cellBg);
            g2d.fill(cellBbox);
            g2d.setColor(cellBg.darker());
            g2d.draw(new Rectangle(cellBbox.x, cellBbox.y, cellBbox.width - 1, cellBbox.height - 1));
            g2d.setColor(cellBg.brighter());
            g2d.draw(new Rectangle(cellBbox.x + 1, cellBbox.y + 1, cellBbox.width - 2, cellBbox.height - 2));
        }
        if (!cellBg.equals(SystemColor.white)) {
            g2d.setColor(cellBg);
            g2d.fill(cellBbox);
        }
        Font zoomedFont = AtPrintUtil.getFont(currFont, zoom);
        FontMetrics fm = table.getFontMetrics(zoomedFont);
        g2d.setFont(zoomedFont);
        g2d.setColor(cellFg);
        String text = (String)cellValue;
        float sx = cellBbox.x + horizontalPadding;
        float sy = cellBbox.y + verticalPadding;
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            String aLine = st.nextToken();
            g2d.drawString(aLine, sx, sy += (float)(fm.getHeight() / 4 * 3));
            sy += (float)(fm.getHeight() / 4);
            sy += (float)fm.getLeading();
        }
        g2d.setColor(orgColor);
        g2d.setFont(orgFont);
    }

    public double getMaxCellHeightOfAMultilineCell(JTable table, int row, int column, boolean isHeaderCell, int inset) {
        TableModel model = table.getModel();
        Object value = null;
        if (isHeaderCell) {
            JTableHeader header = table.getTableHeader();
            TableColumnModel tcm = header.getColumnModel();
            value = tcm.getColumn(column).getHeaderValue();
        } else {
            value = model.getValueAt(row, column);
        }
        Font currFont = table.getFont();
        if (isHeaderCell) {
            currFont = table.getTableHeader().getFont();
        }
        FontMetrics fm = table.getFontMetrics(currFont);
        String cellString = null;
        if (value instanceof String) {
            cellString = (String)value;
        } else if (value != null) {
            cellString = value.toString();
        }
        StringTokenizer stk = new StringTokenizer(cellString, "\n");
        int lineCount = stk.countTokens();
        float cellHeight = lineCount * fm.getHeight();
        return cellHeight += (float)(2 * inset);
    }

    public double getMaxCellWidthOfMultilineCell(JTable table, int row, int column, boolean isHeaderCell, int cellToTextMargin) {
        Font currFont = table.getFont();
        if (isHeaderCell) {
            currFont = table.getTableHeader().getFont();
        }
        FontMetrics fm = table.getFontMetrics(currFont);
        double maxw = 0.0;
        maxw = isHeaderCell ? this.getMaxWidthOfMultilineHeaderCell(table, column, fm) : this.getMaxWidthOfMultilineRowCell(table, row, column, fm);
        return maxw += (double)(2 * cellToTextMargin);
    }

    public double getMaxWidthOfMultilineHeaderCell(JTable table, int column, FontMetrics fm) {
        Object headerValue = table.getColumnModel().getColumn(column).getHeaderValue();
        String value = null;
        if (headerValue != null && headerValue instanceof String) {
            value = (String)headerValue;
        } else if (headerValue != null) {
            value = headerValue.toString();
        }
        double maxw = 0.0;
        if (value != null) {
            StringTokenizer stk = new StringTokenizer(value, "\n");
            while (stk.hasMoreTokens()) {
                String aLine = stk.nextToken();
                float linew = GraphicsUtil.stringWidth(fm.getFont(), aLine);
                if (!(maxw < (double)linew)) continue;
                maxw = linew;
            }
        }
        return maxw;
    }

    public double getMaxWidthOfMultilineRowCell(JTable table, int row, int column, FontMetrics fm) {
        double maxw = 0.0;
        TableModel model = table.getModel();
        String value = (String)model.getValueAt(row, column);
        StringTokenizer stk = new StringTokenizer(value, "\n");
        while (stk.hasMoreTokens()) {
            String aLine = stk.nextToken();
            float linew = GraphicsUtil.stringWidth(fm.getFont(), aLine);
            if (!(maxw < (double)linew)) continue;
            maxw = linew;
        }
        return maxw;
    }

    public Color[] getCellBackgroundForeground(JTable table, int row, int col, boolean isHeaderRow) {
        Object cellObject = null;
        if (isHeaderRow) {
            TableColumnModel tcm = table.getColumnModel();
            TableColumn tc = tcm.getColumn(col);
            cellObject = tc.getHeaderValue();
        } else {
            cellObject = table.getValueAt(row, col);
        }
        TableCellRenderer rendererAtCell = null;
        rendererAtCell = isHeaderRow ? table.getColumnModel().getColumn(col).getHeaderRenderer() : table.getCellRenderer(row, col);
        Component rendererCompAtCell = null;
        if (rendererAtCell != null) {
            rendererCompAtCell = isHeaderRow ? rendererAtCell.getTableCellRendererComponent(table, cellObject, false, false, -1, col) : rendererAtCell.getTableCellRendererComponent(table, cellObject, false, false, row, col);
        }
        Color bg = SystemColor.white;
        Color fg = SystemColor.black;
        if (rendererCompAtCell != null) {
            bg = rendererCompAtCell.getBackground();
            fg = rendererCompAtCell.getForeground();
        }
        Color[] retColors = new Color[]{bg, fg};
        return retColors;
    }

    public Border getCellBorder(JTable table, int row, int col, boolean isHeaderRow) {
        Object cellObject = null;
        if (isHeaderRow) {
            TableColumnModel tcm = table.getColumnModel();
            TableColumn tc = tcm.getColumn(col);
            cellObject = tc.getHeaderValue();
        } else {
            cellObject = table.getValueAt(row, col);
        }
        TableCellRenderer rendererAtCell = null;
        rendererAtCell = isHeaderRow ? table.getColumnModel().getColumn(col).getHeaderRenderer() : table.getCellRenderer(row, col);
        Component rendererCompAtCell = null;
        if (rendererAtCell != null) {
            rendererCompAtCell = isHeaderRow ? rendererAtCell.getTableCellRendererComponent(table, cellObject, false, false, -1, col) : rendererAtCell.getTableCellRendererComponent(table, cellObject, false, false, row, col);
        }
        if (rendererCompAtCell != null && rendererCompAtCell instanceof JComponent) {
            JComponent c = (JComponent)rendererCompAtCell;
            Border b = c.getBorder();
            return b;
        }
        return null;
    }

    public Component getCellComponent(JTable table, int row, int col, boolean isHeaderCell) {
        Object cellObject = null;
        if (isHeaderCell) {
            TableColumnModel tcm = table.getColumnModel();
            TableColumn tc = tcm.getColumn(col);
            cellObject = tc.getHeaderValue();
        } else {
            cellObject = table.getValueAt(row, col);
        }
        TableCellRenderer rendererAtCell = null;
        rendererAtCell = isHeaderCell ? table.getColumnModel().getColumn(col).getHeaderRenderer() : table.getCellRenderer(row, col);
        Component rendererCompAtCell = null;
        if (rendererAtCell != null) {
            rendererCompAtCell = isHeaderCell ? rendererAtCell.getTableCellRendererComponent(table, cellObject, false, false, -1, col) : rendererAtCell.getTableCellRendererComponent(table, cellObject, false, false, row, col);
        }
        return rendererCompAtCell;
    }
}

