/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.internal;

import com.activetree.common.report.AtPrintUtil;
import com.activetree.common.report.internal.ElementDescriptor;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.text.AttributeSet;

public class StringElementDescriptor
extends ElementDescriptor {
    public StringElementDescriptor(String value, int elementType, Font elmFont, FontMetrics elmFm, AttributeSet elmProperties) {
        super(elementType, value, elmFont, elmFm, elmProperties);
    }

    public ElementDescriptor newInstance() {
        String value = (String)this.value;
        int elementType = this.elementType;
        Font font = this.font;
        FontMetrics fm = this.fontMetrics;
        AttributeSet attrs = this.attrSet;
        StringElementDescriptor c = new StringElementDescriptor(value, elementType, font, fm, attrs);
        c.attrSet = this.attrSet;
        c.bbox = (Rectangle)this.bbox.clone();
        c.borderColor = this.borderColor;
        c.elementType = this.elementType;
        c.font = font;
        c.fontMetrics = this.fontMetrics;
        c.value = value;
        c.isDrawCellBorder = this.isDrawCellBorder;
        c.styles.putAll(this.styles);
        return c;
    }

    public void setValue(Object value) {
        if (!(value instanceof String)) {
            throw new RuntimeException(this.getClass().getName() + ": value is not String.");
        }
        this.value = value;
    }

    public float getWidth() {
        String value = (String)this.getValue();
        Font font = (Font)this.getStyle("Font");
        if (font == null) {
            font = this.getFont();
        }
        float leftIndent = this.getLeftIndent();
        float sw = GraphicsUtil.stringWidth(font, value);
        float w = leftIndent + sw;
        return w;
    }

    public float getHeight() {
        Font font = (Font)this.getStyle("Font");
        FontMetrics fm = AtPrintUtil.getFontMetrics(font);
        return fm.getHeight();
    }

    public char[] getCharElements() {
        String value = (String)this.getValue();
        return value.toCharArray();
    }

    public float getCharWidth(char ch) {
        Font font = (Font)this.getStyle("Font");
        FontMetrics fm = AtPrintUtil.getFontMetrics(font);
        float cw = fm.charWidth(ch);
        return cw;
    }
}

