/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableInfoHolder
implements Serializable {
    public static Color headerBgColor = new Color(204, 204, 204);
    protected JTable table;
    protected boolean drawCellBorder = true;
    protected boolean drawHeader = true;
    protected boolean repeatHeader = true;
    protected boolean headerBold = false;
    protected boolean isFitToPageWidth = false;
    protected boolean isFitSmallerTableToPageWidth = false;
    protected boolean isUseCellRenderer = false;
    protected Font cellFont;
    protected Color cellBackground;
    protected Color cellForeground;

    public TableInfoHolder(JTable table, boolean drawCellBorder, boolean drawHeader, boolean repeatHeader, boolean headerBold, Font cellFont, Color cellBackground, Color cellForeground, boolean isFitToPageWidth, boolean isFitSmallerTableToPageWidth, boolean isUseCellRenderer) {
        this.table = table;
        this.drawCellBorder = drawCellBorder;
        this.drawHeader = drawHeader;
        this.repeatHeader = repeatHeader;
        this.headerBold = headerBold;
        this.cellFont = cellFont;
        this.cellBackground = cellBackground;
        this.cellForeground = cellForeground;
        this.isFitToPageWidth = isFitToPageWidth;
        this.isFitSmallerTableToPageWidth = isFitSmallerTableToPageWidth;
        this.isUseCellRenderer = isUseCellRenderer;
    }

    public TableInfoHolder(TableModel tm, boolean drawCellBorder, boolean drawHeader, boolean repeatHeader, boolean headerBold, Font cellFont, Color cellBackground, Color cellForeground, boolean isFitToPageWidth, boolean isFitSmallerTableToPageWidth, boolean isUseCellRenderer) {
        JTable table;
        this.table = table = new JTable(tm);
        this.drawCellBorder = drawCellBorder;
        this.drawHeader = drawHeader;
        this.repeatHeader = repeatHeader;
        this.headerBold = headerBold;
        this.cellFont = cellFont;
        this.cellBackground = cellBackground;
        this.cellForeground = cellForeground;
        this.isFitToPageWidth = isFitToPageWidth;
        this.isFitSmallerTableToPageWidth = isFitSmallerTableToPageWidth;
        this.isUseCellRenderer = isUseCellRenderer;
        this.initProperties();
    }

    void initProperties() {
        class CellRenderer
        extends DefaultTableCellRenderer {
            CellRenderer() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setFont(TableInfoHolder.this.cellFont == null ? table.getFont() : TableInfoHolder.this.cellFont);
                this.setBackground(TableInfoHolder.this.getCellBackground() == null ? SystemColor.white : TableInfoHolder.this.getCellBackground());
                this.setForeground(TableInfoHolder.this.getCellForeground() == null ? SystemColor.black : TableInfoHolder.this.getCellForeground());
                table.setFont(TableInfoHolder.this.cellFont == null ? table.getFont() : TableInfoHolder.this.cellFont);
                table.setBackground(TableInfoHolder.this.getCellBackground() == null ? SystemColor.white : TableInfoHolder.this.getCellBackground());
                table.setForeground(TableInfoHolder.this.getCellForeground() == null ? SystemColor.black : TableInfoHolder.this.getCellForeground());
                Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                return renderer;
            }
        }
        CellRenderer cr = new CellRenderer();
        class HeaderRenderer
        extends DefaultTableCellRenderer {
            HeaderRenderer() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setFont(TableInfoHolder.this.cellFont == null ? table.getFont() : TableInfoHolder.this.cellFont);
                this.setBackground(headerBgColor);
                this.setForeground(TableInfoHolder.this.getCellForeground() == null ? SystemColor.black : TableInfoHolder.this.getCellForeground());
                table.setFont(TableInfoHolder.this.cellFont == null ? table.getFont() : TableInfoHolder.this.cellFont);
                table.setBackground(headerBgColor);
                table.setForeground(TableInfoHolder.this.getCellForeground() == null ? SystemColor.black : TableInfoHolder.this.getCellForeground());
                Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                return renderer;
            }
        }
        HeaderRenderer hr = new HeaderRenderer();
        TableColumnModel tcm = this.table.getColumnModel();
        for (int col = 0; col < tcm.getColumnCount(); ++col) {
            TableColumn tc = tcm.getColumn(col);
            tc.setCellRenderer(cr);
            tc.setHeaderRenderer(hr);
        }
    }

    public boolean isUseCellRenderer() {
        return this.isUseCellRenderer;
    }

    public void setUseCellRenderer(boolean useCellRenderer) {
        this.isUseCellRenderer = useCellRenderer;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public void setDrawHeader(boolean drawHeader) {
        this.drawHeader = drawHeader;
    }

    public boolean isDrawHeader() {
        return this.drawHeader;
    }

    public boolean isDrawCellBorder() {
        return this.drawCellBorder;
    }

    public void setDrawCellBorder(boolean drawCellBorder) {
        this.drawCellBorder = drawCellBorder;
    }

    public boolean isRepeatHeader() {
        return this.repeatHeader;
    }

    public void setRepeatHeader(boolean repeatHeader) {
        this.repeatHeader = repeatHeader;
    }

    public boolean isHeaderBold() {
        return this.headerBold;
    }

    public void setHeaderBold(boolean headerBold) {
        this.headerBold = headerBold;
    }

    public boolean isFitToPageWidth() {
        return this.isFitToPageWidth;
    }

    public void setFitToPageWidth(boolean fitToPageWidth) {
        this.isFitToPageWidth = fitToPageWidth;
    }

    public boolean isFitSmallerTableToPageWidth() {
        return this.isFitSmallerTableToPageWidth;
    }

    public void setFitSmallerTableToPageWidth(boolean fitSmallerTableToPageWidth) {
        this.isFitSmallerTableToPageWidth = fitSmallerTableToPageWidth;
    }

    public Font getCellFont() {
        return this.cellFont;
    }

    public void setCellFont(Font cellFont) {
        this.cellFont = cellFont;
    }

    public Color getCellBackground() {
        return this.cellBackground;
    }

    public void setCellBackground(Color cellBackground) {
        this.cellBackground = cellBackground;
    }

    public Color getCellForeground() {
        return this.cellForeground;
    }

    public void setCellForeground(Color cellForeground) {
        this.cellForeground = cellForeground;
    }
}

