/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.page;

import com.activetree.common.internal.DemoShape;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.report.AtElement;
import com.activetree.common.report.AtHeaderFooterElement;
import com.activetree.common.report.AtPrintUtil;
import com.activetree.common.report.PageHeaderFooterListener;
import com.activetree.common.report.PageHeaderFooterRenderer;
import com.activetree.common.report.PageNoPainter;
import com.activetree.common.report.watermark.Watermark;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.GraphicsUtil;
import com.activetree.common.utils.MediaUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.Serializable;

public abstract class AbstractReportPage
extends AbstractPage
implements PageNoPainter,
PageHeaderFooterRenderer,
Serializable {
    protected String pageNo;
    protected int pNoLoc;
    private FontMetrics fontMetrics;
    protected PageNumberProvider pageNumberProvider = new PageNumberProvider();
    private AtHeaderFooterElement pageHeader;
    private AtHeaderFooterElement pageFooter;
    private PageHeaderFooterListener headerFooterListener;
    protected Watermark watermark;
    protected boolean drawWatermark = false;
    private Rectangle headerBbox;
    private Rectangle footerBbox;
    private double headerHeight = -1.0;
    private double footerHeight = -1.0;
    protected boolean isUseCellRenderer = false;
    protected boolean isViewRendering = false;

    public AbstractReportPage() {
    }

    public AbstractReportPage(int pageNo, int pNoLoc, PageFormat pf, PageHeaderFooterListener headerFooterListener, double zoom, boolean isAntiAliased, boolean isUseCellRenderer, DemoShape demoShape) {
        super(pf, zoom, isAntiAliased, demoShape);
        this.isUseCellRenderer = isUseCellRenderer;
        this.pageNo = String.valueOf(pageNo);
        this.pNoLoc = pNoLoc;
        this.size = new Dimension((int)pf.getWidth(), (int)pf.getHeight());
        this.fontMetrics = AtPrintUtil.getFontMetrics(AtPrintUtil.getDefaultFont());
        this.headerFooterListener = headerFooterListener;
        this.isAntiAliased = isAntiAliased;
        this.watermark = this.createWatermark();
    }

    public void setIsUseCellRenderer(boolean isUseCellRenderer) {
        this.isUseCellRenderer = isUseCellRenderer;
    }

    public boolean isUseCellRenderer() {
        return this.isUseCellRenderer;
    }

    public double getFooterHeight() {
        return this.footerHeight;
    }

    public void setFooterHeight(double footerHeight) {
        this.footerHeight = footerHeight;
    }

    public double getHeaderHeight() {
        return this.headerHeight;
    }

    public void setHeaderHeight(double headerHeight) {
        this.headerHeight = headerHeight;
    }

    public void copyAttributes(AbstractPage page) {
        super.copyAttributes(page);
        AbstractReportPage dest = (AbstractReportPage)page;
        dest.pageNo = this.pageNo;
        dest.pNoLoc = this.pNoLoc;
        dest.fontMetrics = this.fontMetrics;
        dest.pageHeader = this.pageHeader;
        dest.pageFooter = this.pageFooter;
        dest.headerFooterListener = this.headerFooterListener;
        dest.watermark = this.watermark;
        dest.drawWatermark = this.drawWatermark;
        dest.headerBbox = this.headerBbox;
        dest.footerBbox = this.footerBbox;
        dest.isUseCellRenderer = this.isUseCellRenderer;
    }

    public void resizePageFormat(AbstractPage page, double resizeFactor, boolean autoMatchToPaperSize) {
        Rectangle2D printableArea = this.getPrintableArea();
        double resizeFactorToUse = resizeFactor;
        if (autoMatchToPaperSize) {
            resizeFactorToUse = 1.0;
        }
        if (resizeFactorToUse <= 0.0) {
            AtDebug.debug(7, "WARNING! resize factor \"" + resizeFactor + "\" can not be less or equal 0 (using 1.0 instead)");
            resizeFactorToUse = 1.0;
        }
        PageFormat currPf = this.getPageFormat();
        int orientation = currPf.getOrientation();
        double leftMargin = currPf.getImageableX();
        double rightMargin = currPf.getWidth() - currPf.getImageableWidth() - leftMargin;
        double topMargin = currPf.getImageableY();
        double bottomMargin = currPf.getHeight() - currPf.getImageableHeight() - topMargin;
        PageFormat outputPageFormat = MediaUtil.getSelectedPageFormat(printableArea, leftMargin, rightMargin, topMargin, bottomMargin, orientation, resizeFactorToUse);
        page.setPrinterPageFormat(outputPageFormat);
        page.setScale(resizeFactorToUse);
    }

    public void setViewRendering(boolean viewRendering) {
        this.isViewRendering = viewRendering;
    }

    public boolean isViewRendering() {
        return this.isViewRendering;
    }

    protected Watermark createWatermark() {
        return null;
    }

    public abstract void draw(Graphics var1);

    public void drawHeaderFooterPageNumber(Graphics g) {
        this.drawPageNumber(g);
        if (this.getHeaderFooterListener() != null) {
            PageHeaderFooterListener l2 = this.getHeaderFooterListener();
            if (this.getHeader() != null) {
                this.drawHeader(g);
            } else {
                l2.drawHeader(g, this.getHeaderBBox(), this.getPageNumber(), this.getTotalPageCount(), this.getPageNumberLocation(), this.getPageFormat(), this.getZoom());
            }
            if (this.getFooter() != null) {
                this.drawFooter(g);
            } else {
                l2.drawFooter(g, this.getFooterBBox(), this.getPageNumber(), this.getTotalPageCount(), this.getPageNumberLocation(), this.getPageFormat(), this.getZoom());
            }
        }
        this.pageNumberProvider.theProvider.drawDemoShape((Graphics2D)g, this.pageFormat);
    }

    public boolean isDrawWatermark() {
        return this.drawWatermark;
    }

    public void setDrawWatermark(boolean drawWatermark) {
        this.drawWatermark = drawWatermark;
    }

    public void setWatermark(Watermark watermark) {
        this.watermark = watermark;
    }

    public Watermark getWatermark() {
        return this.watermark;
    }

    public void setTotalPage(int totalPageCount) {
        this.totalPageCount = totalPageCount;
    }

    public int getTotalPageCount() {
        return this.totalPageCount;
    }

    public PageHeaderFooterListener getHeaderFooterListener() {
        return this.headerFooterListener;
    }

    public void setHeaderFooterListener(PageHeaderFooterListener hfListener) {
        this.headerFooterListener = hfListener;
    }

    public void setHeader(AtHeaderFooterElement pageHeader) {
        this.pageHeader = pageHeader;
    }

    public AtHeaderFooterElement getHeader() {
        return this.pageHeader;
    }

    public void setFooter(AtHeaderFooterElement pageFooter) {
        this.pageFooter = pageFooter;
    }

    public AtHeaderFooterElement getFooter() {
        return this.pageFooter;
    }

    public PageFormat getPageFormat() {
        PageFormat clonedPf = MediaUtil.getClonedPageFormat(this.pageFormat);
        return clonedPf;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        if (pageFormat != null) {
            this.size = new Dimension((int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        }
    }

    public int getPageNumber() {
        return Integer.parseInt(this.pageNo);
    }

    public void setPageNumber(int pageNo) {
        this.pageNo = String.valueOf(pageNo);
    }

    public int getPageNumberLocation() {
        return this.pNoLoc;
    }

    public void setPageNumbeLocation(int pNoLocation) {
        this.pNoLoc = pNoLocation;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Color getBackground() {
        return SystemColor.white;
    }

    public void clipPrintableArea(Graphics g) {
        this.pageNumberProvider.theProvider.clipPrintableArea(g);
        this.drawWatermark(g);
    }

    private void drawWatermark(Graphics g) {
        if (this.watermark != null && this.isDrawWatermark()) {
            this.watermark.applyWatermark(g, this);
        }
    }

    public void drawHeader(Graphics g) {
        if (this.pageHeader != null) {
            this.pageNumberProvider.theProvider.drawHeader(g);
        }
    }

    public void drawFooter(Graphics g) {
        if (this.pageFooter != null) {
            this.pageNumberProvider.theProvider.drawFooter(g);
        }
    }

    public void drawPageNumber(Graphics g) {
        this.pageNumberProvider.theProvider.drawPageNumber(g, this.pageNo, this.pNoLoc);
    }

    public Rectangle getHeaderBBox() {
        return (Rectangle)this.pageNumberProvider.theProvider.getHeaderBBox().clone();
    }

    public Rectangle getFooterBBox() {
        return (Rectangle)this.pageNumberProvider.theProvider.getFooterBBox().clone();
    }

    class PageNumberProvider
    implements Serializable {
        TheProvider theProvider = new TheProvider();

        PageNumberProvider() {
        }

        class TheProvider
        implements Serializable {
            TheProvider() {
            }

            void drawDemoShape(Graphics2D graphics, PageFormat pf) {
                if (AbstractReportPage.this.demoShape != null) {
                    AbstractReportPage.this.demoShape.drawDemoShape(graphics, pf);
                }
            }

            void clipPrintableArea(Graphics g) {
                Color orgColor = g.getColor();
                Font orgFont = g.getFont();
                if (AbstractReportPage.this.isAntiAliased()) {
                    GraphicsUtil.applyAntiAlias(g);
                }
                Graphics2D g2d = (Graphics2D)g;
                Rectangle clip = this.getClipRect();
                g2d.setClip(clip);
                AbstractReportPage.this.headerBbox = this.getHeaderBBox();
                AbstractReportPage.this.footerBbox = this.getFooterBBox();
                g.setColor(orgColor);
                g.setFont(orgFont);
            }

            Rectangle getHeaderBBox() {
                if (AbstractReportPage.this.headerBbox == null) {
                    AbstractReportPage.this.headerBbox = this.createHeaderBBox();
                }
                return AbstractReportPage.this.headerBbox;
            }

            Rectangle getFooterBBox() {
                if (AbstractReportPage.this.footerBbox == null) {
                    AbstractReportPage.this.footerBbox = this.createFooterBBox();
                }
                return AbstractReportPage.this.footerBbox;
            }

            Rectangle createHeaderBBox() {
                int hh;
                int hw;
                int hy;
                int hx;
                if (AbstractReportPage.this.headerHeight != -1.0) {
                    hx = (int)AbstractReportPage.this.pageFormat.getImageableX();
                    hy = (int)AbstractReportPage.this.pageFormat.getImageableY();
                    hw = (int)AbstractReportPage.this.pageFormat.getImageableWidth();
                    hh = (int)AbstractReportPage.this.headerHeight;
                    hy -= hh;
                } else {
                    hx = 6;
                    hy = 6;
                    hw = (int)AbstractReportPage.this.pageFormat.getWidth() - 2 * hx;
                    hh = (int)AbstractReportPage.this.pageFormat.getImageableY() - hy - 6;
                }
                Rectangle hbbox = new Rectangle(hx, hy, hw, hh);
                return hbbox;
            }

            Rectangle createFooterBBox() {
                int fh;
                int fw;
                int fy;
                int fx;
                if (AbstractReportPage.this.footerHeight != -1.0) {
                    fx = (int)AbstractReportPage.this.pageFormat.getImageableX();
                    fy = (int)(AbstractReportPage.this.pageFormat.getImageableY() + AbstractReportPage.this.pageFormat.getImageableHeight());
                    fw = (int)AbstractReportPage.this.pageFormat.getImageableWidth();
                    fh = (int)AbstractReportPage.this.footerHeight;
                } else {
                    fx = 6;
                    fy = (int)(AbstractReportPage.this.pageFormat.getImageableY() + AbstractReportPage.this.pageFormat.getImageableHeight() + 6.0);
                    fw = (int)AbstractReportPage.this.pageFormat.getWidth() - 2 * fx;
                    fh = (int)(AbstractReportPage.this.pageFormat.getHeight() - (double)fy - 6.0);
                }
                Rectangle footerBbox = new Rectangle(fx, fy, fw, fh);
                return footerBbox;
            }

            Rectangle getClipRect() {
                int x = 5;
                int y = 5;
                int w = (int)AbstractReportPage.this.pageFormat.getWidth() - 10;
                int h = (int)AbstractReportPage.this.pageFormat.getHeight() - 10;
                Rectangle clip = new Rectangle(x, y, w, h);
                return clip;
            }

            void drawPageNumber(Graphics graphics, String pageNo, int location) {
                double bottomEmptySpace;
                if (location == 4) {
                    return;
                }
                Graphics2D g = (Graphics2D)graphics;
                double px2 = 0.0;
                double py = 0.0;
                FontMetrics currFm = g.getFontMetrics();
                double fh = currFm.getHeight();
                double strWidth = GraphicsUtil.stringWidth(currFm.getFont(), pageNo);
                if (location == 0) {
                    px2 = (AbstractReportPage.this.pageFormat.getWidth() - strWidth) / 2.0;
                    int maxY = (int)AbstractReportPage.this.pageFormat.getHeight();
                    bottomEmptySpace = AbstractReportPage.this.pageFormat.getHeight() - (AbstractReportPage.this.pageFormat.getImageableY() + AbstractReportPage.this.pageFormat.getImageableHeight());
                    py = (double)maxY - bottomEmptySpace / 2.0;
                } else if (location == 1) {
                    px2 = AbstractReportPage.this.pageFormat.getImageableX() + AbstractReportPage.this.pageFormat.getImageableWidth() - strWidth;
                    int maxY = (int)AbstractReportPage.this.pageFormat.getHeight();
                    bottomEmptySpace = AbstractReportPage.this.pageFormat.getHeight() - (AbstractReportPage.this.pageFormat.getImageableY() + AbstractReportPage.this.pageFormat.getImageableHeight());
                    py = (double)maxY - bottomEmptySpace / 2.0;
                } else if (location == 2) {
                    double topEmptySpace = AbstractReportPage.this.pageFormat.getImageableY();
                    px2 = (AbstractReportPage.this.pageFormat.getWidth() - strWidth) / 2.0;
                    py = topEmptySpace / 2.0;
                    py += (double)(currFm.getHeight() / 4 * 3);
                } else if (location == 3) {
                    double topEmptySpace = AbstractReportPage.this.pageFormat.getImageableY();
                    px2 = AbstractReportPage.this.pageFormat.getImageableX() + AbstractReportPage.this.pageFormat.getImageableWidth() - strWidth;
                    py = topEmptySpace / 2.0;
                    py += (double)(currFm.getHeight() / 4 * 3);
                }
                Color orgColor = g.getColor();
                Font orgFont = g.getFont();
                g.setFont(AtPrintUtil.getFont(currFm.getFont(), AbstractReportPage.this.getZoom()));
                g.setPaint(Color.black);
                g.drawString(pageNo, (int)px2, (int)py - 6);
                g.setFont(orgFont);
                g.setColor(orgColor);
            }

            void drawHeader(Graphics g) {
                if (AbstractReportPage.this.pageHeader == null) {
                    return;
                }
                if (AbstractReportPage.this.pageHeader instanceof AtHeaderFooterElement) {
                    AtHeaderFooterElement header = AbstractReportPage.this.pageHeader;
                    String str = header.getText();
                    if (str == null) {
                        return;
                    }
                    Font headerFont = AtPrintUtil.getFont(header.getFont(), AbstractReportPage.this.getZoom());
                    FontMetrics headerFm = AtElement.getFontMetrics(headerFont);
                    double strW = GraphicsUtil.stringWidth(headerFont, str);
                    double cx = (AbstractReportPage.this.pageFormat.getWidth() - strW) / 2.0;
                    double cy = AbstractReportPage.this.pageFormat.getImageableY() - (double)headerFm.getDescent() - (double)(headerFm.getHeight() / 4);
                    if (header.getAlignment() == 10) {
                        cx = (AbstractReportPage.this.pageFormat.getWidth() - strW) / 2.0;
                    } else if (header.getAlignment() == 11) {
                        cx = AbstractReportPage.this.pageFormat.getImageableX();
                    } else if (header.getAlignment() == 12) {
                        cx = AbstractReportPage.this.pageFormat.getImageableX() + AbstractReportPage.this.pageFormat.getImageableWidth() - strW;
                    }
                    g.setFont(headerFont);
                    g.setColor(header.getForeground());
                    g.drawString(str, (int)cx, (int)cy);
                    if (header.isUnderlined()) {
                        g.drawLine((int)cx, (int)(cy + 1.0), (int)(cx + strW), (int)(cy + 1.0));
                    }
                }
            }

            void drawFooter(Graphics g) {
                if (AbstractReportPage.this.pageFooter == null) {
                    return;
                }
                if (AbstractReportPage.this.pageFooter instanceof AtHeaderFooterElement) {
                    AtHeaderFooterElement footer = AbstractReportPage.this.pageFooter;
                    String str = footer.getStr();
                    if (str == null) {
                        return;
                    }
                    Font footerFont = AtPrintUtil.getFont(footer.getFont(), AbstractReportPage.this.getZoom());
                    FontMetrics footerFm = AtElement.getFontMetrics(footerFont);
                    double strW = GraphicsUtil.stringWidth(footerFont, str);
                    double cx = (AbstractReportPage.this.pageFormat.getWidth() - strW) / 2.0;
                    double cy = AbstractReportPage.this.pageFormat.getImageableY() + AbstractReportPage.this.pageFormat.getImageableHeight() + (double)footerFm.getHeight();
                    if (footer.getAlignment() == 10) {
                        cx = (AbstractReportPage.this.pageFormat.getWidth() - strW) / 2.0;
                    } else if (footer.getAlignment() == 11) {
                        cx = AbstractReportPage.this.pageFormat.getImageableX();
                    } else if (footer.getAlignment() == 12) {
                        cx = AbstractReportPage.this.pageFormat.getImageableX() + AbstractReportPage.this.pageFormat.getImageableWidth() - strW;
                    }
                    g.setFont(footerFont);
                    g.setColor(footer.getForeground());
                    g.drawString(str, (int)cx, (int)cy);
                    if (footer.isUnderlined()) {
                        g.drawLine((int)cx, (int)(cy + 1.0), (int)(cx + strW), (int)(cy + 1.0));
                    }
                }
            }
        }
    }
}

