/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.printer;

import com.activetree.common.page.AbstractPage;
import com.activetree.common.print.AbstractPrinter;
import com.activetree.common.report.AtElement;
import com.activetree.common.report.AtPrintUtil;
import com.activetree.common.report.internal.ElementDescriptor;
import com.activetree.common.report.internal.ElementParser;
import com.activetree.common.report.internal.IconElementDescriptor;
import com.activetree.common.report.internal.LineDescriptor;
import com.activetree.common.report.internal.NewlineElementDescriptor;
import com.activetree.common.report.internal.PageDescriptor;
import com.activetree.common.report.internal.SplittedElement;
import com.activetree.common.report.internal.StringElementDescriptor;
import com.activetree.common.report.page.ImagePage;
import com.activetree.common.report.page.Page;
import com.activetree.common.report.printer.AbstractReportPrinter;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;

public class JavaDocumentPrinter
extends AbstractReportPrinter
implements ElementParser {
    private final Vector styleElements = new Vector();
    private final Vector data = new Vector();
    private final Vector lines = new Vector();
    private final Vector pages = new Vector();
    private DocumentPageRenderer pageRenderer = new DocumentPageRenderer();
    private boolean iconsResizable = false;
    private JavaDocumentPrinter docPrinter = this;

    protected void copyAttributes(AbstractPrinter anotherPrinter) {
        super.copyAttributes(anotherPrinter);
        if (anotherPrinter instanceof JavaDocumentPrinter) {
            JavaDocumentPrinter newDocPrinter = (JavaDocumentPrinter)anotherPrinter;
            newDocPrinter.styleElements.clear();
            newDocPrinter.styleElements.addAll(this.styleElements);
            newDocPrinter.data.clear();
            newDocPrinter.data.addAll(this.data);
            newDocPrinter.lines.clear();
            newDocPrinter.lines.addAll(this.lines);
            newDocPrinter.pages.clear();
            newDocPrinter.pages.addAll(this.pages);
            newDocPrinter.pageRenderer = this.pageRenderer;
            newDocPrinter.iconsResizable = this.iconsResizable;
        }
    }

    public void close() {
        super.close();
        this.styleElements.clear();
        this.data.clear();
        this.lines.clear();
        this.pages.clear();
        this.pageRenderer = null;
    }

    public boolean isFitIconsToPage() {
        return this.iconsResizable;
    }

    public void setFitIconsToPage(boolean iconsResizable) {
        this.iconsResizable = iconsResizable;
    }

    public void parse(JTextComponent textComponent) {
        this.objectToPrint = textComponent;
        Document doc = textComponent.getDocument();
        this.pageRenderer.theRenderer.flush();
        Element rootElm = doc.getDefaultRootElement();
        this.pageRenderer.theRenderer.processElements(rootElm);
        AtDebug.debug("**** Number of elements from root element processing..." + this.styleElements.size());
        this.pageRenderer.theRenderer.processNewline();
    }

    public ElementDescriptor[][] getElements() {
        if (this.styleElements == null || this.styleElements.size() == 0) {
            return null;
        }
        ElementDescriptor[][] retElms = new ElementDescriptor[1][this.styleElements.size()];
        for (int row = 0; retElms != null && row < retElms.length; ++row) {
            for (int col = 0; col < retElms[row].length; ++col) {
                ElementDescriptor anElm;
                retElms[row][col] = anElm = (ElementDescriptor)this.styleElements.get(col);
            }
        }
        return retElms;
    }

    public void print(JTextComponent compToPrint) {
        this.print(compToPrint, 0);
    }

    public void print(JTextComponent compToPrint, int pageNoLocation) {
        this.print(compToPrint, pageNoLocation, true, true);
    }

    public void print(JTextComponent compToPrint, int pageNoLocation, boolean showPrinterSelectionDialog) {
        this.print(compToPrint, pageNoLocation, showPrinterSelectionDialog, true);
    }

    public void print(JTextComponent compToPrint, int pageNoLocation, boolean showPrinterSelectionDialog, boolean showPageSetupDialog) {
        HashPrintRequestAttributeSet pAttrs = new HashPrintRequestAttributeSet();
        this.print(compToPrint, pageNoLocation, showPrinterSelectionDialog, showPageSetupDialog, pAttrs);
    }

    public void print(JTextComponent compToPrint, int pageNoLocation, boolean showPrinterSelectionDialog, boolean showPageSetupDialog, PrintRequestAttributeSet pAttrs) {
        this.print(compToPrint, pageNoLocation, showPrinterSelectionDialog, showPageSetupDialog, null, pAttrs);
    }

    public void print(JTextComponent compToPrint, int pageNoLocation, boolean showPrinterSelectionDialog, boolean showPageSetupDialog, PageFormat customPageFormat, PrintRequestAttributeSet pAttrs) {
        this.objectToPrint = compToPrint;
        this.pageRenderer.theRenderer.print(compToPrint, pageNoLocation, showPrinterSelectionDialog, showPageSetupDialog, customPageFormat, pAttrs);
    }

    public void preview(JTextComponent compToPreview, Component owner) {
        this.preview(compToPreview, 0, owner);
    }

    public void preview(JTextComponent compToPreview, int pageNoLocation, Component owner) {
        this.preview(compToPreview, pageNoLocation, true, owner);
    }

    public void preview(JTextComponent compToPreview, int pageNoLocation, boolean showPageSetupDialog, Component owner) {
        this.preview(compToPreview, pageNoLocation, showPageSetupDialog, null, owner);
    }

    public void preview(JTextComponent compToPreview, int pageNoLocation, boolean showPageSetupDialog, PageFormat customPageFormat, Component owner) {
        this.preview(compToPreview, pageNoLocation, showPageSetupDialog, customPageFormat, null, owner);
    }

    public void preview(JTextComponent compToPreview, int pageNoLocation, boolean showPageSetupDialog, PageFormat customPageFormat, PrintRequestAttributeSet pAttrs, Component owner) {
        this.objectToPrint = compToPreview;
        this.pageRenderer.theRenderer.preview(compToPreview, pageNoLocation, customPageFormat, pAttrs, showPageSetupDialog, owner);
    }

    public Pageable getPageable(Object editor) {
        Pageable pageable = this.getPageable(editor, 4);
        return pageable;
    }

    public Pageable getPageable(Object source, PageFormat pf) {
        this.setPageFormat(pf);
        Pageable pages = this.getPageable(source);
        return pages;
    }

    public Pageable getPageable(Object editor, int pageNoLocation) {
        this.objectToPrint = editor;
        this.setPageNumberLocation(pageNoLocation);
        this.setBook(new Book());
        Vector previewPages = this.createPages(1);
        this.setPreviewPages(previewPages);
        return this.getBook();
    }

    protected Vector createPages(int purpose) {
        return this.pageRenderer.theRenderer.createPages(purpose);
    }

    class DocumentPageRenderer
    implements Serializable {
        TheDocumentPageRenderer theRenderer = new TheDocumentPageRenderer();

        DocumentPageRenderer() {
        }

        class TheDocumentPageRenderer
        implements Serializable {
            TheDocumentPageRenderer() {
            }

            BufferedImage createEditorImage(Graphics g2d) {
                Component form = (Component)JavaDocumentPrinter.this.getPrintObject();
                int w = form.getWidth();
                int h = form.getHeight();
                BufferedImage bufImage = new BufferedImage(w, h, 2);
                Graphics2D imdGraphics = bufImage.createGraphics();
                imdGraphics.setRenderingHints(GraphicsUtil.getRenderingHints());
                imdGraphics.setColor(SystemColor.white);
                imdGraphics.fill(new Rectangle(0, 0, bufImage.getWidth(), bufImage.getHeight()));
                form.paintAll(imdGraphics);
                double zoomedWidth = (double)w * JavaDocumentPrinter.this.getZoom();
                double zoomedHeight = (double)h * JavaDocumentPrinter.this.getZoom();
                BufferedImage zoomedImage = new BufferedImage((int)zoomedWidth, (int)zoomedHeight, 2);
                Graphics2D g = (Graphics2D)zoomedImage.getGraphics();
                g.setRenderingHints(GraphicsUtil.getRenderingHints());
                g.setColor(SystemColor.white);
                g.fill(new Rectangle(0, 0, zoomedImage.getWidth(), zoomedImage.getHeight()));
                g.drawImage(bufImage, 0, 0, (int)zoomedWidth, (int)zoomedHeight, null);
                bufImage = zoomedImage;
                return bufImage;
            }

            Vector createPagesFromImage(BufferedImage image, int purpose) {
                Vector pages = new Vector();
                if (image == null) {
                    return pages;
                }
                int imageHeight = image.getHeight(null);
                int startY = 0;
                int pNo = 1;
                int pNoLocation = JavaDocumentPrinter.this.getPageNumberLocation();
                PageFormat pf = JavaDocumentPrinter.this.getPageFormat();
                do {
                    Vector hPages = this.horizontalBreak(image, pf, startY, (int)pf.getImageableWidth(), (int)pf.getImageableHeight(), (int)pf.getImageableX(), (int)pf.getImageableY(), pNoLocation, pNo);
                    if (purpose == 2) {
                        pages.addAll(hPages);
                        continue;
                    }
                    if (purpose != 1) continue;
                    for (int i = 0; i < hPages.size(); ++i) {
                        Printable printable = (Printable)hPages.get(i);
                        JavaDocumentPrinter.this.getBook().append(printable, pf);
                    }
                } while ((startY = (int)((double)startY + pf.getImageableHeight())) < imageHeight);
                return pages;
            }

            Vector horizontalBreak(BufferedImage image, PageFormat pageFormat, int startY, int imageableWidth, int imageableHeight, int imgStartX, int imgStartY, int pNoLoc, int pNo) {
                Vector<ImagePage> hPages = new Vector<ImagePage>();
                int imageWidth = image.getWidth(null);
                int imageHeight = image.getHeight(null);
                int x1 = 0;
                int y1 = startY;
                int x2 = x1 + imageableWidth;
                int y2 = y1 + imageableHeight;
                while (true) {
                    if (x2 > imageWidth) {
                        x2 = imageWidth;
                    }
                    if (y2 > imageHeight) {
                        y2 = imageHeight;
                    }
                    BufferedImage pageImage = image.getSubimage(x1, y1, x2 - x1, y2 - y1);
                    ImagePage page = new ImagePage(pageImage, imgStartX, imgStartY, pageFormat, pNo++, pNoLoc, JavaDocumentPrinter.this.getHeaderFooterListener(), JavaDocumentPrinter.this.getZoom(), JavaDocumentPrinter.this.isAntialiased(), JavaDocumentPrinter.this.isUseCellRenderer(), JavaDocumentPrinter.this.demoShape);
                    hPages.add(page);
                    if (x2 >= imageWidth) break;
                    x1 = x2;
                    x2 = x1 + imageableWidth;
                }
                return hPages;
            }

            void flush() {
                JavaDocumentPrinter.this.data.clear();
                JavaDocumentPrinter.this.styleElements.clear();
                JavaDocumentPrinter.this.pages.clear();
                JavaDocumentPrinter.this.lines.clear();
            }

            Vector createPages(int purpose) {
                AtDebug.debug("JavaDocumentPrinter.createPages()...using...x, y, iw, ih=" + JavaDocumentPrinter.this.getPageFormat().getImageableX() + "," + JavaDocumentPrinter.this.getPageFormat().getImageableY() + ", " + JavaDocumentPrinter.this.getPageFormat().getImageableWidth() + ", " + JavaDocumentPrinter.this.getPageFormat().getImageableHeight());
                JTextComponent editor = (JTextComponent)JavaDocumentPrinter.this.getPrintObject();
                if (editor instanceof JEditorPane) {
                    JEditorPane docEditor = (JEditorPane)editor;
                    String contentType = docEditor.getContentType();
                    AtDebug.debug("content type:" + contentType);
                    if (contentType.equals("text/html")) {
                        BufferedImage pageImage = ((JavaDocumentPrinter)((DocumentPageRenderer)DocumentPageRenderer.this).JavaDocumentPrinter.this).pageRenderer.theRenderer.createEditorImage(editor.getGraphics());
                        Vector pages = ((JavaDocumentPrinter)((DocumentPageRenderer)DocumentPageRenderer.this).JavaDocumentPrinter.this).pageRenderer.theRenderer.createPagesFromImage(pageImage, 2);
                        if (purpose == 1) {
                            for (int i = 0; i < pages.size(); ++i) {
                                AbstractPage aPage = (AbstractPage)pages.get(i);
                                JavaDocumentPrinter.this.getBook().append(aPage, aPage.getPageFormat());
                            }
                        }
                        AtPrintUtil.notifyForHeaderAndFooter(pages);
                        return pages;
                    }
                }
                Document doc = editor.getDocument();
                this.flush();
                Element rootElm = doc.getDefaultRootElement();
                this.processElements(rootElm);
                this.processNewline();
                this.createLineElements();
                Vector<LineDescriptor> tempLines = new Vector<LineDescriptor>();
                for (int l2 = 0; JavaDocumentPrinter.this.lines != null && l2 < JavaDocumentPrinter.this.lines.size(); ++l2) {
                    LineDescriptor aLine = (LineDescriptor)JavaDocumentPrinter.this.lines.get(l2);
                    if (aLine != null && aLine.getElementCount() == 0) continue;
                    tempLines.add(aLine);
                }
                JavaDocumentPrinter.this.lines.removeAllElements();
                JavaDocumentPrinter.this.lines.addAll(tempLines);
                AtDebug.debug("^^^^^^After createLineElements()...elms=" + JavaDocumentPrinter.this.lines.size());
                Vector previewPages = new Vector();
                this.createPageElements(previewPages, purpose);
                previewPages = this.removeEmptyPages(previewPages);
                if (purpose == 1) {
                    for (int idx = 0; idx < previewPages.size(); ++idx) {
                        AbstractPage printable = (AbstractPage)previewPages.get(idx);
                        PageFormat pageFormat = printable.getPageFormat();
                        JavaDocumentPrinter.this.getBook().append(printable, pageFormat);
                    }
                }
                AtDebug.debug("^^^^^After createPageElements()...elms=" + JavaDocumentPrinter.this.pages.size());
                if (purpose == 2) {
                    AtDebug.debug("preview pages size: " + previewPages.size());
                }
                AtPrintUtil.notifyForHeaderAndFooter(previewPages);
                return previewPages;
            }

            Vector removeEmptyPages(Vector allPages) {
                Vector<Page> filteredPages = new Vector<Page>();
                for (int page = 0; allPages != null && page < allPages.size(); ++page) {
                    Page aPage = (Page)allPages.get(page);
                    PageDescriptor pageDescriptor = aPage.getPageDescriptor();
                    Vector lines = pageDescriptor.getLines();
                    boolean emptyPage = false;
                    if (lines == null || lines.size() == 0) {
                        emptyPage = true;
                    } else if (lines.size() > 0) {
                        boolean nonNewLineFound = false;
                        String newLine = "\n";
                        block1: for (int line = 0; line < lines.size(); ++line) {
                            LineDescriptor aLine = (LineDescriptor)lines.get(line);
                            for (int elm = 0; aLine != null && elm < aLine.getElementCount(); ++elm) {
                                ElementDescriptor anElm = aLine.getElement(elm);
                                if (anElm instanceof NewlineElementDescriptor) continue;
                                if (anElm instanceof StringElementDescriptor) {
                                    StringElementDescriptor strElm = (StringElementDescriptor)anElm;
                                    String value = (String)strElm.getValue();
                                    if (value != null && value.equals(newLine)) continue;
                                    nonNewLineFound = true;
                                    continue block1;
                                }
                                nonNewLineFound = true;
                                continue block1;
                            }
                        }
                        if (!nonNewLineFound) {
                            emptyPage = true;
                        }
                    }
                    if (emptyPage) continue;
                    filteredPages.add(aPage);
                }
                return filteredPages;
            }

            void preview(JComponent compToPrint, int pageNoLocation, PageFormat customPageFormat, PrintRequestAttributeSet pAttrs, boolean showPageSetupDialog, Component owner) {
                JavaDocumentPrinter.this.setOwner(owner);
                if (customPageFormat != null) {
                    JavaDocumentPrinter.this.setPageFormat(customPageFormat);
                }
                if (JavaDocumentPrinter.this.getPageFormat() == null) {
                    JavaDocumentPrinter.this.setPageFormat(new PageFormat());
                }
                JavaDocumentPrinter.this.setPageNumberLocation(pageNoLocation);
                boolean okPressed = JavaDocumentPrinter.this.showPrintSetup(pAttrs, customPageFormat, false, showPageSetupDialog);
                if (!okPressed) {
                    return;
                }
                Vector previewPages = this.createPages(2);
                JavaDocumentPrinter.this.setPreviewPages(previewPages);
                JavaDocumentPrinter.this.createPreviewWindow(owner);
                ((DocumentPageRenderer)DocumentPageRenderer.this).JavaDocumentPrinter.this.previewWindow.setSize(JavaDocumentPrinter.this.getPreviewPaneSize());
                JFrame frame = ((DocumentPageRenderer)DocumentPageRenderer.this).JavaDocumentPrinter.this.previewWindow.getFrame();
                AtComponentUtil.centerOnScreen(frame);
                ((DocumentPageRenderer)DocumentPageRenderer.this).JavaDocumentPrinter.this.previewWindow.setVisible(true);
            }

            void print(JTextComponent compToPrint, int pageNoLocation, boolean showPrinterSelectionDialog, boolean showPageSetupDialog, PageFormat customPageFormat, PrintRequestAttributeSet pAttrs) {
                if (customPageFormat != null) {
                    JavaDocumentPrinter.this.setPageFormat(customPageFormat);
                }
                if (JavaDocumentPrinter.this.getPageFormat() == null) {
                    JavaDocumentPrinter.this.setPageFormat(new PageFormat());
                }
                JavaDocumentPrinter.this.setPageNumberLocation(pageNoLocation);
                boolean okPressed = JavaDocumentPrinter.this.showPrintSetup(pAttrs, customPageFormat, showPrinterSelectionDialog, showPageSetupDialog);
                if (!okPressed) {
                    return;
                }
                JavaDocumentPrinter.this.setBook(new Book());
                Book book = JavaDocumentPrinter.this.getBook();
                PrinterJob printer = JavaDocumentPrinter.this.getPrinterJob();
                printer.setPageable(book);
                Vector previewPages = this.createPages(1);
                JavaDocumentPrinter.this.setPreviewPages(previewPages);
                try {
                    printer.print();
                }
                catch (Exception e1) {
                    AtDebug.debug(9, e1);
                }
            }

            void processElements(Element elm) {
                ElementDescriptor strElm;
                String elmName = elm.getName();
                if (elmName.equals("icon")) {
                    ElementDescriptor iconElm = this.getIconElement(elm, (JTextComponent)JavaDocumentPrinter.this.getPrintObject());
                    if (iconElm != null) {
                        JavaDocumentPrinter.this.styleElements.add(iconElm);
                    }
                } else if (elmName.equals("component")) {
                    ElementDescriptor compElm = this.getComponentElement(elm, (JTextComponent)JavaDocumentPrinter.this.getPrintObject());
                    if (compElm != null) {
                        JavaDocumentPrinter.this.styleElements.add(compElm);
                    }
                } else if (elmName.equals("content") && (strElm = this.getContentElement(elm, (JTextComponent)JavaDocumentPrinter.this.getPrintObject())) != null) {
                    JavaDocumentPrinter.this.styleElements.add(strElm);
                }
                int elmCount = elm.getElementCount();
                for (int i = 0; i < elmCount; ++i) {
                    Element childElm = elm.getElement(i);
                    this.processElements(childElm);
                }
            }

            private void processNewline() {
                Vector orgStyles = (Vector)JavaDocumentPrinter.this.styleElements.clone();
                JavaDocumentPrinter.this.styleElements.clear();
                for (int i = 0; i < orgStyles.size(); ++i) {
                    ElementDescriptor elm = (ElementDescriptor)orgStyles.get(i);
                    JavaDocumentPrinter.this.styleElements.add(elm);
                    if (!(elm instanceof StringElementDescriptor) || !this.hasNewLine((StringElementDescriptor)elm)) continue;
                    NewlineElementDescriptor newLineElm = new NewlineElementDescriptor("\n", 1, AtElement.DEFAULT_FONT, elm.getFontMetrics(), elm.getAttributeSet());
                    JavaDocumentPrinter.this.styleElements.add(newLineElm);
                }
            }

            boolean hasNewLine(StringElementDescriptor elm) {
                String value = (String)elm.getValue();
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if (ch != '\n') continue;
                    return true;
                }
                return false;
            }

            ElementDescriptor getContentElement(Element elm, JTextComponent editor) {
                Color fgColor;
                Boolean striked;
                Object strikeThrough;
                Boolean underline;
                int soffs = elm.getStartOffset();
                int eoffs = elm.getEndOffset();
                String elmValue = null;
                Document doc = elm.getDocument();
                AttributeSet attrs = elm.getAttributes();
                SimpleAttributeSet attr = new SimpleAttributeSet(attrs);
                TabSet ts = StyleConstants.getTabSet(attr);
                int tabSize = JavaDocumentPrinter.this.getTabSize();
                if (ts != null) {
                    tabSize = 8;
                } else if (editor instanceof JTextArea) {
                    tabSize = ((JTextArea)editor).getTabSize();
                }
                try {
                    elmValue = doc.getText(soffs, eoffs - soffs);
                }
                catch (BadLocationException e) {
                    AtDebug.debug(9, e);
                }
                if (elmValue == null || !elmValue.equals("")) {
                    // empty if block
                }
                StringBuffer buf = new StringBuffer(elmValue.length());
                for (int i = 0; i < elmValue.length(); ++i) {
                    if (elmValue.charAt(i) == '\t') {
                        this.addTabChars(buf, tabSize);
                        continue;
                    }
                    buf.append(elmValue.charAt(i));
                }
                Font elmFont = null;
                elmFont = doc instanceof StyledDocument ? AtPrintUtil.getFont(((StyledDocument)doc).getFont(attrs), JavaDocumentPrinter.this.getZoom()) : AtPrintUtil.getFont(editor.getFont(), JavaDocumentPrinter.this.getZoom());
                FontMetrics elmFm = editor.getFontMetrics(elmFont);
                String value = buf.substring(0);
                Number leftIndentObj = (Number)attrs.getAttribute(StyleConstants.LeftIndent);
                if (leftIndentObj == null) {
                    leftIndentObj = new Double(1.0);
                }
                StringElementDescriptor se = new StringElementDescriptor(value, 1, elmFont, elmFm, attrs);
                buf.delete(0, buf.length());
                Object isUnderline = attrs.getAttribute(StyleConstants.Underline);
                if (isUnderline != null && isUnderline instanceof Boolean && (underline = (Boolean)isUnderline).booleanValue()) {
                    se.addStyle("Underline", underline);
                }
                if ((strikeThrough = attrs.getAttribute(StyleConstants.StrikeThrough)) != null && strikeThrough instanceof Boolean && (striked = (Boolean)strikeThrough).booleanValue()) {
                    se.addStyle("StrikeThrough", striked);
                }
                se.addStyle("Font", elmFont);
                Color bgColor = editor.getBackground();
                if (bgColor != null) {
                    // empty if block
                }
                if (!(doc instanceof StyledDocument) || ((StyledDocument)doc).getBackground(attrs) == null || (bgColor = ((StyledDocument)doc).getBackground(attrs)) != null) {
                    // empty if block
                }
                if ((fgColor = editor.getForeground()) != null) {
                    // empty if block
                }
                if (!(doc instanceof StyledDocument) || ((StyledDocument)doc).getForeground(attrs) == null || (fgColor = ((StyledDocument)doc).getForeground(attrs)) != null) {
                    // empty if block
                }
                if (!this.isWhiteColor(fgColor) && this.isBlackColor(bgColor)) {
                    bgColor = SystemColor.white;
                } else if (this.isWhiteColor(fgColor) && !this.isWhiteColor(bgColor)) {
                    bgColor = SystemColor.black;
                }
                se.addStyle("BackgroundColor", bgColor);
                se.addStyle("ForegroundColor", fgColor);
                se.addStyle("LeftIndent", leftIndentObj);
                return se;
            }

            boolean isWhiteColor(Color color) {
                return color.getRed() == 255 && color.getGreen() == 255 && color.getBlue() == 255;
            }

            boolean isBlackColor(Color color) {
                return color.getRed() == 0 && color.getGreen() == 0 && color.getBlue() == 0;
            }

            void addTabChars(StringBuffer buf, int tabSize) {
                for (int i = 0; i < tabSize; ++i) {
                    buf.append(' ');
                }
            }

            ElementDescriptor getIconElement(Element elm, JTextComponent editor) {
                AttributeSet aSet = elm.getAttributes();
                Object obj = aSet.getAttribute(StyleConstants.IconAttribute);
                Image image = null;
                if (obj instanceof ImageIcon) {
                    image = ((ImageIcon)obj).getImage();
                } else if (obj instanceof Image) {
                    image = (Image)obj;
                }
                if (image == null) {
                    AtDebug.debug("Unknow icon element: " + obj.getClass().getName() + " not processed. return null.");
                    return null;
                }
                int imgW = image.getWidth(null);
                int imgH = image.getHeight(null);
                PageFormat pf = JavaDocumentPrinter.this.getPageFormat();
                if (((double)imgW > pf.getImageableWidth() || (double)imgH > pf.getImageableHeight()) && JavaDocumentPrinter.this.isFitIconsToPage()) {
                    return this.getResizedElement(image, pf.getImageableWidth(), pf.getImageableHeight(), editor, aSet);
                }
                IconElementDescriptor ise = new IconElementDescriptor(image, 2, editor.getFont(), editor.getFontMetrics(editor.getFont()), aSet, false);
                return ise;
            }

            ElementDescriptor getResizedElement(Image image, double maxW, double maxH, JTextComponent editor, AttributeSet aSet) {
                double resizeFactor;
                double resizeFactorY;
                double iconW = image.getWidth(null);
                double iconH = image.getHeight(null);
                double resizedW = iconW;
                if (iconW > maxW) {
                    resizedW = maxW;
                }
                double resizeFactorX = resizedW / iconW;
                double resizedH = iconH;
                if (iconH > maxH) {
                    resizedH = maxH;
                }
                if ((resizeFactorY = resizedH / iconH) < (resizeFactor = resizeFactorX)) {
                    resizeFactor = resizeFactorY;
                }
                resizedW = resizeFactor * iconW;
                resizedH = resizeFactor * iconH;
                if (JavaDocumentPrinter.this.getZoom() != 1.0) {
                    resizedH *= JavaDocumentPrinter.this.getZoom();
                    if ((resizedW *= JavaDocumentPrinter.this.getZoom()) > JavaDocumentPrinter.this.getPageFormat().getImageableWidth() || resizedH > JavaDocumentPrinter.this.getPageFormat().getImageableHeight()) {
                        resizedW = resizeFactor * iconW;
                        resizedH = resizeFactor * iconH;
                    }
                }
                BufferedImage resizedImage = new BufferedImage((int)resizedW, (int)resizedH, 2);
                Graphics2D g = (Graphics2D)resizedImage.getGraphics();
                g.setRenderingHints(GraphicsUtil.getRenderingHints());
                g.setColor(SystemColor.white);
                g.fillRect(0, 0, resizedImage.getWidth(), resizedImage.getHeight());
                g.drawImage(image, 0, 0, (int)resizedW, (int)resizedH, null);
                IconElementDescriptor resizedElm = new IconElementDescriptor(resizedImage, 2, editor.getFont(), editor.getFontMetrics(editor.getFont()), aSet, false);
                return resizedElm;
            }

            ElementDescriptor getComponentElement(Element elm, JTextComponent editor) {
                AttributeSet aSet = elm.getAttributes();
                Object obj = aSet.getAttribute(StyleConstants.ComponentAttribute);
                Component comp = null;
                if (obj instanceof Component) {
                    comp = (Component)obj;
                }
                if (comp == null) {
                    AtDebug.debug("getComponentElement()..got null comp. return null");
                    return null;
                }
                PageFormat pf = JavaDocumentPrinter.this.getPageFormat();
                int w = comp.getWidth();
                int h = comp.getHeight();
                if ((double)w > pf.getImageableWidth() || (double)h > pf.getImageableHeight()) {
                    Image image = comp.createImage(w, h);
                    Graphics formG = image.getGraphics();
                    comp.paintAll(formG);
                    if (image == null) {
                        AtDebug.debug("getComponentElement()..tried to create an conversion out of it...got null... return null");
                        return null;
                    }
                    BufferedImage choppedOffImage = new BufferedImage((int)pf.getImageableWidth(), h, 2);
                    Graphics2D g = (Graphics2D)choppedOffImage.getGraphics();
                    g.setRenderingHints(GraphicsUtil.getRenderingHints());
                    g.setColor(SystemColor.white);
                    g.fillRect(0, 0, choppedOffImage.getWidth(), choppedOffImage.getHeight());
                    g.drawImage(image, 0, 0, null);
                    IconElementDescriptor choppedOffIconElm = new IconElementDescriptor(choppedOffImage, 2, editor.getFont(), editor.getFontMetrics(editor.getFont()), aSet, false);
                    return choppedOffIconElm;
                }
                Image image = comp.createImage(w, h);
                Graphics formG = image.getGraphics();
                comp.paintAll(formG);
                if (image == null) {
                    AtDebug.debug("getComponentElement()..tried to create an conversion out of it...got null... return null");
                    return null;
                }
                IconElementDescriptor ie = new IconElementDescriptor(image, 2, editor.getFont(), editor.getFontMetrics(editor.getFont()), aSet, false);
                return ie;
            }

            void createLineElements() {
                JavaDocumentPrinter.this.lines.clear();
                PageFormat pageFormat = JavaDocumentPrinter.this.getPageFormat();
                LineDescriptor lineElm = new LineDescriptor(pageFormat, JavaDocumentPrinter.this.isUseCellRenderer());
                for (int i = 0; i < JavaDocumentPrinter.this.styleElements.size(); ++i) {
                    ElementDescriptor elm = (ElementDescriptor)JavaDocumentPrinter.this.styleElements.get(i);
                    if (elm == null) continue;
                    if (elm instanceof NewlineElementDescriptor) {
                        lineElm.lineFilled = true;
                        JavaDocumentPrinter.this.lines.add(lineElm);
                        lineElm = new LineDescriptor(pageFormat, JavaDocumentPrinter.this.isUseCellRenderer());
                        continue;
                    }
                    SplittedElement spElm = lineElm.addElement(elm);
                    if (spElm != null) {
                        // empty if block
                    }
                    if (spElm == null) continue;
                    if (spElm.elmType == 1) {
                        if (spElm.splitted) {
                            JavaDocumentPrinter.this.styleElements.setElementAt(spElm.element1, i);
                            JavaDocumentPrinter.this.styleElements.insertElementAt(spElm.element2, i + 1);
                        } else {
                            JavaDocumentPrinter.this.styleElements.insertElementAt(spElm.element2, i + 1);
                        }
                    } else if (spElm.elmType == 2 || spElm.elmType == 3) {
                        // empty if block
                    }
                    JavaDocumentPrinter.this.lines.add(lineElm);
                    lineElm = new LineDescriptor(pageFormat, JavaDocumentPrinter.this.isUseCellRenderer());
                }
                if (!lineElm.lineFilled) {
                    lineElm.lineFilled = true;
                    JavaDocumentPrinter.this.lines.add(lineElm);
                }
            }

            void createPageElements(Vector previewPages, int purpose) {
                ArrayList<Page> allPrintables = new ArrayList<Page>();
                PageFormat pageFormat = JavaDocumentPrinter.this.getPageFormat();
                int pageNoLoc = JavaDocumentPrinter.this.getPageNumberLocation();
                int pageNo = 1;
                JavaDocumentPrinter.this.pages.clear();
                LineDescriptor line = null;
                PageDescriptor page = new PageDescriptor((float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getImageableHeight());
                boolean isAddedToTablePage = false;
                for (int i = 0; i < JavaDocumentPrinter.this.lines.size(); ++i) {
                    Page aPrintable;
                    line = (LineDescriptor)JavaDocumentPrinter.this.lines.elementAt(i);
                    if (page.add(line)) continue;
                    for (int xx = 0; line != null && xx < line.getElementCount(); ++xx) {
                        ElementDescriptor elm = line.getElement(xx);
                        if (elm == null) continue;
                    }
                    boolean isBiggerThanAvailableHeight = page.isBiggerThanAvailableHeight(line);
                    if (isBiggerThanAvailableHeight) {
                        if (page.getLineCount() == 0) {
                            page.addOnlyElement(line);
                            page.usedImageHeight += line.getMaxHeight();
                            page.usedImageHeight += line.getLineGap();
                            page.pageFilled = true;
                            if (isAddedToTablePage) {
                                isAddedToTablePage = false;
                            } else {
                                JavaDocumentPrinter.this.pages.add(page);
                                aPrintable = new Page(page, pageNo++, pageNoLoc, pageFormat, JavaDocumentPrinter.this.getHeaderFooterListener(), JavaDocumentPrinter.this.getZoom(), JavaDocumentPrinter.this.isAntialiased(), JavaDocumentPrinter.this.isUseCellRenderer(), JavaDocumentPrinter.this.demoShape);
                                allPrintables.add(aPrintable);
                            }
                            page = new PageDescriptor((float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getImageableHeight());
                            continue;
                        }
                        page.pageFilled = true;
                        if (isAddedToTablePage) {
                            isAddedToTablePage = false;
                        } else {
                            JavaDocumentPrinter.this.pages.add(page);
                            aPrintable = new Page(page, pageNo++, pageNoLoc, pageFormat, JavaDocumentPrinter.this.getHeaderFooterListener(), JavaDocumentPrinter.this.getZoom(), JavaDocumentPrinter.this.isAntialiased(), JavaDocumentPrinter.this.isUseCellRenderer(), JavaDocumentPrinter.this.demoShape);
                            allPrintables.add(aPrintable);
                        }
                        page = new PageDescriptor((float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getImageableHeight());
                        page.forceAdd(line);
                        continue;
                    }
                    if (isAddedToTablePage) {
                        isAddedToTablePage = false;
                    } else {
                        JavaDocumentPrinter.this.pages.add(page);
                        aPrintable = new Page(page, pageNo++, pageNoLoc, pageFormat, JavaDocumentPrinter.this.getHeaderFooterListener(), JavaDocumentPrinter.this.getZoom(), JavaDocumentPrinter.this.isAntialiased(), JavaDocumentPrinter.this.isUseCellRenderer(), JavaDocumentPrinter.this.demoShape);
                        allPrintables.add(aPrintable);
                    }
                    page = new PageDescriptor((float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getImageableHeight());
                    page.add(line);
                }
                if (!page.pageFilled && page.getLineCount() > 0) {
                    if (isAddedToTablePage) {
                        isAddedToTablePage = false;
                    } else {
                        JavaDocumentPrinter.this.pages.add(page);
                        Page aPrintable = new Page(page, pageNo++, pageNoLoc, pageFormat, JavaDocumentPrinter.this.getHeaderFooterListener(), JavaDocumentPrinter.this.getZoom(), JavaDocumentPrinter.this.isAntialiased(), JavaDocumentPrinter.this.isUseCellRenderer(), JavaDocumentPrinter.this.demoShape);
                        allPrintables.add(aPrintable);
                    }
                }
                previewPages.addAll(allPrintables);
            }
        }
    }
}

