/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.shape;

import com.activetree.common.report.shape.AbstractShape2D;
import com.activetree.common.report.shape.ShapeSourceInterface;
import com.activetree.common.resource.AtCommonResource;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import javax.swing.JScrollPane;

public class CustomText2D
extends AbstractShape2D {
    public CustomText2D(ShapeSourceInterface source, Dimension size) {
        super(source, size, AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SMART_JPRINT"));
        this.recreateShape();
    }

    public void recreateShape() {
        this.font = new Font(this.getFontFamily(), this.getFontStyle(), this.getFontSize());
        TextLayout tl = new TextLayout(this.text, this.font, new FontRenderContext(null, false, false));
        AffineTransform textAt = new AffineTransform();
        textAt.translate(0.0, (float)tl.getBounds().getHeight());
        this.shape = tl.getOutline(textAt);
        Rectangle r = this.shape.getBounds();
        int max = r.width;
        if (max < r.height) {
            max = r.height;
        }
        this.size = new Dimension(max += 24, max);
    }

    public String toString() {
        return AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_TEXT");
    }

    public void createScrollPane() {
        this.scroll = new JScrollPane(this);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.setTransform(this.shape);
        this.drawShape();
    }
}

