/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.watermark;

import com.activetree.common.page.AbstractPage;
import com.activetree.common.report.AtPrintUtil;
import com.activetree.common.report.AtStringElement;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Watermark
implements Serializable {
    public static final int MARGIN = 6;
    protected Image watermark;
    protected boolean antiAliased = true;

    public Watermark() {
    }

    public Watermark(Image watermark) {
        this.watermark = watermark;
    }

    public Image getWatermark() {
        return this.watermark;
    }

    public void setWatermark(Image watermark) {
        this.watermark = watermark;
    }

    public void setAntiAliased(boolean aa) {
        this.antiAliased = aa;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public static final Watermark createTextWatermark(AtStringElement strElm) {
        Font font = strElm.getFont();
        Color bgColor = strElm.getBackground();
        Color fgColor = strElm.getForeground();
        FontMetrics fm = AtPrintUtil.getFontMetrics(font);
        int strWidth = GraphicsUtil.stringWidth(font, strElm.getText());
        int strHeight = fm.getHeight();
        BufferedImage image = new BufferedImage(strWidth, strHeight, 1);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        GraphicsUtil.applyAntiAlias(g2d);
        g2d.setColor(bgColor);
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        FontRenderContext fontCtx = g2d.getFontRenderContext();
        TextLayout layout = new TextLayout(strElm.getText(), font, fontCtx);
        Shape textShape = layout.getOutline(null);
        Rectangle textBBox = textShape.getBounds();
        AffineTransform at = g2d.getTransform();
        at.translate((strWidth - textBBox.width) / 2, strHeight / 2 + textBBox.height / 4);
        g2d.setTransform(at);
        g2d.setColor(fgColor);
        g2d.draw(textShape);
        Watermark textmark = new Watermark(image);
        return textmark;
    }

    public static final Watermark createIconWatermark(Object icon, Color bgColor) {
        int imgw = -1;
        int imgh = -1;
        Image image = null;
        if (icon == null) {
            String errMsg = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_NULL_IOCN_FOR_WATERMARK");
            throw new NullPointerException(errMsg);
        }
        if (icon instanceof Image) {
            imgw = ((Image)icon).getWidth(null);
            imgh = ((Image)icon).getHeight(null);
            image = (Image)icon;
        } else if (icon instanceof ImageIcon) {
            imgw = ((Icon)icon).getIconWidth();
            imgh = ((Icon)icon).getIconHeight();
            image = ((ImageIcon)icon).getImage();
        } else {
            String errMsg = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_UNSUPPORTED_IOCN_TYPE_FOR_WATERMARK");
            throw new RuntimeException(errMsg + " " + icon.getClass().getName());
        }
        BufferedImage bufImg = new BufferedImage(imgw, imgh, 1);
        Graphics2D g2d = (Graphics2D)bufImg.getGraphics();
        GraphicsUtil.applyAntiAlias(g2d);
        g2d.setColor(bgColor);
        g2d.fillRect(0, 0, bufImg.getWidth(), bufImg.getHeight());
        g2d.drawImage(image, 0, 0, null);
        Watermark iconmark = new Watermark(bufImg);
        return iconmark;
    }

    public void applyWatermark(Graphics g, AbstractPage page) {
        if (page == null || g == null) {
            return;
        }
        Image img = this.watermark;
        PageFormat pf = page.getPageFormat();
        int imgx = (int)pf.getImageableX();
        int imgy = (int)pf.getImageableY();
        int imgw = (int)pf.getImageableWidth();
        int imgh = (int)pf.getImageableHeight();
        int cx = imgx + (imgw - this.watermark.getWidth(null)) / 2;
        int cy = imgy + (imgh - this.watermark.getHeight(null)) / 2;
        Rectangle clipRect = new Rectangle(imgx, imgy, imgw, imgh);
        Shape orgClip = g.getClip();
        g.setClip(clipRect);
        g.drawImage(img, cx, cy, null);
        g.setClip(orgClip);
    }
}

