/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.report.watermark;

import com.activetree.common.action.AtColorSelectionChangeListener;
import com.activetree.common.report.shape.AbstractShape2D;
import com.activetree.common.report.shape.CustomImage2D;
import com.activetree.common.report.shape.CustomText2D;
import com.activetree.common.report.shape.ShapeSourceInterface;
import com.activetree.common.report.watermark.Watermark;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.resource.AtImageList;
import com.activetree.common.swing.AtColorChooser;
import com.activetree.common.swing.AtColorSelectionChangeEvent;
import com.activetree.common.swing.AtImageCellWidget;
import com.activetree.common.swing.AtInsetsPanel;
import com.activetree.common.swing.AtMouseWheelScrollListener;
import com.activetree.common.utils.AtComponentUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class WatermarkProducer
extends JPanel
implements ItemListener,
ActionListener,
ShapeSourceInterface,
Serializable {
    private static final String IDENTITY_CMD = "IDENTITY";
    private static final String ROTATE_CMD = "ROTATE";
    private static final String SHEAR_CMD = "SHEAR";
    private static final String APPLY_TEXT_CMD = "APPLY_TEXT_CMD";
    private static final String OK_CMD = "OK";
    private static final String CANCEL_CMD = "CANCEL";
    private static final String LOAD_ICON_CMD = "LOAD_ICON";
    public static final float[] dash1 = new float[]{3.0f};
    public static final BasicStroke[] strokeOptions = new BasicStroke[]{new BasicStroke(2.0f), new BasicStroke(3.0f), new BasicStroke(1.0f, 0, 0, 2.0f, dash1, 0.0f)};
    public static final String[] strokeNames = new String[]{AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Normal"), AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Wider"), AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Dashed")};
    public static final String[] fillingOptions = new String[]{AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Draw"), AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Fill"), AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_DRAW_AND_FILL")};
    public static final String[] paintOptions = new String[]{AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Normal"), AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Gradient"), AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Texture")};
    protected Dimension size = new Dimension(500, 250);
    protected AbstractShape2D[] shapeOptions = null;
    protected JComboBox shapes;
    protected JComboBox strokes;
    protected JComboBox fillingStyles;
    protected JComboBox paints;
    protected JPanel cardPanel = new JPanel();
    protected CardLayout cardLayout = new CardLayout(3, 3);
    protected BasicStroke currentStroke;
    protected String currentFilling;
    protected String currentPaint;
    protected AbstractShape2D currentItem;
    protected JScrollPane scroll;
    protected JButton identityButton;
    protected JButton rotateButton;
    protected JButton shearButton;
    protected WatermarkFontPanel fontPanel;
    protected JTextField textField = new JTextField();
    protected JButton applyTextButton;
    protected JButton okButton;
    protected JButton cancelButton;
    protected boolean okPressed = false;
    protected Watermark watermark;
    protected JButton loadIconButton;
    protected JTextField iconFileField = new JTextField();
    protected JCheckBox enableWatermark;

    public JScrollPane getScroller() {
        return this.scroll;
    }

    public WatermarkProducer() {
        this.setMinimumSize(this.size);
        this.setPreferredSize(this.size);
        this.shapeOptions = new AbstractShape2D[2];
        this.shapeOptions[0] = new CustomText2D(this, this.size);
        this.shapeOptions[1] = new CustomImage2D(this, this.size);
        new AtMouseWheelScrollListener(this.shapeOptions[0].getScrollPane(), 25);
        new AtMouseWheelScrollListener(this.shapeOptions[1].getScrollPane(), 25);
        this.currentStroke = strokeOptions[0];
        this.currentFilling = fillingOptions[0];
        this.currentPaint = paintOptions[0];
        this.currentItem = this.shapeOptions[0];
        this.cardPanel.setLayout(this.cardLayout);
        this.strokes = new JComboBox<String>(strokeNames);
        this.strokes.addItemListener(this);
        this.shapes = new JComboBox<AbstractShape2D>(this.shapeOptions);
        this.shapes.setEditable(false);
        this.shapes.addItemListener(this);
        this.shapes.setSelectedItem(this.shapeOptions[0]);
        this.fillingStyles = new JComboBox<String>(fillingOptions);
        this.fillingStyles.setEditable(false);
        this.fillingStyles.addItemListener(this);
        this.fillingStyles.setSelectedItem(fillingOptions[0]);
        this.paints = new JComboBox<String>(paintOptions);
        this.paints.setEditable(false);
        this.paints.addItemListener(this);
        this.paints.setSelectedItem(paintOptions[0]);
        for (int i = 0; i < this.shapeOptions.length; ++i) {
            this.scroll = this.shapeOptions[i].getScrollPane();
            this.cardPanel.add((Component)this.scroll, this.shapeOptions[i].toString());
        }
        this.identityButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Normal"));
        this.identityButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_Normal"));
        this.identityButton.setActionCommand(IDENTITY_CMD);
        this.identityButton.addActionListener(this);
        this.rotateButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Rotate"));
        this.rotateButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_Rotate"));
        this.rotateButton.setActionCommand(ROTATE_CMD);
        this.rotateButton.addActionListener(this);
        this.shearButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Shear"));
        this.shearButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_Shear"));
        this.shearButton.setActionCommand(SHEAR_CMD);
        this.shearButton.addActionListener(this);
        this.fontPanel = new WatermarkFontPanel();
        this.textField.setText(this.shapeOptions[0].getText());
        this.iconFileField.setEditable(false);
        this.applyTextButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Apply"));
        this.applyTextButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_Apply"));
        this.applyTextButton.setActionCommand(APPLY_TEXT_CMD);
        this.applyTextButton.addActionListener(this);
        this.applyTextButton.setPreferredSize(new Dimension(80, this.applyTextButton.getPreferredSize().height));
        this.okButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_DONE"));
        this.okButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_DONE"));
        this.okButton.setActionCommand(OK_CMD);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_Cancel"));
        this.cancelButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_Cancel"));
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.cancelButton.addActionListener(this);
        this.loadIconButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_LOAD_ICON"));
        this.loadIconButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_LOAD_ICON"));
        this.loadIconButton.setActionCommand(LOAD_ICON_CMD);
        this.loadIconButton.addActionListener(this);
        this.loadIconButton.setPreferredSize(new Dimension(80, this.loadIconButton.getPreferredSize().height));
        this.enableWatermark = new JCheckBox(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_ENABLED"), true);
        this.enableWatermark.addActionListener(this);
        this.setupContentPane();
        this.addKeyListener(new KeyAdapter(){});
    }

    protected void setupContentPane() {
        JPanel iconFilePane = new JPanel(new GridBagLayout());
        iconFilePane.add((Component)this.iconFileField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        iconFilePane.add((Component)this.loadIconButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 5, 0, 0), 0, 0));
        JPanel textPane = new JPanel(new GridBagLayout());
        textPane.add((Component)this.textField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        textPane.add((Component)this.applyTextButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        JPanel inputPane = new JPanel(new GridBagLayout());
        inputPane.add((Component)iconFilePane, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        inputPane.add((Component)textPane, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel choicePane = new JPanel(new GridBagLayout());
        Border styleBorder = BorderFactory.createEtchedBorder();
        styleBorder = BorderFactory.createTitledBorder(styleBorder, AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_STYLE_SELECTION"), 2, 2);
        choicePane.setBorder(styleBorder);
        choicePane.add((Component)new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SHAPES")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        choicePane.add((Component)this.shapes, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        choicePane.add((Component)new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_STROKES")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        choicePane.add((Component)this.strokes, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        choicePane.add((Component)new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_FILLING")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        choicePane.add((Component)this.fillingStyles, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        choicePane.add((Component)new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_PAINTS")), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        choicePane.add((Component)this.paints, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        JPanel doneButtonPane = new JPanel(new GridBagLayout());
        doneButtonPane.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        doneButtonPane.add((Component)this.cancelButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 2, 0), 0, 0));
        JPanel watermarkEnablePane = new JPanel(new GridBagLayout());
        watermarkEnablePane.add((Component)new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_WATERMARK")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        watermarkEnablePane.add((Component)this.enableWatermark, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 2, 0), 0, 0));
        JPanel actionButtonPane = new JPanel(new GridBagLayout());
        actionButtonPane.add((Component)this.identityButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        actionButtonPane.add((Component)this.rotateButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 0, 0), 0, 0));
        actionButtonPane.add((Component)this.shearButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 0, 0), 0, 0));
        JPanel buttonPane = new JPanel(new GridBagLayout());
        buttonPane.add((Component)actionButtonPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        buttonPane.add((Component)watermarkEnablePane, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 15, 2, new Insets(5, 0, 0, 0), 0, 0));
        buttonPane.add((Component)doneButtonPane, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        JPanel toolsPanel = new JPanel(new GridBagLayout());
        toolsPanel.add((Component)inputPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        toolsPanel.add((Component)choicePane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        toolsPanel.add((Component)this.fontPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
        toolsPanel.add((Component)buttonPane, new GridBagConstraints(1, 0, 1, 3, 0.0, 1.0, 13, 1, new Insets(0, 10, 0, 0), 0, 0));
        AtInsetsPanel top = new AtInsetsPanel(new BorderLayout(5, 5));
        top.setInsets(new Insets(4, 4, 4, 4));
        top.add((Component)toolsPanel, "North");
        top.add((Component)this.cardPanel, "Center");
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)top, "Center");
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.shapes) {
            this.currentItem = (AbstractShape2D)this.shapes.getSelectedItem();
            this.scroll = this.currentItem.getScrollPane();
            this.cardLayout.show(this.cardPanel, this.currentItem.toString());
        } else if (source == this.strokes) {
            String name = (String)this.strokes.getSelectedItem();
            if (name.equals(strokeNames[0])) {
                this.currentStroke = strokeOptions[0];
            } else if (name.equals(strokeNames[1])) {
                this.currentStroke = strokeOptions[1];
            } else if (name.equals(strokeNames[2])) {
                this.currentStroke = strokeOptions[2];
            }
        } else if (source == this.fillingStyles) {
            this.currentFilling = (String)this.fillingStyles.getSelectedItem();
        } else if (source == this.paints) {
            this.currentPaint = (String)this.paints.getSelectedItem();
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(IDENTITY_CMD)) {
            this.currentItem.identity();
        } else if (cmd.equals(ROTATE_CMD)) {
            this.currentItem.rotate(15);
        } else if (cmd.equals(SHEAR_CMD)) {
            this.currentItem.shear(0.5, 0.0);
        } else if (cmd.equals(APPLY_TEXT_CMD)) {
            this.shapeOptions[0].setText(this.textField.getText());
            this.shapeOptions[0].recreateShape();
            this.shapes.setSelectedIndex(0);
        } else if (cmd.equals(LOAD_ICON_CMD)) {
            JFileChooser iconChooser = new JFileChooser(".");
            iconChooser.showOpenDialog(this);
            File selFile = iconChooser.getSelectedFile();
            if (selFile == null) {
                return;
            }
            if (selFile.canRead() && selFile.isFile()) {
                ImageIcon icon = null;
                try {
                    this.iconFileField.setText(selFile.getAbsolutePath());
                    icon = new ImageIcon(selFile.getAbsolutePath());
                    ((CustomImage2D)this.shapeOptions[1]).setImage(icon.getImage());
                    this.shapes.setSelectedIndex(1);
                }
                catch (Throwable t) {
                    String message = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_UNKNOWN_ICON_FILE");
                    String title = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_UNKNOWN_ICON_TITLE");
                    JOptionPane.showMessageDialog(this, message, title, 1);
                    return;
                }
            }
        } else if (evt.getSource() != this.enableWatermark) {
            if (cmd.equals(OK_CMD)) {
                this.okPressed = true;
                this.createWatermark();
                Window window = AtComponentUtil.getWindowForComponent(this);
                window.setVisible(false);
            } else if (cmd.equals(CANCEL_CMD)) {
                this.okPressed = false;
                Window window = AtComponentUtil.getWindowForComponent(this);
                window.setVisible(false);
            }
        }
        this.currentItem.updateUI();
        this.scroll.validate();
        this.scroll.updateUI();
        this.repaint();
    }

    public void setWatermarkEnabled(boolean enable) {
        this.enableWatermark.setSelected(enable);
    }

    public boolean isWatermarkEnabled() {
        return this.enableWatermark.isSelected();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public Watermark getWatermark() {
        return this.watermark;
    }

    protected void createWatermark() {
        AbstractShape2D form = this.currentItem;
        int w = ((Component)form).getWidth();
        int h = ((Component)form).getHeight();
        BufferedImage bufImage = new BufferedImage(w, h, 1);
        Graphics2D imdGraphics = bufImage.createGraphics();
        form.paintAll(imdGraphics);
        this.watermark = new Watermark(bufImage);
    }

    public String getCurrentPaint() {
        return this.currentPaint;
    }

    public Stroke getCurrentStroke() {
        return this.currentStroke;
    }

    public String getCurrentFilling() {
        return this.currentFilling;
    }

    class WatermarkFontPanel
    extends JPanel
    implements ActionListener {
        Vector fontSizes = new Vector();
        Vector fontNames = new Vector();
        JComboBox fontBox = null;
        JComboBox sizeBox = null;
        AtColorChooser colorPane;
        AtColorChooser gradientColorPane;
        AtColorChooser gradientEndColorPane;
        AtImageCellWidget colorPopupButton;
        AtImageCellWidget gradientBeginColorButton;
        AtImageCellWidget gradientEndColorButton;
        JPopupMenu colorPopup = new JPopupMenu();
        JPopupMenu gradientColorPopup = new JPopupMenu();
        JPopupMenu gradientEndColorPopup = new JPopupMenu();
        WatermarkFontPanel parent = this;

        public WatermarkFontPanel() {
            int i;
            GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font[] fonts = genv.getAllFonts();
            for (i = 0; i < fonts.length; ++i) {
                this.fontNames.add(fonts[i].getFontName());
            }
            this.fontBox = new JComboBox(this.fontNames);
            this.fontBox.setFocusable(false);
            this.fontBox.setSelectedItem(WatermarkProducer.this.currentItem.getFontFamily());
            this.fontBox.setEditable(true);
            for (i = 6; i <= 150; ++i) {
                this.fontSizes.add(new Integer(i));
            }
            this.sizeBox = new JComboBox(this.fontSizes);
            this.sizeBox.setFocusable(false);
            this.sizeBox.setEditable(true);
            this.sizeBox.setSelectedItem("80");
            this.colorPane = new AtColorChooser();
            this.colorPane.addSelectionChangeListener(new ColorSelectionChangeHandler());
            this.gradientColorPane = new AtColorChooser();
            this.gradientColorPane.addSelectionChangeListener(new GradStartColorSelectionChangeHandler());
            this.gradientEndColorPane = new AtColorChooser();
            this.gradientEndColorPane.addSelectionChangeListener(new GradEndColorSelectionChangeHandler());
            Border directionBorder = BorderFactory.createEtchedBorder();
            directionBorder = BorderFactory.createTitledBorder(directionBorder, AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_FONT_SELECTION"), 2, 2);
            this.setBorder(directionBorder);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.fontBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.sizeBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            String tooltip = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SELECT_TEXT_COLOR");
            this.colorPopupButton = this.createFlatButton(this, AtImageList.IMAGE_LIST.FONT_COLOR, "Color", tooltip);
            this.colorPopup.add(this.colorPane);
            this.add((Component)this.colorPopupButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
            this.fontBox.addActionListener(this);
            this.sizeBox.addActionListener(this);
            this.colorPopupButton.addActionListener(this);
            tooltip = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_GRADIENT_COLOR");
            this.gradientBeginColorButton = this.createFlatButton(this, AtImageList.IMAGE_LIST.FONT_COLOR, "GradientBeginColor", tooltip);
            this.gradientColorPopup.add(this.gradientColorPane);
            this.add((Component)this.gradientBeginColorButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
            tooltip = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_GRAD_END_COLOR");
            this.gradientEndColorButton = this.createFlatButton(this, AtImageList.IMAGE_LIST.FONT_COLOR, "GradientEndColor", tooltip);
            this.gradientEndColorPopup.add(this.gradientEndColorPane);
            this.add((Component)this.gradientEndColorButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
            this.fontBox.setEditable(false);
            this.sizeBox.setEditable(false);
        }

        private AtImageCellWidget createFlatButton(ActionListener l2, ImageIcon icon, String cmd, String tooltip) {
            AtImageCellWidget button = new AtImageCellWidget(icon);
            button.setToolTipText(tooltip);
            button.setRequestFocusEnabled(true);
            button.setFocusEnabled(true);
            button.setActionCommand(cmd);
            button.addActionListener(l2);
            return button;
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.fontBox) {
                String newFontFamily = (String)this.fontBox.getSelectedItem();
                WatermarkProducer.this.currentItem.setFontFamily(newFontFamily);
                WatermarkProducer.this.currentItem.recreateShape();
            } else if (source == this.sizeBox) {
                Object obj = this.sizeBox.getSelectedItem();
                if (obj instanceof Integer) {
                    Integer item = (Integer)obj;
                    int newFontSize = item;
                    WatermarkProducer.this.currentItem.setFontSize(newFontSize);
                    WatermarkProducer.this.currentItem.recreateShape();
                }
            } else if (source == this.colorPopupButton) {
                this.colorPopup.show(this.colorPopupButton, 0, 0);
            } else if (source == this.gradientBeginColorButton) {
                this.gradientColorPopup.show(this.gradientBeginColorButton, 0, 0);
            } else if (source == this.gradientEndColorButton) {
                this.gradientEndColorPopup.show(this.gradientEndColorButton, 0, 0);
            }
            WatermarkProducer.this.currentItem.updateUI();
            WatermarkProducer.this.scroll.validate();
            WatermarkProducer.this.scroll.updateUI();
            this.repaint();
        }

        public void enableAll(boolean enable) {
            this.fontBox.setEnabled(enable);
            this.sizeBox.setEnabled(enable);
            this.colorPopupButton.setEnabled(enable);
        }

        class GradEndColorSelectionChangeHandler
        implements AtColorSelectionChangeListener {
            GradEndColorSelectionChangeHandler() {
            }

            public void colorSelectionChanged(AtColorSelectionChangeEvent evt) {
                WatermarkFontPanel.this.gradientEndColorPopup.setVisible(false);
                Color selColor = evt.getNewColor();
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.currentItem.setGradientEndColor(selColor);
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.currentItem.updateUI();
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.scroll.validate();
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.scroll.updateUI();
                WatermarkFontPanel.this.repaint();
            }
        }

        class GradStartColorSelectionChangeHandler
        implements AtColorSelectionChangeListener {
            GradStartColorSelectionChangeHandler() {
            }

            public void colorSelectionChanged(AtColorSelectionChangeEvent evt) {
                WatermarkFontPanel.this.gradientColorPopup.setVisible(false);
                Color selColor = evt.getNewColor();
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.currentItem.setGradientBeginColor(selColor);
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.currentItem.updateUI();
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.scroll.validate();
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.scroll.updateUI();
                WatermarkFontPanel.this.repaint();
            }
        }

        class ColorSelectionChangeHandler
        implements AtColorSelectionChangeListener {
            ColorSelectionChangeHandler() {
            }

            public void colorSelectionChanged(AtColorSelectionChangeEvent evt) {
                WatermarkFontPanel.this.colorPopup.setVisible(false);
                Color selColor = evt.getNewColor();
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.currentItem.setTextColor(selColor);
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.currentItem.updateUI();
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.scroll.validate();
                ((WatermarkFontPanel)WatermarkFontPanel.this).WatermarkProducer.this.scroll.updateUI();
                WatermarkFontPanel.this.repaint();
            }
        }
    }
}

