/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.attr.reader.DefaultCommonUiAttributeReader;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;

public class ArrowMaker
extends DefaultCommonUiAttributeReader
implements Serializable {
    protected int arrowBaseDiagonalDistance = 10;
    protected int arrowBaseHalfWidth = 4;
    private Shape[] shapes;

    public int getArrowBaseDiagonalDistance() {
        return this.arrowBaseDiagonalDistance;
    }

    public void setArrowBaseDiagonalDistance(int arrowBaseDiagonalDistance) {
        this.arrowBaseDiagonalDistance = arrowBaseDiagonalDistance;
    }

    public int getArrowBaseHalfWidth() {
        return this.arrowBaseHalfWidth;
    }

    public void setArrowBaseHalfWidth(int arrowBaseHalfWidth) {
        this.arrowBaseHalfWidth = arrowBaseHalfWidth;
    }

    public Shape[] getArrowShape() {
        return this.shapes;
    }

    public void resetArrow(Point2D pointFrom, Point2D pointTo, int arrowBaseDiagonalDistance, int arrowBaseHalfWidth) {
        this.shapes = this.createArrow(pointFrom, pointTo, arrowBaseDiagonalDistance, arrowBaseHalfWidth);
    }

    private Shape[] toArray(ArrayList arrows) {
        Shape[] arrs = new Shape[arrows.size()];
        for (int i = 0; i < arrows.size(); ++i) {
            arrs[i] = (Shape)arrows.get(i);
        }
        return arrs;
    }

    public Shape[] createArrow(Point2D pointFrom, Point2D pointTo, int arrowBaseDiagonalDistance, int arrowBaseHalfWidth) {
        boolean twoWayArrow;
        ArrayList<Polygon> arrows = new ArrayList<Polygon>();
        boolean drawArrow = this.getPrimitiveBooleanAttribute("drawArrow", false, false);
        if (drawArrow) {
            ArrayList arrowPointsRetList = new ArrayList();
            this.calculateArrowPoints(new Point2D.Double(pointFrom.getX(), pointFrom.getY()), new Point2D.Double(pointTo.getX(), pointTo.getY()), arrowBaseDiagonalDistance, arrowBaseHalfWidth, arrowPointsRetList);
            Point2D.Double aArrowBase = (Point2D.Double)arrowPointsRetList.get(0);
            Point2D.Double aArrowBaseLeft = (Point2D.Double)arrowPointsRetList.get(1);
            Point2D.Double aArrowBaseRight = (Point2D.Double)arrowPointsRetList.get(2);
            Polygon aShape = this.createArrowShape(pointFrom, pointTo, aArrowBaseLeft, aArrowBase, aArrowBaseRight);
            arrows.add(aShape);
        }
        if (twoWayArrow = this.getPrimitiveBooleanAttribute("twoWayArrow", false, false)) {
            ArrayList arrowPointsRetList = new ArrayList();
            this.calculateArrowPoints(new Point2D.Double(pointTo.getX(), pointTo.getY()), new Point2D.Double(pointFrom.getX(), pointFrom.getY()), arrowBaseDiagonalDistance, arrowBaseHalfWidth, arrowPointsRetList);
            Point2D.Double aArrowBase = (Point2D.Double)arrowPointsRetList.get(0);
            Point2D.Double aArrowBaseLeft = (Point2D.Double)arrowPointsRetList.get(1);
            Point2D.Double aArrowBaseRight = (Point2D.Double)arrowPointsRetList.get(2);
            Polygon aShape = this.createArrowShape(pointTo, pointFrom, aArrowBaseLeft, aArrowBase, aArrowBaseRight);
            arrows.add(aShape);
        }
        Shape[] arrowShapes = this.toArray(arrows);
        return arrowShapes;
    }

    Polygon createArrowShape(Point2D pointFrom, Point2D pointTo, Point2D arrowBaseLeft, Point2D arrowBase, Point2D arrowBaseRight) {
        Point2D.Double tip = new Point2D.Double(pointTo.getX(), pointTo.getY());
        Polygon arrow = new Polygon();
        arrow.addPoint((int)tip.getX(), (int)tip.getY());
        arrow.addPoint((int)arrowBaseLeft.getX(), (int)arrowBaseLeft.getY());
        arrow.addPoint((int)arrowBase.getX(), (int)arrowBase.getY());
        arrow.addPoint((int)arrowBaseRight.getX(), (int)arrowBaseRight.getY());
        return arrow;
    }

    void calculateArrowPoints(Point2D.Double p1, Point2D.Double p2, int ARROW_BASE_DIAGONAL_DISTANCE, int ARROW_BASE_HALF_WIDTH, ArrayList retList) {
        Point2D.Double p3 = new Point2D.Double();
        Point2D.Double p4 = new Point2D.Double();
        double x = 0.0;
        double y = 0.0;
        double ydiff = p2.y - p1.y;
        double xdiff = p2.x - p1.x;
        if (xdiff == 0.0) {
            xdiff = 1.0;
        }
        double delta = ydiff / xdiff;
        double delta_square = Math.pow(delta, 2.0);
        double diogonal_dist_sq = ARROW_BASE_DIAGONAL_DISTANCE * ARROW_BASE_DIAGONAL_DISTANCE;
        double dx_sq = diogonal_dist_sq / (delta_square + 1.0);
        double dx = Math.sqrt(dx_sq);
        double dy = delta * dx;
        double diagonal_base_dist_sq = ARROW_BASE_HALF_WIDTH * ARROW_BASE_HALF_WIDTH;
        double dx_dash_sq = diagonal_base_dist_sq / (delta_square + 1.0);
        double dy_dash = Math.sqrt(dx_dash_sq);
        double dx_dash = delta * dy_dash;
        if (p2.y < p1.y && p2.x > p1.x) {
            y = p2.y + Math.abs(dy);
            x = p2.x - Math.abs(dx);
            p3.x = x + dx_dash;
            p3.y = y - dy_dash;
            p4.x = x - dx_dash;
            p4.y = y + dy_dash;
        } else if (p2.y > p1.y && p2.x < p1.x) {
            y = p2.y - Math.abs(dy);
            x = p2.x + Math.abs(dx);
            p3.x = x + dx_dash;
            p3.y = y - dy_dash;
            p4.x = x - dx_dash;
            p4.y = y + dy_dash;
        } else if (p2.y > p1.y && p2.x > p1.x) {
            y = p2.y - Math.abs(dy);
            x = p2.x - Math.abs(dx);
            p3.x = x + dx_dash;
            p3.y = y - dy_dash;
            p4.x = x - dx_dash;
            p4.y = y + dy_dash;
        } else if (p2.y < p1.y && p2.x < p1.x) {
            y = p2.y + Math.abs(dy);
            x = p2.x + Math.abs(dx);
            p3.x = x + dx_dash;
            p3.y = y - dy_dash;
            p4.x = x - dx_dash;
            p4.y = y + dy_dash;
        } else if (p2.y == p1.y && p2.x > p1.x) {
            y = p2.y;
            p3.x = x = p2.x - Math.abs(dx);
            p3.y = p2.y + (double)ARROW_BASE_HALF_WIDTH;
            p4.x = x;
            p4.y = p2.y - (double)ARROW_BASE_HALF_WIDTH;
        } else if (p2.y == p1.y && p2.x < p1.x) {
            y = p2.y;
            p3.x = x = p2.x + Math.abs(dx);
            p3.y = p2.y + (double)ARROW_BASE_HALF_WIDTH;
            p4.x = x;
            p4.y = p2.y - (double)ARROW_BASE_HALF_WIDTH;
        } else if (p2.x == p1.x && p2.y < p1.y) {
            y = p2.y + (double)ARROW_BASE_DIAGONAL_DISTANCE;
            x = p2.x;
            p3.x = p2.x + (double)ARROW_BASE_HALF_WIDTH;
            p3.y = y;
            p4.x = p2.x - (double)ARROW_BASE_HALF_WIDTH;
            p4.y = y;
        } else if (p2.x == p1.x && p2.y > p1.y) {
            y = p2.y - (double)ARROW_BASE_DIAGONAL_DISTANCE;
            x = p2.x;
            p3.x = p2.x + (double)ARROW_BASE_HALF_WIDTH;
            p3.y = y;
            p4.x = p2.x - (double)ARROW_BASE_HALF_WIDTH;
            p4.y = y;
        }
        Point2D.Double arrowBase = new Point2D.Double(x, y);
        Point2D.Double arrowBaseLeft = p3;
        Point2D.Double arrowBaseRight = p4;
        retList.add(arrowBase);
        retList.add(arrowBaseLeft);
        retList.add(arrowBaseRight);
    }
}

