/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.swing.AtWidget;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AtImageCellWidget
extends AtWidget {
    protected Icon orgIcon;
    protected Icon defaultIcon;
    protected Icon selectedDisabledIcon;
    protected Icon disabledIcon;

    public AtImageCellWidget() {
    }

    public AtImageCellWidget(ImageIcon imageIcon) {
        this.resetImageProperties(imageIcon);
    }

    private void resetImageProperties(ImageIcon imageIcon) {
        this.defaultIcon = this.orgIcon = imageIcon;
        this.selectedDisabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.orgIcon).getImage()));
        this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.orgIcon).getImage()));
        this.calculateWidgetSize();
    }

    protected void calculateWidgetSize() {
        this.pSize.width = this.getWidgetWidth();
        this.pSize.height = this.getWidgetHeight();
    }

    public void setIcon(ImageIcon icon) {
        this.resetImageProperties(icon);
    }

    public ImageIcon getIcon() {
        return (ImageIcon)this.orgIcon;
    }

    public void paintComponent(Graphics g) {
        this.defaultIcon = !super.isEnabled() ? this.disabledIcon : this.orgIcon;
        super.paintComponent(g);
    }

    public int getWidgetWidth() {
        int width = this.defaultIcon.getIconWidth() + 5;
        return width;
    }

    public int getWidgetHeight() {
        if (this.orgIcon != null) {
            return this.orgIcon.getIconHeight() + 5;
        }
        return 0;
    }

    protected void paintForeground(Graphics2D g2d) {
        Dimension d = this.getSize();
        int start_x = d.width / 2 - this.defaultIcon.getIconWidth() / 2;
        int start_y = d.height / 2 - this.defaultIcon.getIconHeight() / 2;
        if (this.mousePressed) {
            g2d.drawImage(((ImageIcon)this.defaultIcon).getImage(), start_x + 1, start_y + 1, this.defaultIcon.getIconWidth(), this.defaultIcon.getIconHeight(), this);
        } else {
            g2d.drawImage(((ImageIcon)this.defaultIcon).getImage(), start_x - 1, start_y, this.defaultIcon.getIconWidth(), this.defaultIcon.getIconHeight(), this);
        }
    }

    protected void paintCellBorder(Graphics2D g2d) {
        Dimension d = this.getSize();
        if (this.isFocusEnabled() && this.isFocusGained() && super.isEnabled()) {
            g2d.setColor(this.getFocusBorderColor());
            g2d.drawRect(0, 0, d.width - 1, d.height - 1);
        } else if (this.isSelected()) {
            g2d.setColor(this.getFocusBorderColor());
            g2d.drawRect(0, 0, d.width - 1, d.height - 1);
        }
    }
}

