/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollPane;

public class AtMouseWheelScrollListener {
    public AtMouseWheelScrollListener(JScrollPane scroller, int scrollAmount) {
        this.addMouseWheelListener(scroller, scrollAmount);
    }

    private void addMouseWheelListener(final JScrollPane scroller, final int scrollAmount) {
        if (scroller == null) {
            return;
        }
        scroller.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                int scrollDirection = evt.getWheelRotation();
                Rectangle visRect = scroller.getViewport().getViewRect();
                Dimension viewSize = scroller.getViewport().getViewSize();
                visRect.y = scrollDirection < 0 ? (visRect.y -= scrollAmount) : (visRect.y += scrollAmount);
                if (visRect.y < 0) {
                    visRect.y = 0;
                }
                if (visRect.y > viewSize.height - visRect.height) {
                    visRect.y = viewSize.height - visRect.height;
                }
                scroller.getViewport().setViewPosition(new Point(visRect.x, visRect.y));
            }
        });
    }
}

