/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.action.AtBaseAction;
import com.activetree.common.action.AtClearAction;
import com.activetree.common.action.AtCopyAction;
import com.activetree.common.action.AtCutAction;
import com.activetree.common.action.AtPasteAction;
import com.activetree.common.action.AtPopup;
import com.activetree.common.action.AtPopupAdapter;
import com.activetree.common.action.AtSelectAllAction;
import com.activetree.common.swing.AtPopupMenu;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class AtTextField
extends JTextField
implements AtPopup,
FocusListener {
    boolean clear = true;
    boolean copy = true;
    boolean cut = true;
    boolean paste = true;
    boolean popup = true;
    boolean selectAll = true;

    public AtTextField() {
        this("", 0);
    }

    public AtTextField(String text) {
        this(text, 0);
    }

    public AtTextField(int columns) {
        this("", columns);
    }

    public AtTextField(String text, int columns) {
        super(text, columns);
        this.initialize();
    }

    public AtTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.initialize();
    }

    protected void initialize() {
        AtPopupAdapter adapter = new AtPopupAdapter(this);
        this.addMouseListener(adapter);
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent e) {
        this.selectAll();
    }

    public void focusLost(FocusEvent e) {
        this.select(0, 0);
    }

    public void setClear(boolean clear) {
        this.clear = clear;
    }

    public void setCut(boolean cut) {
        this.cut = cut;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public void setPaste(boolean paste) {
        this.paste = paste;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public void setPopup(boolean popup) {
        this.popup = popup;
    }

    public boolean isCutEnabled() {
        return this.cut;
    }

    public boolean isCopyEnabled() {
        return this.copy;
    }

    public boolean isClearEnabled() {
        return this.clear;
    }

    public boolean isPasteEnabled() {
        return this.paste;
    }

    public boolean isSelectAllEnabled() {
        return this.selectAll;
    }

    public void popup(MouseEvent evt) {
        AtBaseAction action;
        Object src = evt.getSource();
        if (!this.popup) {
            return;
        }
        AtPopupMenu popup = new AtPopupMenu();
        if (this.cut) {
            action = new AtCutAction(this);
            popup.add(action);
            if (this.getSelectedText() == null) {
                action.setEnabled(false);
            }
        }
        if (this.copy) {
            action = new AtCopyAction(this);
            popup.add(action);
            if (this.getSelectedText() == null) {
                action.setEnabled(false);
            }
        }
        if (this.paste) {
            action = new AtPasteAction(this);
            ((AtPasteAction)action).setSelectionStart(this.getSelectionStart());
            ((AtPasteAction)action).setSelectionEnd(this.getSelectionEnd());
            popup.add(action);
        }
        if (this.clear) {
            action = new AtClearAction(this);
            popup.addSeparator();
            popup.add(action);
        }
        if (this.selectAll) {
            if (!this.clear) {
                popup.addSeparator();
            }
            action = new AtSelectAllAction(this);
            popup.add(action);
        }
        Point pt = evt.getPoint();
        popup.show(this, pt.x, pt.y);
    }
}

