/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtInsetsPanel;
import com.activetree.common.utils.AtDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class AtURLEditDialog
extends JDialog
implements ActionListener,
Serializable {
    private ArrayList items = new ArrayList();
    protected JTable table;
    protected JButton selectAllButton;
    protected JButton unselectAllButton;
    protected JButton deleteButton;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected JButton okButton;
    protected JButton cancelButton;
    private boolean cancelled = true;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public AtURLEditDialog(String[] itemList, Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init(itemList);
    }

    public AtURLEditDialog(String[] itemList, Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init(itemList);
    }

    protected void init(String[] itemList) {
        for (int i = 0; itemList != null && i < itemList.length; ++i) {
            this.items.add(itemList[i]);
        }
        URLTableModel tableModel = new URLTableModel(this.items);
        this.table = new JTable(tableModel);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                int selectionRows = AtURLEditDialog.this.getSelectionRows();
                int selectedIdx = AtURLEditDialog.this.table.getSelectedRow();
                AtURLEditDialog.this.enableDisableEditListButtons(selectionRows, selectedIdx);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                int selectionRows = AtURLEditDialog.this.getSelectionRows();
                int selectedIdx = AtURLEditDialog.this.table.rowAtPoint(evt.getPoint());
                AtURLEditDialog.this.enableDisableEditListButtons(selectionRows, selectedIdx);
            }
        });
        this.table.getColumnModel().getColumn(1).setMaxWidth(90);
        JScrollPane tableScroller = new JScrollPane(this.table);
        this.selectAllButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("SELECT_ALL"));
        this.selectAllButton.setActionCommand("SELECT_ALL");
        char selChar = AtCommonResource.MESSAGE_RESOURCE.getMnemonic("SELECT_ALL");
        this.selectAllButton.setMnemonic(selChar);
        this.selectAllButton.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getTooltip("SELECT_ALL"));
        this.selectAllButton.addActionListener(this);
        this.unselectAllButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("UNSELECT_ALL"));
        this.unselectAllButton.setActionCommand("UNSELECT_ALL");
        char uselChar = AtCommonResource.MESSAGE_RESOURCE.getMnemonic("UNSELECT_ALL");
        this.unselectAllButton.setMnemonic(uselChar);
        this.unselectAllButton.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getTooltip("UNSELECT_ALL"));
        this.unselectAllButton.addActionListener(this);
        this.deleteButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("PDF_DELETE_BUTTON"));
        this.deleteButton.setActionCommand("DELETE");
        this.deleteButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("PDF_DELETE_BUTTON"));
        this.deleteButton.addActionListener(this);
        this.moveUpButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("PDF_MOVE_UP_BUTTON"));
        this.moveUpButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("PDF_MOVE_UP_BUTTON"));
        this.moveUpButton.setActionCommand("MOVE_UP");
        this.moveUpButton.addActionListener(this);
        this.moveDownButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("PDF_MOVE_DOWN_BUTTON"));
        this.moveDownButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("PDF_MOVE_DOWN_BUTTON"));
        this.moveDownButton.setActionCommand("MOVE_DOWN");
        this.moveDownButton.addActionListener(this);
        this.okButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("Ok"));
        this.okButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("Ok"));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("Cancel"));
        this.cancelButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("Cancel"));
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.selectAllButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.unselectAllButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.moveUpButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.moveDownButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.okButton, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 16, 1, new Insets(5, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 16, 1, new Insets(5, 0, 0, 0), 0, 0));
        AtInsetsPanel top = new AtInsetsPanel(new BorderLayout(5, 5));
        top.setInsets(new Insets(5, 5, 5, 5));
        top.add((Component)tableScroller, "Center");
        top.add((Component)buttonPanel, "East");
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)top, "Center");
        int selectionRows = this.getSelectionRows();
        this.enableDisableEditListButtons(selectionRows, -1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AtURLEditDialog.this.cancelActionPerformed();
            }
        });
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals("OK")) {
            this.okActionPerformed();
        } else if (cmd.equals("SELECT_ALL")) {
            this.selectAll(Boolean.TRUE);
        } else if (cmd.equals("UNSELECT_ALL")) {
            this.selectAll(Boolean.FALSE);
        } else if (cmd.equals("CANCEL")) {
            this.cancelActionPerformed();
        } else if (cmd.equals("DELETE")) {
            this.deleteActionPerformed();
        } else if (cmd.equals("MOVE_UP")) {
            this.moveUpActionPerformed();
        } else if (cmd.equals("MOVE_DOWN")) {
            this.moveDownActionPerformed();
        }
    }

    protected void selectAll(Boolean value) {
        URLTableModel tm = (URLTableModel)this.table.getModel();
        for (int i = 0; i < tm.getRowCount(); ++i) {
            tm.setValueAt(value, i, 1);
        }
        tm.fireTableDataChanged();
        int selectionRows = this.getSelectionRows();
        this.enableDisableEditListButtons(selectionRows, -1);
    }

    protected void cancelActionPerformed() {
        this.setVisible(false);
        this.cancelled = true;
    }

    public void okActionPerformed() {
        this.setVisible(false);
        this.cancelled = false;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void deleteActionPerformed() {
        Comparable<Boolean> x;
        int i;
        URLTableModel tm = (URLTableModel)this.table.getModel();
        ArrayList<Integer> selectedRows = new ArrayList<Integer>();
        for (i = 0; i < tm.getRowCount(); ++i) {
            x = (Boolean)tm.getValueAt(i, 1);
            if (!((Boolean)x).booleanValue()) continue;
            selectedRows.add(new Integer(i));
        }
        for (i = selectedRows.size() - 1; i >= 0; --i) {
            x = (Integer)selectedRows.get(i);
            int rowToDelete = (Integer)x;
            AtDebug.debug("deleting..." + rowToDelete + "...value=" + this.table.getValueAt(rowToDelete, 0));
            tm.deleteRow(rowToDelete);
            AtDebug.debug("rowCount..." + this.table.getRowCount());
        }
    }

    public void moveUpActionPerformed() {
        int selIdx = this.table.getSelectedRow();
        if (selIdx != 0) {
            URLTableModel tm = (URLTableModel)this.table.getModel();
            tm.swapRow(selIdx, selIdx - 1);
            this.table.getSelectionModel().setLeadSelectionIndex(selIdx - 1);
        }
    }

    public void moveDownActionPerformed() {
        int rowCount = this.table.getRowCount();
        int selIdx = this.table.getSelectedRow();
        if (selIdx <= rowCount - 1) {
            URLTableModel tm = (URLTableModel)this.table.getModel();
            tm.swapRow(selIdx, selIdx + 1);
            this.table.getSelectionModel().setLeadSelectionIndex(selIdx + 1);
        }
    }

    protected void enableDisableEditListButtons(int selectionRows, int selectedIdx) {
        int rowCount = this.table.getRowCount();
        if (selectedIdx >= 0) {
            this.moveUpButton.setEnabled(true);
            this.moveDownButton.setEnabled(true);
        } else {
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        }
        if (selectionRows > 0) {
            this.deleteButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
        }
        if (selectedIdx == 0) {
            this.moveUpButton.setEnabled(false);
        }
        if (selectedIdx == 0 && rowCount == 1) {
            this.moveDownButton.setEnabled(false);
        }
        if (selectedIdx == rowCount - 1) {
            this.moveDownButton.setEnabled(false);
        }
    }

    public int getSelectionRows() {
        URLTableModel tm = (URLTableModel)this.table.getModel();
        ArrayList<Integer> selectedRows = new ArrayList<Integer>();
        for (int i = 0; i < tm.getRowCount(); ++i) {
            Boolean x = (Boolean)tm.getValueAt(i, 1);
            if (!x.booleanValue()) continue;
            selectedRows.add(new Integer(i));
        }
        return selectedRows.size();
    }

    public int getItemCount() {
        return this.table.getRowCount();
    }

    public Object getItemAt(int row) {
        return this.table.getValueAt(row, 0);
    }

    class URLTableModel
    extends AbstractTableModel {
        Class[] colClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AtURLEditDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = AtURLEditDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean};
        Object[] columns = new Object[]{AtCommonResource.MESSAGE_RESOURCE.getText("PDF_URL_COLUMN_NAME"), AtCommonResource.MESSAGE_RESOURCE.getText("PDF_SELECTION_COLUMN_NAME")};
        Vector items = new Vector();

        public URLTableModel(ArrayList values) {
            for (int i = 0; i < values.size(); ++i) {
                Vector aRow = new Vector();
                aRow.add(values.get(i));
                aRow.add(new Boolean(false));
                this.items.add(aRow);
            }
        }

        public String getColumnName(int col) {
            return this.columns[col].toString();
        }

        public Class getColumnClass(int col) {
            return this.colClasses[col];
        }

        public int getColumnCount() {
            return this.columns.length;
        }

        public int getRowCount() {
            return this.items.size();
        }

        public Object getValueAt(int row, int col) {
            Vector aRow = (Vector)this.items.get(row);
            return aRow.get(col);
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            Vector aRow = (Vector)this.items.get(row);
            aRow.setElementAt(value, col);
            this.fireTableCellUpdated(row, col);
        }

        public void deleteRow(int row) {
            this.items.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public void swapRow(int idx1, int idx2) {
            Vector row1 = (Vector)this.items.get(idx1);
            Vector row2 = (Vector)this.items.get(idx2);
            this.items.setElementAt(row2, idx1);
            this.items.setElementAt(row1, idx2);
            this.fireTableDataChanged();
        }
    }
}

