/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.resource.AtImageList;
import com.activetree.common.swing.AtInsetsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public abstract class HelpDialog
extends JDialog
implements Serializable {
    protected String helpText;

    public HelpDialog(Frame frame, String title) {
        super(frame, title);
        if (frame == null) {
            frame = new JFrame();
        }
        frame.setIconImage(AtImageList.IMAGE_LIST.ACTIVETREE_ICON_SMALL.getImage());
        this.setupContentPane();
    }

    public HelpDialog(Dialog dialog, String title) {
        super(dialog, title);
        this.setupContentPane();
    }

    private void setupContentPane() {
        this.setSize(550, 600);
        this.getHelpText();
        this.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HelpDialog.this.setVisible(false);
                HelpDialog.this.dispose();
            }
        });
    }

    private void init() {
        AtInsetsPanel cp = new AtInsetsPanel(new BorderLayout());
        cp.setBackground(SystemColor.white);
        cp.setInsets(new Insets(1, 1, 1, 1));
        cp.setLayout(new BorderLayout(0, 0));
        JEditorPane htmlPane = new JEditorPane("text/html", this.helpText);
        htmlPane.setEditable(false);
        htmlPane.setCaretPosition(0);
        JScrollPane htmlScroller = new JScrollPane(htmlPane);
        cp.add((Component)htmlScroller, "Center");
        Container top = this.getContentPane();
        top.setLayout(new BorderLayout(0, 0));
        top.add((Component)cp, "Center");
    }

    public abstract String getHelpText();
}

