/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtDoubleTypeDocument;
import com.activetree.common.swing.AtFileChooser;
import com.activetree.common.swing.AtInsetsPanel;
import com.activetree.common.swing.AtTextField;
import com.activetree.common.utils.AtDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImageOutputSetupDialog
extends JDialog
implements ActionListener {
    public static final int CURRENT_PAGE = 100;
    public static final int SELECTED_PAGES = 101;
    public static final int ALL_PAGES = 102;
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected JCheckBox currPageCb;
    protected JCheckBox selectedPagesCb;
    protected JCheckBox allPagesCb;
    protected AtTextField fileNameTf;
    protected JButton fileSelectionButton;
    protected JButton ok;
    protected JButton cancel;
    protected String extension;
    protected String description;
    protected int outputMode = 100;
    protected String fileName;
    protected AtFileChooser chooser;
    protected JLabel resizeFactorLabel;
    protected AtTextField resizeFactorTf;
    protected boolean okPressed = false;
    protected String fileSep = System.getProperty("file.separator");
    protected JPanel choicePane;
    protected JPanel resizePane;
    protected JPanel filePane;
    public static final int MODE_FILES_ONLY = 0;
    public static final int MODE_DIRECTORIES_ONLY = 1;
    public static final int MODE_FILES_AND_DIRECTORIES = 2;
    protected int fileSelectionMode = 0;

    public ImageOutputSetupDialog(Dialog owner, String title, String fileExtension, String fileDescription, boolean modal) {
        super(owner, title, modal);
        this.setupContentPane();
        this.extension = fileExtension;
        this.description = fileDescription;
    }

    public ImageOutputSetupDialog(Frame owner, String title, String fileExtension, String fileDescription, boolean modal) {
        super(owner, title, modal);
        this.setupContentPane();
        this.extension = fileExtension;
        this.description = fileDescription;
    }

    protected void setupContentPane() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.currPageCb = new JCheckBox(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_CURRENT_PAGE"));
        this.currPageCb.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_CURRENT_PAGE"));
        this.currPageCb.addActionListener(this);
        this.selectedPagesCb = new JCheckBox(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SELECTED_PAGES"));
        this.selectedPagesCb.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_SELECTED_PAGES"));
        this.selectedPagesCb.addActionListener(this);
        this.allPagesCb = new JCheckBox(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_ALL_PAGES"));
        this.allPagesCb.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_ALL_PAGES"));
        this.allPagesCb.addActionListener(this);
        this.buttonGroup.add(this.currPageCb);
        this.buttonGroup.add(this.selectedPagesCb);
        this.buttonGroup.add(this.allPagesCb);
        this.choicePane = new JPanel(new GridBagLayout());
        this.choicePane.add((Component)this.currPageCb, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.choicePane.add((Component)this.selectedPagesCb, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.choicePane.add((Component)this.allPagesCb, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.resizeFactorLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("RESIZE_FACTOR"));
        this.resizeFactorTf = new AtTextField(new AtDoubleTypeDocument(), "1.0", 5);
        this.resizePane = new JPanel(new GridBagLayout());
        this.resizePane.add((Component)this.resizeFactorLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.resizePane.add((Component)this.resizeFactorTf, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 0, new Insets(0, 0, 0, 5), 0, 0));
        JLabel fileNameLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SELECT_FILE_NAME"));
        this.fileNameTf = new AtTextField();
        this.fileNameTf.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ImageOutputSetupDialog.this.enableDisableButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                ImageOutputSetupDialog.this.enableDisableButtons();
            }

            public void changedUpdate(DocumentEvent e) {
                ImageOutputSetupDialog.this.enableDisableButtons();
            }
        });
        this.fileSelectionButton = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("SELECT"));
        this.fileSelectionButton.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("SELECT"));
        this.fileSelectionButton.addActionListener(this);
        this.filePane = new JPanel(new GridBagLayout());
        this.filePane.add((Component)fileNameLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.filePane.add((Component)this.fileNameTf, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.filePane.add((Component)this.fileSelectionButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.ok = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("Ok"));
        this.ok.addActionListener(this);
        this.cancel = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("Cancel"));
        this.cancel.addActionListener(this);
        JPanel buttonPane = new JPanel(new FlowLayout(4, 0, 0));
        buttonPane.add(this.ok);
        buttonPane.add(this.cancel);
        AtInsetsPanel contentArea = new AtInsetsPanel(new BorderLayout(0, 0));
        contentArea.setInsets(new Insets(5, 5, 5, 5));
        contentArea.setBorder(BorderFactory.createEtchedBorder());
        contentArea.add((Component)this.choicePane, "North");
        contentArea.add((Component)this.resizePane, "Center");
        contentArea.add((Component)this.filePane, "South");
        AtInsetsPanel top = new AtInsetsPanel(new GridBagLayout());
        top.setInsets(new Insets(0, 5, 5, 5));
        top.add((Component)contentArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 0, 0, 0), 0, 0));
        top.add((Component)buttonPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)top, "Center");
        this.buttonGroup.setSelected(this.currPageCb.getModel(), true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ImageOutputSetupDialog.this.cancel();
            }
        });
        this.enableDisableButtons();
    }

    private void enableDisableButtons() {
        if (this.fileNameTf.getText() != null && this.fileNameTf.getText().length() > 0) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.currPageCb) {
            this.outputMode = 100;
        } else if (source == this.selectedPagesCb) {
            this.outputMode = 101;
        } else if (source == this.allPagesCb) {
            this.outputMode = 102;
        } else if (source == this.fileSelectionButton) {
            String aFileName = this.showFileDialog();
            if (aFileName != null) {
                this.fileNameTf.setText(aFileName);
                this.fileName = aFileName;
            } else {
                this.fileName = this.fileNameTf.getText();
            }
            if (this.fileName == null || this.fileName.equals("")) {
                this.ok.setEnabled(false);
            } else {
                this.ok.setEnabled(true);
            }
        } else if (source == this.ok) {
            this.fileName = this.fileNameTf.getText();
            File f = new File(this.fileName);
            if (f.isDirectory()) {
                char lc2 = this.fileName.charAt(this.fileName.length() - 1);
                this.fileName = lc2 == '/' || lc2 == '\\' ? this.fileName + "page." + this.extension : this.fileName + this.fileSep + "page." + this.extension;
            }
            if (this.fileName == null) {
                String msg = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SELECT_FILE_NAME");
                String title = AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SELECT_A_FILE");
                JOptionPane.showMessageDialog(this, msg, title, 1);
                return;
            }
            this.setVisible(false);
            this.okPressed = true;
        } else if (source == this.cancel) {
            this.cancel();
        }
    }

    protected void cancel() {
        this.setVisible(false);
        this.okPressed = false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getOuputMode() {
        return this.outputMode;
    }

    public double getResizeFactor() {
        String s = this.resizeFactorTf.getText();
        double resizeFactor = 1.0;
        try {
            resizeFactor = Double.parseDouble(s);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (resizeFactor < 0.0) {
            resizeFactor = 1.0;
        }
        return resizeFactor;
    }

    public void setResizeFactor(double resizeFactor) {
        this.resizeFactorTf.setText(String.valueOf(resizeFactor));
    }

    public void setFileSelectionMode(int mode) {
        this.fileSelectionMode = mode;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    private String showFileDialog() {
        if (this.chooser == null) {
            String[] filters = new String[]{this.extension};
            this.chooser = new AtFileChooser(new File("."), this.description, AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SELECT"), AtCommonResource.MESSAGE_RESOURCE.getMnemonic("REPORT_SELECT"), AtCommonResource.MESSAGE_RESOURCE.getText("REPORT_SELECT_FILE_NAME"), filters, this.description, false);
        }
        String fileName = null;
        File f = this.chooser.showDialog(1, this);
        if (f == null) {
            return null;
        }
        fileName = f.getAbsolutePath();
        try {
            int extIdx = fileName.lastIndexOf(46);
            if (extIdx >= 0) {
                String ext = fileName.substring(extIdx + 1);
                String file = fileName.substring(0, extIdx);
                if (ext == null || ext.equals("") || !ext.equals(this.extension)) {
                    fileName = file + "." + this.extension;
                }
            } else {
                fileName = fileName + "." + this.extension;
            }
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        return fileName;
    }
}

