/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.swing.AtInsetsPanel;
import com.activetree.common.utils.AtComponentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class OkMessageDialog
extends JDialog {
    protected String message = "N/A";
    protected final WindowCloseListener windowCloseListener = new WindowCloseListener();
    protected final JEditorPane editorPane = new JEditorPane();

    public static OkMessageDialog getInstance(Component owner, String title, String message, boolean modal) {
        Window window = SwingUtilities.getWindowAncestor(owner);
        OkMessageDialog d = null;
        d = window instanceof Frame ? new OkMessageDialog((Frame)window, title, message, modal) : (window instanceof Dialog ? new OkMessageDialog((Dialog)window, title, message, modal) : new OkMessageDialog((Frame)null, title, message, modal));
        return d;
    }

    protected OkMessageDialog(Frame owner, String title, String message, boolean modal) {
        super(owner, title, modal);
        this.message = message;
        this.init();
        this.setMessage();
    }

    protected OkMessageDialog(Dialog owner, String title, String message, boolean modal) {
        super(owner, title, modal);
        this.message = message;
        this.init();
        this.setMessage();
    }

    private void init() {
        AtInsetsPanel top = new AtInsetsPanel(new BorderLayout(0, 0));
        top.setInsets(new Insets(1, 1, 1, 1));
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        JScrollPane scroller = new JScrollPane(this.editorPane);
        top.add((Component)scroller, "Center");
        Border b = BorderFactory.createEtchedBorder();
        scroller.setBorder(b);
        JButton okButton = new JButton("Ok");
        okButton.setActionCommand("ok");
        okButton.setMnemonic('O');
        AtInsetsPanel buttonPane = new AtInsetsPanel(new Insets(0, 5, 0, 5));
        buttonPane.setLayout(new FlowLayout(1));
        buttonPane.add(okButton);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OkMessageDialog.this.close();
            }
        });
        top.add((Component)buttonPane, "South");
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)top, "Center");
        super.getRootPane().setDefaultButton(okButton);
        this.addWindowCloseListener();
        this.resetSize();
        AtComponentUtil.centerOnContainer(this.getOwner(), this);
    }

    protected void setMessage() {
        this.editorPane.setText(this.message);
    }

    protected void resetSize() {
        this.setSize(new Dimension(500, 150));
    }

    protected void addWindowCloseListener() {
        this.removeWindowListener(this.windowCloseListener);
        this.addWindowListener(this.windowCloseListener);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    class WindowCloseListener
    extends WindowAdapter {
        WindowCloseListener() {
        }

        public void windowClosing(WindowEvent evt) {
            OkMessageDialog.this.close();
        }
    }
}

