/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.swing;

import com.activetree.common.resource.AtConstants;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;

public class StringCellRenderer
extends JPanel {
    public static final int CENTER = 0;
    public static final int LEADING = 10;
    public static final int TRAILING = 11;
    protected Dimension prefSize = null;
    protected Insets insets = new Insets(0, 3, 0, 3);
    protected int alignment = 0;
    protected int horizontalGap = 2;
    protected JTable table;
    protected boolean selected;
    protected Object value;
    protected boolean hasFocus;
    protected int row;
    protected int col;
    protected ImageIcon icon;
    protected Color selectionForeground = SystemColor.black;
    protected Color selectionBackground = AtConstants.SELECTION_BACKGROUND;
    private int GAP = 3;

    public StringCellRenderer() {
        super.setBackground(SystemColor.white);
        super.setForeground(SystemColor.black);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setHorizontalGap(int hGap) {
        this.horizontalGap = hGap;
    }

    public int getHorizontalGap() {
        return this.horizontalGap;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
        this.calculatePreferredSize();
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getText() {
        return (String)this.value;
    }

    public void setText(String text) {
        this.value = text;
        this.calculatePreferredSize();
    }

    protected void calculatePreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        String text = this.getText();
        if (text == null) {
            text = "";
        }
        int iconw = 0;
        int iconh = 0;
        if (this.icon != null) {
            iconw = this.icon.getIconWidth();
            iconh = this.icon.getIconHeight();
            iconw += this.GAP;
        }
        int w = GraphicsUtil.stringWidth(this.getFont(), text);
        w += this.getInsets().left;
        w += iconw;
        w += this.getInsets().right;
        int h = fm.getHeight();
        h += this.getInsets().top;
        if ((h += this.getInsets().bottom) < iconh) {
            h = iconh;
        }
        this.prefSize = new Dimension(w, h);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color selBg) {
        this.selectionBackground = selBg;
    }

    public void setSelectionForeground(Color selFg) {
        this.selectionForeground = selFg;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void paintComponent(Graphics g) {
        Color orgColor = g.getColor();
        Font orgFont = g.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int w = this.getSize().width;
        int h = this.getSize().height;
        int iconw = 0;
        int iconh = 0;
        if (this.icon != null) {
            iconw = this.icon.getIconWidth();
            iconh = this.icon.getIconHeight();
        }
        int fontHeight = fontMetrics.getHeight();
        String label = this.getText();
        int labelWidth = 0;
        int iconAndLabelWidth = 0;
        if (label != null) {
            labelWidth = GraphicsUtil.stringWidth(this.getFont(), label);
            iconAndLabelWidth = iconw + this.GAP + labelWidth;
        }
        int iconx = 0;
        int icony = (h - iconh) / 2;
        if (this.getAlignment() == 10) {
            iconx = this.getInsets().left;
        } else if (this.getAlignment() == 0) {
            iconx = w / 2 - iconAndLabelWidth / 2;
        } else if (this.getAlignment() == 11) {
            iconx = w - this.getInsets().right - iconAndLabelWidth;
        }
        int lx = this.GAP;
        int ly = 0;
        if (label != null) {
            lx = iconx;
            lx += iconw;
            lx += this.GAP;
            ly = this.getSize().height / 2 + fontHeight / 3;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        if (this.selected && label != null) {
            g.setColor(this.getSelectionBackground());
            g.fillRect(lx, 0, w, h);
        }
        if (this.icon != null) {
            g.drawImage(this.icon.getImage(), iconx, icony, this);
        }
        if (label != null) {
            g.setFont(this.getFont());
            if (this.selected) {
                g.setColor(this.getSelectionForeground());
            } else {
                g.setColor(this.getForeground());
            }
            g.drawString(label, lx, ly);
        }
        g.setColor(orgColor);
        g.setFont(orgFont);
    }
}

