/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.doc.DocPageable;
import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.AtDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;
import javax.swing.JOptionPane;

public class AtCommonUtil
implements Serializable {
    private static RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    private static final Font titleFont;
    private static final Color titleFg;
    private static final Color borderColor;
    private static Hashtable SPECIAL_JRE_VERSIONS;
    public static final String HIGH = "HIGH";
    public static final String NORMAL = "NORMAL";
    public static final String DRAFT = "DRAFT";
    public static final String ONE_SIDED = "ONE_SIDED";
    public static final String DUPLEX = "DUPLEX";
    public static final String TUMBLE = "TUMBLE";
    public static final String TWO_SIDED_LONG_EDGE = "TWO_SIDED_LONG_EDGE";
    public static final String TWO_SIDED_SHORT_EDGE = "TWO_SIDED_SHORT_EDGE";

    public static String getMemoryInfo() {
        long KB = 1024L;
        long MB = KB * KB;
        Runtime rt = Runtime.getRuntime();
        long roundup = MB / 2L - 1L;
        long totalMem = rt.totalMemory();
        long freeMem = rt.freeMemory();
        long freeMb = (freeMem + roundup) / MB;
        long totalMb = (totalMem + roundup) / MB;
        long usedMb = totalMb - freeMb;
        String heading = "Memory Usage: ";
        String memoryInfo = heading + "Used: " + usedMb + " MB, " + "Free: " + freeMb + " MB, " + "Total: " + totalMb + " MB";
        return memoryInfo;
    }

    public static final RenderingHints getRenderingHints() {
        return (RenderingHints)hints.clone();
    }

    public static Book createCollatedCopiesForPrint(Pageable book, boolean collate, int numOfCopies) {
        if (numOfCopies <= 1) {
            DocPageable docPages = new DocPageable();
            for (int i = 0; book != null && i < book.getNumberOfPages(); ++i) {
                Printable printable = book.getPrintable(i);
                PageFormat pf = book.getPageFormat(i);
                docPages.append(printable, pf);
            }
            return docPages;
        }
        DocPageable collatedCopies = new DocPageable();
        if (collate) {
            for (int copy = 0; copy < numOfCopies; ++copy) {
                for (int i = 0; book != null && i < book.getNumberOfPages(); ++i) {
                    AbstractPage aPage = (AbstractPage)book.getPrintable(i);
                    AbstractPage copiedPage = aPage.newInstance();
                    collatedCopies.append(copiedPage, copiedPage.getPageFormat());
                }
            }
        } else {
            for (int i = 0; book != null && i < book.getNumberOfPages(); ++i) {
                AbstractPage aPage = (AbstractPage)book.getPrintable(i);
                for (int copy = 0; copy < numOfCopies; ++copy) {
                    AbstractPage copiedPage = aPage.newInstance();
                    collatedCopies.append(copiedPage, copiedPage.getPageFormat());
                }
            }
        }
        return collatedCopies;
    }

    public static void setRenderingReasonforPages(Pageable pdfPages, Object renderingReason) {
        if (pdfPages == null) {
            return;
        }
        for (int i = 0; i < pdfPages.getNumberOfPages(); ++i) {
            AbstractPage aPage = (AbstractPage)pdfPages.getPrintable(i);
            aPage.setRenderingReason(renderingReason);
        }
    }

    public static int getOperatingSystem() {
        String s = System.getProperty("os.name");
        if (s != null) {
            if (s.equalsIgnoreCase("Windows")) {
                return 0;
            }
            if (s.equalsIgnoreCase("Mac")) {
                return 3;
            }
            if (s.equalsIgnoreCase("Unix")) {
                return 1;
            }
            if (s.equalsIgnoreCase("Linux")) {
                return 2;
            }
        }
        return 1;
    }

    public static final boolean isSpecialJREversion(String currJreVersion) {
        Object reply = SPECIAL_JRE_VERSIONS.get(currJreVersion);
        return reply != null;
    }

    public static final int getJREMajorVersionNumber() {
        String javaVersion = System.getProperty("java.version");
        int idx = javaVersion.indexOf(46);
        String major = javaVersion.substring(0, idx);
        return Integer.parseInt(major);
    }

    public static final int getJREMinorVersionNumber() {
        String javaVersion = System.getProperty("java.version");
        int idx = javaVersion.indexOf(46);
        javaVersion = javaVersion.substring(idx + 1);
        idx = javaVersion.indexOf(46);
        String minor = javaVersion.substring(0, idx);
        return Integer.parseInt(minor);
    }

    public static final int getJREMildVersionNumber() {
        char ch;
        String javaVersion = System.getProperty("java.version");
        int idx = javaVersion.indexOf(46);
        javaVersion = javaVersion.substring(idx + 1);
        idx = javaVersion.indexOf(46);
        javaVersion = javaVersion.substring(idx + 1);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < javaVersion.length() && Character.isDigit(ch = javaVersion.charAt(i)); ++i) {
            b.append(ch);
        }
        String mild = b.toString();
        return Integer.parseInt(mild);
    }

    public static final String getJREUpdateVersion() {
        char ch;
        String javaVersion = System.getProperty("java.version");
        int idx = javaVersion.indexOf(46);
        javaVersion = javaVersion.substring(idx + 1);
        idx = javaVersion.indexOf(46);
        javaVersion = javaVersion.substring(idx + 1);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < javaVersion.length() && Character.isDigit(ch = javaVersion.charAt(i)); ++i) {
            b.append(ch);
        }
        idx = b.length();
        javaVersion = javaVersion.substring(idx + 1);
        return javaVersion;
    }

    public static final String getJREMajorMinorVersion() {
        int major = AtCommonUtil.getJREMajorVersionNumber();
        int minor = AtCommonUtil.getJREMinorVersionNumber();
        String mn = major + "." + minor;
        return mn;
    }

    public static final String getJREVersion() {
        String javaVersion = System.getProperty("java.version");
        return javaVersion;
    }

    public static final String getExceptionMessage(Throwable t) {
        String msg = t.getClass().getName() + " exception. " + t.getMessage();
        return msg;
    }

    public static final Class loadClass(String clsName) throws ClassNotFoundException {
        Class<?> cls = Class.forName(clsName);
        return cls;
    }

    public static final boolean isClassFound(String clsName) {
        try {
            Class<?> cls = Class.forName(clsName);
            if (cls != null) {
                AtDebug.debug("\"" + clsName + "\" found in class path? - OK.");
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static final Method getMethod(Class cls, String methodName, Class[] args) {
        Method method = null;
        try {
            method = cls.getDeclaredMethod(methodName, args);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getClass().getName() + "" + t.getMessage() + " for loading " + cls.getName() + "." + methodName);
        }
        return method;
    }

    public static final Object invokeMethod(Class cls, Method method, Object[] args) {
        Object retValue = null;
        try {
            retValue = method.invoke((Object)cls, args);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getClass().getName() + "" + t.getMessage() + " for invoking " + cls.getName() + "." + method.getName());
        }
        return retValue;
    }

    public static final boolean canWrite(Component owner, String fileName) {
        int reply;
        if (fileName == null) {
            return false;
        }
        File file = new File(fileName);
        String aFileName = AtCommonResource.MESSAGE_RESOURCE.getText("A_FILE_NAME");
        String isAlreadyExisting = AtCommonResource.MESSAGE_RESOURCE.getText("IS_ALREADY_EXISTING");
        String doYouWantToOverwriteIt = AtCommonResource.MESSAGE_RESOURCE.getText("DO_YOU_WANT_TO_OVERWRITE_IT");
        String confirm = AtCommonResource.MESSAGE_RESOURCE.getText("CONFIRM");
        return !file.exists() || (reply = JOptionPane.showConfirmDialog(owner, aFileName + " \"" + file.getAbsolutePath() + "\" " + isAlreadyExisting + "\n\n" + doYouWantToOverwriteIt, confirm, 0, 1)) == 0;
    }

    public static final Font getTitleFont() {
        return titleFont;
    }

    public static final Color getTitleForeground() {
        return titleFg;
    }

    public static final Color getBorderColor() {
        return borderColor;
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        printWriter.flush();
        String stackTrace = result.getBuffer().toString();
        if (stackTrace != null) {
            stackTrace = stackTrace.trim();
        }
        return stackTrace;
    }

    public static final String truncateString(String value, int maxWidth, FontMetrics fm) {
        if (fm.stringWidth(value) <= maxWidth) {
            return value;
        }
        String dots = "...";
        int allowedWidth = maxWidth;
        String retStr = "";
        for (int len = value.length(); len >= 0; --len) {
            String currStr = value.substring(0, len);
            int strWidth = fm.stringWidth(currStr);
            if (strWidth > allowedWidth) continue;
            retStr = currStr;
            break;
        }
        if (retStr.length() > 3) {
            return retStr.substring(0, retStr.length() - 3) + dots;
        }
        if (retStr.length() == 3) {
            return dots;
        }
        if (retStr.length() == 2) {
            return "..";
        }
        if (retStr.length() == 1) {
            return ".";
        }
        if (retStr.length() == 0) {
            return "";
        }
        return "";
    }

    public static String trimDoubleQuotes(String string) {
        if (string == null) {
            return null;
        }
        string = AtCommonUtil.trimLeadingCharacter(string, "\"");
        string = AtCommonUtil.trimTrailingCharacter(string, "\"");
        return string;
    }

    public static String trimLeadingCharacter(String string, String c) {
        if (string == null) {
            return null;
        }
        if (string.startsWith(c)) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    public static final String trimTrailingCharacter(String string, String c) {
        if (string == null) {
            return null;
        }
        if (string.endsWith(c)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static final String getDirectoryPathFromFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            String fileName = file.getAbsolutePath();
            if (fileName == null) {
                return null;
            }
            String fileSep = System.getProperty("file.separator");
            int lastFileSepIdx = fileName.lastIndexOf(fileSep);
            if (lastFileSepIdx >= 0) {
                String dir = fileName.substring(0, lastFileSepIdx + 1);
                return dir;
            }
            return fileName;
        }
        catch (Throwable t) {
            AtDebug.debug(t);
            return null;
        }
    }

    public static final PageFormat getClonedPageFormat(PageFormat inputPf) {
        if (inputPf == null) {
            return null;
        }
        Paper paperIn = inputPf.getPaper();
        PageFormat printerSupportedPageFormat = new PageFormat();
        Paper printerSupportedPaper = new Paper();
        printerSupportedPaper.setSize(paperIn.getWidth(), paperIn.getHeight());
        printerSupportedPaper.setImageableArea(paperIn.getImageableX(), paperIn.getImageableY(), paperIn.getImageableWidth(), paperIn.getImageableHeight());
        printerSupportedPageFormat.setPaper(printerSupportedPaper);
        printerSupportedPageFormat.setOrientation(inputPf.getOrientation());
        return printerSupportedPageFormat;
    }

    public static final String getString(double value, int precisionCount) {
        String str = String.valueOf(value);
        StringBuffer buf = new StringBuffer();
        int count = -1;
        boolean dotFound = false;
        for (int i = 0; i < str.length(); ++i) {
            char aCh = str.charAt(i);
            if (aCh == '.') {
                dotFound = true;
            }
            if (dotFound) {
                ++count;
            }
            if (count > precisionCount) break;
            buf.append(str.charAt(i));
        }
        if (precisionCount == 0 && buf.charAt(buf.length() - 1) == '.') {
            buf.deleteCharAt(buf.length() - 1);
        }
        String outStr = buf.toString();
        return outStr;
    }

    public static final String getString(float value, int precisionCount) {
        String str = String.valueOf(value);
        StringBuffer buf = new StringBuffer();
        int count = -1;
        boolean dotFound = false;
        for (int i = 0; i < str.length(); ++i) {
            char aCh = str.charAt(i);
            if (aCh == '.') {
                dotFound = true;
            }
            if (dotFound) {
                ++count;
            }
            if (count > precisionCount) break;
            buf.append(str.charAt(i));
        }
        if (precisionCount == 0 && buf.charAt(buf.length() - 1) == '.') {
            buf.deleteCharAt(buf.length() - 1);
        }
        String outStr = buf.toString();
        return outStr;
    }

    public static final void debugPageFormat(PageFormat pf) {
        if (pf != null) {
            double x = pf.getImageableX();
            double y = pf.getImageableY();
            double iw = pf.getImageableWidth();
            double ih = pf.getImageableHeight();
            double w = pf.getWidth();
            double h = pf.getHeight();
            AtDebug.debug("PageFormat: " + pf + "[ix=" + x + ", iy=" + y + ", iw=" + iw + ",ih=" + ih + ", tw=" + w + ", th=" + h + ", orientation=" + (pf.getOrientation() == 1 ? "Portrait" : "Landscape") + "]");
        } else {
            AtDebug.debug("PageFormat: null");
        }
    }

    public static final URL getURL(String pdfSource) throws Throwable {
        String urlStr = AtCommonUtil.getWhiteSpaceEnabledURL(pdfSource);
        URL url = null;
        if (url == null) {
            try {
                url = new URL(urlStr);
            }
            catch (Throwable t) {
                File f = new File(urlStr);
                url = f.toURL();
            }
        }
        return url;
    }

    public static String getWhiteSpaceEnabledURL(String urlStr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; urlStr != null && i < urlStr.length(); ++i) {
            char c = urlStr.charAt(i);
            if (c == ' ') {
                buf.append("%20");
                continue;
            }
            buf.append(c);
        }
        String retStr = buf.toString();
        return retStr;
    }

    public static final PageFormat getDefaultPrinterPageFormat() {
        PageFormat printerSupportedPageFormat = new PageFormat();
        Paper printerSupportedPaper = new Paper();
        printerSupportedPaper.setSize(612.0, 792.0);
        printerSupportedPaper.setImageableArea(0.0, 0.0, printerSupportedPaper.getWidth(), printerSupportedPaper.getHeight());
        printerSupportedPageFormat.setPaper(printerSupportedPaper);
        return printerSupportedPageFormat;
    }

    public static final PageFormat getSelectedPageFormat(MediaSizeName mediaSizeName) {
        AtMediaSizeObject mObj = new AtMediaSizeObject(mediaSizeName);
        double paperWidth = mObj.getMediaWidthPixel();
        double paperHeight = mObj.getMediaHeightPixel();
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        int orientation = 1;
        Paper paper = new Paper();
        paper.setSize(paperWidth, paperHeight);
        double imageableWidth = paperWidth - (leftMargin + rightMargin);
        double imageableHeight = paperHeight - (topMargin + bottomMargin);
        paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(MediaSizeName mediaSizeName, double leftMargin, double rightMargin, double topMargin, double bottomMargin) {
        AtMediaSizeObject mObj = new AtMediaSizeObject(mediaSizeName);
        double paperWidth = mObj.getMediaWidthPixel();
        double paperHeight = mObj.getMediaHeightPixel();
        int orientation = 1;
        Paper paper = new Paper();
        paper.setSize(paperWidth, paperHeight);
        double imageableWidth = paperWidth - (leftMargin + rightMargin);
        double imageableHeight = paperHeight - (topMargin + bottomMargin);
        paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(MediaSizeName mediaSizeName, double leftMargin, double rightMargin, double topMargin, double bottomMargin, int orientation) {
        AtMediaSizeObject mObj = new AtMediaSizeObject(mediaSizeName);
        double paperWidth = mObj.getMediaWidthPixel();
        double paperHeight = mObj.getMediaHeightPixel();
        Paper paper = new Paper();
        paper.setSize(paperWidth, paperHeight);
        double imageableWidth = paperWidth - (leftMargin + rightMargin);
        double imageableHeight = paperHeight - (topMargin + bottomMargin);
        paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(Rectangle2D printableArea) {
        double paperWidth = printableArea.getWidth();
        double paperHeight = printableArea.getHeight();
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        int orientation = 1;
        Paper paper = new Paper();
        paper.setSize(paperWidth, paperHeight);
        double imageableWidth = paperWidth - (leftMargin + rightMargin);
        double imageableHeight = paperHeight - (topMargin + bottomMargin);
        paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(Rectangle2D printableArea, double leftMargin, double rightMargin, double topMargin, double bottomMargin, int orientation) {
        double resizeFactor = 1.0;
        PageFormat pf = AtCommonUtil.getSelectedPageFormat(printableArea, leftMargin, rightMargin, topMargin, bottomMargin, orientation, resizeFactor);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(Rectangle2D printableArea, double resizeFactor) {
        PageFormat pf = AtCommonUtil.getSelectedPageFormat(printableArea, 0.0, 0.0, 0.0, 0.0, 1, resizeFactor);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(Rectangle2D printableArea, double leftMargin, double rightMargin, double topMargin, double bottomMargin, int orientation, double resolutionFactor) {
        PageFormat outputPageFormat = new PageFormat();
        Paper paper = new Paper();
        double width = printableArea.getWidth();
        double height = printableArea.getHeight();
        paper.setSize(width *= resolutionFactor, height *= resolutionFactor);
        double imageableWidth = width - (leftMargin + rightMargin);
        double imageableHeight = height - (topMargin + bottomMargin);
        paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        outputPageFormat.setPaper(paper);
        outputPageFormat.setOrientation(orientation);
        return outputPageFormat;
    }

    public static final String getDebugString(PageFormat pageFormat) {
        if (pageFormat == null) {
            return "null";
        }
        double x = pageFormat.getImageableX();
        double y = pageFormat.getImageableY();
        double iw = pageFormat.getImageableWidth();
        double ih = pageFormat.getImageableHeight();
        double w = pageFormat.getWidth();
        double h = pageFormat.getHeight();
        String s = pageFormat + "[ix=" + x + ", iy=" + y + ", iw=" + iw + ",ih=" + ih + ", tw=" + w + ", th=" + h + ", orientation=" + (pageFormat.getOrientation() == 1 ? "Portrait" : "Landscape") + "]";
        return s;
    }

    public static final PrintQuality getPrintQuality(String qualityName) {
        if (qualityName == null) {
            return PrintQuality.HIGH;
        }
        if (qualityName.equalsIgnoreCase(HIGH)) {
            return PrintQuality.HIGH;
        }
        if (qualityName.equalsIgnoreCase(NORMAL)) {
            return PrintQuality.NORMAL;
        }
        if (qualityName.equalsIgnoreCase(DRAFT)) {
            return PrintQuality.DRAFT;
        }
        return PrintQuality.HIGH;
    }

    public static final Sides getMediaSide(String sideName) {
        if (sideName == null) {
            return Sides.ONE_SIDED;
        }
        if (sideName.equalsIgnoreCase(ONE_SIDED)) {
            return Sides.ONE_SIDED;
        }
        if (sideName.equalsIgnoreCase(DUPLEX)) {
            return Sides.DUPLEX;
        }
        if (sideName.equalsIgnoreCase(TUMBLE)) {
            return Sides.TUMBLE;
        }
        if (sideName.equalsIgnoreCase(TWO_SIDED_LONG_EDGE)) {
            return Sides.TWO_SIDED_LONG_EDGE;
        }
        if (sideName.equalsIgnoreCase(TWO_SIDED_SHORT_EDGE)) {
            return Sides.TWO_SIDED_SHORT_EDGE;
        }
        return Sides.ONE_SIDED;
    }

    static {
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        titleFont = new Font("Arial", 1, 12);
        titleFg = Color.decode("#003366");
        borderColor = Color.decode("#4b73af");
        SPECIAL_JRE_VERSIONS = new Hashtable();
        SPECIAL_JRE_VERSIONS.put("1.5", new Boolean(true));
        SPECIAL_JRE_VERSIONS.put("1.6", new Boolean(true));
        SPECIAL_JRE_VERSIONS.put("1.7", new Boolean(true));
    }
}

