/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AtComponentUtil {
    public static final void showExceptionMessageDialog(Throwable t, Component owner) {
        String title = t.getMessage();
        if (title == null) {
            title = "";
        }
        String message = t.getClass().getName() + " " + t.getMessage();
        JOptionPane.showMessageDialog(owner, message, title, 0);
    }

    public static Window getWindowAncestor(Component comp) {
        if (comp == null) {
            return null;
        }
        Window compToReturn = null;
        if (comp instanceof Window) {
            compToReturn = (Window)comp;
        }
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            compToReturn = (Window)parent;
        }
        return compToReturn;
    }

    public static Window getWindowForComponent(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof Window) {
            return (Window)comp;
        }
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            return (Window)parent;
        }
        return null;
    }

    public static Component getParentForComponent(Component from, Class parentToFind) {
        if (from == null) {
            return null;
        }
        for (Component parent = from; parent != null; parent = parent.getParent()) {
            if (!parent.getClass().getName().equals(parentToFind.getName())) continue;
            return parent;
        }
        return null;
    }

    public static Component getParentForComponent(Component from, Class parentToFind, boolean matchType) {
        if (from == null) {
            return null;
        }
        for (Component parent = from; parent != null; parent = parent.getParent()) {
            boolean typeMatched = false;
            if (matchType) {
                typeMatched = parentToFind.isInstance(parent);
            }
            boolean exactMatch = parent.getClass().getName().equals(parentToFind.getName());
            if (!typeMatched && !exactMatch) continue;
            return parent;
        }
        return null;
    }

    public static void findAllByType(Component where, Class type, Vector store) {
        if (where == null) {
            return;
        }
        boolean matched = type.isInstance(where);
        if (matched) {
            store.add(where);
        }
        if (where instanceof Container) {
            Component[] childs = ((Container)where).getComponents();
            for (int i = 0; childs != null && i < childs.length; ++i) {
                Component aComp = childs[i];
                if (!(aComp instanceof Container)) continue;
                AtComponentUtil.findAllByType(aComp, type, store);
            }
        }
    }

    public static boolean hasComponent(Component where, Class type) {
        if (where == null) {
            return false;
        }
        boolean matched = type.isInstance(where);
        if (matched) {
            return true;
        }
        if (where instanceof Container) {
            Component[] childs = ((Container)where).getComponents();
            for (int i = 0; childs != null && i < childs.length; ++i) {
                Component aChild = childs[i];
                matched = AtComponentUtil.hasComponent(aChild, type);
                if (!matched) continue;
                return true;
            }
        }
        return false;
    }

    public static Component findComponent(Container where, Class what, boolean matchType) {
        if (where == null || what == null) {
            return null;
        }
        boolean typeMatched = false;
        if (matchType) {
            typeMatched = what.isInstance(where);
        }
        boolean exactMatch = where.getClass().getName().equals(what.getName());
        if (typeMatched || exactMatch) {
            return where;
        }
        Component[] childs = where.getComponents();
        for (int i = 0; childs != null && i < childs.length; ++i) {
            Component foundComp;
            Component aComp = childs[i];
            if (!(aComp instanceof Container) || (foundComp = AtComponentUtil.findComponent((Container)aComp, what, matchType)) == null) continue;
            return foundComp;
        }
        return null;
    }

    public static void findAllComponents(Container where, Class what, Vector putTo) {
        if (where == null || what == null) {
            return;
        }
        if (where.getClass().getName().equals(what.getName()) && !putTo.contains(where)) {
            putTo.add(where);
        }
        Component[] childs = where.getComponents();
        for (int i = 0; childs != null && i < childs.length; ++i) {
            Component aComp = childs[i];
            if (aComp.getClass().getName().equals(what.getName()) && !putTo.contains(aComp)) {
                putTo.add(aComp);
            }
            if (!(aComp instanceof Container)) continue;
            AtComponentUtil.findAllComponents((Container)aComp, what, putTo);
        }
    }

    public static boolean hasComponent(Component where, Component who) {
        if (where == null || who == null) {
            return false;
        }
        if (where == who) {
            return true;
        }
        if (where instanceof Container) {
            Container c = (Container)where;
            Component[] childs = c.getComponents();
            for (int i = 0; childs != null && i < childs.length; ++i) {
                Component aChild = childs[i];
                boolean matched = AtComponentUtil.hasComponent(aChild, who);
                if (!matched) continue;
                return true;
            }
        }
        return false;
    }

    public static Component findComponent(Container where, Class what) {
        if (where == null || what == null) {
            return null;
        }
        if (where.getClass().getName().equals(what.getName())) {
            return where;
        }
        Component[] childs = where.getComponents();
        for (int i = 0; childs != null && i < childs.length; ++i) {
            Component foundComp;
            Component aComp = childs[i];
            if (aComp.getClass().getName().equals(what.getName())) {
                return aComp;
            }
            if (!(aComp instanceof Container) || (foundComp = AtComponentUtil.findComponent((Container)aComp, what)) == null) continue;
            return foundComp;
        }
        return null;
    }

    public static Component findComponentByBame(Container where, String nameToMatch) {
        if (where == null) {
            return null;
        }
        String whereName = where.getName();
        if (whereName != null && whereName.equals(nameToMatch)) {
            return where;
        }
        Component[] childs = where.getComponents();
        for (int i = 0; childs != null && i < childs.length; ++i) {
            Component foundComp;
            Component aComp = childs[i];
            String aCompName = aComp.getName();
            if (aCompName != null && aCompName.equals(nameToMatch)) {
                return aComp;
            }
            if (!(aComp instanceof Container) || (foundComp = AtComponentUtil.findComponentByBame((Container)aComp, nameToMatch)) == null) continue;
            return foundComp;
        }
        return null;
    }

    public static void getExpandedNodes(JTree tree, DefaultMutableTreeNode node, Vector putTo) {
        if (node == null) {
            return;
        }
        if (tree.isExpanded(new TreePath(node))) {
            putTo.add(node);
        }
        Enumeration<TreeNode> childs = node.children();
        while (childs != null && childs.hasMoreElements()) {
            DefaultMutableTreeNode aChildNode = (DefaultMutableTreeNode)childs.nextElement();
            AtComponentUtil.getExpandedNodes(tree, aChildNode, putTo);
        }
    }

    public static void expand(JTree tree, DefaultMutableTreeNode node, boolean all) {
        if (!all) {
            TreePath treePath = new TreePath(node.getPath());
            tree.expandPath(treePath);
        } else {
            Enumeration<TreeNode> childs = node.children();
            while (childs != null && childs.hasMoreElements()) {
                DefaultMutableTreeNode aChildNode = (DefaultMutableTreeNode)childs.nextElement();
                TreePath treePath = new TreePath(node.getPath());
                tree.expandPath(treePath);
                AtComponentUtil.expand(tree, aChildNode, all);
            }
        }
    }

    public void expand(JTree tree, Object parent, boolean all) {
        if (!all) {
            TreePath treePath = null;
            if (parent instanceof TreePath) {
                treePath = (TreePath)parent;
                tree.expandPath(treePath);
            } else {
                treePath = new TreePath(parent);
                tree.expandPath(treePath);
            }
        } else {
            int childCount = tree.getModel().getChildCount(parent);
            for (int i = 0; i < childCount; ++i) {
                Object aChildNode = tree.getModel().getChild(parent, i);
                this.expand(tree, aChildNode, all);
            }
        }
    }

    public static void maximizeWindow(Component window) {
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        window.setSize(scrSize);
    }

    public static Point getParentLocation(Component currComp) {
        Point location = new Point(0, 0);
        Point last = null;
        for (Component parent = currComp; parent != null; parent = parent.getParent()) {
            AtDebug.debug("adding location for: " + parent.getClass().getName());
            AtDebug.debug("\tcurr loc: " + location + " adding=" + parent.getLocation());
            last = parent.getLocation();
            location.x += last.x;
            location.y += last.y;
        }
        if (last != null) {
            location.x -= last.x;
            location.y -= last.y;
        }
        return location;
    }

    public static Component getTopContainer(Component comp) {
        Component lastComp = null;
        for (Component parent = comp; parent != null; parent = parent.getParent()) {
            lastComp = parent;
        }
        AtDebug.debug("top container: " + lastComp.getClass().getName());
        return lastComp;
    }

    public static Frame getFrameForComponent(Component comp) {
        if (comp == null) {
            return null;
        }
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Frame)) continue;
            return (Frame)parent;
        }
        return null;
    }

    public static void centerOnContainer(Container where, Component who) {
        if (where == null || who == null) {
            return;
        }
        try {
            Rectangle bounds = where.getBounds();
            Point locOnScreen = where.getLocationOnScreen();
            if (locOnScreen == null) {
                locOnScreen = bounds.getLocation();
            }
            Dimension whoSize = who.getSize();
            double whereCx = locOnScreen.getX() + (double)(bounds.width / 2);
            double whereCy = locOnScreen.getY() + (double)(bounds.height / 2);
            double whox = whereCx - (double)(whoSize.width / 2);
            double whoy = whereCy - (double)(whoSize.height / 2);
            if (whox < 0.0) {
                whox = 0.0;
            }
            if (whoy < 0.0) {
                whoy = 0.0;
            }
            who.setLocation((int)whox, (int)whoy);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void centerOnScreen(Component who) {
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        int lx = scrSize.width / 2 - who.getSize().width / 2;
        int ly = scrSize.height / 2 - who.getSize().height / 2;
        who.setLocation(lx, ly);
    }

    public static ImageIcon getDefaultImageIcon(Component comp) {
        BufferedImage defaultIcon = new BufferedImage(10, 10, 2);
        Graphics2D g = (Graphics2D)defaultIcon.getGraphics();
        GraphicsUtil.applyAntiAlias(g);
        g.setColor(comp.getBackground());
        g.fillRect(0, 0, defaultIcon.getWidth(), defaultIcon.getHeight());
        int iconw = defaultIcon.getWidth();
        int iconh = defaultIcon.getHeight();
        int[] x = new int[]{0, 10, 5};
        int[] y = new int[]{3, 3, 8};
        Polygon polygon = new Polygon(x, y, 3);
        g.setColor(new Color(0, 51, 51, 255));
        g.setClip(polygon);
        g.fillRect(0, 0, iconw, iconh);
        return new ImageIcon(defaultIcon);
    }
}

