/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.utils.StringUtil;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AtDebug {
    private static final String prefix = "dc";
    private static final String dateFormat = "yyyy/MM/dd HH:mm:ss.SSS";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    public static final String SMARTJ_DEBUG = "SMARTJ_DEBUG";
    public static final String SMARTJ_DEBUG_LEVEL = "SMARTJ_DEBUG_LEVEL";
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String WARNING = "WARNING";
    public static final String ERROR = "ERROR";
    public static final String FATAL = "FATAL";
    public static final String OFF = "OFF";
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 4;
    public static final int LEVEL_WARNING = 7;
    public static final int LEVEL_ERROR = 9;
    public static final int LEVEL_FATAL = 11;
    public static final int LEVEL_OFF = 15;
    private static boolean debug = false;
    private static int currDebugLevel = 4;
    private static PrintStream outputStream = System.err;

    public static boolean isDebug() {
        return debug;
    }

    public static int getCurrentDebugLevel() {
        return currDebugLevel;
    }

    public static void resetDebug() {
        String level;
        String cmdline_debug;
        block27: {
            block26: {
                cmdline_debug = null;
                try {
                    if (cmdline_debug == null) {
                        cmdline_debug = System.getProperty(SMARTJ_DEBUG);
                    }
                    if (cmdline_debug == null) {
                        cmdline_debug = System.getProperty(SMARTJ_DEBUG.toLowerCase());
                    }
                }
                catch (Throwable t) {
                    if (outputStream == null) break block26;
                    outputStream.println("ERROR in seeking SMARTJ_DEBUG system property: " + t.getMessage());
                }
            }
            level = null;
            try {
                level = System.getProperty(SMARTJ_DEBUG_LEVEL);
                if (level == null) {
                    level = System.getProperty(SMARTJ_DEBUG_LEVEL.toLowerCase());
                }
            }
            catch (Throwable t) {
                if (outputStream == null) break block27;
                outputStream.println("ERROR in seeking SMARTJ_DEBUG_LEVEL system property: " + t.getMessage());
            }
        }
        debug = true;
        if (level == null) {
            currDebugLevel = 1;
        } else if (level.equalsIgnoreCase(DEBUG)) {
            currDebugLevel = 1;
        } else if (level.equalsIgnoreCase(INFO)) {
            currDebugLevel = 4;
        } else if (level.equalsIgnoreCase(WARNING)) {
            currDebugLevel = 7;
        } else if (level.equalsIgnoreCase(ERROR)) {
            currDebugLevel = 9;
        } else if (level.equalsIgnoreCase(FATAL)) {
            currDebugLevel = 11;
        } else if (level.equalsIgnoreCase(OFF)) {
            currDebugLevel = 15;
            debug = false;
        } else if (outputStream != null) {
            outputStream.println("WARNING: Unknown debug level: " + level);
        }
        if (cmdline_debug != null) {
            if (cmdline_debug.equals("true")) {
                debug = true;
            } else if (cmdline_debug.equals("false")) {
                debug = false;
                currDebugLevel = 15;
            }
        }
    }

    public static void setLogStream(OutputStream os) {
        PrintStream ps;
        outputStream = !(os instanceof PrintStream) ? (ps = new PrintStream(os)) : (PrintStream)os;
    }

    public static PrintStream getLogStream() {
        return outputStream;
    }

    public static void debugRuntime() {
        AtDebug.debugRuntime(1);
    }

    public static void debugRuntime(int debugLevel) {
        if (debug && debugLevel >= currDebugLevel) {
            try {
                String osName = System.getProperty("os.name");
                String osVersion = System.getProperty("os.version");
                String javaHome = System.getProperty("java.home");
                String javaVendor = System.getProperty("java.vendor");
                String javaVersion = System.getProperty("java.version");
                String printerJob = System.getProperty("java.awt.printerjob");
                String headless = System.getProperty("java.awt.headless");
                AtDebug.debug(1, "os.name=" + osName);
                AtDebug.debug(1, "os.version=" + osVersion);
                AtDebug.debug(1, "java.home=" + javaHome);
                AtDebug.debug(1, "java.vendor=" + javaVendor);
                AtDebug.debug(1, "java.version=" + javaVersion);
                AtDebug.debug(1, "java.awt.printerjob=" + printerJob);
                AtDebug.debug(1, "java.awt.headless=" + headless);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void debug(Object o) {
        AtDebug.debug(1, o);
    }

    public static void debug(int debugLevel, Object o) {
        if (o instanceof String) {
            AtDebug.debug(debugLevel, (String)o);
        } else if (o instanceof Throwable) {
            AtDebug.debug(debugLevel, (Throwable)o);
        } else if (o != null) {
            AtDebug.debug(debugLevel, o.toString());
        }
    }

    public static void debug(String msg) {
        AtDebug.println(1, msg);
    }

    public static void debug(int debugLevel, String msg) {
        AtDebug.println(debugLevel, msg);
    }

    public static void debug(Throwable t) {
        AtDebug.debug(1, t);
    }

    public static void debug(int debugLevel, Throwable t) {
        if (debug && debugLevel >= currDebugLevel) {
            String stackTrace = StringUtil.getStackTrace(t);
            AtDebug.println(debugLevel, stackTrace);
        }
    }

    public static void debug(Object source, String msg) {
        AtDebug.debug(1, source, msg);
    }

    public static void debug(int debugLevel, Object source, String msg) {
        AtDebug.println(debugLevel, source.getClass().getName() + ": " + msg);
    }

    private static void println(int debugLevel, String msg) {
        if (debug && debugLevel >= currDebugLevel && outputStream != null) {
            outputStream.println("dc: " + dateFormatter.format(new Date()) + ": " + msg);
        }
    }

    public static void raise(final Exception ex) {
        Thread t = new Thread(){

            public void run() {
                throw new RuntimeException(ex.getMessage());
            }
        };
        t.start();
    }

    public static void debugPerformence(String source, long startTime, int pageCount) {
        AtDebug.debugPerformence(1, source, startTime, pageCount);
    }

    public static void debugPerformence(int debugLevel, String source, long startTime, int pageCount) {
        if (debug && debugLevel >= currDebugLevel) {
            long endTime = new Date().getTime();
            long deltaMillis = endTime - startTime;
            AtDebug.debug("START----Performence Statistics---");
            AtDebug.debug(source);
            AtDebug.debug("Duration: " + deltaMillis + " milliseconds");
            AtDebug.debug("Pages: " + pageCount);
            AtDebug.debug("END------Performence Statistics---");
        }
    }

    static {
        AtDebug.resetDebug();
    }
}

