/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.utils.AtDebug;
import javax.swing.UIManager;

public class AtLAFUtil {
    public static final String WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final int METAL_LF = 3;
    public static final int MOTIF_LF = 2;
    public static final int WINDOWS_LF = 1;
    public static int currentLF = -1;

    public static void setMotifLookAndFeel() {
        try {
            UIManager.setLookAndFeel(MOTIF);
            currentLF = 2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setWindowsLookAndFeel() {
        try {
            UIManager.setLookAndFeel(WINDOWS);
            currentLF = 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setMetalLookAndFeel() {
        try {
            UIManager.setLookAndFeel(METAL);
            currentLF = 3;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setDefaultLookAndFeel() {
        try {
            String s = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(s);
            currentLF = s.equals(MOTIF) ? 2 : (s.equals(WINDOWS) ? 1 : 3);
        }
        catch (Exception e) {
            AtDebug.debug(9, "Look and feel setup error.");
        }
    }

    public static boolean isLAFStyleWindows() {
        return currentLF == 1;
    }

    public static boolean isLAFStyleMotif() {
        return currentLF == 2;
    }

    public static boolean isLAFStyleMetal() {
        return currentLF == 3;
    }

    public static int getCurrentLookAndFeel() {
        return currentLF;
    }
}

