/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.resource.AtImageList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRootPane;

public class CursorUtil
implements Serializable {
    public static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    public static final Cursor HAND_CLOSED_CURSOR = CursorUtil.createCustomCursor(AtImageList.IMAGE_LIST.HAND_CLOSED_ICON);
    public static final Cursor HAND_OPEN_CURSOR = CursorUtil.createCustomCursor(AtImageList.IMAGE_LIST.HAND_OPEN_ICON);
    public static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    public static final Cursor URL_CURSOR = Cursor.getPredefinedCursor(12);
    public static final Cursor E_RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    public static final Cursor W_RESIZE_CURSOR = Cursor.getPredefinedCursor(10);
    public static final Cursor N_RESIZE_CURSOR = Cursor.getPredefinedCursor(8);
    public static final Cursor NE_RESIZE_CURSOR = Cursor.getPredefinedCursor(7);
    public static final Cursor NW_RESIZE_CURSOR = Cursor.getPredefinedCursor(6);
    public static final Cursor S_RESIZE_CURSOR = Cursor.getPredefinedCursor(9);
    public static final Cursor SE_RESIZE_CURSOR = Cursor.getPredefinedCursor(5);
    public static final Cursor SW_RESIZE_CURSOR = Cursor.getPredefinedCursor(4);
    public static final Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(13);
    public static final Cursor TEXT_CURSOR = Cursor.getPredefinedCursor(2);

    public static final void setCursorToAllPanes(JComponent where, Cursor cursor) {
        if (where == null || cursor == null) {
            return;
        }
        where.setCursor(cursor);
        JRootPane rootPane = where.getRootPane();
        if (rootPane == null) {
            return;
        }
        Component gp = rootPane.getGlassPane();
        if (gp != null) {
            gp.setCursor(cursor);
        }
    }

    public static final Cursor createCustomCursor(ImageIcon imageicon) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point point = new Point(10, 10);
        String s3 = "";
        Cursor cursor = toolkit.createCustomCursor(imageicon.getImage(), point, s3);
        return cursor;
    }
}

