/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.exception.AtException;
import com.activetree.common.object.DefaultPasswordProvider;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.Base64;
import com.activetree.common.utils.ReferenceHolder;
import com.activetree.common.utils.ResourceLoadUtil;
import com.activetree.common.utils.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class DataCommUtil
implements Serializable {
    public static URLClassLoader getArchiveClassLoader(String baseUrl, Object archive, Authenticator auth) {
        URLClassLoader retVal = null;
        if (archive instanceof URLClassLoader) {
            retVal = (URLClassLoader)archive;
        }
        if (retVal == null && archive instanceof String) {
            DataCommUtil.setAuthenticator(auth);
            String archiveStr = (String)archive;
            String[] jarNames = DataCommUtil.getJarNames(baseUrl, archiveStr);
            URLClassLoader urlClsLoader = null;
            if (jarNames != null && jarNames.length > 0) {
                urlClsLoader = DataCommUtil.getUrlClassLoader(jarNames);
            }
            retVal = urlClsLoader;
        }
        DataCommUtil.setAuthenticator(null);
        return retVal;
    }

    public static byte[] getByteData(Object dataSource) throws AtException {
        byte[] data = DataCommUtil.getByteData(null, null, dataSource, null);
        return data;
    }

    public static byte[] getByteData(Object dataSource, Authenticator auth) throws AtException {
        byte[] data = DataCommUtil.getByteData(null, null, dataSource, auth);
        return data;
    }

    public static byte[] getByteData(URLClassLoader urlClsLoader, String baseUrl, Object dataSource, Authenticator urlAuthenticator) throws AtException {
        DataCommUtil.setAuthenticator(urlAuthenticator);
        byte[] data = DataCommUtil.readData(urlClsLoader, urlAuthenticator, baseUrl, dataSource);
        DataCommUtil.setAuthenticator(null);
        return data;
    }

    private static void setAuthenticator(Authenticator urlAuthenticator) {
        if (urlAuthenticator != null && urlAuthenticator instanceof DefaultPasswordProvider) {
            DefaultPasswordProvider auth = (DefaultPasswordProvider)urlAuthenticator;
            String user = auth.getUrlAuthUser();
            String pswd = auth.getUrlAuthPassword();
            int userLen = user == null ? 0 : user.length();
            int pswdLen = pswd == null ? 0 : pswd.length();
            AtDebug.debug("[" + auth.getClass().getName() + "] uid len=[" + userLen + "] p2 len=[" + pswdLen + "]");
            String proxyHost = auth.getProxyHost();
            String proxyPort = auth.getProxyPort();
            if (proxyPort == null) {
                proxyPort = "80";
            }
            String proxySet = "false";
            if (proxyHost != null) {
                proxySet = "true";
                try {
                    Properties sysProp = System.getProperties();
                    sysProp.put("proxyHost", proxyHost);
                    sysProp.put("proxyPort", proxyPort);
                    sysProp.put("proxySet", proxySet);
                }
                catch (Throwable t) {
                    AtDebug.debug(9, "ERROR: setting proxy properties in system properties [" + t.getMessage() + "]");
                }
            }
        }
        AtDebug.debug("urlAuthenticator=" + (urlAuthenticator == null ? "null" : urlAuthenticator.getClass().getName()));
        try {
            Authenticator.setDefault(urlAuthenticator);
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
    }

    private static DataInfo readBytes(URL url, Object dataSource, Authenticator urlAuthenticator) throws AtException {
        DataInfo dataInfo = new DataInfo();
        if (dataSource instanceof byte[]) {
            dataInfo.hasData = true;
            dataInfo.data = (byte[])dataSource;
            return dataInfo;
        }
        if (url == null) {
            return dataInfo;
        }
        try {
            InputStream docInputStream;
            URLConnection con = url.openConnection();
            InputStream is = null;
            AtDebug.debug("URLConnection...done");
            DataCommUtil.setJSessionID(con);
            if (urlAuthenticator != null && urlAuthenticator instanceof DefaultPasswordProvider && con instanceof HttpURLConnection) {
                DefaultPasswordProvider auth = (DefaultPasswordProvider)urlAuthenticator;
                String username = auth.getUrlAuthUser();
                String password = auth.getUrlAuthPassword();
                if (username != null && username.length() > 0) {
                    String authHeader = "Basic ";
                    try {
                        String userpass = username + ":" + password;
                        byte[] encoding = Base64.encode(userpass.getBytes("ISO-8859-1"));
                        authHeader = authHeader + new String(encoding, 0, encoding.length, "US-ASCII");
                        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        con.setRequestProperty("Authorization", authHeader);
                        con.setRequestProperty("Proxy-Authorization", authHeader);
                        ((HttpURLConnection)con).setRequestMethod("GET");
                        con.setDoOutput(true);
                        OutputStream docOutputStream = con.getOutputStream();
                        docOutputStream.flush();
                        docOutputStream.close();
                        AtDebug.debug("wrote header to server.");
                        AtDebug.debug("next -- read response code");
                        int responseCode = ((HttpURLConnection)con).getResponseCode();
                        AtDebug.debug("response code: " + responseCode);
                        String responseMsg = ((HttpURLConnection)con).getResponseMessage();
                        AtDebug.debug("response message: " + responseMsg);
                    }
                    catch (Throwable t) {
                        AtDebug.debug(9, t);
                    }
                }
            }
            if (con != null && con instanceof HttpURLConnection) {
                con.setUseCaches(false);
                con.setDefaultUseCaches(false);
                AtDebug.debug("cache : no");
            }
            if (con != null && con instanceof HttpURLConnection) {
                try {
                    is = con.getInputStream();
                    AtDebug.debug("called con.getInputStream() - is=" + is);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if ((docInputStream = is) == null) {
                AtDebug.debug("url.openStream()....because \"is\" was null.");
                docInputStream = url.openStream();
                AtDebug.debug("called con.openStream is=" + is);
            }
            AtDebug.debug("got input stream....done (inputStream=" + docInputStream + ")");
            if (docInputStream == null) {
                return dataInfo;
            }
            dataInfo.hasData = true;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[40960];
                int bytesCount = 0;
                while ((bytesCount = docInputStream.read(buf)) != -1) {
                    out.write(buf, 0, bytesCount);
                }
                docInputStream.close();
                if (con != null && con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                out.close();
                byte[] data = out.toByteArray();
                AtDebug.debug("[" + (url != null ? url : null) + "] loaded (" + data.length + " bytes)");
                dataInfo.data = data;
            }
            catch (Throwable t) {
                dataInfo.errMsg = t.getMessage();
                dataInfo.errStack = StringUtil.getStackTrace(t);
            }
        }
        catch (Exception t) {
            dataInfo.errMsg = t.getMessage();
            dataInfo.errStack = StringUtil.getStackTrace(t);
        }
        return dataInfo;
    }

    public static void setJSessionID(URLConnection con) {
        if (con != null && con instanceof HttpURLConnection) {
            try {
                Object jSessionId = ReferenceHolder.getAttribute("jsessionid");
                if (jSessionId != null) {
                    con.setRequestProperty("Cookie", "jsessionid=" + jSessionId);
                }
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
        }
    }

    private static byte[] readData(URLClassLoader urlClassLoader, Authenticator urlAuthenticator, String baseUrl, Object dataSource) throws AtException {
        if (dataSource instanceof byte[]) {
            return (byte[])dataSource;
        }
        DataInfo data = null;
        String errMsg = null;
        try {
            if (data == null && dataSource instanceof URL) {
                data = DataCommUtil.readBytes((URL)dataSource, dataSource, urlAuthenticator);
                DataCommUtil.checkData(data);
            }
            if (data == null && dataSource instanceof File) {
                URL fileUrl = ((File)dataSource).toURL();
                data = DataCommUtil.readBytes(fileUrl, dataSource, urlAuthenticator);
                DataCommUtil.checkData(data);
            }
            if (data == null && dataSource instanceof String) {
                data = DataCommUtil.readResource(urlClassLoader, urlAuthenticator, baseUrl, (String)dataSource);
                DataCommUtil.checkData(data);
            }
        }
        catch (Throwable t) {
            errMsg = t.getMessage();
        }
        if (data != null) {
            if (data.hasData && data.data == null) {
                AtDebug.debug(data.errStack);
                throw new AtException("[" + dataSource + "] [" + data.errMsg + "]");
            }
            if (data.data == null) {
                throw new AtException("[" + dataSource + "] [" + "NOT_FOUND" + "]");
            }
        } else {
            throw new AtException("[" + dataSource + "] [" + "NOT_FOUND" + "]");
        }
        return data.data;
    }

    private static void checkData(DataInfo data) throws AtException {
        if (data != null && data.hasData && data.data == null) {
            throw new AtException(data.errMsg);
        }
    }

    private static DataInfo readResource(URLClassLoader urlClsLoader, Authenticator urlAuthenticator, String baseUrlStr, String source) throws AtException {
        File f;
        DataInfo data = new DataInfo();
        baseUrlStr = StringUtil.getWhiteSpaceEnabledURL(baseUrlStr);
        if ((source = StringUtil.getWhiteSpaceEnabledURL(source)) == null || source.length() == 0) {
            return data;
        }
        if (baseUrlStr == null) {
            baseUrlStr = "";
        }
        URL url = null;
        if (urlClsLoader != null) {
            String s = source;
            try {
                url = urlClsLoader.findResource(s);
            }
            catch (Throwable t) {
                url = null;
            }
            if (url == null) {
                s = baseUrlStr + source;
                try {
                    url = urlClsLoader.findResource(s);
                }
                catch (Throwable t) {
                    url = null;
                }
            }
        }
        if (data.data == null) {
            try {
                data = DataCommUtil.readBytes(url, null, urlAuthenticator);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (data != null && data.hasData && data.data == null) {
                return data;
            }
        }
        if (data.data == null) {
            try {
                url = new URL(source);
                data = DataCommUtil.readBytes(url, null, urlAuthenticator);
            }
            catch (Throwable t) {
                url = null;
            }
            if (data != null && data.hasData && data.data == null) {
                return data;
            }
        }
        if (data.data == null) {
            try {
                url = new URL(baseUrlStr + source);
                data = DataCommUtil.readBytes(url, null, urlAuthenticator);
            }
            catch (Throwable t) {
                url = null;
            }
            if (data != null && data.hasData && data.data == null) {
                return data;
            }
        }
        if (data.data == null) {
            try {
                f = new File(source);
                url = f.toURL();
                data = DataCommUtil.readBytes(url, null, urlAuthenticator);
            }
            catch (Throwable t) {
                url = null;
            }
            if (data != null && data.hasData && data.data == null) {
                return data;
            }
        }
        if (data.data == null) {
            try {
                f = new File(baseUrlStr + source);
                url = f.toURL();
                data = DataCommUtil.readBytes(url, null, urlAuthenticator);
            }
            catch (Throwable t) {
                url = null;
            }
            if (data != null && data.hasData && data.data == null) {
                return data;
            }
        }
        if (data.data == null) {
            try {
                url = ResourceLoadUtil.getURLResource(source);
                data = DataCommUtil.readBytes(url, null, urlAuthenticator);
            }
            catch (Throwable t) {
                url = null;
            }
            if (data != null && data.hasData && data.data == null) {
                return data;
            }
        }
        if (data.data == null) {
            try {
                url = ResourceLoadUtil.getURLResource(baseUrlStr + source);
                data = DataCommUtil.readBytes(url, null, urlAuthenticator);
            }
            catch (Throwable t) {
                url = null;
            }
            if (data != null && data.hasData && data.data == null) {
                return data;
            }
        }
        return data;
    }

    private static URLClassLoader getUrlClassLoader(String[] jarNames) {
        ArrayList<URL> list = null;
        for (int i = 0; jarNames != null && i < jarNames.length; ++i) {
            String aJar = jarNames[i];
            aJar = StringUtil.getWhiteSpaceEnabledURL(aJar);
            try {
                URL aUrl = new URL(aJar);
                if (list == null) {
                    list = new ArrayList<URL>();
                }
                list.add(aUrl);
                continue;
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
        }
        URL[] jarUrls = new URL[list != null ? list.size() : 0];
        for (int i = 0; jarUrls != null && i < jarUrls.length; ++i) {
            jarUrls[i] = (URL)list.get(i);
        }
        URLClassLoader urlClsLoader = null;
        try {
            urlClsLoader = new URLClassLoader(jarUrls);
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        return urlClsLoader;
    }

    private static String[] getJarNames(String baseUrl, String archive) {
        baseUrl = StringUtil.getWhiteSpaceEnabledURL(baseUrl);
        if (archive == null) {
            return null;
        }
        ArrayList<String> list = null;
        StringTokenizer tk = new StringTokenizer(archive, ",");
        while (tk.hasMoreTokens()) {
            int x;
            InputStream is;
            String aTk = tk.nextToken();
            aTk = aTk.trim();
            if ((aTk = StringUtil.getWhiteSpaceEnabledURL(aTk)).length() <= 0) continue;
            if (list == null) {
                list = new ArrayList<String>();
            }
            URL url = null;
            try {
                url = new URL(aTk);
                is = url.openStream();
                is.close();
                x = 10;
                ++x;
            }
            catch (Throwable t) {
                url = null;
                AtDebug.debug(9, "URLClassLoader could not be constructed from url [" + url + "]");
            }
            if (url == null && baseUrl != null && baseUrl.length() > 0) {
                aTk = baseUrl + aTk;
                try {
                    url = new URL(aTk);
                    is = url.openStream();
                    is.close();
                    x = 10;
                    ++x;
                }
                catch (Throwable t) {
                    url = null;
                    AtDebug.debug(9, "URLClassLoader could not be constructed from url [" + url + "]");
                }
            }
            if (url == null) continue;
            list.add(aTk);
        }
        String[] arr = new String[list != null ? list.size() : 0];
        for (int i = 0; arr != null && i < arr.length; ++i) {
            arr[i] = (String)list.get(i);
        }
        return arr;
    }

    static class DataInfo {
        public boolean hasData = false;
        public String errMsg;
        public String errStack;
        public byte[] data;

        DataInfo() {
        }
    }
}

