/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.data.DateValue2D;
import com.activetree.common.data.NumberValue2D;
import com.activetree.common.data.PointData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

public class DataUtil
implements Serializable {
    public static void main(String[] args) {
        DataUtil.testOneDimensionalArray(args);
        DataUtil.testTwoDimensionalArray(args);
        DataUtil.testThreeDimensionalArray(args);
        DataUtil.testStringArray2NumberArray(args);
    }

    private static void testThreeDimensionalArray(String[] args) {
        String data = "{  {     {1, 2},     {3, 4},     {5, 6},     {7, 8}  },  {     {9, 10},     {11, 12},     {13, 14}  }}";
        int dim = DataUtil.getArrayDimension(data);
        System.out.println("Array dim: " + dim);
        Object strArray = DataUtil.parseArray(data);
        DataUtil.testArray(data, strArray, 0);
        Double[][][] numArray = (Double[][][])DataUtil.getNumberArray(strArray, dim);
        int x = 10;
        ++x;
    }

    private static void testStringArray2NumberArray(String[] args) {
        String arry1 = "{{1,2,3},{4,5,6},{7,8,9}}";
        int dim = DataUtil.getArrayDimension(arry1);
        Object strArr1 = DataUtil.parseArray(arry1);
        DataUtil.testArray(arry1, strArr1, 0);
        Double[][] numArr1 = (Double[][])DataUtil.getNumberArray(strArr1, dim);
        DataUtil.testArray(arry1, numArr1, 0);
        String arry2 = "{{1, 2, 3},{4,5,  6},{  7, 8,9}}";
        dim = DataUtil.getArrayDimension(arry2);
        Object strArr2 = DataUtil.parseArray(arry2);
        DataUtil.testArray(arry2, strArr2, 0);
        Double[][] numArr2 = (Double[][])DataUtil.getNumberArray(strArr2, dim);
        DataUtil.testArray(arry2, numArr2, 0);
    }

    private static void testTwoDimensionalArray(String[] args) {
        String arry = "{{1},{2},{3}}";
        String arry1 = "{}";
        String arry2 = "{1, 2, 3}";
        String arry3 = "{{1,2,3},{4,5,6},{7,8,9}}";
        Object arr = DataUtil.parseArray(arry);
        DataUtil.testArray(arry, arr, 0);
        Object arr1 = DataUtil.parseArray(arry1);
        DataUtil.testArray(arry1, arr1, 0);
        Object arr2 = DataUtil.parseArray(arry2);
        DataUtil.testArray(arry2, arr2, 0);
        Object arr3 = DataUtil.parseArray(arry3);
        DataUtil.testArray(arry3, arr3, 0);
    }

    private static void testOneDimensionalArray(String[] args) {
        String arry = "{ }";
        String arry1 = "{1, 2, 3}";
        String arry2 = "{string1, string2, 123}";
        String arry3 = "1 \"on, e\" one";
        String arry4 = "{1, 2, 3,}";
        String arry5 = "{1 \"one, comma test in double quotes\", 2 \"two\", 3 \"three\"}";
        String arry6 = "{,,}";
        Object[] arr = DataUtil.parseOneDimensionalArray(arry);
        Object[] arr1 = DataUtil.parseOneDimensionalArray(arry1);
        Object[] arr2 = DataUtil.parseOneDimensionalArray(arry2);
        Object[] arr3 = DataUtil.parseOneDimensionalArray(arry3);
        Object[] arr4 = DataUtil.parseOneDimensionalArray(arry4);
        Object[] arr5 = DataUtil.parseOneDimensionalArray(arry5);
        Object[] arr6 = DataUtil.parseOneDimensionalArray(arry6);
        DataUtil.testArray(arry, arr, 0);
        DataUtil.testArray(arry1, arr1, 0);
        DataUtil.testArray(arry2, arr2, 0);
        DataUtil.testArray(arry3, arr3, 0);
        DataUtil.testArray(arry4, arr4, 0);
        DataUtil.testArray(arry5, arr5, 0);
        DataUtil.testArray(arry6, arr6, 0);
        int x = 10;
        ++x;
    }

    public static void testArray(String arrStr, Object array, int level) {
        if (arrStr != null) {
            System.out.println(arrStr);
        }
        Object[] arr = (Object[])array;
        String currIndent = DataUtil.getIndentation(level);
        System.out.println(currIndent + "{");
        for (int i = 0; arr != null && i < arr.length; ++i) {
            Object o = arr[i];
            if (!(o instanceof Object[])) {
                System.out.println(currIndent + "  " + o + (i == arr.length - 1 ? "" : ","));
                continue;
            }
            DataUtil.testArray(null, o, level + 1);
        }
        System.out.println(currIndent + "}");
    }

    private static String getIndentation(int level) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buf.append("  ");
        }
        return buf.toString();
    }

    public static int getArrayDimension(String str) {
        if (str == null || str.length() == 0) {
            throw new NullPointerException("Null argument - can not decide array dimension.");
        }
        int len = str.length();
        int beginCount = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '{') {
                ++beginCount;
                continue;
            }
            if (ch == '}') break;
        }
        int endCount = 0;
        for (int i = len - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (ch == '}') {
                ++endCount;
                continue;
            }
            if (ch == '{') break;
        }
        if (beginCount != endCount) {
            throw new RuntimeException("Invalid data - brackets does not match ('{' count: " + beginCount + ", '}' count: " + endCount + ")");
        }
        if (beginCount == 0 && endCount == 0) {
            return -1;
        }
        return beginCount;
    }

    public static Object parseArray(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        Object[] arr = DataUtil.parseRecursively(str);
        return arr;
    }

    private static int getDelimeterLocation(String str, int currLocation, char delim) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        int len = str.length();
        for (int i = currLocation; i < len; ++i) {
            if (str.charAt(i) != delim) continue;
            return i;
        }
        return -1;
    }

    public static Object[] parseOneDimensionalArray(String s) {
        int i;
        if (s == null || s.length() == 0) {
            return null;
        }
        String str = s.trim();
        int arrayBeginIdx = -1;
        int arrayEndIdx = -1;
        int len = str.length();
        for (i = 0; i < len; ++i) {
            if (str.charAt(i) != '{') continue;
            arrayBeginIdx = i;
            break;
        }
        for (i = len - 1; i > 0; --i) {
            if (str.charAt(i) != '}') continue;
            arrayEndIdx = i;
            break;
        }
        boolean enclosed = true;
        if (arrayBeginIdx == -1 && arrayEndIdx == -1) {
            enclosed = false;
            arrayBeginIdx = 0;
            arrayEndIdx = str.length() - 1;
        }
        int idx1 = arrayBeginIdx;
        int doubleQuoteCount = 0;
        ArrayList<String> list = new ArrayList<String>();
        boolean empty = true;
        for (int i2 = arrayBeginIdx; i2 < arrayEndIdx; ++i2) {
            char ch = str.charAt(i2);
            if (!enclosed && ch != ' ' || enclosed && i2 > arrayBeginIdx && ch != ' ') {
                empty = false;
            }
            if (ch == '\"') {
                ++doubleQuoteCount;
            }
            if (ch != ',' || doubleQuoteCount % 2 != 0) continue;
            String elm = str.substring(idx1 + 1, i2);
            list.add(elm);
            idx1 = i2;
        }
        if (arrayEndIdx - arrayBeginIdx > 1 && !empty) {
            int inc = 0;
            if (enclosed || list.size() > 0) {
                inc = 1;
            }
            String lastElm = str.substring(idx1 + inc, arrayEndIdx + (enclosed ? 0 : 1));
            list.add(lastElm);
        }
        Object[] arry = list != null ? new Object[list.size()] : null;
        int arrLen = arry != null ? arry.length : 0;
        for (int j = 0; j < arrLen; ++j) {
            arry[j] = list.get(j);
        }
        return arry;
    }

    public static Double[] getNumberArray(Object[] strArray) {
        Double[] numArray = strArray != null ? new Double[strArray.length] : null;
        for (int i = 0; strArray != null && i < strArray.length; ++i) {
            Double d = null;
            String value = null;
            Object obj = strArray[i];
            if (obj instanceof String) {
                value = (String)obj;
            } else if (obj instanceof Number) {
                d = new Double(((Number)obj).doubleValue());
            }
            if (value != null && value.length() > 0) {
                value = value.trim();
                try {
                    double dd = Double.parseDouble(value);
                    d = new Double(dd);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            numArray[i] = d;
        }
        return numArray;
    }

    public static Object[] getAutomaticArray(Object[] strArray) {
        Object[] numArray = strArray != null ? new Object[strArray.length] : null;
        for (int i = 0; strArray != null && i < strArray.length; ++i) {
            String value = null;
            Object obj = strArray[i];
            if (obj instanceof String) {
                value = (String)obj;
            }
            if (value != null && value.length() > 0) {
                value = value.trim();
                try {
                    double dd = Double.parseDouble(value);
                    obj = new Double(dd);
                }
                catch (Throwable t) {
                    obj = value;
                }
            }
            numArray[i] = obj;
        }
        return numArray;
    }

    public static Object getNumberArray(Object array, int dim) {
        Object[] arr = (Object[])array;
        if (arr[0] instanceof String) {
            Double[] numArray = DataUtil.getNumberArray(arr);
            return numArray;
        }
        Double[] arrX = null;
        block6: for (int i = 0; arr != null && i < arr.length; ++i) {
            Object anArray = DataUtil.getNumberArray(arr[i], dim - 1);
            switch (dim) {
                case 4: {
                    Double[][][][] tArr4 = null;
                    if (arrX == null) {
                        tArr4 = new Double[arr.length][][][];
                        arrX = tArr4;
                    } else {
                        tArr4 = (Double[][][][])anArray;
                    }
                    tArr4[i] = (Double[][][])anArray;
                    continue block6;
                }
                case 3: {
                    Double[][][] tArr3 = null;
                    if (arrX == null) {
                        tArr3 = new Double[arr.length][][];
                        arrX = tArr3;
                    } else {
                        tArr3 = (Double[][][])arrX;
                    }
                    tArr3[i] = (Double[][])anArray;
                    continue block6;
                }
                case 2: {
                    Double[][] tArr2 = null;
                    if (arrX == null) {
                        tArr2 = new Double[arr.length][];
                        arrX = tArr2;
                    } else {
                        tArr2 = (Double[][])arrX;
                    }
                    tArr2[i] = (Double[])anArray;
                    continue block6;
                }
                case 1: {
                    Double[] tArr1;
                    arrX = tArr1 = (Double[])anArray;
                }
            }
        }
        return arrX;
    }

    public static Object getStringArray(Object array, int dim) {
        Object[] arr = (Object[])array;
        if (arr[0] instanceof String) {
            String[] numArray = DataUtil.getStringArray(arr);
            return numArray;
        }
        String[] arrX = null;
        block6: for (int i = 0; arr != null && i < arr.length; ++i) {
            Object anArray = DataUtil.getStringArray(arr[i], dim - 1);
            switch (dim) {
                case 4: {
                    String[][][][] tArr4 = null;
                    if (arrX == null) {
                        tArr4 = new String[arr.length][][][];
                        arrX = tArr4;
                    } else {
                        tArr4 = (String[][][][])anArray;
                    }
                    tArr4[i] = (String[][][])anArray;
                    continue block6;
                }
                case 3: {
                    String[][][] tArr3 = null;
                    if (arrX == null) {
                        tArr3 = new String[arr.length][][];
                        arrX = tArr3;
                    } else {
                        tArr3 = (String[][][])arrX;
                    }
                    tArr3[i] = (String[][])anArray;
                    continue block6;
                }
                case 2: {
                    String[][] tArr2 = null;
                    if (arrX == null) {
                        tArr2 = new String[arr.length][];
                        arrX = tArr2;
                    } else {
                        tArr2 = (String[][])arrX;
                    }
                    tArr2[i] = (String[])anArray;
                    continue block6;
                }
                case 1: {
                    String[] tArr1;
                    arrX = tArr1 = (String[])anArray;
                }
            }
        }
        return arrX;
    }

    private static String[] getStringArray(Object[] array) {
        String[] strArry = DataUtil.getStringArray(array, true);
        return strArry;
    }

    private static String[] getStringArray(Object[] array, boolean trim) {
        String[] strArray = array != null ? new String[array.length] : null;
        for (int i = 0; array != null && i < array.length; ++i) {
            Object obj = array[i];
            String value = null;
            value = obj instanceof String ? (String)obj : obj.toString();
            if (trim) {
                value = value != null ? value.trim() : null;
            }
            strArray[i] = value;
        }
        return strArray;
    }

    public static int getDigitCount(double N) {
        int digitCount = (int)(Math.log(N) / Math.log(10.0)) + 1;
        return digitCount;
    }

    public static final String getString(double value, int precisionCount) {
        String str = String.valueOf(value);
        StringBuffer buf = new StringBuffer();
        int count = -1;
        boolean dotFound = false;
        for (int i = 0; i < str.length(); ++i) {
            char aCh = str.charAt(i);
            if (aCh == '.') {
                dotFound = true;
            }
            if (dotFound) {
                ++count;
            }
            if (count > precisionCount) break;
            buf.append(str.charAt(i));
        }
        if (precisionCount == 0 && buf.charAt(buf.length() - 1) == '.') {
            buf.deleteCharAt(buf.length() - 1);
        }
        String outStr = buf.toString();
        return outStr;
    }

    public static final String getString(float value, int precisionCount) {
        String str = String.valueOf(value);
        StringBuffer buf = new StringBuffer();
        int count = -1;
        boolean dotFound = false;
        for (int i = 0; i < str.length(); ++i) {
            char aCh = str.charAt(i);
            if (aCh == '.') {
                dotFound = true;
            }
            if (dotFound) {
                ++count;
            }
            if (count > precisionCount) break;
            buf.append(str.charAt(i));
        }
        if (precisionCount == 0 && buf.charAt(buf.length() - 1) == '.') {
            buf.deleteCharAt(buf.length() - 1);
        }
        String outStr = buf.toString();
        return outStr;
    }

    private static Object[] parseRecursively(String s) {
        int currDim = DataUtil.getArrayDimension(s);
        if (currDim < 1) {
            throw new RuntimeException("Invalid input data: " + s);
        }
        if (currDim == 1) {
            Object[] oneDimArray = DataUtil.parseOneDimensionalArray(s);
            return oneDimArray;
        }
        PointData boundary = DataUtil.getBoundary(s);
        if (boundary == null) {
            return null;
        }
        int beginMarker = (int)boundary.getX();
        int endMarker = (int)boundary.getY();
        String s1 = s.substring(beginMarker + 1, endMarker);
        ArrayList currStrList = DataUtil.parseCurrentList(s1, currDim - 1);
        Object[] currArray = new Object[currStrList.size()];
        for (int i = 0; i < currStrList.size(); ++i) {
            Object[] childArray;
            String currArrayStr = (String)currStrList.get(i);
            currArray[i] = childArray = DataUtil.parseRecursively(currArrayStr);
        }
        return currArray;
    }

    private static ArrayList parseCurrentList(String s, int dim) {
        int i;
        int len = s != null ? s.length() : 0;
        int dataBeginIdx = DataUtil.getDelimeterLocation(s, 0, '{');
        ArrayList<String> currStrList = new ArrayList<String>();
        for (i = 0; i < len; ++i) {
            boolean isDataEnd;
            char ch = s.charAt(i);
            if (ch != ',' || !(isDataEnd = DataUtil.hasEndMarkerCount(s, i - 1, dim))) continue;
            String elm = s.substring(dataBeginIdx, i);
            currStrList.add(elm);
            dataBeginIdx = DataUtil.getDelimeterLocation(s, i, '{');
        }
        if (i > dataBeginIdx) {
            String lastElm = s.substring(dataBeginIdx, i);
            currStrList.add(lastElm);
        }
        return currStrList;
    }

    private static boolean hasEndMarkerCount(String s, int idx, int markerCount) {
        int currMarkerCount = 0;
        for (int i = idx; i >= 0; --i) {
            char ch = s.charAt(i);
            if (ch == '}') {
                ++currMarkerCount;
                continue;
            }
            if (Character.isLetterOrDigit(ch)) break;
        }
        return currMarkerCount == markerCount;
    }

    private static PointData getBoundary(String s) {
        int endIdx;
        int len = s != null ? s.length() : 0;
        int beginIdx = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch != '{') continue;
            beginIdx = i;
            break;
        }
        for (int i = endIdx = len - 1; i >= 0; --i) {
            char ch = s.charAt(i);
            if (ch != '}') continue;
            endIdx = i;
            break;
        }
        return new PointData(beginIdx, endIdx);
    }

    public static NumberValue2D[][] getNumberValue2D(Double[][][] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        NumberValue2D[][] values = new NumberValue2D[data.length][];
        for (int i = 0; i < data.length; ++i) {
            Double[][] aSeriesList = data[i];
            NumberValue2D[] aSeries = aSeriesList != null ? new NumberValue2D[aSeriesList.length] : null;
            for (int j = 0; aSeriesList != null && j < aSeriesList.length; ++j) {
                NumberValue2D aPoint;
                Double[] point = aSeriesList[j];
                aSeries[j] = aPoint = new NumberValue2D(point[0], point[1]);
            }
            values[i] = aSeries;
        }
        return values;
    }

    public static DateValue2D[][] getDateValue2D(Double[][][] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        DateValue2D[][] values = new DateValue2D[data.length][];
        for (int i = 0; i < data.length; ++i) {
            Double[][] aSeriesList = data[i];
            DateValue2D[] aSeries = aSeriesList != null ? new DateValue2D[aSeriesList.length] : null;
            for (int j = 0; aSeriesList != null && j < aSeriesList.length; ++j) {
                DateValue2D aPoint;
                Double[] point = aSeriesList[j];
                Date dt = new Date(point[0].longValue());
                aSeries[j] = aPoint = new DateValue2D(dt, (Number)point[1]);
            }
            values[i] = aSeries;
        }
        return values;
    }
}

