/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.doc.DocPageable;
import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.utils.AtDebug;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.Sides;

public class MediaUtil
implements Serializable {
    public static final int UNIT_CM = 1;
    public static final int UNIT_INCH = 2;
    public static final int UNIT_PIXEL = 3;
    public static final int PAGE_SCALING_NONE = 10;
    public static final int PAGE_SCALING_FIT_TO_PRINTABLE_AREA = 11;
    public static final int PAGE_SCALING_SHRINK_TO_PRINTABLE_AREA = 12;
    public static final int AUTO_ROTATE_AND_CENTER = 20;
    public static final int CHOOSE_PAPER_SOURCE_BY_PAGE_SIZE = 30;

    public static void setRenderingReasonforPages(Pageable pages, Object renderingReason) {
        if (pages == null) {
            return;
        }
        for (int i = 0; i < pages.getNumberOfPages(); ++i) {
            AbstractPage aPage = (AbstractPage)pages.getPrintable(i);
            aPage.setRenderingReason(renderingReason);
        }
    }

    public static final String getFilteredPaper(String paper, double defaultTopMargin, double defaultLeftMargin, double defaultBottomMargin, double defaultRightMargin, double defaultPaperWidth, double defaultPaperHeight) {
        AtDebug.debug("getFilteredPaper[paper=" + paper + ", tm=" + defaultTopMargin + ", lm=" + defaultLeftMargin + ", bm=" + defaultBottomMargin + ", rm=" + defaultRightMargin + ", w=" + defaultPaperWidth + ", h=" + defaultPaperHeight + "]");
        if (paper == null || paper.length() == 0) {
            paper = "";
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tk = new StringTokenizer(paper, "(),");
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            tokens.add(token);
        }
        AtDebug.debug("Input paper tokens (B4 sending to print thread)=" + tokens);
        String filteredPaper = null;
        if (tokens.size() == 0) {
            filteredPaper = "(" + defaultTopMargin + "," + defaultLeftMargin + "," + defaultBottomMargin + "," + defaultRightMargin + "," + defaultPaperWidth + "," + defaultPaperHeight + ")";
        } else if (tokens.size() == 2) {
            String paperWidth = (String)tokens.get(0);
            String paperHeight = (String)tokens.get(1);
            filteredPaper = "(" + defaultTopMargin + "," + defaultLeftMargin + "," + defaultBottomMargin + "," + defaultRightMargin + "," + paperWidth + "," + paperHeight + ")";
        } else {
            filteredPaper = paper;
        }
        AtDebug.debug("inputPaper vs filteredPaper: \"" + paper + "\" " + "->\"" + filteredPaper + "\"");
        return filteredPaper;
    }

    public static Book createCollatedCopiesForPrint(Pageable book, boolean collate, int numOfCopies) {
        if (numOfCopies <= 1) {
            DocPageable docPages = new DocPageable();
            for (int i = 0; book != null && i < book.getNumberOfPages(); ++i) {
                Printable printable = book.getPrintable(i);
                PageFormat pf = book.getPageFormat(i);
                docPages.append(printable, pf);
            }
            return docPages;
        }
        DocPageable collatedCopies = new DocPageable();
        if (collate) {
            for (int copy = 0; copy < numOfCopies; ++copy) {
                for (int i = 0; book != null && i < book.getNumberOfPages(); ++i) {
                    AbstractPage aPage = (AbstractPage)book.getPrintable(i);
                    AbstractPage copiedPage = aPage.newInstance();
                    collatedCopies.append(copiedPage, copiedPage.getPageFormat());
                }
            }
        } else {
            for (int i = 0; book != null && i < book.getNumberOfPages(); ++i) {
                AbstractPage aPage = (AbstractPage)book.getPrintable(i);
                for (int copy = 0; copy < numOfCopies; ++copy) {
                    AbstractPage copiedPage = aPage.newInstance();
                    collatedCopies.append(copiedPage, copiedPage.getPageFormat());
                }
            }
        }
        return collatedCopies;
    }

    public static final PageFormat getClonedPageFormat(PageFormat inputPf) {
        if (inputPf == null) {
            return null;
        }
        PageFormat clonedPf = (PageFormat)inputPf.clone();
        return clonedPf;
    }

    public static final void debugPageFormat(PageFormat pf) {
        if (pf != null) {
            double x = pf.getImageableX();
            double y = pf.getImageableY();
            double iw = pf.getImageableWidth();
            double ih = pf.getImageableHeight();
            double w = pf.getWidth();
            double h = pf.getHeight();
            AtDebug.debug("PageFormat: " + pf + "[ix=" + x + ", iy=" + y + ", iw=" + iw + ",ih=" + ih + ", tw=" + w + ", th=" + h + ", orientation=" + (pf.getOrientation() == 1 ? "Portrait" : "Landscape") + "]");
        } else {
            AtDebug.debug("PageFormat: null");
        }
    }

    public static final PageFormat getDefaultPrinterPageFormat() {
        PageFormat printerSupportedPageFormat = new PageFormat();
        Paper printerSupportedPaper = new Paper();
        printerSupportedPaper.setSize(612.0, 792.0);
        printerSupportedPaper.setImageableArea(0.0, 0.0, printerSupportedPaper.getWidth(), printerSupportedPaper.getHeight());
        printerSupportedPageFormat.setPaper(printerSupportedPaper);
        return printerSupportedPageFormat;
    }

    public static final PageFormat getSelectedPageFormat(MediaSizeName mediaSizeName) {
        AtMediaSizeObject mObj = new AtMediaSizeObject(mediaSizeName);
        double paperWidth = mObj.getMediaWidthPixel();
        double paperHeight = mObj.getMediaHeightPixel();
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        int orientation = 1;
        Paper paper = new Paper();
        paper.setSize(paperWidth, paperHeight);
        double imageableWidth = paperWidth - (leftMargin + rightMargin);
        double imageableHeight = paperHeight - (topMargin + bottomMargin);
        paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(MediaSizeName mediaSizeName, double leftMargin, double rightMargin, double topMargin, double bottomMargin) {
        AtMediaSizeObject mObj = new AtMediaSizeObject(mediaSizeName);
        double paperWidth = mObj.getMediaWidthPixel();
        double paperHeight = mObj.getMediaHeightPixel();
        int orientation = 1;
        Paper paper = new Paper();
        paperWidth = Math.round(paperWidth);
        paperHeight = Math.round(paperHeight);
        paper.setSize(paperWidth, paperHeight);
        double imageableWidth = paperWidth - (leftMargin + rightMargin);
        double imageableHeight = paperHeight - (topMargin + bottomMargin);
        paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(MediaSizeName mediaSizeName, double leftMargin, double rightMargin, double topMargin, double bottomMargin, int orientation) {
        AtMediaSizeObject mObj = new AtMediaSizeObject(mediaSizeName);
        double paperWidth = mObj.getMediaWidthPixel();
        double paperHeight = mObj.getMediaHeightPixel();
        Paper paper = new Paper();
        paperWidth = Math.round(paperWidth);
        paperHeight = Math.round(paperHeight);
        paper.setSize(paperWidth, paperHeight);
        double imageableWidth = paperWidth - (leftMargin + rightMargin);
        double imageableHeight = paperHeight - (topMargin + bottomMargin);
        paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(Rectangle2D printableArea) {
        double paperWidth = printableArea.getWidth();
        double paperHeight = printableArea.getHeight();
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        int orientation = 1;
        Paper paper = new Paper();
        paperWidth = Math.round(paperWidth);
        paperHeight = Math.round(paperHeight);
        paper.setSize(paperWidth, paperHeight);
        double imageableWidth = paperWidth - (leftMargin + rightMargin);
        double imageableHeight = paperHeight - (topMargin + bottomMargin);
        paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(Rectangle2D printableArea, double leftMargin, double rightMargin, double topMargin, double bottomMargin, int orientation) {
        double resizeFactor = 1.0;
        PageFormat pf = MediaUtil.getSelectedPageFormat(printableArea, leftMargin, rightMargin, topMargin, bottomMargin, orientation, resizeFactor);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(Rectangle2D printableArea, double resizeFactor) {
        PageFormat pf = MediaUtil.getSelectedPageFormat(printableArea, 0.0, 0.0, 0.0, 0.0, 1, resizeFactor);
        return pf;
    }

    public static final PageFormat getSelectedPageFormat(Rectangle2D printableArea, double leftMargin, double rightMargin, double topMargin, double bottomMargin, int orientation, double resolutionFactor) {
        PageFormat outputPageFormat = new PageFormat();
        Paper paper = new Paper();
        double width = printableArea.getWidth();
        double height = printableArea.getHeight();
        width *= resolutionFactor;
        height *= resolutionFactor;
        width = Math.round(width);
        height = Math.round(height);
        paper.setSize(width, height);
        double imageableWidth = width - (leftMargin + rightMargin);
        double imageableHeight = height - (topMargin + bottomMargin);
        paper.setImageableArea(leftMargin, topMargin, imageableWidth, imageableHeight);
        outputPageFormat.setPaper(paper);
        outputPageFormat.setOrientation(orientation);
        return outputPageFormat;
    }

    public static final String getDebugString(PageFormat pageFormat) {
        if (pageFormat == null) {
            return "null";
        }
        double x = pageFormat.getImageableX();
        double y = pageFormat.getImageableY();
        double iw = pageFormat.getImageableWidth();
        double ih = pageFormat.getImageableHeight();
        double w = pageFormat.getWidth();
        double h = pageFormat.getHeight();
        String s = pageFormat + "[ix=" + x + ", iy=" + y + ", iw=" + iw + ",ih=" + ih + ", tw=" + w + ", th=" + h + ", orientation=" + (pageFormat.getOrientation() == 1 ? "Portrait" : "Landscape") + "]";
        return s;
    }

    public static final Sides getMediaSide(String sideName) {
        if (sideName == null) {
            return Sides.ONE_SIDED;
        }
        if (sideName.equalsIgnoreCase("ONE_SIDED")) {
            return Sides.ONE_SIDED;
        }
        if (sideName.equalsIgnoreCase("DUPLEX")) {
            return Sides.DUPLEX;
        }
        if (sideName.equalsIgnoreCase("TUMBLE")) {
            return Sides.TUMBLE;
        }
        if (sideName.equalsIgnoreCase("TWO_SIDED_LONG_EDGE")) {
            return Sides.TWO_SIDED_LONG_EDGE;
        }
        if (sideName.equalsIgnoreCase("TWO_SIDED_SHORT_EDGE")) {
            return Sides.TWO_SIDED_SHORT_EDGE;
        }
        return Sides.ONE_SIDED;
    }

    public static final String getMediaSide(Sides side) {
        if (side == null) {
            return "ONE_SIDED";
        }
        if (side == Sides.ONE_SIDED) {
            return "ONE_SIDED";
        }
        if (side == Sides.DUPLEX) {
            return "DUPLEX";
        }
        if (side == Sides.TUMBLE) {
            return "TUMBLE";
        }
        if (side == Sides.TWO_SIDED_LONG_EDGE) {
            return "TWO_SIDED_LONG_EDGE";
        }
        if (side == Sides.TWO_SIDED_SHORT_EDGE) {
            return "TWO_SIDED_SHORT_EDGE";
        }
        return "ONE_SIDED";
    }
}

