/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.utils.AtDebug;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URLClassLoader;

public class ReflectionUtil
implements Serializable {
    public static final Class loadClass(URLClassLoader clsLoader, String clsName) {
        Class<?> cls = null;
        try {
            cls = ReflectionUtil.loadClass(clsName);
        }
        catch (Throwable t) {
            AtDebug.debug(9, "load class local - not found (" + clsName + ")");
        }
        if (cls == null && clsLoader != null) {
            try {
                cls = clsLoader.loadClass(clsName);
            }
            catch (Throwable t) {
                AtDebug.debug(9, "load class remote - not found (clsLoader=" + clsLoader + ", clsName=" + clsName + ")");
            }
        }
        return cls;
    }

    public static final Class loadClass(String clsName) throws ClassNotFoundException {
        Class<?> cls = Class.forName(clsName);
        return cls;
    }

    public static final boolean isClassFound(String clsName) {
        try {
            Class<?> cls = Class.forName(clsName);
            if (cls != null) {
                AtDebug.debug("\"" + clsName + "\" found in class path? - OK.");
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static final Method getMethod(Class cls, String methodName, Class[] args) {
        Method method = null;
        try {
            method = cls.getDeclaredMethod(methodName, args);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getClass().getName() + "" + t.getMessage() + " for loading " + cls.getName() + "." + methodName);
        }
        return method;
    }

    public static final Object invokeMethod(Class cls, Method method, Object[] args) {
        Object retValue = null;
        try {
            retValue = method.invoke((Object)cls, args);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getClass().getName() + "" + t.getMessage() + " for invoking " + cls.getName() + "." + method.getName());
        }
        return retValue;
    }
}

