/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.utils.AtDebug;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import javax.imageio.ImageIO;

public class ResourceLoadUtil
implements Serializable {
    public static URL getURLResource(String resName) {
        URL url = null;
        if (resName != null) {
            url = ResourceLoadUtil.class.getResource(resName);
        }
        if (url == null) {
            AtDebug.debug("ERROR loading resource [" + resName + "] [" + null + "]");
        }
        return url;
    }

    public static InputStream getResource(String resName) {
        InputStream is = ResourceLoadUtil.class.getResourceAsStream(resName);
        return is;
    }

    public static BufferedImage getIconResource(String iconName) {
        try {
            InputStream is = ResourceLoadUtil.getResource(iconName);
            BufferedImage bi = ImageIO.read(is);
            return bi;
        }
        catch (Throwable t) {
            AtDebug.debug(9, "ERROR loading icon resource [" + iconName + "] [" + t.getMessage() + "]");
            return null;
        }
    }

    public static URL getURLClassLoaderResource(URLClassLoader urlClsLoader, String resName) {
        URL url = null;
        if (urlClsLoader != null) {
            url = urlClsLoader.findResource(resName);
        }
        if (url == null) {
            AtDebug.debug("ERROR loading URLClassLoader resource [clsLoader=" + urlClsLoader + "] [" + resName + "] [" + null + "]");
        }
        return url;
    }

    public static BufferedImage getIconResource(URLClassLoader urlClsLoader, String iconName) {
        try {
            URL iconUrl = ResourceLoadUtil.getURLClassLoaderResource(urlClsLoader, iconName);
            BufferedImage bi = ImageIO.read(iconUrl);
            return bi;
        }
        catch (Throwable t) {
            AtDebug.debug(9, "ERROR loading icon resource [" + iconName + "] [" + t.getMessage() + "]");
            return null;
        }
    }
}

