/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class StringPattern
implements Serializable {
    public List getUnmatchedList(String[] listToSearch, String searchPatterns, String wildCardChars, boolean caseSensitive) {
        if (listToSearch == null || listToSearch.length == 0) {
            return null;
        }
        List foundList = this.getMatchedList(listToSearch, searchPatterns, wildCardChars, caseSensitive);
        int n = listToSearch.length - (foundList != null ? foundList.size() : 0);
        ArrayList<String> unmatchedList = null;
        for (int i = 0; n > 0 && i < listToSearch.length; ++i) {
            if (foundList != null && foundList.contains(listToSearch[i])) continue;
            if (unmatchedList == null) {
                unmatchedList = new ArrayList<String>();
            }
            unmatchedList.add(listToSearch[i]);
        }
        return unmatchedList;
    }

    public List getMatchedList(String[] listToSearch, String searchPatterns, String wildCardChars, boolean caseSensitive) {
        if (listToSearch == null || listToSearch.length == 0) {
            return null;
        }
        if (searchPatterns == null) {
            searchPatterns = "";
        }
        ArrayList<String> patterns = null;
        StringTokenizer tk = new StringTokenizer(searchPatterns, ",");
        while (tk != null && tk.hasMoreTokens()) {
            String aPattern = tk.nextToken();
            if ((aPattern = aPattern.trim()).length() <= 0) continue;
            if (patterns == null) {
                patterns = new ArrayList<String>();
            }
            if (caseSensitive) {
                patterns.add(aPattern);
                continue;
            }
            patterns.add(aPattern.toLowerCase());
        }
        Hashtable<String, List> patternSegments = null;
        for (int i = 0; patterns != null && i < patterns.size(); ++i) {
            String aPattern = (String)patterns.get(i);
            List aPatternSegments = this.toPatternSegments(aPattern, wildCardChars, caseSensitive);
            if (patternSegments == null) {
                patternSegments = new Hashtable<String, List>();
            }
            if (aPatternSegments == null || aPatternSegments.size() <= 0) continue;
            patternSegments.put(aPattern, aPatternSegments);
        }
        ArrayList<String> foundList = null;
        block2: for (int i = 0; listToSearch != null && i < listToSearch.length; ++i) {
            String aSearchable = listToSearch[i];
            if (!caseSensitive) {
                aSearchable = aSearchable.toLowerCase();
            }
            Iterator iter = null;
            if (patternSegments != null) {
                iter = patternSegments.keySet().iterator();
            }
            while (iter != null && iter.hasNext()) {
                String aPattern = (String)iter.next();
                List segmentsForThePattern = (List)patternSegments.get(aPattern);
                boolean isExactMatch = this.isExactMatch(aPattern, wildCardChars);
                boolean searchableFolder = this.isMatchSegments(aSearchable, wildCardChars, isExactMatch, segmentsForThePattern);
                if (!searchableFolder) continue;
                if (foundList == null) {
                    foundList = new ArrayList<String>();
                }
                foundList.add(listToSearch[i]);
                continue block2;
            }
        }
        return foundList;
    }

    public List toPatternSegments(String pattern, String delimiters, boolean caseSensitive) {
        if (pattern == null || pattern.length() == 0) {
            return null;
        }
        if (delimiters == null) {
            delimiters = "";
        }
        ArrayList<String> retList = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        boolean matched = false;
        int i = 0;
        for (i = 0; pattern != null && i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            matched = this.isDelimiter(ch, delimiters);
            if (matched) {
                if (buf.length() > 0) {
                    String prevSegment = buf.toString();
                    retList.add(prevSegment);
                }
                retList.add(ch + "");
                buf.delete(0, buf.length());
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            retList.add(buf.toString());
        }
        return retList;
    }

    public boolean isDelimiter(char ch, String delimiters) {
        boolean matched = false;
        for (int j = 0; delimiters != null && j < delimiters.length(); ++j) {
            char dc = delimiters.charAt(j);
            if (dc != ch) continue;
            matched = true;
            break;
        }
        return matched;
    }

    public boolean isExactMatch(String aPattern, String wildcardChars) {
        for (int i = 0; aPattern != null && wildcardChars != null && i < wildcardChars.length(); ++i) {
            if (aPattern.indexOf(wildcardChars.charAt(i)) < 0) continue;
            return false;
        }
        return true;
    }

    public boolean isMatchSegments(String str, String delimiters, boolean exactMatch, List segments) {
        if (segments == null || segments.size() == 0) {
            return false;
        }
        if (exactMatch) {
            String segment1;
            String string = segment1 = segments != null ? (String)segments.get(0) : null;
            return segment1 != null && segment1.equals(str);
        }
        String rem = str;
        int segmentCount = segments != null ? segments.size() : 0;
        boolean[] match = new boolean[segmentCount];
        boolean remainingNeedsMatch = false;
        for (int i = 0; segments != null && i < segments.size(); ++i) {
            String segment = (String)segments.get(i);
            char ch = segment.length() > 0 ? (char)segment.charAt(0) : (char)' ';
            boolean isDelimiter = this.isDelimiter(ch, delimiters);
            if (isDelimiter) {
                remainingNeedsMatch = false;
                match[i] = true;
                continue;
            }
            int idx = rem.indexOf(segment);
            if (idx < 0) break;
            rem = rem.substring(idx + segment.length());
            match[i] = true;
            remainingNeedsMatch = true;
        }
        boolean matched = true;
        for (int i = 0; i < match.length; ++i) {
            if (match[i]) continue;
            matched = false;
            break;
        }
        return matched && !remainingNeedsMatch;
    }
}

