/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.FontMetrics;
import java.io.File;
import java.io.Serializable;
import java.net.URL;

public class StringUtil
implements Serializable {
    public static final String getExceptionMessage(Throwable t) {
        String msg = t.getClass().getName() + " exception. " + t.getMessage();
        return msg;
    }

    public static String getStackTrace(Throwable aThrowable) {
        String stack = StringUtil.getStackTrace(aThrowable, "\n");
        return stack;
    }

    public static String getStackTrace(Throwable t, String lineBreak) {
        if (t == null) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        StackTraceElement[] elms = t.getStackTrace();
        String msg = StringUtil.getMessage(t);
        b.append(msg + lineBreak);
        for (int i = 0; elms != null && i < elms.length; ++i) {
            String codeLine = elms[i].toString();
            b.append(codeLine + lineBreak);
        }
        return b.toString();
    }

    public static final String getMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable orgT = t;
        String msg = null;
        while (t != null && (msg = t.getMessage()) == null) {
            t = t.getCause();
        }
        if (msg == null) {
            msg = orgT.toString();
        }
        return msg;
    }

    public static final String truncateString(String value, int maxWidth, FontMetrics fm) {
        int valueWidth = GraphicsUtil.stringWidth(fm.getFont(), value);
        if (valueWidth <= maxWidth) {
            return value;
        }
        String dots = "...";
        int allowedWidth = maxWidth;
        String retStr = "";
        for (int len = value.length(); len >= 0; --len) {
            String currStr = value.substring(0, len);
            int strWidth = GraphicsUtil.stringWidth(fm.getFont(), currStr);
            if (strWidth > allowedWidth) continue;
            retStr = currStr;
            break;
        }
        if (retStr.length() > 3) {
            return retStr.substring(0, retStr.length() - 3) + dots;
        }
        if (retStr.length() == 3) {
            return dots;
        }
        if (retStr.length() == 2) {
            return "..";
        }
        if (retStr.length() == 1) {
            return ".";
        }
        if (retStr.length() == 0) {
            return "";
        }
        return "";
    }

    public static String trimDoubleQuotes(String string) {
        if (string == null) {
            return null;
        }
        string = StringUtil.trimLeadingCharacter(string, "\"");
        string = StringUtil.trimTrailingCharacter(string, "\"");
        return string;
    }

    public static String trimLeadingCharacter(String string, String c) {
        if (string == null) {
            return null;
        }
        if (string.startsWith(c)) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    public static final String trimTrailingCharacter(String string, String c) {
        if (string == null) {
            return null;
        }
        if (string.endsWith(c)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static final String getDirectoryPathFromFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            String fileName = file.getAbsolutePath();
            if (fileName == null) {
                return null;
            }
            String fileSep = System.getProperty("file.separator");
            int lastFileSepIdx = fileName.lastIndexOf(fileSep);
            if (lastFileSepIdx >= 0) {
                String dir = fileName.substring(0, lastFileSepIdx + 1);
                return dir;
            }
            return fileName;
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
            return null;
        }
    }

    public static String getWhiteSpaceEnabledURL(String urlStr) {
        if (urlStr == null) {
            return urlStr;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; urlStr != null && i < urlStr.length(); ++i) {
            char c = urlStr.charAt(i);
            if (c == ' ') {
                buf.append("%20");
                continue;
            }
            buf.append(c);
        }
        String retStr = buf.toString();
        return retStr;
    }

    public static String decodeWhiteSpaces(String urlStr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; urlStr != null && i < urlStr.length(); ++i) {
            char c1 = urlStr.charAt(i);
            int c2 = 110;
            int c3 = 97;
            try {
                c2 = urlStr.charAt(i + 1);
                c3 = urlStr.charAt(i + 2);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (c1 == '%' && c2 == 50 && c3 == 48) {
                buf.append(' ');
                i += 2;
                continue;
            }
            buf.append(c1);
        }
        return buf.toString();
    }

    public static final URL getURL(String source) throws Throwable {
        String urlStr = StringUtil.getWhiteSpaceEnabledURL(source);
        URL url = null;
        if (url == null) {
            try {
                url = new URL(urlStr);
            }
            catch (Throwable t) {
                File f = new File(urlStr);
                url = f.toURL();
            }
        }
        return url;
    }
}

