/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.utils;

import com.activetree.common.utils.AtDebug;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class WebUtil
implements Serializable {
    public static String getProtocol(HttpServletRequest req) throws IOException {
        String protocol = req.getProtocol();
        String scheme = req.getScheme();
        if (scheme != null && scheme.length() > 0) {
            protocol = scheme;
        }
        if (protocol == null) {
            throw new RuntimeException("No protocol.");
        }
        return protocol;
    }

    public static boolean isHttps(HttpServletRequest req) throws IOException {
        String protocol = WebUtil.getProtocol(req);
        String urlLowerCase = protocol.toLowerCase();
        int httpsIdx = urlLowerCase.indexOf("https");
        return httpsIdx == 0;
    }

    public static String getEndPointURLString(HttpServletRequest req) throws IOException {
        String protocol = WebUtil.getProtocol(req);
        String host = req.getServerName();
        String port = ":" + req.getServerPort();
        if (port.equalsIgnoreCase(":80") || port.equalsIgnoreCase(":443")) {
            port = "";
        }
        String baseUrlStr = protocol + "://" + host + port;
        return baseUrlStr;
    }

    public static String getCodeBaseURLString(HttpServletRequest req) throws IOException {
        String contextPath = req.getContextPath();
        String epUrl = WebUtil.getEndPointURLString(req);
        String baseUrlStr = epUrl + contextPath;
        return baseUrlStr;
    }

    public static String toHttpsUrl(String urlString) {
        if (urlString == null) {
            return null;
        }
        String httpPrefix = "http:";
        String httpsPrefix = "https:";
        String urlLowerCase = urlString.toLowerCase();
        int httpsIdx = urlLowerCase.indexOf(httpsPrefix);
        if (httpsIdx == -1) {
            String subStr = urlString.substring(httpPrefix.length());
            String httpsUrlStr = httpsPrefix + subStr;
            return httpsUrlStr;
        }
        return urlString;
    }

    public static String getUrlStringXXX(String paramName, String queryString) {
        return null;
    }

    public static String getUrlString(String paramName, String paramValue) {
        int endIdx;
        AtDebug.debug("parseUrlValue() => [" + paramValue + "]");
        String qStr = paramValue;
        if (qStr == null || qStr.length() == 0 || qStr.equalsIgnoreCase("null")) {
            return "";
        }
        String tempQStr = qStr.toLowerCase();
        int len = paramName.length();
        int keyIdx = tempQStr.indexOf(paramName.toLowerCase());
        if (keyIdx < 0) {
            return null;
        }
        tempQStr = qStr;
        String substr = tempQStr.substring(keyIdx + (len + 1));
        int beginIdx = (substr = substr.trim()).length() > 0 && substr.charAt(0) == '[' ? 0 : -1;
        int n = endIdx = beginIdx == 0 ? substr.indexOf(93) : -1;
        if (beginIdx == -1) {
            AtDebug.debug("beginIdx is -1 => try as simple doc wihtout []");
            int idx = substr.indexOf(38);
            if (idx > 0) {
                StringTokenizer tempTk = new StringTokenizer(substr, "&");
                try {
                    substr = tempTk.nextToken();
                }
                catch (Throwable t) {}
            } else {
                substr = substr.trim();
            }
        } else {
            substr = substr.substring(beginIdx + 1, endIdx);
        }
        return substr;
    }

    public static String parseDocListParam(String paramName, String docString) {
        AtDebug.debug("parseDocListParam() => [" + docString + "]");
        String qStr = docString;
        if (qStr == null || qStr.length() == 0 || qStr.equalsIgnoreCase("null")) {
            return "";
        }
        String tempQStr = qStr.toLowerCase();
        if (tempQStr.indexOf(paramName.toLowerCase()) < 0) {
            String docTag = "DOCUMENT=";
            int docIdx = tempQStr.indexOf(docTag = docTag.toLowerCase());
            if (docIdx >= 0) {
                String s = qStr.substring(docIdx + docTag.length());
                AtDebug.debug("substring s=|" + s + "|");
                int endIdx = -1;
                if (s.charAt(0) == '[') {
                    endIdx = s.indexOf(93);
                    if (endIdx >= 0) {
                        s = s.substring(0, endIdx + 1);
                    }
                } else {
                    endIdx = s.indexOf(38);
                    if (endIdx >= 0) {
                        s = s.substring(0, endIdx);
                        s = "[" + s + "]";
                    }
                }
                AtDebug.debug("DOCUMENT tag was detected; value \"" + s + "\"");
                return s;
            }
            AtDebug.debug("No DOC_LIST as well as DOCUMENT prefix in doc url...doc docs to process");
            return null;
        }
        int len = paramName.length();
        int keyIdx = tempQStr.indexOf(paramName.toLowerCase());
        tempQStr = qStr;
        String docListStr = tempQStr.substring(keyIdx + (len + 1));
        docListStr = docListStr.trim();
        int beginIdx = docListStr.indexOf(91);
        int endIdx = docListStr.lastIndexOf(93);
        if (beginIdx == -1) {
            AtDebug.debug("beginIdx is -1 => try as simple doc wihtout []");
            String ts = null;
            int idx = docListStr.indexOf(38);
            if (idx > 0) {
                StringTokenizer tempTk = new StringTokenizer(docListStr, "&");
                try {
                    ts = tempTk.nextToken();
                }
                catch (Throwable t) {}
            } else {
                ts = docListStr.trim();
            }
            try {
                String orgTs = ts;
                ts = ts.toLowerCase();
                if (ts.indexOf("http") >= 0 || ts.indexOf("file") >= 0 || ts.indexOf("ftp") >= 0) {
                    docListStr = orgTs;
                    beginIdx = 0;
                    endIdx = docListStr.length() - 1;
                }
            }
            catch (Throwable t) {}
        } else {
            docListStr = docListStr.substring(beginIdx + 1, endIdx);
        }
        AtDebug.debug("Before parse to begin docListStr: " + docListStr);
        if (beginIdx < 0 || endIdx < 0) {
            AtDebug.debug("beginIdx=" + beginIdx + ", endIdx=" + endIdx);
            AtDebug.debug("Malformedattr=\"" + paramName + "\" docListStr=\"" + docListStr + "\"");
            return null;
        }
        StringTokenizer tk = new StringTokenizer(docListStr, "[]");
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        while (tk.hasMoreTokens()) {
            String doc = tk.nextToken();
            doc = doc.trim();
            list.add(doc);
            AtDebug.debug("doc-" + count + ":" + doc);
            ++count;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            buf.append("[");
            buf.append((String)list.get(i));
            buf.append("]");
        }
        String docList = buf.toString();
        AtDebug.debug("Parsed...docList: " + docList);
        return docList;
    }

    public static List getDocListParameter(String docs) {
        Vector<String> values = new Vector<String>();
        if (docs == null) {
            docs = "";
        }
        StringTokenizer tk = new StringTokenizer(docs, "[]");
        while (tk.hasMoreTokens()) {
            String t = tk.nextToken();
            t = t.trim();
            values.add(t);
            AtDebug.debug("\"" + t + "\"");
        }
        AtDebug.debug("getDocListParameter() got values..." + values);
        return values;
    }
}

