/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.action.AtViewerActionListener;
import com.activetree.common.attr.PrintAttributes;
import com.activetree.common.attr.ViewerControlCommands;
import com.activetree.common.attr.WebDocAttributes;
import com.activetree.common.conversion.ConversionFactory;
import com.activetree.common.doc.DocEvent;
import com.activetree.common.doc.DocListener;
import com.activetree.common.doc.DocPageable;
import com.activetree.common.doc.OnLoadProperty;
import com.activetree.common.doc.PrintDialog;
import com.activetree.common.exception.AtUserActionVetoException;
import com.activetree.common.object.KeyValueObject;
import com.activetree.common.object.PasswordProvider;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.print.AbstractPrinter;
import com.activetree.common.print.dialog.AtPrintDialog;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.resource.AtImageList;
import com.activetree.common.swing.ActionTextField;
import com.activetree.common.swing.AtFileChooser;
import com.activetree.common.swing.AtImageCellWidget;
import com.activetree.common.swing.AtIntegerTypeDocument;
import com.activetree.common.swing.AtToggleButton;
import com.activetree.common.swing.AtURLEditDialog;
import com.activetree.common.swing.AutoInputCombo;
import com.activetree.common.swing.CustomScrollPane;
import com.activetree.common.swing.ImageOutputSetupDialog;
import com.activetree.common.swing.ProxyDialog;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.CursorUtil;
import com.activetree.common.utils.MediaUtil;
import com.activetree.common.utils.StringUtil;
import com.activetree.common.viewer.AbstractThumbnailsView;
import com.activetree.common.viewer.AtStatusCell;
import com.activetree.common.viewer.DocPasswordProviderDialog;
import com.activetree.common.viewer.MultiPageView;
import com.activetree.common.viewer.StatusBarControl;
import com.activetree.common.viewer.UIDocListener;
import com.activetree.common.web.BasicWebDoc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.JTextComponent;

public abstract class AbstractDocumentViewer
extends JPanel
implements WebDocAttributes,
PrintAttributes,
ViewerControlCommands {
    final BasicWebDoc webDoc = new BasicWebDoc();
    protected static final String WINDOW_BOUNDS = "WindowBounds";
    protected static final String THUMBNAILS_VISIBLE = "ThumbnailsVisible";
    protected static final String LAST_OPENED_DIRECTORY = "LastOpenedDirectory";
    public static final int CLOCKWISE = 1;
    public static final int ANTICLOCKWISE = 2;
    public static final int ZOOMIN = 1;
    public static final int ZOOMOUT = 2;
    public static final int ZOOM_TO_NORMAL = 3;
    public static final int ZOOM_FROM_COMBO = 4;
    public static final int ZOOM_EXTERNAL = 5;
    public static final int LIMIT_MAXIMUM = 1;
    public static final int LIMIT_MINIMUM = 2;
    public static final int LIMIT_NORMAL = 5;
    protected final Vector unselectableCommandList = new Vector();
    protected final Vector onLoadProperties = new Vector();
    protected String userPrefPropertiesName = null;
    protected String entryPrefix = null;
    public static final OnLoadProperty PROPERTY_ON_LOAD_SHOW_FIRST_PAGE = new OnLoadProperty("OnLoad_ShowFirstPage", new Boolean(true));
    public static final OnLoadProperty PROPERTY_ON_LOAD_SHOW_LAST_PAGE = new OnLoadProperty("OnLoad_ShowLastPage", new Boolean(true));
    public static final OnLoadProperty PROPERTY_ON_LOAD_SHOW_PAGE_INDEX = new OnLoadProperty("OnLoad_ShowPageIndex", new Boolean(true));
    public static final OnLoadProperty PROPERTY_ON_LOAD_FIT_TO_WIDTH = new OnLoadProperty("OnLoad_FitToWidth", new Boolean(true));
    public static final OnLoadProperty PROPERTY_ON_LOAD_FIT_TO_HEIGHT = new OnLoadProperty("OnLoad_FitToHeight", new Boolean(true));
    public static final OnLoadProperty PROPERTY_ON_LOAD_FIT_TO_WINDOW = new OnLoadProperty("OnLoad_FitToWindow", new Boolean(true));
    public static final OnLoadProperty PROPERTY_ON_LOAD_ROTATION_CLOCKWISE = new OnLoadProperty("OnLoad_RotationClockwise", new Integer(90));
    public static final OnLoadProperty PROPERTY_ON_LOAD_ROTATION_ANTI_CLOCKWISE = new OnLoadProperty("OnLoad_RotationAntiClockwise", new Integer(-90));
    public static final Cursor DEFAULT_CURSOR = CursorUtil.DEFAULT_CURSOR;
    public static final Cursor HAND_CLOSED_CURSOR = CursorUtil.HAND_CLOSED_CURSOR;
    public static final Cursor HAND_OPEN_CURSOR = CursorUtil.HAND_OPEN_CURSOR;
    public static final Cursor WAIT_CURSOR = CursorUtil.WAIT_CURSOR;
    public static final Cursor URL_CURSOR = CursorUtil.URL_CURSOR;
    protected AbstractPrinter docPrinter;
    protected AbstractPage[] pages;
    protected int currPageIndex = 0;
    protected Container container;
    protected JLabel pageNo;
    protected boolean thumbnailsVisible = true;
    protected int lastDividerLocation = -1;
    protected JScrollPane pageScroller;
    protected AbstractThumbnailsView thumbnailsView;
    protected PasswordProvider passwordProvider;
    protected MultiPageView pageView;
    protected JSplitPane splitPane;
    protected JScrollPane thumbnailsScroller;
    protected int splitLocation = 110;
    protected int dividerThickness = 3;
    protected int mouseWheelScrollAmount = 25;
    protected Dimension size = new Dimension(780, 500);
    protected AutoInputCombo locationCombo;
    protected StatusBarControl statusBar;
    protected final JTabbedPane leftTab = new JTabbedPane(1);
    protected String pageOf = " " + AtCommonResource.MESSAGE_RESOURCE.getText("PAGE_OF") + " ";
    protected boolean restoreUserPreferences = true;
    protected double minZoom = 0.2;
    protected double maxZoom = 5.0;
    protected double zoom = 1.0;
    protected double zoomPercentChange = 0.1;
    protected Vector zoomToolBars = new Vector();
    protected boolean singlePageMode = false;
    protected AtImageCellWidget locationButton;
    protected AtImageCellWidget editUrlListButton;
    protected AtImageCellWidget fileOpen;
    protected AtImageCellWidget thumbnails;
    protected AtImageCellWidget goToFirstPage;
    protected AtImageCellWidget next;
    protected AtImageCellWidget previous;
    protected AtImageCellWidget goToLastPage;
    protected AtImageCellWidget zoomin;
    protected AtImageCellWidget zoomout;
    protected AtImageCellWidget hundreadPercentView;
    protected AtImageCellWidget singlePageLayout;
    protected AtImageCellWidget continousPageLayout;
    protected AtImageCellWidget print;
    protected AtImageCellWidget pdf;
    protected AtImageCellWidget png;
    protected AtImageCellWidget jpeg;
    protected AtImageCellWidget bmp;
    protected AtImageCellWidget help;
    protected AtImageCellWidget close;
    protected AtImageCellWidget rotateClockwiseButton;
    protected AtImageCellWidget rotateAntiClockwiseButton;
    protected AtImageCellWidget fitToWidthButton;
    protected AtImageCellWidget fitToHeightButton;
    protected AtImageCellWidget fitToPageButton;
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu viewMenu;
    protected JMenu helpMenu;
    protected JMenuItem fitToWidthMenu;
    protected JMenuItem fitToHeightMenu;
    protected JMenuItem fitToPageMenu;
    protected JMenuItem rotateClockwiseMenu;
    protected JMenuItem rotateAnticlockwiseMenu;
    protected JMenuItem locationMenuItem;
    protected JMenuItem fileOpenMenuItem;
    protected JMenuItem thumbnailsMenuItem;
    protected JMenuItem nextMenuItem;
    protected JMenuItem previousMenuItem;
    protected JMenuItem goToFirstPageMenuItem;
    protected JMenuItem goToLastPageMenuItem;
    protected JMenuItem zoominMenuItem;
    protected JMenuItem zoomoutMenuItem;
    protected JMenuItem goToPageMenuItem;
    protected JMenuItem hundreadPercentViewMenuItem;
    protected JMenuItem singlePageLayoutMi;
    protected JMenuItem continousPageLayoutMi;
    protected JMenuItem printMenuItem;
    protected JMenuItem pdfMenuItem;
    protected JMenuItem pngMenuItem;
    protected JMenuItem jpegMenuItem;
    protected JMenuItem bmpMenuItem;
    protected JMenuItem helpMenuItem;
    protected JMenuItem aboutMenuItem;
    protected JMenuItem proxyMenuItem;
    protected JMenuItem closeMenuItem;
    protected JMenuItem editUrlListMenuItem;
    protected JTextField printField;
    protected JToolBar locationBar;
    protected JToolBar fileToolBar;
    protected JToolBar thumbnailsBar;
    protected JToolBar browseBar;
    protected JToolBar pageLayoutBar;
    protected JToolBar zoomBar;
    protected JToolBar printBar;
    protected JToolBar rotateBar;
    protected JComboBox percentCombo;
    protected KeyValueObject[] percentValues;
    protected final Hashtable controlsMap = new Hashtable();
    protected final Hashtable cmdMap = new Hashtable();
    protected ComponentListener resizeListener;
    protected boolean onLoad = false;
    protected PrintDialog printDialog;
    protected boolean enableThumbnailsLoading = false;
    protected JTextField pageField;
    protected boolean pageViewCreated = false;
    protected boolean isEnabledDiabledButtons = false;
    protected JLabel totalPageLabel = new JLabel("/0   "){

        public Font getFont() {
            Font f = super.getFont();
            if (f != null) {
                f = f.deriveFont(0);
            }
            return f;
        }
    };
    protected JLabel urlAddressLabel;
    ActionListener controlActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            AbstractDocumentViewer.this.notifyControlActionClients(e);
        }
    };
    private Vector listeners = new Vector();
    protected boolean isAlreadyAdded = false;
    protected DefaultComboBoxModel locationComboModel = new DefaultComboBoxModel();
    protected Rectangle windowBounds = null;
    protected Boolean thumbnailsFromProperties = null;
    protected String directoryToOpen;
    protected Object dataSource;
    protected static final int PNG = 1;
    protected static final int JPEG = 2;
    protected static final int JPG = 3;
    protected static final int BMP = 4;
    protected static final int GIF = 5;
    protected boolean firstTimeLoadingADocument = true;
    protected boolean isActionListenerAdded = false;
    protected Vector actionListeners = new Vector();
    protected AtFileChooser chooser;
    protected Provider provider = new Provider();
    protected boolean toolbarCreated = false;
    protected boolean thumbnailsCreated = false;
    protected String proxyHost;
    protected String proxyPort;
    protected String proxtSet = "true";
    protected Timer gcTimer;
    protected TimerTask task;
    protected int delay = 10000;
    protected final UIDocListener progressIndicator = new UIDocListener();
    protected String lastUrl = null;
    protected boolean pageViewMouseDragged = false;
    protected boolean tnViewMouseDragged = false;
    private boolean stopping = false;
    protected JComponent toolBarPane;
    protected JComponent locationPane;
    protected JComponent toolsPane;
    private boolean controlsCached = false;
    protected AbstractDocumentViewer viewPane = this;
    protected ImageOutputSetupDialog pngFileDialog = null;
    protected ImageOutputSetupDialog jpgFileDialog = null;
    protected ImageOutputSetupDialog bmpFileDialog = null;

    public void setAttribute(String attr, Object attrValue) {
        this.webDoc.setAttribute(attr, attrValue);
    }

    public Object getAttribute(String attr) {
        return this.webDoc.getAttribute(attr);
    }

    public Map getDefaultAttributes() {
        return null;
    }

    public void clean() {
        try {
            this.webDoc.clean();
            if (this.passwordProvider instanceof DocPasswordProviderDialog) {
                ((DocPasswordProviderDialog)this.passwordProvider).setOwner(null);
            }
            if (this.actionListeners != null) {
                this.actionListeners.clear();
                this.actionListeners = null;
            }
            if (this.cmdMap != null) {
                this.cmdMap.clear();
            }
            this.printDialog = null;
            if (this.controlsMap != null) {
                this.controlsMap.clear();
            }
            if (this.listeners != null) {
                this.listeners.clear();
            }
            if (this.pageView != null) {
                this.pageView.clean();
                this.pageView = null;
            }
            if (this.printDialog != null) {
                this.printDialog = null;
            }
            if (this.webDoc != null) {
                this.webDoc.clean();
            }
            this.viewPane = null;
            this.statusBar = null;
            if (this.zoomToolBars != null) {
                this.zoomToolBars.clear();
                this.zoomToolBars = null;
            }
            this.docPrinter.close();
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
    }

    public AbstractDocumentViewer(boolean restoreUserPreferences, boolean enableThumbnailsLoading) {
        this.initUserPreferenceProperties();
        this.passwordProvider = this.createPasswordProvider();
        this.docPrinter = this.createDocumentPrinter();
        this.docPrinter.setPasswordProvider(this.passwordProvider);
        this.restoreUserPreferences = restoreUserPreferences;
        this.enableThumbnailsLoading = enableThumbnailsLoading;
        this.percentValues = this.createZoomComboValueList();
        if (restoreUserPreferences) {
            this.loadUserPreferences();
        }
        this.resizeListener = this.createComponentResizeListener();
        this.setupContentPane(null);
        this.postInit();
        this.setResizeListenerEnabled(true);
    }

    public AbstractPrinter getDocPrinter() {
        return this.docPrinter;
    }

    protected void viewResized() {
        if (this.isFitPageToWidthOnViewResize()) {
            this.fitPageToViewWidth();
        } else if (this.isFitPageToHeightOnViewResize()) {
            this.fitPageToViewHeight();
        } else if (this.isFitPageToWindowOnViewResize()) {
            this.fitToPage();
            this.unselectAllControls();
            this.selectControl("FIT_TO_WINDOW_CMD", true);
        } else if (this.isHundredPercentView()) {
            this.hundreadPercentViewActionPerformed();
        }
    }

    protected abstract void initUserPreferenceProperties();

    protected abstract AbstractPrinter createDocumentPrinter();

    protected void postInit() {
        this.unselectableCommandList.clear();
        this.unselectableCommandList.add("FIT_TO_WIDTH_CMD");
        this.unselectableCommandList.add("FIT_TO_HEIGHT_CMD");
        this.unselectableCommandList.add("FIT_TO_WINDOW_CMD");
        this.unselectableCommandList.add("HUNDREAD_PERCENT_CMD");
        this.unselectableCommandList.add("ZOOM_CHANGE_CMD");
        this.unselectableCommandList.add("ZOOMIN_CMD");
        this.unselectableCommandList.add("ZOOMOUT_CMD");
        this.pageNo = new JLabel("0", 10);
    }

    protected abstract PrintDialog createPrintDialog();

    protected abstract void addTabSelectionChangeListener(JTabbedPane var1);

    protected abstract void populateLeftTabbedPane(JTabbedPane var1);

    protected boolean isPageSizeChanged(int lastPageIndex, int currPageIndex) {
        if (lastPageIndex < 0 || currPageIndex < 0) {
            return false;
        }
        try {
            AbstractPage lastPage = this.getDisplayedPage();
            AbstractPage currPage = this.pages[currPageIndex];
            Rectangle2D lastPageArea = lastPage.getPrintableArea();
            Rectangle2D currPageArea = currPage.getPrintableArea();
            if (lastPageArea.getWidth() != currPageArea.getWidth()) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    protected void applyOnLoadProperties() {
        this.setOnLoad(false);
        for (int i = 0; this.onLoadProperties != null && i < this.onLoadProperties.size(); ++i) {
            OnLoadProperty aProperty = (OnLoadProperty)this.onLoadProperties.get(i);
            if (aProperty.getProperty().equals(PROPERTY_ON_LOAD_FIT_TO_WIDTH.getProperty())) {
                this.onLoadFitToWidth(aProperty);
                continue;
            }
            if (aProperty.getProperty().equals(PROPERTY_ON_LOAD_FIT_TO_HEIGHT.getProperty())) {
                this.onLoadFitToHeight(aProperty);
                continue;
            }
            if (aProperty.getProperty().equals(PROPERTY_ON_LOAD_FIT_TO_WINDOW.getProperty())) {
                this.onLoadFitToWindow(aProperty);
                continue;
            }
            if (aProperty.getProperty().equals(PROPERTY_ON_LOAD_ROTATION_CLOCKWISE.getProperty())) {
                this.onLoadRotateClockwise(aProperty);
                continue;
            }
            if (!aProperty.getProperty().equals(PROPERTY_ON_LOAD_ROTATION_ANTI_CLOCKWISE.getProperty())) continue;
            this.onLoadRotateAntiClockwise(aProperty);
        }
    }

    protected int getOnLoadPageToDisplay(AbstractPage[] pages) {
        for (int i = 0; this.onLoadProperties != null && i < this.onLoadProperties.size(); ++i) {
            OnLoadProperty aProperty = (OnLoadProperty)this.onLoadProperties.get(i);
            if (aProperty.getProperty().equals(PROPERTY_ON_LOAD_SHOW_FIRST_PAGE.getProperty())) {
                return 0;
            }
            if (aProperty.getProperty().equals(PROPERTY_ON_LOAD_SHOW_LAST_PAGE.getProperty())) {
                if (pages == null) continue;
                int pIndex = pages.length - 1;
                if (pIndex < 0) {
                    return 0;
                }
                return pIndex;
            }
            if (!aProperty.getProperty().equals(PROPERTY_ON_LOAD_SHOW_PAGE_INDEX.getProperty())) continue;
            int pageIndex = (Integer)aProperty.getPropertyValue();
            if (pageIndex < 0) {
                return 0;
            }
            if (pageIndex > pages.length - 1) {
                return pages.length - 1;
            }
            return pageIndex;
        }
        return 0;
    }

    protected void onLoadRotateAntiClockwise(OnLoadProperty property) {
        Integer i;
        if (property != null && (i = (Integer)property.getPropertyValue()) != null && i >= 0) {
            if (this.pages == null || this.pages.length == 0) {
                return;
            }
            int rotationDegrees = i;
            this.pageView.rotate(2, rotationDegrees, false);
        }
    }

    protected void onLoadRotateClockwise(OnLoadProperty property) {
        Integer i;
        if (property != null && (i = (Integer)property.getPropertyValue()) != null && i >= 0) {
            if (this.pages == null || this.pages.length == 0) {
                return;
            }
            int rotationDegrees = i;
            this.pageView.rotate(1, rotationDegrees, false);
        }
    }

    protected void onLoadFitToWindow(OnLoadProperty property) {
        Boolean b;
        if (property != null && (b = (Boolean)property.getPropertyValue()) != null && b.booleanValue()) {
            this.fitToPage();
        }
    }

    protected void onLoadFitToHeight(OnLoadProperty property) {
        Boolean b;
        if (property != null && (b = (Boolean)property.getPropertyValue()) != null && b.booleanValue()) {
            this.fitPageToViewHeight();
        }
    }

    protected void onLoadFitToWidth(OnLoadProperty property) {
        Boolean b;
        if (property != null && (b = (Boolean)property.getPropertyValue()) != null && b.booleanValue()) {
            this.fitPageToViewWidth();
        }
    }

    public void saveUserPreferences() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.locationCombo.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String key = this.entryPrefix + i;
            properties.put(key, model.getElementAt(i));
        }
        Rectangle windowBounds = this.getBounds();
        Window window = AtComponentUtil.getWindowForComponent(this);
        if (window != null) {
            windowBounds = window.getBounds();
        }
        String windowBbox = windowBounds.x + " " + windowBounds.y + " " + windowBounds.width + " " + windowBounds.height;
        properties.put(WINDOW_BOUNDS, windowBbox);
        AtDebug.debug("saveUserPreferences()...saved windowBounds=" + windowBbox);
        String isThumbnailsVisible = "true";
        if (!this.thumbnailsVisible) {
            isThumbnailsVisible = "false";
        }
        properties.put(THUMBNAILS_VISIBLE, isThumbnailsVisible);
        String lastOpenedDirectory = ".";
        if (this.directoryToOpen != null) {
            lastOpenedDirectory = this.directoryToOpen;
        }
        properties.put(LAST_OPENED_DIRECTORY, lastOpenedDirectory);
        FileOutputStream out = null;
        try {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                String urlPropFile = userHome + System.getProperty("file.separator") + this.userPrefPropertiesName;
                out = new FileOutputStream(urlPropFile);
            }
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        if (out != null) {
            try {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)properties);
                p.store(out, this.entryPrefix + " - User preferences");
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
        }
    }

    public abstract void showDocument(Object var1);

    protected boolean loadSource(Object source, AbstractPrinter printer) {
        printer.close();
        if (this.passwordProvider instanceof DocPasswordProviderDialog) {
            ((DocPasswordProviderDialog)this.passwordProvider).setDocument(this.getDocumentSource());
        }
        this.startAnimation(source);
        Pageable newPages = null;
        try {
            this.setLicenseKey();
            newPages = printer.getPageable(source);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (newPages == null || newPages.getNumberOfPages() == 0 || printer.hasError()) {
            JOptionPane.showMessageDialog(this, printer.getErrorMessage(), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
            this.stopAnimation(printer);
            return false;
        }
        this.statusBar.setMessage(AtCommonResource.MESSAGE_RESOURCE.getText("RECEIVED_DOCUMENT_INFORMATION"));
        AbstractPage[] allPages = new AbstractPage[newPages.getNumberOfPages()];
        for (int pageIdx = 0; pageIdx < allPages.length; ++pageIdx) {
            allPages[pageIdx] = (AbstractPage)newPages.getPrintable(pageIdx);
        }
        this.pages = allPages;
        this.totalPageLabel.setText(this.getTotalPageLabel(this.pages.length));
        this.statusBar.setMessage(AtCommonResource.MESSAGE_RESOURCE.getText("FINISHED_READING_DOCUMENT"));
        this.setOnLoad(true);
        this.setupContentPane(this.pages);
        this.setThumbnailsLoadingStatus(false);
        String urlDisplay = "";
        if (source instanceof URL) {
            urlDisplay = URLDecoder.decode(source.toString());
        } else if (source instanceof File) {
            urlDisplay = ((File)source).getAbsolutePath();
        } else if (source instanceof String) {
            urlDisplay = (String)source;
        }
        this.locationCombo.setSelectedItem(urlDisplay);
        this.stopAnimation(printer);
        Runnable r = new Runnable(){

            public void run() {
                AbstractDocumentViewer.this.setThumbnailsLoadingStatus(true);
            }
        };
        SwingUtilities.invokeLater(r);
        return true;
    }

    protected void startAnimation(Object pdfSource) {
        ImageIcon icon = null;
        String message = null;
        if (pdfSource instanceof File) {
            icon = AtImageList.IMAGE_LIST.WEB_LOADING;
            message = AtCommonResource.MESSAGE_RESOURCE.getText("FILE_LOADING");
        } else if (pdfSource instanceof URL) {
            icon = AtImageList.IMAGE_LIST.WEB_LOADING;
            message = AtCommonResource.MESSAGE_RESOURCE.getText("WEB_LOADING");
        } else if (pdfSource instanceof byte[]) {
            icon = AtImageList.IMAGE_LIST.WEB_LOADING;
            message = AtCommonResource.MESSAGE_RESOURCE.getText("BYTE_LOADING");
        }
        this.statusBar.startAnimation(icon, message);
    }

    protected void stopAnimation(AbstractPrinter pdfPrinter) {
        ImageIcon statusIcon = null;
        String statusMessage = null;
        ImageIcon msgIcon = null;
        if (pdfPrinter.hasError()) {
            statusIcon = AtImageList.IMAGE_LIST.WEB_LOADING;
            msgIcon = AtImageList.IMAGE_LIST.ERROR_STATUS;
            statusMessage = pdfPrinter.getErrorMessage();
        } else {
            statusIcon = AtImageList.IMAGE_LIST.WEB_LOADING;
            msgIcon = AtImageList.IMAGE_LIST.DOC_LOAD;
            statusMessage = AtCommonResource.MESSAGE_RESOURCE.getText("DONE");
        }
        this.statusBar.getMessageCell().setIcon(msgIcon);
        this.statusBar.stopAnimation(statusIcon, statusMessage);
    }

    protected abstract void setLicenseKey();

    protected abstract void helpActionPerformed(ActionEvent var1);

    protected abstract void aboutActionPerformed(ActionEvent var1);

    protected abstract void saveAsPdfActionPerformed(ActionEvent var1);

    protected abstract AtFileChooser createFileChooser(File var1);

    protected abstract AbstractThumbnailsView createThumbnailsViewPane();

    protected abstract MultiPageView createPageView();

    protected abstract void doTask();

    public void setGCTimerEnabled(boolean enabled) {
        if (enabled) {
            this.setGCTimerEnabled(false);
            this.task = new TimerTask(){

                public void run() {
                    AbstractDocumentViewer.this.doTask();
                }
            };
            this.gcTimer = new Timer(false);
            this.gcTimer.schedule(this.task, this.delay, (long)this.delay);
        } else {
            if (this.gcTimer != null) {
                this.gcTimer.cancel();
            }
            if (this.task != null) {
                this.task.cancel();
            }
            this.gcTimer = null;
            this.task = null;
        }
    }

    protected ComponentListener createComponentResizeListener() {
        ComponentAdapter viewResizeListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                AbstractDocumentViewer.this.viewResized();
            }
        };
        return viewResizeListener;
    }

    protected void loadUserPreferences() {
        AtDebug.debug("loadUserPreferences()");
        FileInputStream is = null;
        try {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                String urlPropFile = userHome + System.getProperty("file.separator") + this.userPrefPropertiesName;
                is = new FileInputStream(urlPropFile);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (is != null) {
            try {
                ArrayList<String> entryKeys = new ArrayList<String>();
                ArrayList<String> entryValues = new ArrayList<String>();
                Properties p = new Properties();
                p.load(is);
                Enumeration<Object> keys = p.keys();
                while (keys != null && keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = p.getProperty(key);
                    if (key == null) continue;
                    if (key.indexOf(this.entryPrefix) >= 0) {
                        entryKeys.add(key);
                        entryValues.add(value);
                        continue;
                    }
                    if (key.indexOf(WINDOW_BOUNDS) >= 0) {
                        StringTokenizer tk = new StringTokenizer(value, " ");
                        try {
                            String x = tk.nextToken();
                            String y = tk.nextToken();
                            String w = tk.nextToken();
                            String h = tk.nextToken();
                            this.windowBounds = new Rectangle();
                            this.windowBounds.x = Integer.parseInt(x);
                            this.windowBounds.y = Integer.parseInt(y);
                            this.windowBounds.width = Integer.parseInt(w);
                            this.windowBounds.height = Integer.parseInt(h);
                        }
                        catch (Throwable tx) {}
                        continue;
                    }
                    if (key.indexOf(THUMBNAILS_VISIBLE) >= 0) {
                        boolean isThumbnails = true;
                        if (value.equals("false")) {
                            isThumbnails = false;
                        }
                        this.thumbnailsFromProperties = new Boolean(isThumbnails);
                        continue;
                    }
                    if (key.indexOf(LAST_OPENED_DIRECTORY) < 0) continue;
                    this.directoryToOpen = value;
                }
                for (int i = entryValues.size() - 1; i >= 0; --i) {
                    String url = (String)entryValues.get(i);
                    this.locationComboModel.addElement(url);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        AtDebug.debug("found windowBounds=" + this.windowBounds);
    }

    protected void setupContentPane(AbstractPage[] allPages) {
        this.pages = allPages;
        int pageCount = 0;
        if (this.pages != null) {
            pageCount = this.pages.length;
        }
        this.createPageViewPane();
        this.pageView.refreshUI(this.isSinglePageMode());
        this.createButtonPane(pageCount);
        this.createTopLevel();
        this.enableDisableButtons();
        this.cacheControls();
        this.addActionListeners();
        this.addWindowListeners();
        if (!this.thumbnailsVisible) {
            this.splitPane.setDividerLocation(0);
            this.splitPane.setDividerSize(0);
        }
        this.validate();
        if (this.pageView != null) {
            this.zoom(3);
        }
        int pageIndexToShow = this.getOnLoadPageToDisplay(allPages);
        this.show(pageIndexToShow);
        if (this.thumbnailsView != null && this.thumbnailsVisible && this.pages != null && this.pages.length > 0) {
            this.reloadThumbnails();
        }
    }

    protected void reloadThumbnails() {
        Runnable r2 = new Runnable(){

            public void run() {
                AbstractDocumentViewer.this.thumbnailsCreated = true;
                if (AbstractDocumentViewer.this.thumbnailsView != null) {
                    AbstractDocumentViewer.this.thumbnailsView.refreshUI();
                }
            }
        };
        SwingUtilities.invokeLater(r2);
    }

    protected void addActionListeners() {
        if (this.isActionListenerAdded) {
            return;
        }
        this.addControlActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    AbstractDocumentViewer.this.notifyViewerControlActionListeners(evt);
                }
                catch (AtUserActionVetoException ex) {
                    AtDebug.debug(1, "User action is vetowed by: " + ex.getClass().getName());
                    return;
                }
                AbstractDocumentViewer.this.performToggleButtonSelection(evt);
                CursorUtil.setCursorToAllPanes(AbstractDocumentViewer.this.viewPane, WAIT_CURSOR);
                String cmd = evt.getActionCommand();
                if (cmd.equals("SHOW_NEXT_PAGE_CMD")) {
                    AbstractDocumentViewer.this.nextActionPerformed(evt);
                } else if (cmd.equals("THUMBNAILS_CMD")) {
                    AbstractDocumentViewer.this.thumbnailsActionPerformed(evt);
                } else if (cmd.equals("SHOW_PREVIOUS_PAGE_CMD")) {
                    AbstractDocumentViewer.this.previousActionPerformed(evt);
                } else if (cmd.equals("GO_FIRST_PAGE_CMD")) {
                    AbstractDocumentViewer.this.goToFirstPageActionPerformed(evt);
                } else if (cmd.equals("GO_LAST_PAGE_CMD")) {
                    AbstractDocumentViewer.this.goToLastPageActionPerformed(evt);
                } else if (cmd.equals("GO_TO_A_PAGE_CMD")) {
                    AbstractDocumentViewer.this.goActionPerformed(evt);
                } else if (cmd.equals("HUNDREAD_PERCENT_CMD")) {
                    AbstractDocumentViewer.this.hundreadPercentViewActionPerformed(evt);
                } else if (cmd.equals("SINGLE_PAGE_LAYOUT_CMD")) {
                    AbstractDocumentViewer.this.singlePageLayoutActionPerformed(evt);
                } else if (cmd.equals("CONTINOUS_PAGE_LAYOUT_CMD")) {
                    AbstractDocumentViewer.this.continousPageLayoutActionPerformed(evt);
                } else if (cmd.equals("ZOOMIN_CMD")) {
                    AbstractDocumentViewer.this.zoominActionPerformed(evt);
                } else if (cmd.equals("ZOOMOUT_CMD")) {
                    AbstractDocumentViewer.this.zoomoutActionPerformed(evt);
                } else if (cmd.equals("PRINT_CMD")) {
                    AbstractDocumentViewer.this.printActionPerformed(evt);
                } else if (cmd.equals("SILENT_PRINT_CMD")) {
                    AbstractDocumentViewer.this.silentPrintActionPerformed(evt);
                } else if (cmd.equals("SAVE_AS_PDF_CMD")) {
                    AbstractDocumentViewer.this.saveAsPdfActionPerformed(evt);
                } else if (cmd.equals("SAVE_AS_PNG_CMD")) {
                    AbstractDocumentViewer.this.savePagesAsPNGActionPerformed(evt);
                } else if (cmd.equals("SAVE_AS_JPEG_CMD")) {
                    AbstractDocumentViewer.this.savePagesAsJPEGActionPerformed(evt);
                } else if (cmd.equals("SAVE_AS_BMP_CMD")) {
                    AbstractDocumentViewer.this.savePagesAsBMPActionPerformed(evt);
                } else if (cmd.equals("SHOW_HELP_CMD")) {
                    AbstractDocumentViewer.this.helpActionPerformed(evt);
                } else if (cmd.equals("ABOUT_CMD")) {
                    AbstractDocumentViewer.this.aboutActionPerformed(evt);
                } else if (cmd.equals("CLOSE_DOCUMENT_CMD")) {
                    AbstractDocumentViewer.this.closeActionPerformed(evt);
                } else if (cmd.equals("OPEN_LOCAL_DOCUMENT_CMD")) {
                    AbstractDocumentViewer.this.fileOpenActionPerformed(evt);
                } else if (cmd.equals("EDIT_DOCUMENT_HISTORY_CMD")) {
                    AbstractDocumentViewer.this.editUrlList(evt);
                } else if (cmd.equals("OPEN_FROM_URL_CMD")) {
                    AbstractDocumentViewer.this.urlOpenActionPerformed(evt);
                } else if (cmd.equals("ROTATE_PAGE_CLOCKWISE_CMD")) {
                    AbstractDocumentViewer.this.clockwiseRotationActionPerformed(evt);
                } else if (cmd.equals("ROTATE_PAGE_ANTICLOCKWISE_CMD")) {
                    AbstractDocumentViewer.this.anticlockwiseRotationActionPerformed(evt);
                } else if (cmd.equals("FIT_TO_WIDTH_CMD")) {
                    AbstractDocumentViewer.this.fitPageToViewWidth(evt);
                } else if (cmd.equals("FIT_TO_HEIGHT_CMD")) {
                    AbstractDocumentViewer.this.fitPageToViewHeight(evt);
                } else if (cmd.equals("FIT_TO_WINDOW_CMD")) {
                    AbstractDocumentViewer.this.fitToPage(evt);
                } else if (cmd.equals("PROXY_SETTINGS_CMD")) {
                    AbstractDocumentViewer.this.proxySettingActionPerformed(evt);
                }
                CursorUtil.setCursorToAllPanes(AbstractDocumentViewer.this.viewPane, DEFAULT_CURSOR);
            }
        });
        this.isActionListenerAdded = true;
    }

    protected void thumbnailsActionPerformed(ActionEvent evt) {
        if (this.thumbnailsVisible) {
            this.lastDividerLocation = this.splitPane.getDividerLocation();
            if (this.splitPane.getLeftComponent() != null) {
                this.splitPane.getLeftComponent().setVisible(false);
            }
            this.splitPane.setDividerLocation(0);
            this.splitPane.setDividerSize(0);
            this.thumbnailsVisible = false;
        } else {
            if (this.splitPane.getLeftComponent() != null) {
                this.splitPane.getLeftComponent().setVisible(true);
            }
            this.splitPane.setDividerLocation(this.lastDividerLocation);
            this.splitPane.setDividerSize(this.dividerThickness);
            this.thumbnailsVisible = true;
        }
        this.splitPane.revalidate();
        this.pageScroller.revalidate();
        this.selectControl("THUMBNAIL_SELECTION_CMD", this.thumbnailsVisible);
        Runnable r = new Runnable(){

            public void run() {
                AbstractDocumentViewer.this.viewResized();
                if (!AbstractDocumentViewer.this.thumbnailsCreated) {
                    AbstractDocumentViewer.this.reloadThumbnails();
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void nextActionPerformed(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        this.setThumbnailsLoadingStatus(false);
        this.showNext();
        Runnable r = new Runnable(){

            public void run() {
                AbstractDocumentViewer.this.setThumbnailsLoadingStatus(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void previousActionPerformed(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        this.setThumbnailsLoadingStatus(false);
        this.showPrevious();
        Runnable r = new Runnable(){

            public void run() {
                AbstractDocumentViewer.this.setThumbnailsLoadingStatus(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void goActionPerformed(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        this.setThumbnailsLoadingStatus(false);
        this.provider.theProvider.goActionPerformed(evt);
        Runnable r = new Runnable(){

            public void run() {
                AbstractDocumentViewer.this.setThumbnailsLoadingStatus(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void goToFirstPageActionPerformed(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        int lastDisplayedPageIndex = this.getDisplayedPageIndex();
        if (lastDisplayedPageIndex == 0) {
            return;
        }
        this.setThumbnailsLoadingStatus(false);
        this.provider.theProvider.goToFirstPageActionPerformed(evt);
        Runnable r = new Runnable(){

            public void run() {
                AbstractDocumentViewer.this.setThumbnailsLoadingStatus(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void goToLastPageActionPerformed(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        int idxToDisplay = this.pages.length - 1;
        int lastDisplayedPageIndex = this.getDisplayedPageIndex();
        if (lastDisplayedPageIndex == idxToDisplay) {
            return;
        }
        this.setThumbnailsLoadingStatus(false);
        this.provider.theProvider.goToLastPageActionPerformed(evt);
        Runnable r = new Runnable(){

            public void run() {
                AbstractDocumentViewer.this.setThumbnailsLoadingStatus(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void hundreadPercentViewActionPerformed(ActionEvent evt) {
        this.hundreadPercentViewActionPerformed();
    }

    protected void singlePageLayoutActionPerformed(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        if (this.isSinglePageMode()) {
            return;
        }
        this.setSingePageMode(true);
        this.pageView.clean();
        this.pageView.refreshUI(this.isSinglePageMode());
        this.pageView.validate();
        this.show(this.currPageIndex);
        this.validate();
    }

    protected void continousPageLayoutActionPerformed(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        if (!this.isSinglePageMode()) {
            return;
        }
        this.setSingePageMode(false);
        this.pageView.clean();
        this.pageView.refreshUI(this.isSinglePageMode());
        this.pageView.validate();
        this.validate();
        this.show(this.currPageIndex);
    }

    public void hundreadPercentViewActionPerformed() {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        this.zoom(3);
        int pageIndex = this.getDisplayedPageIndex();
        if (this.thumbnailsView != null) {
            this.thumbnailsView.setThumbnailSelectionIndex(pageIndex);
        }
        this.selectControl("HUNDREAD_PERCENT_CMD", true);
    }

    protected void zoominActionPerformed(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        this.zoom(1);
        int pageIndex = this.getDisplayedPageIndex();
        if (this.thumbnailsView != null) {
            this.thumbnailsView.setThumbnailSelectionIndex(pageIndex);
        }
    }

    protected void zoomoutActionPerformed(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        this.zoom(2);
        int pageIndex = this.getDisplayedPageIndex();
        if (this.thumbnailsView != null) {
            this.thumbnailsView.setThumbnailSelectionIndex(pageIndex);
        }
    }

    protected void clockwiseRotationActionPerformed(ActionEvent evt) {
        this.rotateClockwise();
    }

    public void rotateClockwise() {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        this.pageView.rotate(1, 90, true);
        this.viewResized();
    }

    protected void anticlockwiseRotationActionPerformed(ActionEvent evt) {
        this.rotateAnticlockwise();
    }

    public void rotateAnticlockwise() {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        this.pageView.rotate(2, 90, true);
        this.viewResized();
    }

    protected void fitPageToViewWidth(ActionEvent evt) {
        this.fitPageToViewWidth();
    }

    public void fitPageToViewWidth() {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        if (this.pageView != null) {
            this.pageView.cacheResizePreferences();
        }
        double newZoom = this.pageView.getFitToWidthZoom();
        this.pageView.setZoom(newZoom);
        this.zoom = newZoom;
        this.zoom(4);
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        int pageIndex = this.getDisplayedPageIndex();
        if (this.thumbnailsView != null) {
            this.thumbnailsView.setThumbnailSelectionIndex(pageIndex);
        }
        this.selectControl("FIT_TO_WIDTH_CMD", true);
        this.pageView.repaint();
        if (this.pageView != null) {
            Runnable r = new Runnable(){

                public void run() {
                    AbstractDocumentViewer.this.pageView.regainResizePreferences();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void unselectAllControls() {
        Iterator keys = this.cmdMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (key.equals("SINGLE_PAGE_LAYOUT_CMD") || key.equals("CONTINOUS_PAGE_LAYOUT_CMD")) continue;
            ArrayList controlGroup = (ArrayList)this.cmdMap.get(key);
            for (int i = 0; controlGroup != null && i < controlGroup.size(); ++i) {
                Component c = (Component)controlGroup.get(i);
                if (c instanceof AbstractButton) {
                    ((AbstractButton)c).setSelected(false);
                } else if (c instanceof AtToggleButton) {
                    ((AtToggleButton)c).setSelected(false);
                } else if (c instanceof AtImageCellWidget) {
                    ((AtImageCellWidget)c).setSelected(false);
                } else {
                    AtDebug.debug("ERROR: unknown control type to unselect (type: " + c.getClass().getName());
                }
                c.repaint();
            }
        }
    }

    protected void selectControl(String cmd, boolean select) {
        ArrayList controls = (ArrayList)this.cmdMap.get(cmd);
        for (int i = 0; controls != null && i < controls.size(); ++i) {
            Component control = (Component)controls.get(i);
            this.selectControl(control, select);
        }
    }

    protected void selectControl(Component control, boolean select) {
        if (control instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)control;
            ab.setSelected(select);
        } else if (control instanceof AtToggleButton) {
            AtToggleButton tb = (AtToggleButton)control;
            tb.setSelected(select);
        } else {
            AtDebug.debug(control.getClass().getName() + ": unknown control for selection to " + select);
        }
        control.repaint();
    }

    protected void fitPageToViewHeight(ActionEvent evt) {
        this.fitPageToViewHeight();
    }

    public void fitPageToViewHeight() {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        if (this.pageView != null) {
            this.pageView.cacheResizePreferences();
        }
        double newZoom = this.pageView.getFitToHeightZoom();
        this.pageView.setZoom(newZoom);
        this.zoom = newZoom;
        this.zoom(4);
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        int pageIndex = this.getDisplayedPageIndex();
        if (this.thumbnailsView != null) {
            this.thumbnailsView.setThumbnailSelectionIndex(pageIndex);
        }
        this.selectControl("FIT_TO_HEIGHT_CMD", true);
        this.pageView.repaint();
        if (this.pageView != null) {
            Runnable r = new Runnable(){

                public void run() {
                    AbstractDocumentViewer.this.pageView.regainResizePreferences();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void fitToPage(ActionEvent evt) {
        this.fitToPage();
        if (this.pages != null && this.pages.length > 0) {
            this.unselectAllControls();
            this.selectControl("FIT_TO_WINDOW_CMD", true);
        }
        this.pageView.repaint();
    }

    public void fitToPage() {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        boolean widthFit = this.pageView.isWidthFit();
        if (!widthFit) {
            this.fitPageToViewHeight();
        } else {
            this.fitPageToViewWidth();
        }
    }

    public final Vector getSelectedPagesForSaveAs() {
        return this.provider.theProvider.getSelectedPagesForSaveAs(this.pages);
    }

    public int[] getSelectedPagesForPrint() {
        AtPrintDialog printDialog = (AtPrintDialog)this.createPrintDialog();
        int[] range = printDialog.getRange(this.getPageCount(), this.getDisplayedPageIndex() + 1);
        return range;
    }

    protected boolean hasIllegalChars(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (!Character.isLetter(ch)) continue;
            return true;
        }
        return false;
    }

    protected String getFilteredPageString() {
        String value = this.getPrintFieldValue();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == ' ') continue;
            buf.append(ch);
        }
        String filteredStr = buf.toString();
        return filteredStr;
    }

    protected boolean isRangeToken(String token) {
        StringTokenizer tk = new StringTokenizer(token, "-");
        int tokenCount = tk.countTokens();
        return tokenCount >= 2;
    }

    protected Vector getPagesFromRange(String range) {
        StringTokenizer tk = new StringTokenizer(range, "-");
        String startToken = tk.nextToken();
        String endToken = tk.nextToken();
        int startPage = Integer.parseInt(startToken);
        int endPage = Integer.parseInt(endToken);
        Vector<Integer> rangePages = new Vector<Integer>();
        for (int i = startPage; i <= endPage; ++i) {
            rangePages.add(new Integer(i));
        }
        return rangePages;
    }

    protected void printActionPerformed(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        AbstractPage[] allPages = this.pages;
        if (allPages != null) {
            this.provider.theProvider.printActionPerformed(allPages);
        }
    }

    protected void silentPrintActionPerformed(ActionEvent evt) {
    }

    protected void savePagesAsPNGActionPerformed(ActionEvent evt) {
        this.provider.theProvider.savePagesAsPNG();
    }

    protected void savePagesAsJPEGActionPerformed(ActionEvent evt) {
        this.provider.theProvider.savePagesAsJPEG();
    }

    protected void savePagesAsBMPActionPerformed(ActionEvent evt) {
        this.provider.theProvider.savePagesAsBMP();
    }

    protected void centerOnViewPane(Component who) {
        AtComponentUtil.centerOnContainer(this, who);
    }

    protected void editUrlList(ActionEvent evt) {
        ComboBoxModel m = this.locationCombo.getModel();
        String[] items = new String[m.getSize()];
        for (int i = 0; i < items.length; ++i) {
            String aItem;
            items[i] = aItem = (String)m.getElementAt(i);
        }
        String title = AtCommonResource.MESSAGE_RESOURCE.getText("EDIT_HISTORY_BOOK");
        Window window = AtComponentUtil.getWindowForComponent(this);
        AtURLEditDialog dialog = null;
        if (window != null) {
            if (window instanceof Frame) {
                dialog = new AtURLEditDialog(items, (Frame)window, title, true);
            } else if (window instanceof Dialog) {
                dialog = new AtURLEditDialog(items, (Dialog)window, title, true);
            }
        } else {
            dialog = new AtURLEditDialog(items, (Frame)null, title, false);
        }
        dialog.setSize(new Dimension(500, 300));
        this.centerOnViewPane(dialog);
        dialog.setVisible(true);
        if (dialog.isCancelled()) {
            dialog.dispose();
            return;
        }
        if (m instanceof DefaultComboBoxModel) {
            Object currSelection = m.getSelectedItem();
            DefaultComboBoxModel mm = (DefaultComboBoxModel)m;
            mm.removeAllElements();
            for (int i = 0; i < dialog.getItemCount(); ++i) {
                String anItem = (String)dialog.getItemAt(i);
                mm.addElement(anItem);
            }
            this.locationCombo.setSelectedItem(currSelection);
            this.locationCombo.revalidate();
            dialog.dispose();
        }
    }

    protected void proxySettingActionPerformed(ActionEvent evt) {
        DocPasswordProviderDialog auth;
        String title = AtCommonResource.MESSAGE_RESOURCE.getText("PROXY_SETTINGS");
        String msg = AtCommonResource.MESSAGE_RESOURCE.getText("HTTP_PROXY_SETTINGS");
        Window window = AtComponentUtil.getWindowForComponent(this);
        ProxyDialog pd = null;
        pd = window instanceof Dialog ? new ProxyDialog((Dialog)window, title, true, msg) : new ProxyDialog((Frame)window, title, true, msg);
        AtComponentUtil.centerOnContainer(this, pd);
        pd.setVisible(true);
        if (pd != null && pd.isOkPressed()) {
            this.proxyHost = pd.getHostValue();
            if (this.proxyHost != null && this.proxyHost.length() == 0) {
                this.proxyHost = null;
            }
            this.proxyPort = pd.getPortValue();
            if (this.proxyPort != null && this.proxyPort.length() == 0) {
                this.proxyPort = null;
            }
        }
        if (this.proxyHost != null && this.proxyPort != null && (auth = (DocPasswordProviderDialog)this.getPasswordProvider()) != null) {
            auth.setProxyHost(this.proxyHost);
            auth.setProxyPort(this.proxyPort);
            auth.setProxySet("true");
        }
    }

    protected void closeActionPerformed(ActionEvent evt) {
        this.zoom = 1.0;
        this.pageView.clean();
        this.pages = null;
        if (this.thumbnailsView != null) {
            this.thumbnailsView.refreshUI();
            this.thumbnailsCreated = false;
        }
        this.locationCombo.setSelectedItem(AtCommonResource.MESSAGE_RESOURCE.getText("NONE"));
        this.setupContentPane(null);
        this.next.setEnabled(true);
        this.previous.setEnabled(true);
        this.setResizeListenerEnabled(true);
        try {
            this.docPrinter.close();
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
    }

    protected void fileOpenActionPerformed(ActionEvent evt) {
        this.lastUrl = ((JTextField)this.locationCombo.getEditor().getEditorComponent()).getText();
        File fileToOpen = this.openFile();
        if (fileToOpen == null) {
            return;
        }
        JTextField tf = (JTextField)this.locationCombo.getEditor().getEditorComponent();
        String fileName = fileToOpen.getAbsolutePath();
        tf.setText(fileName);
        this.urlOpenActionPerformed(evt);
    }

    protected void urlOpenActionPerformed(ActionEvent evt) {
        this.lastUrl = ((JTextField)this.locationCombo.getEditor().getEditorComponent()).getText();
        String urlString = this.getUrl();
        this.showDocument(urlString);
    }

    protected File openFile() {
        if (this.chooser == null) {
            File directory = new File(".");
            if (this.directoryToOpen != null) {
                directory = new File(this.directoryToOpen);
            }
            this.chooser = this.createFileChooser(directory);
        }
        this.centerOnViewPane(this.chooser.getFileChooser());
        File f = this.chooser.showDialog(1, this);
        if (f == null) {
            return null;
        }
        String fileName = f.getAbsolutePath();
        if (fileName == null) {
            return null;
        }
        String fileSep = System.getProperty("file.separator");
        int idx = fileName.lastIndexOf(fileSep);
        if (idx >= 0) {
            this.directoryToOpen = fileName.substring(0, idx);
        }
        File file = new File(fileName);
        return file;
    }

    String getUrl() {
        String item = this.locationCombo.getEditor().getItem().toString();
        if (item == null) {
            return "";
        }
        return item.toString();
    }

    protected void createButtonPane(int pageCount) {
        if (!this.toolbarCreated) {
            this.createMenusAndButtons(pageCount);
            this.toolsPane = this.createToolbarPane();
            this.toolbarCreated = true;
        }
        if (pageCount <= 0) {
            this.setPrintFieldValue(AtCommonResource.MESSAGE_RESOURCE.getText("ZERO_DASH") + pageCount);
        } else {
            this.setPrintFieldValue(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_DASH") + pageCount);
        }
    }

    protected void createPageViewPane() {
        if (!this.pageViewCreated) {
            if (this.statusBar == null) {
                this.statusBar = this.createStatusPane();
            }
            this.pageView = this.createPageView();
            this.pageView.setFocusable(true);
            this.setGCTimerEnabled(true);
            this.thumbnailsScroller = new CustomScrollPane();
            if (this.isThumbnailsLoadingEnabled()) {
                this.thumbnailsView = this.createThumbnailsViewPane();
                this.thumbnailsScroller.setViewportView(this.thumbnailsView);
                this.thumbnailsView.setAutoPageLoadingOnScrollingEnabled(true);
                this.thumbnailsView.setAutoscrolls(true);
                this.thumbnailsScroller.setWheelScrollingEnabled(true);
                this.thumbnailsScroller.getVerticalScrollBar().setUnitIncrement(this.mouseWheelScrollAmount);
                this.addThumbnailViewMouseWheelListener();
                this.addThumbnailsViewMouseListener(this.thumbnailsView);
                this.addThumbnailsViewDragListener(this.thumbnailsView);
            }
            this.populateLeftTabbedPane(this.leftTab);
            this.pageScroller = new CustomScrollPane(this.pageView);
            this.pageView.setAutoPageLoadingOnScrollingEnabled(true);
            this.pageView.setAutoscrolls(true);
            this.pageScroller.setWheelScrollingEnabled(true);
            this.pageScroller.getVerticalScrollBar().setUnitIncrement(this.mouseWheelScrollAmount);
            this.addPageViewMouseWheelListener();
            this.addPageViewMouseListener(this.pageView);
            this.addPageViewDragListener(this.pageView);
            this.splitPane = new JSplitPane(1, true, this.leftTab, this.pageScroller);
            this.splitPane.setDividerSize(this.dividerThickness);
            this.splitPane.setDividerLocation(this.splitLocation);
            this.addTabSelectionChangeListener(this.leftTab);
            this.pageViewCreated = true;
        }
    }

    public void setSingePageMode(boolean singlePageMode) {
        this.singlePageMode = singlePageMode;
    }

    public boolean isSinglePageMode() {
        return this.singlePageMode;
    }

    protected PasswordProvider createPasswordProvider() {
        DocPasswordProviderDialog auth = new DocPasswordProviderDialog(this);
        auth.setProxyHost(this.proxyHost);
        auth.setProxyPort(this.proxyPort);
        auth.setProxySet("true");
        return auth;
    }

    protected void addPageViewDragListener(MultiPageView pageView) {
        pageView.addMouseMotionListener(new MouseMotionListener(){
            final Point dragPoint = new Point();

            public void mouseDragged(MouseEvent me) {
                if (this.dragPoint == null) {
                    return;
                }
                JScrollBar vBar = AbstractDocumentViewer.this.pageScroller.getVerticalScrollBar();
                JScrollBar hBar = AbstractDocumentViewer.this.pageScroller.getHorizontalScrollBar();
                Point point = new Point((int)me.getPoint().getX() - hBar.getValue(), (int)me.getPoint().getY() - vBar.getValue());
                int x = (int)((double)hBar.getValue() - (point.getX() - this.dragPoint.getX()));
                int y = (int)((double)vBar.getValue() - (point.getY() - this.dragPoint.getY()));
                hBar.setValue(x);
                vBar.setValue(y);
                this.dragPoint.setLocation(point);
                AbstractDocumentViewer.this.pageViewMouseDragged = true;
            }

            public void mouseMoved(MouseEvent me) {
                JScrollBar vbar = AbstractDocumentViewer.this.pageScroller.getVerticalScrollBar();
                JScrollBar hbar = AbstractDocumentViewer.this.pageScroller.getHorizontalScrollBar();
                this.dragPoint.setLocation(me.getPoint().getX() - (double)hbar.getValue(), me.getPoint().getY() - (double)vbar.getValue());
            }
        });
    }

    protected void addPageViewMouseListener(final MultiPageView pageView) {
        pageView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                pageView.grabFocus();
            }

            public void mousePressed(MouseEvent evt) {
                AbstractDocumentViewer.this.pageViewMouseDragged = false;
                pageView.setPageLoadingEnabled(false);
                CursorUtil.setCursorToAllPanes(pageView, HAND_CLOSED_CURSOR);
            }

            public void mouseReleased(MouseEvent evt) {
                pageView.setPageLoadingEnabled(true);
                CursorUtil.setCursorToAllPanes(pageView, HAND_OPEN_CURSOR);
                Runnable r = new Runnable(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (17.access$000(this.this$1).pageViewMouseDragged) {
                            17.access$100(this.this$1).updateControls();
                        }
                    }
                };
                SwingUtilities.invokeLater(r);
            }

            public void mouseExited(MouseEvent evt) {
                CursorUtil.setCursorToAllPanes(pageView, DEFAULT_CURSOR);
            }

            public void mouseEntered(MouseEvent evt) {
                Point mp = evt.getPoint();
                String pageSizeInfo = pageView.getPageSizeInfo(mp);
                String pageInfoTooltip = pageView.getPageSizeInfoTooltip(mp);
                AbstractDocumentViewer.this.statusBar.setPageSizeInfo(pageSizeInfo, pageInfoTooltip);
                CursorUtil.setCursorToAllPanes(pageView, HAND_OPEN_CURSOR);
            }

            static /* synthetic */ AbstractDocumentViewer access$000(17 x0) {
                return x0.AbstractDocumentViewer.this;
            }

            static /* synthetic */ MultiPageView access$100(17 x0) {
                return x0.pageView;
            }
        });
    }

    protected void addPageViewMouseWheelListener() {
        this.pageScroller.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                Runnable r = new Runnable(this){
                    private final /* synthetic */ 19 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        19.access$200(this.this$1).pageView.updateControls();
                    }
                };
                SwingUtilities.invokeLater(r);
            }

            static /* synthetic */ AbstractDocumentViewer access$200(19 x0) {
                return x0.AbstractDocumentViewer.this;
            }
        });
    }

    protected void addThumbnailsViewDragListener(AbstractThumbnailsView tnView) {
        tnView.addMouseMotionListener(new MouseMotionListener(){
            final Point dragPoint = new Point();

            public void mouseDragged(MouseEvent me) {
                if (this.dragPoint == null || AbstractDocumentViewer.this.thumbnailsScroller == null) {
                    return;
                }
                JScrollBar vBar = AbstractDocumentViewer.this.thumbnailsScroller.getVerticalScrollBar();
                JScrollBar hBar = AbstractDocumentViewer.this.thumbnailsScroller.getHorizontalScrollBar();
                Point point = new Point((int)me.getPoint().getX() - hBar.getValue(), (int)me.getPoint().getY() - vBar.getValue());
                int x = (int)((double)hBar.getValue() - (point.getX() - this.dragPoint.getX()));
                int y = (int)((double)vBar.getValue() - (point.getY() - this.dragPoint.getY()));
                hBar.setValue(x);
                vBar.setValue(y);
                this.dragPoint.setLocation(point);
                AbstractDocumentViewer.this.tnViewMouseDragged = true;
            }

            public void mouseMoved(MouseEvent me) {
                if (AbstractDocumentViewer.this.thumbnailsScroller == null) {
                    return;
                }
                JScrollBar vbar = AbstractDocumentViewer.this.thumbnailsScroller.getVerticalScrollBar();
                JScrollBar hbar = AbstractDocumentViewer.this.thumbnailsScroller.getHorizontalScrollBar();
                this.dragPoint.setLocation(me.getPoint().getX() - (double)hbar.getValue(), me.getPoint().getY() - (double)vbar.getValue());
            }
        });
    }

    protected void addThumbnailsViewMouseListener(final AbstractThumbnailsView tnPane) {
        tnPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                tnPane.grabFocus();
            }

            public void mousePressed(MouseEvent evt) {
                AbstractDocumentViewer.this.tnViewMouseDragged = false;
                tnPane.setPageLoadingEnabled(false);
                CursorUtil.setCursorToAllPanes(tnPane, HAND_CLOSED_CURSOR);
            }

            public void mouseReleased(MouseEvent evt) {
                tnPane.setPageLoadingEnabled(true);
                CursorUtil.setCursorToAllPanes(tnPane, DEFAULT_CURSOR);
                Runnable r = new Runnable(this){
                    private final /* synthetic */ 22 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (22.access$300(this.this$1).tnViewMouseDragged) {
                            22.access$400(this.this$1).updateControls();
                        }
                    }
                };
                SwingUtilities.invokeLater(r);
            }

            public void mouseExited(MouseEvent evt) {
            }

            public void mouseEntered(MouseEvent evt) {
            }

            static /* synthetic */ AbstractDocumentViewer access$300(22 x0) {
                return x0.AbstractDocumentViewer.this;
            }

            static /* synthetic */ AbstractThumbnailsView access$400(22 x0) {
                return x0.tnPane;
            }
        });
    }

    protected void addThumbnailViewMouseWheelListener() {
        if (this.thumbnailsScroller == null) {
            return;
        }
        this.thumbnailsScroller.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                Runnable r = new Runnable(this){
                    private final /* synthetic */ 24 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        24.access$500(this.this$1).thumbnailsView.updateControls();
                    }
                };
                SwingUtilities.invokeLater(r);
            }

            static /* synthetic */ AbstractDocumentViewer access$500(24 x0) {
                return x0.AbstractDocumentViewer.this;
            }
        });
    }

    protected void performToggleButtonSelection(ActionEvent evt) {
        if (this.pages == null || this.pages.length == 0) {
            return;
        }
        boolean zoomControlAction = this.isZoomChangeControlAction(evt);
        if (zoomControlAction) {
            this.unselectAllControls();
        }
    }

    protected boolean isZoomChangeControlAction(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        for (int i = 0; i < this.unselectableCommandList.size(); ++i) {
            String aCmd = (String)this.unselectableCommandList.get(i);
            if (!aCmd.equals(cmd)) continue;
            return true;
        }
        return false;
    }

    public void setSplitLocation(int newSplitLocation) {
        this.splitLocation = newSplitLocation;
    }

    public int getSplitLocation() {
        return this.splitLocation;
    }

    public void finalize() {
        this.pages = null;
        this.dataSource = null;
        if (this.zoomToolBars != null) {
            this.zoomToolBars.clear();
        }
    }

    public boolean addViewerControlActionListener(AtViewerActionListener listener) {
        if (!this.actionListeners.contains(listener)) {
            this.actionListeners.add(listener);
        }
        return false;
    }

    public boolean removeViewerControlActionListener(AtViewerActionListener l2) {
        return this.actionListeners.remove(l2);
    }

    public void removeAllViewerControlActionListeners() {
        this.actionListeners.removeAllElements();
    }

    protected void notifyViewerControlActionListeners(ActionEvent evt) throws AtUserActionVetoException {
        for (int i = 0; this.actionListeners != null && i < this.actionListeners.size(); ++i) {
            AtViewerActionListener l2 = (AtViewerActionListener)this.actionListeners.get(i);
            l2.viewerActionPerformed(evt);
        }
    }

    boolean isStopping() {
        return this.stopping;
    }

    public void stopCurrentLoading() {
        this.stopping = true;
        this.zoom = 1.0;
        this.zoom(4);
        this.pageView.clean();
        try {
            this.docPrinter.close();
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
        this.stopping = false;
        ActionEvent closeEvt = new ActionEvent(this.close, 1001, "CLOSE_DOCUMENT_CMD");
        this.closeActionPerformed(closeEvt);
    }

    public void setStatusBarMessage(final String message) {
        Runnable r = new Runnable(){

            public void run() {
                AbstractDocumentViewer.this.statusBar.setMessage(message);
            }
        };
        new Thread(r).start();
    }

    public void setStatusBarIcon(final ImageIcon icon) {
        Runnable r = new Runnable(){

            public void run() {
                AbstractDocumentViewer.this.statusBar.setStatusIcon(icon);
            }
        };
        new Thread(r).start();
    }

    public void destroy() {
        if (this.restoreUserPreferences) {
            this.saveUserPreferences();
            if (this.gcTimer != null) {
                this.setGCTimerEnabled(false);
                this.gcTimer = null;
                this.task = null;
            }
        }
        this.clean();
    }

    public AbstractPage[] getPages() {
        return this.pages;
    }

    public JScrollPane getPagesScroller() {
        return this.pageScroller;
    }

    public void setPages(AbstractPage[] pages) {
        this.pages = pages;
    }

    public Image getPageAsImage() {
        return this.pageView.getPageImage();
    }

    protected void show(int pageIndex) {
        if (pageIndex < 0) {
            return;
        }
        AbstractPage page = null;
        if (this.pages == null || this.pages.length == 0) {
            this.pageView.setPageImage(null);
            this.setCurrentPageLabel(-1);
            this.setPrintFieldValue(String.valueOf(0) + "-" + String.valueOf(0));
            this.setPageFieldValue(0);
            this.pageView.validate();
            this.pageView.repaint();
            return;
        }
        boolean pageSizeChanged = this.isPageSizeChanged(this.getDisplayedPageIndex(), pageIndex);
        page = this.pages[pageIndex];
        double currZoom = this.getCurrentUserSelectedZoom();
        page.setZoom(currZoom);
        this.pageView.setZoom(currZoom);
        if (!this.isOnLoad()) {
            this.pageView.setPage(page, true);
        } else if (this.firstTimeLoadingADocument) {
            this.pageView.setPage(page, true);
            this.firstTimeLoadingADocument = false;
        } else {
            this.pageView.setPage(page, false);
        }
        this.pageSelectionChanged(pageIndex);
        if (this.isOnLoad()) {
            this.applyOnLoadProperties();
        }
        if (pageSizeChanged) {
            this.viewResized();
        }
        this.selectPageLayoutControls();
    }

    protected void selectPageLayoutControls() {
        this.selectControl("SINGLE_PAGE_LAYOUT_CMD", false);
        this.selectControl("CONTINOUS_PAGE_LAYOUT_CMD", false);
        if (this.isSinglePageMode()) {
            this.selectControl("SINGLE_PAGE_LAYOUT_CMD", true);
        } else {
            this.selectControl("CONTINOUS_PAGE_LAYOUT_CMD", true);
        }
    }

    protected void pageSelectionChanged(int pageIndex) {
        this.enableDisableBrowseControls(pageIndex);
        this.currPageIndex = pageIndex;
        this.setCurrentPageLabel(pageIndex);
        this.getPageField().setText(String.valueOf(pageIndex + 1));
    }

    protected void enableDisableBrowseControls(int pageIndex) {
        if (pageIndex == 0) {
            this.previous.setEnabled(false);
            this.previousMenuItem.setEnabled(false);
            this.goToFirstPage.setEnabled(false);
            this.goToFirstPageMenuItem.setEnabled(false);
        } else {
            this.previous.setEnabled(true);
            this.previousMenuItem.setEnabled(true);
            this.goToFirstPage.setEnabled(true);
            this.goToFirstPageMenuItem.setEnabled(true);
        }
        if (pageIndex == this.pages.length - 1) {
            this.next.setEnabled(false);
            this.nextMenuItem.setEnabled(false);
            this.goToLastPage.setEnabled(false);
            this.goToLastPageMenuItem.setEnabled(false);
        } else {
            this.next.setEnabled(true);
            this.nextMenuItem.setEnabled(true);
            this.goToLastPage.setEnabled(true);
            this.goToLastPageMenuItem.setEnabled(true);
        }
    }

    public void printPageIndex(PrintService printerService, PageFormat mediaPageFormat, int pageIndex, int copies, boolean isUsePrinterMargins) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        try {
            pj.setPrintService(printerService);
            DocPageable book = new DocPageable();
            PageFormat validatedPf = AbstractPrinter.getPrinterValidatedPageFormat(pj, mediaPageFormat, isUsePrinterMargins);
            AbstractPage page = this.getPageAt(pageIndex);
            AbstractPage clonedPage = page.newInstance();
            clonedPage.setZoom(1.0);
            PageFormat clonedPf = MediaUtil.getClonedPageFormat(validatedPf);
            clonedPage.setRenderingReason("PageRenderingReasonPrinting");
            clonedPage.setPrinterPageFormat(clonedPf);
            clonedPage.setFitToPrintableArea(true);
            ((Book)book).append(clonedPage, clonedPf, copies);
            pj.setPageable(book);
            String jobName = this.getDocumentName();
            if (jobName == null) {
                jobName = AtCommonResource.MESSAGE_RESOURCE.getText("ACTIVETREE_PRINT_JOB");
            }
            pj.setJobName(jobName);
            MediaUtil.setRenderingReasonforPages(book, "PageRenderingReasonPrinting");
            int pageCount = ((Book)book).getNumberOfPages();
            DocEvent printStartEvent = new DocEvent(null, 21, pageCount, pj.getPrintService());
            this.docPrinter.notifyEvent(printStartEvent);
            HashPrintRequestAttributeSet pSet = new HashPrintRequestAttributeSet();
            pSet.add(PrintQuality.HIGH);
            pj.print(pSet);
            DocEvent printEndedEvent = new DocEvent(null, 22, pageCount, pj.getPrintService());
            this.docPrinter.notifyEvent(printEndedEvent);
            AtDebug.debug("printPageIndex() printed to: " + printerService.getName());
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
    }

    public void printPages(AbstractPage[] pages) {
        this.printPages(pages, 1);
    }

    public void printPages(AbstractPage[] pages, int copies) {
        PageFormat mediaPageFormat = this.getDefaultPrinterPageFormat();
        this.printPages(pages, mediaPageFormat, copies);
    }

    public void printPages(AbstractPage[] pages, PageFormat pageFormat, int copies) {
        PrintService defaultPrinter = PrintServiceLookup.lookupDefaultPrintService();
        this.printPages(pages, defaultPrinter, pageFormat, copies);
    }

    public void printPages(AbstractPage[] pages, PrintService printerService, PageFormat mediaPageFormat, int copies) {
        this.printPages(pages, printerService, mediaPageFormat, copies, true);
    }

    public void printPages(AbstractPage[] pages, PrintService printerService, PageFormat mediaPageFormat, int copies, boolean isUsePrinterMargins) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        try {
            pj.setPrintService(printerService);
            DocPageable book = new DocPageable();
            PageFormat validatedPf = AbstractPrinter.getPrinterValidatedPageFormat(pj, mediaPageFormat, isUsePrinterMargins);
            for (int i = 0; pages != null && i < pages.length; ++i) {
                AbstractPage page = pages[i];
                AbstractPage clonedPage = page.newInstance();
                clonedPage.setZoom(1.0);
                PageFormat clonedPf = MediaUtil.getClonedPageFormat(validatedPf);
                clonedPage.setPrinterPageFormat(clonedPf);
                clonedPage.setFitToPrintableArea(true);
                ((Book)book).append(clonedPage, clonedPf, copies);
            }
            String jobName = this.getDocumentName();
            if (jobName == null) {
                jobName = AtCommonResource.MESSAGE_RESOURCE.getText("ACTIVETREE_PRINT_JOB");
            }
            pj.setJobName(jobName);
            pj.setPageable(book);
            MediaUtil.setRenderingReasonforPages(book, "PageRenderingReasonPrinting");
            int pageCount = ((Book)book).getNumberOfPages();
            DocEvent printStartEvent = new DocEvent(null, 21, pageCount, pj.getPrintService());
            this.docPrinter.notifyEvent(printStartEvent);
            HashPrintRequestAttributeSet pSet = new HashPrintRequestAttributeSet();
            pSet.add(PrintQuality.HIGH);
            pj.print(pSet);
            DocEvent printEndedEvent = new DocEvent(null, 22, pageCount, pj.getPrintService());
            this.docPrinter.notifyEvent(printEndedEvent);
            AtDebug.debug("printPageIndex() printed to: " + printerService.getName());
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
        }
    }

    public PageFormat getDefaultPrinterPageFormat() {
        PageFormat printerSupportedPageFormat = new PageFormat();
        Paper printerSupportedPaper = new Paper();
        printerSupportedPaper.setSize(612.0, 792.0);
        printerSupportedPaper.setImageableArea(0.0, 0.0, printerSupportedPaper.getWidth(), printerSupportedPaper.getHeight());
        printerSupportedPageFormat.setPaper(printerSupportedPaper);
        return printerSupportedPageFormat;
    }

    protected boolean showPrintDialog() {
        this.printDialog = this.createPrintDialog();
        Window window = AtComponentUtil.getWindowForComponent(this.viewPane);
        String currRangeStr = null;
        AtPrintDialog pd = null;
        if (this.printDialog instanceof AtPrintDialog) {
            pd = (AtPrintDialog)this.printDialog;
            pd.getRangeSelectionPane().getRangeOfPageString();
        }
        if (currRangeStr == null || currRangeStr.equals("")) {
            this.printDialog.setTotalPageCount(this.getPageCount());
        }
        AtComponentUtil.centerOnContainer(window, pd);
        boolean okPressed = this.printDialog.showPrintDialog(true, false);
        return okPressed;
    }

    private JComponent createToolbarPane() {
        this.toolBarPane = new JPanel(new FlowLayout(3, 0, 0));
        this.toolBarPane.add(this.fileToolBar);
        this.toolBarPane.add(this.thumbnailsBar);
        this.toolBarPane.add(this.browseBar);
        this.toolBarPane.add(this.printBar);
        this.toolBarPane.add(this.rotateBar);
        this.toolBarPane.add(this.zoomBar);
        this.toolBarPane.add(this.pageLayoutBar);
        this.toolBarPane.setName("toolBarPane");
        this.toolBarPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                AbstractDocumentViewer.this.resizeMyComponent(e);
            }
        });
        this.locationPane = new JPanel(new GridBagLayout());
        this.locationPane.add((Component)this.locationBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel toolsTop = new JPanel(new BorderLayout(0, 0));
        toolsTop.add((Component)this.menuBar, "North");
        toolsTop.add((Component)this.toolBarPane, "Center");
        toolsTop.add((Component)this.locationPane, "South");
        return toolsTop;
    }

    protected void resizeMyComponent(ComponentEvent e) {
        JComponent c = (JComponent)e.getComponent();
        Component[] childs = c.getComponents();
        int rowCount = 1;
        int rowHeight = 0;
        for (int i = 0; childs != null && i < childs.length; ++i) {
            double currRowHeight;
            JComponent comp = (JComponent)childs[i];
            rowHeight = comp.getHeight();
            double cy = comp.getBounds().getCenterY();
            if (!(cy > (currRowHeight = (double)(rowCount * comp.getHeight())))) continue;
            ++rowCount;
        }
        Dimension minSize = new Dimension();
        minSize.width = c.getSize().width;
        minSize.height = rowCount * rowHeight;
        minSize.height += 3;
        c.setPreferredSize(minSize);
    }

    protected void createMenusAndButtons(int pageCount) {
        ActionListener l2 = this.controlActionListener;
        this.fitToWidthButton = this.createFlatToggleButton("FIT_TO_WIDTH_CMD", AtImageList.IMAGE_LIST.FIT_TO_WIDTH, l2);
        this.fitToWidthMenu = new JCheckBoxMenuItem(this.createMenuAction("FIT_TO_WIDTH_CMD", AtImageList.IMAGE_LIST.FIT_TO_WIDTH, l2));
        this.cacheGroupControls("FIT_TO_WIDTH_CMD", new Component[]{this.fitToWidthButton, this.fitToWidthMenu});
        this.fitToHeightButton = this.createFlatToggleButton("FIT_TO_HEIGHT_CMD", AtImageList.IMAGE_LIST.FIT_TO_HEIGHT, l2);
        this.fitToHeightMenu = new JCheckBoxMenuItem(this.createMenuAction("FIT_TO_HEIGHT_CMD", AtImageList.IMAGE_LIST.FIT_TO_HEIGHT, l2));
        this.cacheGroupControls("FIT_TO_HEIGHT_CMD", new Component[]{this.fitToHeightButton, this.fitToHeightMenu});
        this.fitToPageButton = this.createFlatToggleButton("FIT_TO_WINDOW_CMD", AtImageList.IMAGE_LIST.FIT_TO_PAGE, l2);
        this.fitToPageMenu = new JCheckBoxMenuItem(this.createMenuAction("FIT_TO_WINDOW_CMD", AtImageList.IMAGE_LIST.FIT_TO_PAGE, l2));
        this.cacheGroupControls("FIT_TO_WINDOW_CMD", new Component[]{this.fitToPageButton, this.fitToPageMenu});
        this.rotateClockwiseButton = this.createFlatButton("ROTATE_PAGE_CLOCKWISE_CMD", AtImageList.IMAGE_LIST.ROTATE_CLOCKWISE, l2);
        this.rotateClockwiseMenu = new JMenuItem(this.createMenuAction("ROTATE_PAGE_CLOCKWISE_CMD", AtImageList.IMAGE_LIST.ROTATE_CLOCKWISE, l2));
        this.cacheGroupControls("ROTATE_PAGE_CLOCKWISE_CMD", new Component[]{this.rotateClockwiseButton, this.rotateClockwiseMenu});
        this.rotateAntiClockwiseButton = this.createFlatButton("ROTATE_PAGE_ANTICLOCKWISE_CMD", AtImageList.IMAGE_LIST.ROTATE_ANTICLOCKWISE, l2);
        this.rotateAnticlockwiseMenu = new JMenuItem(this.createMenuAction("ROTATE_PAGE_ANTICLOCKWISE_CMD", AtImageList.IMAGE_LIST.ROTATE_ANTICLOCKWISE, l2));
        this.cacheGroupControls("ROTATE_PAGE_ANTICLOCKWISE_CMD", new Component[]{this.rotateAntiClockwiseButton, this.rotateAntiClockwiseButton});
        this.locationButton = this.createFlatButton("OPEN_FROM_URL_CMD", AtImageList.IMAGE_LIST.GO_LIGHT_GREEN, l2);
        this.locationMenuItem = new JMenuItem(this.createMenuAction("OPEN_FROM_URL_CMD", AtImageList.IMAGE_LIST.GO_LIGHT_GREEN, l2));
        this.cacheGroupControls("OPEN_FROM_URL_CMD", new Component[]{this.locationButton, this.locationMenuItem});
        this.editUrlListButton = this.createFlatButton("EDIT_DOCUMENT_HISTORY_CMD", AtImageList.IMAGE_LIST.EDIT_ICON, l2);
        this.editUrlListMenuItem = new JMenuItem(this.createMenuAction("EDIT_DOCUMENT_HISTORY_CMD", AtImageList.IMAGE_LIST.EDIT_ICON, l2));
        this.cacheGroupControls("EDIT_DOCUMENT_HISTORY_CMD", new Component[]{this.editUrlListButton, this.editUrlListMenuItem});
        this.fileOpen = this.createFlatButton("OPEN_LOCAL_DOCUMENT_CMD", AtImageList.IMAGE_LIST.OPEN_16, l2);
        this.fileOpenMenuItem = new JMenuItem(this.createMenuAction("OPEN_LOCAL_DOCUMENT_CMD", AtImageList.IMAGE_LIST.OPEN_16, l2));
        this.cacheGroupControls("OPEN_LOCAL_DOCUMENT_CMD", new Component[]{this.fileOpen, this.fileOpenMenuItem});
        this.thumbnails = this.createFlatButton("THUMBNAILS_CMD", AtImageList.IMAGE_LIST.THUMBNAILS, l2);
        this.thumbnailsMenuItem = new JCheckBoxMenuItem(this.createMenuAction("THUMBNAILS_CMD", AtImageList.IMAGE_LIST.THUMBNAILS, l2));
        this.thumbnailsMenuItem.setSelected(true);
        this.cacheGroupControls("THUMBNAILS_CMD", new Component[]{this.thumbnails, this.thumbnailsMenuItem});
        this.next = this.createFlatButton("SHOW_NEXT_PAGE_CMD", AtImageList.IMAGE_LIST.RIGHT_ARROW_16, l2);
        this.nextMenuItem = new JMenuItem(this.createMenuAction("SHOW_NEXT_PAGE_CMD", AtImageList.IMAGE_LIST.RIGHT_ARROW_16, l2));
        this.cacheGroupControls("SHOW_NEXT_PAGE_CMD", new Component[]{this.next, this.nextMenuItem});
        this.previous = this.createFlatButton("SHOW_PREVIOUS_PAGE_CMD", AtImageList.IMAGE_LIST.LEFT_ARROW_16, l2);
        this.previousMenuItem = new JMenuItem(this.createMenuAction("SHOW_PREVIOUS_PAGE_CMD", AtImageList.IMAGE_LIST.LEFT_ARROW_16, l2));
        this.cacheGroupControls("SHOW_PREVIOUS_PAGE_CMD", new Component[]{this.previous, this.previousMenuItem});
        this.zoomin = this.createFlatButton("ZOOMIN_CMD", AtImageList.IMAGE_LIST.ZOOMIN, l2);
        this.zoominMenuItem = new JMenuItem(this.createMenuAction("ZOOMIN_CMD", AtImageList.IMAGE_LIST.ZOOMIN, l2));
        this.cacheGroupControls("ZOOMIN_CMD", new Component[]{this.zoomin, this.zoominMenuItem});
        this.zoomout = this.createFlatButton("ZOOMOUT_CMD", AtImageList.IMAGE_LIST.ZOOMOUT, l2);
        this.zoomoutMenuItem = new JMenuItem(this.createMenuAction("ZOOMOUT_CMD", AtImageList.IMAGE_LIST.ZOOMOUT, l2));
        this.cacheGroupControls("ZOOMOUT_CMD", new Component[]{this.zoomout, this.zoomoutMenuItem});
        this.goToFirstPage = this.createFlatButton("GO_FIRST_PAGE_CMD", AtImageList.IMAGE_LIST.LEFT_DOUBLE_ARROW_16, l2);
        this.goToFirstPageMenuItem = new JMenuItem(this.createMenuAction("GO_FIRST_PAGE_CMD", AtImageList.IMAGE_LIST.LEFT_DOUBLE_ARROW_16, l2));
        this.cacheGroupControls("GO_FIRST_PAGE_CMD", new Component[]{this.goToFirstPage, this.goToFirstPageMenuItem});
        this.goToLastPage = this.createFlatButton("GO_LAST_PAGE_CMD", AtImageList.IMAGE_LIST.RIGHT_DOUBLE_ARROW_16, l2);
        this.goToLastPageMenuItem = new JMenuItem(this.createMenuAction("GO_LAST_PAGE_CMD", AtImageList.IMAGE_LIST.RIGHT_DOUBLE_ARROW_16, l2));
        this.cacheGroupControls("GO_LAST_PAGE_CMD", new Component[]{this.goToLastPage, this.goToLastPageMenuItem});
        this.hundreadPercentView = this.createFlatToggleButton("HUNDREAD_PERCENT_CMD", AtImageList.IMAGE_LIST.HUNDREAD_PERCENT, l2);
        this.hundreadPercentViewMenuItem = new JCheckBoxMenuItem(this.createMenuAction("HUNDREAD_PERCENT_CMD", AtImageList.IMAGE_LIST.HUNDREAD_PERCENT, l2));
        this.cacheGroupControls("HUNDREAD_PERCENT_CMD", new Component[]{this.hundreadPercentView, this.hundreadPercentViewMenuItem});
        this.singlePageLayout = this.createFlatToggleButton("SINGLE_PAGE_LAYOUT_CMD", AtImageList.IMAGE_LIST.SINGLE_PAGE_LAYOUT, l2);
        this.singlePageLayoutMi = new JCheckBoxMenuItem(this.createMenuAction("SINGLE_PAGE_LAYOUT_CMD", AtImageList.IMAGE_LIST.SINGLE_PAGE_LAYOUT, l2));
        this.cacheGroupControls("SINGLE_PAGE_LAYOUT_CMD", new Component[]{this.singlePageLayout, this.singlePageLayoutMi});
        this.continousPageLayout = this.createFlatToggleButton("CONTINOUS_PAGE_LAYOUT_CMD", AtImageList.IMAGE_LIST.CONTINOUS_PAGE_LAYOUT, l2);
        this.continousPageLayoutMi = new JCheckBoxMenuItem(this.createMenuAction("CONTINOUS_PAGE_LAYOUT_CMD", AtImageList.IMAGE_LIST.CONTINOUS_PAGE_LAYOUT, l2));
        this.continousPageLayoutMi.setSelected(true);
        this.cacheGroupControls("CONTINOUS_PAGE_LAYOUT_CMD", new Component[]{this.continousPageLayout, this.continousPageLayoutMi});
        this.print = this.createFlatButton("PRINT_CMD", AtImageList.IMAGE_LIST.PRINT, l2);
        this.printMenuItem = new JMenuItem(this.createMenuAction("PRINT_CMD", AtImageList.IMAGE_LIST.PRINT, l2));
        this.cacheGroupControls("PRINT_CMD", new Component[]{this.print, this.printMenuItem});
        this.pdf = this.createFlatButton("SAVE_AS_PDF_CMD", AtImageList.IMAGE_LIST.PDF, l2);
        this.pdfMenuItem = new JMenuItem(this.createMenuAction("SAVE_AS_PDF_CMD", AtImageList.IMAGE_LIST.PDF, l2));
        this.cacheGroupControls("SAVE_AS_PDF_CMD", new Component[]{this.pdf, this.pdfMenuItem});
        this.png = this.createFlatButton("SAVE_AS_PNG_CMD", AtImageList.IMAGE_LIST.PNG, l2);
        this.pngMenuItem = new JMenuItem(this.createMenuAction("SAVE_AS_PNG_CMD", AtImageList.IMAGE_LIST.PNG, l2));
        this.cacheGroupControls("SAVE_AS_PNG_CMD", new Component[]{this.png, this.pngMenuItem});
        this.jpeg = this.createFlatButton("SAVE_AS_JPEG_CMD", AtImageList.IMAGE_LIST.JPEG, l2);
        this.jpegMenuItem = new JMenuItem(this.createMenuAction("SAVE_AS_JPEG_CMD", AtImageList.IMAGE_LIST.JPEG, l2));
        this.cacheGroupControls("SAVE_AS_JPEG_CMD", new Component[]{this.jpeg, this.jpegMenuItem});
        this.bmp = this.createFlatButton("SAVE_AS_BMP_CMD", AtImageList.IMAGE_LIST.INSERT_ICON, l2);
        this.bmpMenuItem = new JMenuItem(this.createMenuAction("SAVE_AS_BMP_CMD", AtImageList.IMAGE_LIST.INSERT_ICON, l2));
        this.cacheGroupControls("SAVE_AS_BMP_CMD", new Component[]{this.bmp, this.bmpMenuItem});
        this.help = this.createFlatButton("SHOW_HELP_CMD", AtImageList.IMAGE_LIST.HELP, l2);
        this.helpMenuItem = new JMenuItem(this.createMenuAction("SHOW_HELP_CMD", AtImageList.IMAGE_LIST.HELP, l2));
        this.cacheGroupControls("SHOW_HELP_CMD", new Component[]{this.help, this.helpMenuItem});
        this.aboutMenuItem = new JMenuItem(this.createMenuAction("ABOUT_CMD", null, l2));
        this.cacheGroupControls("ABOUT_CMD", new Component[]{this.aboutMenuItem});
        this.proxyMenuItem = new JMenuItem(this.createMenuAction("PROXY_SETTINGS_CMD", null, l2));
        this.cacheGroupControls("PROXY_SETTINGS_CMD", new Component[]{this.proxyMenuItem});
        this.close = this.createFlatButton("CLOSE_DOCUMENT_CMD", AtImageList.IMAGE_LIST.CLOSE_X, l2);
        this.closeMenuItem = new JMenuItem(this.createMenuAction("CLOSE_DOCUMENT_CMD", AtImageList.IMAGE_LIST.CLOSE_X, l2));
        this.cacheGroupControls("CLOSE_DOCUMENT_CMD", new Component[]{this.close, this.closeMenuItem});
        this.fileMenu = new JMenu(AtCommonResource.MESSAGE_RESOURCE.getText("FILE_MENU"));
        this.fileMenu.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("FILE_MENU"));
        this.viewMenu = new JMenu(AtCommonResource.MESSAGE_RESOURCE.getText("VIEW_MENU"));
        this.viewMenu.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("VIEW_MENU"));
        this.helpMenu = new JMenu(AtCommonResource.MESSAGE_RESOURCE.getText("HELP_MENU"));
        this.helpMenu.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("HELP_MENU"));
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.helpMenu);
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileMenu.add(this.locationMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.editUrlListMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.printMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.pdfMenuItem);
        this.fileMenu.add(this.pngMenuItem);
        this.fileMenu.add(this.jpegMenuItem);
        this.fileMenu.add(this.bmpMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeMenuItem);
        this.viewMenu.add(this.thumbnailsMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.goToFirstPageMenuItem);
        this.viewMenu.add(this.previousMenuItem);
        this.viewMenu.add(this.nextMenuItem);
        this.viewMenu.add(this.goToLastPageMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.rotateClockwiseMenu);
        this.viewMenu.add(this.rotateAnticlockwiseMenu);
        this.viewMenu.add(this.fitToWidthMenu);
        this.viewMenu.add(this.fitToHeightMenu);
        this.viewMenu.add(this.fitToPageMenu);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.zoominMenuItem);
        this.viewMenu.add(this.zoomoutMenuItem);
        this.viewMenu.add(this.hundreadPercentViewMenuItem);
        this.viewMenu.add(this.singlePageLayoutMi);
        this.viewMenu.add(this.continousPageLayoutMi);
        this.helpMenu.add(this.proxyMenuItem);
        this.helpMenu.add(this.aboutMenuItem);
        this.percentCombo = new JComboBox<KeyValueObject>(this.percentValues);
        this.percentCombo.setEditable(true);
        this.percentCombo.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("Select_or_type_the_required_zoom_in_percent"));
        this.percentCombo.setActionCommand("ZOOM_CHANGE_CMD");
        PercentComboActionListener zoomComboListener = new PercentComboActionListener();
        this.percentCombo.addActionListener(zoomComboListener);
        if (this.locationCombo == null) {
            this.locationCombo = new AutoInputCombo(this.locationComboModel, l2, "OPEN_FROM_URL_CMD", this.viewPane);
            this.locationCombo.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText("OPEN_URL_DOCUMENT_FROM_WEB_TOOLTIP"));
        }
        this.pageField = new JTextField(3);
        this.pageField.setDocument(new AtIntegerTypeDocument());
        this.printField = new JTextField(6);
        this.printField.setText(AtCommonResource.MESSAGE_RESOURCE.getText("ONE_DASH") + pageCount);
        this.fileToolBar = new JToolBar("fileToolBar");
        this.fileToolBar.setLayout(new FlowLayout(3, 0, 0));
        this.fileToolBar.setFloatable(false);
        this.fileToolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.fileToolBar.getBackground().darker()));
        this.fileToolBar.add(this.fileOpen);
        this.fileToolBar.add(this.editUrlListButton);
        this.thumbnailsBar = new JToolBar("thumbnailsToolBar");
        this.thumbnailsBar.setLayout(new FlowLayout(3, 0, 0));
        this.thumbnailsBar.setFloatable(false);
        this.thumbnailsBar.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.thumbnailsBar.getBackground().darker()));
        this.thumbnailsBar.add(this.thumbnails);
        this.browseBar = new JToolBar("browseToolBar");
        this.browseBar.setLayout(new FlowLayout(3, 0, 0));
        this.browseBar.setFloatable(false);
        this.browseBar.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.browseBar.getBackground().darker()));
        this.browseBar.add(this.goToFirstPage);
        this.browseBar.add(this.previous);
        this.browseBar.add(this.next);
        this.browseBar.add(this.goToLastPage);
        this.browseBar.add(this.pageField);
        this.browseBar.add(this.totalPageLabel);
        this.printBar = new JToolBar("printToolBar");
        this.printBar.setLayout(new FlowLayout(3, 0, 0));
        this.printBar.setFloatable(false);
        this.printBar.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, this.printBar.getBackground().darker()));
        this.printBar.addSeparator();
        this.printBar.add(this.printField);
        this.printBar.add(this.print);
        this.printBar.add(this.pdf);
        this.printBar.add(this.png);
        this.printBar.add(this.jpeg);
        this.printBar.add(this.bmp);
        this.rotateBar = new JToolBar("rotateToolBar");
        this.rotateBar.setLayout(new FlowLayout(3, 0, 0));
        this.rotateBar.setFloatable(false);
        this.rotateBar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.rotateBar.getBackground().darker()));
        this.rotateBar.add(this.rotateClockwiseButton);
        this.rotateBar.add(this.rotateAntiClockwiseButton);
        this.rotateBar.add(this.fitToWidthButton);
        this.rotateBar.add(this.fitToHeightButton);
        this.rotateBar.add(this.fitToPageButton);
        this.zoomBar = new JToolBar("zoomToolBar");
        this.zoomBar.setLayout(new FlowLayout(3, 0, 0));
        this.zoomBar.setFloatable(false);
        this.zoomBar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, this.zoomBar.getBackground().darker()));
        this.zoomBar.add(this.zoomout);
        this.zoomBar.add(this.zoomin);
        this.zoomBar.add(this.percentCombo);
        this.zoomBar.add(this.hundreadPercentView);
        this.pageLayoutBar = new JToolBar("pageLayoutToolBar");
        this.pageLayoutBar.setLayout(new FlowLayout(3, 0, 0));
        this.pageLayoutBar.setFloatable(false);
        this.pageLayoutBar.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.pageLayoutBar.getBackground().darker()));
        this.pageLayoutBar.add(this.singlePageLayout);
        this.pageLayoutBar.add(this.continousPageLayout);
        this.locationBar = new JToolBar("locationBar");
        this.locationBar.setLayout(new GridBagLayout());
        this.locationBar.setFloatable(false);
        this.urlAddressLabel = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("URL_COLON"));
        this.locationBar.add((Component)this.urlAddressLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 1, new Insets(0, 2, 0, 2), 0, 0));
        this.locationBar.add((Component)this.locationCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 2), 0, 0));
        this.locationBar.add((Component)this.locationButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 1, new Insets(0, 0, 0, 2), 0, 0));
        new ActionTextField(l2, this.printField, "PRINT_CMD", this.viewPane);
        new ActionTextField(l2, this.pageField, "GO_TO_A_PAGE_CMD", this.viewPane);
    }

    public void setZoomComboListener() {
    }

    public void setStatusBarVisible(boolean visible) {
        this.statusBar.statusPane.setVisible(visible);
        this.statusBar.statusPane.invalidate();
    }

    protected KeyValueObject[] createZoomComboValueList() {
        KeyValueObject[] valueList = new KeyValueObject[]{new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("500%"), 500.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("475%"), 475.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("450%"), 450.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("425%"), 425.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("400%"), 400.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("375%"), 375.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("350%"), 350.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("325%"), 325.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("300%"), 300.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("275%"), 275.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("250%"), 250.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("225%"), 225.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("200%"), 200.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("175%"), 175.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("150%"), 150.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("125%"), 125.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("100%"), 100.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("75%"), 75.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("50%"), 50.0), new KeyValueObject(AtCommonResource.MESSAGE_RESOURCE.getText("25%"), 25.0)};
        return valueList;
    }

    public double getCurrentUserSelectedZoom() {
        return this.zoom;
    }

    public void setCurrentUserSelectedZoom(float zoom) {
        this.zoom = zoom;
        if (this.pageView != null) {
            this.zoom(5);
            int pageIndex = this.getDisplayedPageIndex();
            this.show(pageIndex);
            if (this.thumbnailsView != null) {
                this.thumbnailsView.setThumbnailSelectionIndex(pageIndex);
            }
        }
    }

    public AbstractThumbnailsView getThumbnailsView() {
        return this.thumbnailsView;
    }

    protected void resetZoomSelection(double zoom) {
        String zoomPercentString = this.getPercentStringFromZoom(zoom);
        zoomPercentString = zoomPercentString + AtCommonResource.MESSAGE_RESOURCE.getText("PERCENT_CHAR");
        KeyValueObject selItem = new KeyValueObject(zoomPercentString, 100.0 * zoom);
        this.percentCombo.setSelectedItem(selItem);
    }

    protected String getPercentStringFromZoom(double zoom) {
        double percent = zoom * 100.0;
        String zoomPercentString = String.valueOf(percent);
        int dotIdx = zoomPercentString.indexOf(46);
        int fractionPart = 0;
        int intPart = 0;
        if (dotIdx >= 0) {
            String intPartStr = zoomPercentString.substring(0, dotIdx);
            intPart = Integer.parseInt(intPartStr);
            String fractionStr = zoomPercentString.substring(dotIdx + 1);
            if (fractionStr != null) {
                long fractionLong;
                if (fractionStr.length() >= 2) {
                    fractionStr = fractionStr.substring(0, 2);
                }
                fractionPart = (fractionLong = Long.parseLong(fractionStr)) > 50L ? 1 : 0;
            }
        } else {
            intPart = Integer.parseInt(zoomPercentString);
        }
        zoomPercentString = String.valueOf(intPart += fractionPart);
        return zoomPercentString;
    }

    public void setMinimumZoomPercent(int minZoomPercent) {
        this.minZoom = (float)minZoomPercent / 100.0f;
    }

    public double getMinimumZoomPercent() {
        return this.minZoom * 100.0;
    }

    public double getZoomLowerLimit() {
        return this.minZoom;
    }

    public void setZoomLowerLimit(double zoomLowerLimit) {
        this.minZoom = zoomLowerLimit;
    }

    public void setMaximumZoomPercent(int maxZoomPercent) {
        this.maxZoom = (float)maxZoomPercent / 100.0f;
    }

    public double getMaximumZoomPercent() {
        return this.maxZoom * 100.0;
    }

    public void setZoomUpperLimit(double zoomUpperLimit) {
        this.maxZoom = zoomUpperLimit;
    }

    public double getZoomUpperLimit() {
        return this.maxZoom;
    }

    public void setZoomPercentChange(double zoomIncrement) {
        this.zoomPercentChange = zoomIncrement;
    }

    public double getZoomPercentChange() {
        return this.zoomPercentChange;
    }

    protected void zoom(int zoomType) {
        double currZoom = 1.0;
        int limitType = 5;
        if (zoomType == 1) {
            if (this.pages != null && this.pages.length > 0) {
                this.zoom += this.getZoomPercentChange();
            }
            if (this.zoom > this.maxZoom) {
                currZoom = this.zoom;
                limitType = 1;
                this.zoom = this.maxZoom;
            }
        } else if (zoomType == 2) {
            if (this.pages != null && this.pages.length > 0) {
                this.zoom -= this.getZoomPercentChange();
            }
            if (this.zoom < this.minZoom) {
                currZoom = this.zoom;
                limitType = 2;
                this.zoom = this.minZoom;
            }
        } else if (zoomType == 3) {
            this.zoom = 1.0;
        } else if (zoomType == 5 || zoomType == 4) {
            // empty if block
        }
        this.showZoomLimitErrorMessage(currZoom, limitType);
        this.resetZoomSelection(this.zoom);
    }

    public void showZoomLimitErrorMessage(double zoom, int limitType) {
        AtStatusCell messageCell = this.statusBar.statusPane.getStatusCellAt(0);
        String msg = null;
        if (limitType == 1) {
            String zoomPercent = this.getPercentStringFromZoom(zoom);
            zoomPercent = zoomPercent + AtCommonResource.MESSAGE_RESOURCE.getText("PERCENT_CHAR");
            String maxZoomPercent = this.getPercentStringFromZoom(this.maxZoom);
            maxZoomPercent = maxZoomPercent + AtCommonResource.MESSAGE_RESOURCE.getText("PERCENT_CHAR");
            if (messageCell != null) {
                messageCell.setNormalLabelColor(SystemColor.RED);
            }
            msg = AtCommonResource.MESSAGE_RESOURCE.getText("Zoom_in") + " " + zoomPercent + " " + AtCommonResource.MESSAGE_RESOURCE.getText("crossed_maximum_limit") + " " + maxZoomPercent;
        } else if (limitType == 2) {
            String zoomPercent = this.getPercentStringFromZoom(zoom);
            zoomPercent = zoomPercent + AtCommonResource.MESSAGE_RESOURCE.getText("PERCENT_CHAR");
            String minZoomPercent = this.getPercentStringFromZoom(this.minZoom);
            minZoomPercent = minZoomPercent + AtCommonResource.MESSAGE_RESOURCE.getText("PERCENT_CHAR");
            if (messageCell != null) {
                messageCell.setNormalLabelColor(SystemColor.RED);
            }
            msg = AtCommonResource.MESSAGE_RESOURCE.getText("Zoom_out") + " " + zoomPercent + " " + AtCommonResource.MESSAGE_RESOURCE.getText("crossed_minimum_limit") + " " + minZoomPercent;
        } else {
            if (messageCell != null) {
                messageCell.setNormalLabelColor(SystemColor.BLACK);
            }
            msg = "";
        }
        if (messageCell != null) {
            messageCell.setDisplayLabel(msg);
            messageCell.setTooltip(msg);
        }
    }

    public void showNext() {
        if (this.pages == null) {
            int pageIndex = this.currPageIndex + 1;
            OnLoadProperty aProp = new OnLoadProperty(PROPERTY_ON_LOAD_SHOW_PAGE_INDEX.getProperty(), new Integer(pageIndex));
            this.onLoadProperties.add(aProp);
            return;
        }
        if (this.pages.length - 1 >= this.currPageIndex + 1) {
            this.show(this.currPageIndex + 1);
            if (this.thumbnailsView != null) {
                this.thumbnailsView.setThumbnailSelectionIndex(this.getDisplayedPageIndex());
            }
        }
    }

    public void showPrevious() {
        if (this.pages == null) {
            int pageIndex = this.currPageIndex - 1;
            if (pageIndex < 0) {
                pageIndex = 0;
            }
            OnLoadProperty aProp = new OnLoadProperty(PROPERTY_ON_LOAD_SHOW_PAGE_INDEX.getProperty(), new Integer(pageIndex));
            this.onLoadProperties.add(aProp);
            return;
        }
        if (this.currPageIndex - 1 >= 0) {
            this.show(this.currPageIndex - 1);
            if (this.thumbnailsView != null) {
                this.thumbnailsView.setThumbnailSelectionIndex(this.getDisplayedPageIndex());
            }
        }
    }

    public void showLast() {
        if (this.pages == null) {
            this.addOnLoadProperty(PROPERTY_ON_LOAD_SHOW_LAST_PAGE);
            return;
        }
        if (this.pages.length - 1 >= 0) {
            this.show(this.pages.length - 1);
            if (this.thumbnailsView != null) {
                this.thumbnailsView.setThumbnailSelectionIndex(this.getDisplayedPageIndex());
            }
        }
    }

    public void showFirst() {
        if (this.pages == null) {
            this.addOnLoadProperty(PROPERTY_ON_LOAD_SHOW_FIRST_PAGE);
            return;
        }
        this.show(0);
        if (this.thumbnailsView != null) {
            this.thumbnailsView.setThumbnailSelectionIndex(this.getDisplayedPageIndex());
        }
    }

    public void showPageIndex(int pageIndex) {
        if (this.pages == null) {
            OnLoadProperty aProp = new OnLoadProperty(PROPERTY_ON_LOAD_SHOW_PAGE_INDEX.getProperty(), new Integer(pageIndex));
            this.onLoadProperties.add(aProp);
            return;
        }
        if (pageIndex <= this.pages.length - 1) {
            this.show(pageIndex);
            if (this.thumbnailsView != null) {
                this.thumbnailsView.setThumbnailSelectionIndex(pageIndex);
            }
        }
    }

    public int getDisplayedPageIndex() {
        if (this.pages == null) {
            return -1;
        }
        return this.currPageIndex;
    }

    public AbstractPage getDisplayedPage() {
        return this.pages[this.currPageIndex];
    }

    public AbstractPage getPageAt(int idx) {
        return this.pages[idx];
    }

    public int getPageCount() {
        if (this.pages == null) {
            return 0;
        }
        return this.pages.length;
    }

    public Rectangle getUserPreferredViewSize() {
        return this.windowBounds;
    }

    public Dimension getDefaultViewSize() {
        return this.size;
    }

    protected void createTopLevel() {
        if (this.container == null) {
            this.container = this;
            this.container.removeAll();
            this.container.setLayout(new BorderLayout(0, 0));
            this.container.add((Component)this.toolsPane, "North");
            this.container.add((Component)this.statusBar.statusPane, "South");
            this.container.add((Component)this.splitPane, "Center");
        }
    }

    protected void cacheControls() {
        if (this.controlsCached) {
            return;
        }
        this.controlsMap.put("FIT_TO_WIDTH_BUTTON", this.fitToWidthButton);
        this.controlsMap.put("FIT_TO_HEIGHT_BUTTON", this.fitToHeightButton);
        this.controlsMap.put("FIT_TO_WINDOW_BUTTON", this.fitToPageButton);
        this.controlsMap.put("ROTATE_PAGE_CLOCKWISE_BUTTON", this.rotateClockwiseButton);
        this.controlsMap.put("ROTATE_PAGE_ANTICLOCKWISE_BUTTON", this.rotateAntiClockwiseButton);
        this.controlsMap.put("OPEN_FROM_URL_BUTTON", this.locationButton);
        this.controlsMap.put("EDIT_DOCUMENT_HISTORY_BUTTON", this.editUrlListButton);
        this.controlsMap.put("FIRST_PAGE_BUTTON", this.goToFirstPage);
        this.controlsMap.put("PREVIOUS_PAGE_BUTTON", this.previous);
        this.controlsMap.put("NEXT_PAGE_BUTTON", this.next);
        this.controlsMap.put("LAST_PAGE_BUTTON", this.goToLastPage);
        this.controlsMap.put("ZOOMIN_BUTTON", this.zoomin);
        this.controlsMap.put("ZOOMOUT_BUTTON", this.zoomout);
        this.controlsMap.put("HUNDREAD_PERCENT_BUTTON", this.hundreadPercentView);
        this.controlsMap.put("PRINT_BUTTON", this.print);
        this.controlsMap.put("SILENT_PRINT_BUTTON", this.print);
        this.controlsMap.put("SAVE_AS_PDF_BUTTON", this.pdf);
        this.controlsMap.put("SAVE_AS_PNG_BUTTON", this.png);
        this.controlsMap.put("SAVE_AS_JPEG_BUTTON", this.jpeg);
        this.controlsMap.put("SAVE_AS_BMP_BUTTON", this.bmp);
        this.controlsMap.put("HELP_BUTTON", this.help);
        this.controlsMap.put("CLOSE_DOCUMENT_BUTTON", this.close);
        this.controlsMap.put("OPEN_LOCAL_DOCUMENT_BUTTON", this.fileOpen);
        this.controlsMap.put("THUMBNAILS_VIEW_BUTTON", this.thumbnails);
        this.controlsMap.put("SINGLE_PAGE_LAYOUT_BUTTON", this.singlePageLayout);
        this.controlsMap.put("CONTINOUS_PAGE_LAYOUT_BUTTON", this.continousPageLayout);
        this.controlsMap.put("FIT_TO_HEIGHT_MI", this.fitToWidthMenu);
        this.controlsMap.put("FIT_TO_WIDTH_MI", this.fitToHeightMenu);
        this.controlsMap.put("FIT_TO_WINDOW_MI", this.fitToPageMenu);
        this.controlsMap.put("ROTATE_PAGE_CLOCKWISE_MI", this.rotateClockwiseMenu);
        this.controlsMap.put("ROTATE_PAGE_ANTICLOCKWISE_MI", this.rotateAnticlockwiseMenu);
        this.controlsMap.put("OPEN_FROM_URL_MI", this.locationMenuItem);
        this.controlsMap.put("EDIT_DOCUMENT_HISTORY_MI", this.editUrlListMenuItem);
        this.controlsMap.put("FIRST_PAGE_MI", this.goToFirstPageMenuItem);
        this.controlsMap.put("PREVIOUS_PAGE_MI", this.previousMenuItem);
        this.controlsMap.put("NEXT_PAGE_MI", this.nextMenuItem);
        this.controlsMap.put("LAST_PAGE_MI", this.goToLastPageMenuItem);
        this.controlsMap.put("ZOOMIN_MI", this.zoominMenuItem);
        this.controlsMap.put("ZOOMOUT_MI", this.zoomoutMenuItem);
        this.controlsMap.put("HUNDREAD_PERCENT_MI", this.hundreadPercentViewMenuItem);
        this.controlsMap.put("PRINT_MI", this.printMenuItem);
        this.controlsMap.put("SILENT_PRINT_MI", this.printMenuItem);
        this.controlsMap.put("SAVE_AS_PDF_MI", this.pdfMenuItem);
        this.controlsMap.put("SAVE_AS_PNG_MI", this.pngMenuItem);
        this.controlsMap.put("SAVE_AS_JPEG_MI", this.jpegMenuItem);
        this.controlsMap.put("SAVE_AS_BMP_MI", this.bmpMenuItem);
        this.controlsMap.put("SHOW_HELP_MI", this.helpMenuItem);
        this.controlsMap.put("ABOUT_MI", this.aboutMenuItem);
        this.controlsMap.put("PROXY_MI", this.proxyMenuItem);
        this.controlsMap.put("CLOSE_DOCUMENT_MI", this.closeMenuItem);
        this.controlsMap.put("OPEN_LOCAL_DOCUMENT_MI", this.fileOpenMenuItem);
        this.controlsMap.put("THUMBNAILS_VIEW_MI", this.thumbnailsMenuItem);
        this.controlsMap.put("SINGLE_PAGE_LAYOUT_MI", this.singlePageLayoutMi);
        this.controlsMap.put("CONTINOUS_PAGE_LAYOUT_MI", this.continousPageLayoutMi);
        this.controlsMap.put("TOOLS_PANE", this.toolsPane);
        this.controlsMap.put("TOOL_BAR_PANE", this.toolBarPane);
        this.controlsMap.put("TOOL_BAR_LOCATION", this.locationPane);
        this.controlsMap.put("FILE_TOOL", this.fileToolBar);
        this.controlsMap.put("THUMBNAIL_TOOL", this.thumbnailsBar);
        this.controlsMap.put("BROWSE_TOOL", this.browseBar);
        this.controlsMap.put("ZOOM_TOOL", this.zoomBar);
        this.controlsMap.put("PRINT_TOOL", this.printBar);
        this.controlsMap.put("ROTATE_TOOL", this.rotateBar);
        this.controlsMap.put("HELP_TOOL", this.help);
        this.controlsMap.put("PAGE_LAYOUT_TOOL", this.pageLayoutBar);
        this.controlsMap.put("PRINT_RANGE_FIELD", this.printField);
        this.controlsMap.put("ZOOM_CHANGE_COMBO", this.percentCombo);
        this.controlsMap.put("GO_TO_A_PAGE_FIELD", this.pageField);
        this.controlsMap.put("TOTAL_PAGE_LABEL", this.totalPageLabel);
        this.controlsMap.put("URL_ADDRESS_LABEL", this.urlAddressLabel);
        this.controlsMap.put("MENU_BAR_PANE", this.menuBar);
        this.controlsMap.put("FILE_MENU", this.fileMenu);
        this.controlsMap.put("VIEW_MENU", this.viewMenu);
        this.controlsMap.put("HELP_MENU", this.helpMenu);
        this.controlsMap.put("STATUS_BAR", this.statusBar.statusPane);
        this.controlsMap.put("LEFT_TAB", this.leftTab);
        this.controlsCached = true;
    }

    public Iterator getControlNames() {
        if (this.controlsMap != null) {
            return this.controlsMap.keySet().iterator();
        }
        return null;
    }

    protected void enableDisableButtons() {
        if (!this.isEnabledDiabledButtons) {
            this.isEnabledDiabledButtons = true;
        }
    }

    protected void addWindowListeners() {
        if (this.isAlreadyAdded) {
            return;
        }
        this.setFocusable(true);
        if (this.thumbnailsFromProperties != null) {
            this.thumbnailsVisible = this.thumbnailsFromProperties;
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                AbstractDocumentViewer.this.size = e.getComponent().getSize();
            }
        });
        this.locationCombo.setSelectedItem(AtCommonResource.MESSAGE_RESOURCE.getText("NONE"));
        this.isAlreadyAdded = true;
    }

    public Object getDocumentSource() {
        return this.dataSource;
    }

    public int getInputType() {
        return -1;
    }

    public String getDocumentName() {
        if (this.dataSource instanceof byte[]) {
            return AtCommonResource.MESSAGE_RESOURCE.getText("DATA_BYTES");
        }
        if (this.dataSource instanceof String) {
            return this.getFilePart((String)this.dataSource);
        }
        if (this.dataSource instanceof File) {
            String s = ((File)this.dataSource).getAbsolutePath();
            return this.getFilePart(s);
        }
        if (this.dataSource instanceof URL) {
            String s = ((URL)this.dataSource).toString();
            return this.getFilePart(s);
        }
        if (this.dataSource != null) {
            return this.dataSource.toString();
        }
        return null;
    }

    private String getFilePart(String s) {
        if (s == null) {
            return null;
        }
        int idx = s.lastIndexOf(47);
        if (idx < 0) {
            idx = s.lastIndexOf(92);
        }
        if (idx >= 0) {
            return s.substring(idx + 1);
        }
        return s;
    }

    public PasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    public MultiPageView getPageView() {
        return this.pageView;
    }

    public void addOnLoadProperty(OnLoadProperty property) {
        if (!this.onLoadProperties.contains(property)) {
            this.onLoadProperties.add(property);
        }
    }

    public boolean hasOnLoadProperty(OnLoadProperty p) {
        return this.onLoadProperties.contains(p);
    }

    public void removeOnLoadProperty(OnLoadProperty property) {
        this.onLoadProperties.remove(property);
    }

    public void removeAllOnLoadProperties() {
        this.onLoadProperties.clear();
    }

    public void setThumbnailSelectionIndex(int pageIndex) {
        if (this.thumbnailsView != null) {
            this.thumbnailsView.setThumbnailSelectionIndex(pageIndex);
        }
    }

    public JScrollPane getThumbnailsScroller() {
        return this.thumbnailsScroller;
    }

    public void setLocationComboVisible(boolean visible) {
        this.locationCombo.setVisible(visible);
        this.locationCombo.invalidate();
    }

    public void setLeftUtilityPaneVisible(boolean visible) {
        this.leftTab.setVisible(visible);
        this.leftTab.revalidate();
        if (!visible) {
            this.splitPane.setDividerSize(0);
            this.lastDividerLocation = this.splitPane.getDividerLocation();
        } else {
            this.splitPane.setDividerSize(this.dividerThickness);
            this.splitPane.setDividerLocation(this.lastDividerLocation);
            this.splitPane.invalidate();
        }
    }

    public void setPagesPaneVisible(boolean visible) {
        if (!visible) {
            this.leftTab.removeTabAt(0);
            this.leftTab.revalidate();
        } else {
            this.leftTab.addTab(AtCommonResource.MESSAGE_RESOURCE.getText("PAGES_MSG"), this.thumbnailsScroller);
            this.leftTab.revalidate();
        }
    }

    public void setLocationBarGoButtonVisible(boolean visible) {
        this.locationButton.setVisible(visible);
        this.locationButton.revalidate();
    }

    public void setEditUrlListButtonVisbile(boolean visible) {
        this.editUrlListButton.setVisible(visible);
        this.editUrlListButton.revalidate();
    }

    public void setOpenButtonVisible(boolean visible) {
        this.fileOpen.setVisible(visible);
        this.fileOpen.revalidate();
    }

    public void setThumbnailsButtonVisible(boolean visible) {
        this.thumbnails.setVisible(visible);
        this.thumbnails.revalidate();
    }

    public void setGoFirstButtonVisible(boolean visible) {
        this.goToFirstPage.setVisible(visible);
        this.goToFirstPage.revalidate();
    }

    public void setNextButtonVisible(boolean visible) {
        this.next.setVisible(visible);
        this.next.revalidate();
    }

    public void setPreviousButtonVisible(boolean visible) {
        this.previous.setVisible(visible);
        this.previous.revalidate();
    }

    public void setGoLastButtonVisible(boolean visible) {
        this.goToLastPage.setVisible(visible);
        this.goToLastPage.revalidate();
    }

    public void setGotoPageNumberField(boolean visible) {
        this.pageField.setVisible(visible);
        this.pageField.revalidate();
    }

    public void setTotalPageLabelVisible(boolean visible) {
        this.totalPageLabel.setVisible(visible);
        this.totalPageLabel.revalidate();
    }

    public void setZoominButtonVisible(boolean visible) {
        this.zoomin.setVisible(visible);
        this.zoomin.revalidate();
    }

    public void setZoomoutButtonVisible(boolean visible) {
        this.zoomout.setVisible(visible);
        this.zoomout.revalidate();
    }

    public void setHundreadPercentViewButtonVisible(boolean visible) {
        this.hundreadPercentView.setVisible(visible);
        this.hundreadPercentView.revalidate();
    }

    public void setPrintButtonVisible(boolean visible) {
        this.print.setVisible(visible);
        this.print.revalidate();
    }

    public void setSaveAsPdfButtonVisible(boolean visible) {
        this.pdf.setVisible(false);
        this.pdf.revalidate();
    }

    public void setSaveAsBMPButtonVisible(boolean visible) {
        this.bmp.setVisible(false);
        this.bmp.revalidate();
    }

    public void setPNGButtonVisible(boolean visible) {
        this.png.setVisible(visible);
        this.png.revalidate();
    }

    public void setJPEGButtonVisible(boolean visible) {
        this.jpeg.setVisible(visible);
        this.jpeg.revalidate();
    }

    public void setHelpButtonVisible(boolean visible) {
        this.help.setVisible(visible);
        this.help.revalidate();
    }

    public void setCloseButtonVisible(boolean visible) {
        this.close.setVisible(visible);
        this.close.revalidate();
    }

    public void setRotateClockwiseButtonVisible(boolean visible) {
        this.rotateClockwiseButton.setVisible(visible);
        this.rotateClockwiseButton.revalidate();
    }

    public void setRotateAntiClockwiseButtonVisible(boolean visible) {
        this.rotateAntiClockwiseButton.setVisible(visible);
        this.rotateAntiClockwiseButton.revalidate();
    }

    public void setFitToWidthButtonVisible(boolean visible) {
        this.fitToWidthButton.setVisible(visible);
        this.fitToWidthButton.revalidate();
    }

    public void setFitToHeightButtonVisible(boolean visible) {
        this.fitToHeightButton.setVisible(visible);
        this.fitToHeightButton.revalidate();
    }

    public void setFitToPageButtonVisible(boolean visible) {
        this.fitToPageButton.setVisible(visible);
        this.fitToPageButton.revalidate();
    }

    public void setMenuBarVisible(boolean visible) {
        this.menuBar.setVisible(visible);
        this.menuBar.revalidate();
    }

    public void setFileMenuVisible(boolean visible) {
        this.fileMenu.setVisible(visible);
        this.fileMenu.revalidate();
    }

    public void setViewMenuVisible(boolean visible) {
        this.viewMenu.setVisible(visible);
        this.viewMenu.revalidate();
    }

    public void setHelpMenuVisible(boolean visible) {
        this.helpMenu.setVisible(visible);
        this.helpMenu.revalidate();
    }

    public void setFitToWidthMenuVisible(boolean visible) {
        this.fitToWidthMenu.setVisible(visible);
        this.fitToWidthMenu.revalidate();
    }

    public void setFitToHeightMenuVisible(boolean visible) {
        this.fitToHeightMenu.setVisible(visible);
        this.fitToHeightMenu.revalidate();
    }

    public void setFitToPageMenuVisible(boolean visible) {
        this.fitToPageMenu.setVisible(visible);
        this.fitToPageMenu.revalidate();
    }

    public void setRotateClockwiseMenuVisible(boolean visible) {
        this.rotateClockwiseMenu.setVisible(visible);
        this.rotateClockwiseMenu.revalidate();
    }

    public void setRotateAnticlockwiseMenu(boolean visible) {
        this.rotateAnticlockwiseMenu.setVisible(visible);
        this.rotateAnticlockwiseMenu.revalidate();
    }

    public void setLocationMenuItemVisible(boolean visible) {
        this.locationMenuItem.setVisible(visible);
        this.locationMenuItem.revalidate();
    }

    public void setOpenMenuVisible(boolean visible) {
        this.fileOpenMenuItem.setVisible(visible);
        this.fileOpenMenuItem.revalidate();
    }

    public void setThumbnailsMenuItemVisible(boolean visible) {
        this.thumbnailsMenuItem.setVisible(visible);
        this.thumbnailsMenuItem.revalidate();
    }

    public void setNextMenuItemVisible(boolean visible) {
        this.nextMenuItem.setVisible(visible);
        this.nextMenuItem.revalidate();
    }

    public void setPreviousMenuItemVisible(boolean visible) {
        this.previousMenuItem.setVisible(visible);
        this.previousMenuItem.revalidate();
    }

    public void setGoToFirstMenuItemVisible(boolean visible) {
        this.goToFirstPageMenuItem.setVisible(visible);
        this.goToFirstPageMenuItem.revalidate();
    }

    public void setGoToLastMenuItemVisible(boolean visible) {
        this.goToLastPageMenuItem.setVisible(visible);
        this.goToLastPageMenuItem.revalidate();
    }

    public void setZoominMenuItemVisible(boolean visible) {
        this.zoominMenuItem.setVisible(visible);
        this.zoominMenuItem.revalidate();
    }

    public void setZoomoutMenuItem(boolean visible) {
        this.zoomoutMenuItem.setVisible(visible);
        this.zoomoutMenuItem.revalidate();
    }

    public void setGotoPageMenuItemVisible(boolean visible) {
        this.goToPageMenuItem.setVisible(visible);
        this.goToPageMenuItem.revalidate();
    }

    public void setHundreadPercentViewMenuItemVisible(boolean visible) {
        this.hundreadPercentViewMenuItem.setVisible(visible);
        this.hundreadPercentViewMenuItem.revalidate();
    }

    public void setPrintMenuItem(boolean visible) {
        this.printMenuItem.setVisible(visible);
        this.printMenuItem.revalidate();
    }

    public void setSaveAsPdfMenuItemVisible(boolean visible) {
        this.pdfMenuItem.setVisible(visible);
        this.pdfMenuItem.revalidate();
    }

    public void setPNGMenuItemVisible(boolean visible) {
        this.pngMenuItem.setVisible(visible);
        this.pngMenuItem.revalidate();
    }

    public void setJPEGMenuItemVisible(boolean visible) {
        this.jpegMenuItem.setVisible(visible);
        this.jpegMenuItem.revalidate();
    }

    public void setSaveAsBMPMenuItemVisible(boolean visible) {
        this.bmpMenuItem.setVisible(visible);
        this.bmpMenuItem.revalidate();
    }

    public void setHelpMenuItemVisible(boolean visible) {
        this.helpMenuItem.setVisible(visible);
        this.helpMenuItem.revalidate();
    }

    public void setAboutMenuItemVisible(boolean visible) {
        this.aboutMenuItem.setVisible(visible);
        this.aboutMenuItem.revalidate();
    }

    public void setCloseMenuItem(boolean visible) {
        this.closeMenuItem.setVisible(visible);
        this.closeMenuItem.revalidate();
    }

    public void setEditUrlListMenuItemVisible(boolean visible) {
        this.editUrlListMenuItem.setVisible(visible);
        this.editUrlListMenuItem.revalidate();
    }

    public void setPrintPageEntryFieldVisible(boolean visible) {
        this.printField.setVisible(visible);
        this.printField.revalidate();
    }

    public void setLocationBarVisible(boolean visible) {
        this.locationBar.setVisible(visible);
        this.locationBar.revalidate();
    }

    public void setFileToolbarVisible(boolean visible) {
        this.fileToolBar.setVisible(visible);
        this.fileToolBar.invalidate();
    }

    public void setThumbnailsToolbarVisible(boolean visible) {
        this.thumbnailsBar.setVisible(visible);
        this.thumbnailsBar.revalidate();
    }

    public void setBrowseToolbarVisible(boolean visible) {
        this.browseBar.setVisible(visible);
        this.browseBar.revalidate();
    }

    public void setZoomToolBarVisible(boolean visible) {
        this.zoomBar.setVisible(visible);
        this.zoomBar.revalidate();
    }

    public void setPageToolbarVisible(boolean visible) {
    }

    public void setPrintToolbarVisible(boolean visible) {
        this.printBar.setVisible(visible);
        this.printBar.revalidate();
    }

    public void setRotateToolbarVisible(boolean visible) {
        this.rotateBar.setVisible(visible);
        this.rotateBar.revalidate();
    }

    public void setPercentComboVisible(boolean visible) {
        this.percentCombo.setVisible(visible);
        this.percentCombo.revalidate();
    }

    public boolean isFitPageToWidthOnViewResize() {
        AtImageCellWidget button = (AtImageCellWidget)this.controlsMap.get("FIT_TO_WIDTH_BUTTON");
        if (button != null) {
            return button.isSelected();
        }
        return false;
    }

    public void setFitPageToWidthOnViewResize(boolean resize) {
    }

    public boolean isFitPageToHeightOnViewResize() {
        AtImageCellWidget button = (AtImageCellWidget)this.controlsMap.get("FIT_TO_HEIGHT_BUTTON");
        if (button != null) {
            return button.isSelected();
        }
        return false;
    }

    public boolean isFitPageToWindowOnViewResize() {
        AtImageCellWidget button = (AtImageCellWidget)this.controlsMap.get("FIT_TO_WINDOW_BUTTON");
        if (button != null) {
            return button.isSelected();
        }
        return false;
    }

    public boolean isHundredPercentView() {
        AtImageCellWidget button = (AtImageCellWidget)this.controlsMap.get("HUNDREAD_PERCENT_BUTTON");
        if (button != null) {
            return button.isSelected();
        }
        return false;
    }

    public void setPageViewTooltipEnabled(boolean enabled) {
        this.pageView.setTooltipEnabled(enabled);
    }

    public boolean isPageViewTooltipEnabled() {
        return this.pageView.isTooltipEnabled();
    }

    protected boolean isOnLoad() {
        return this.onLoad;
    }

    protected void setOnLoad(boolean onLoad) {
        this.onLoad = onLoad;
    }

    public void setThumbnailsLoadingStatus(boolean enable) {
        if (this.thumbnailsView != null) {
            this.thumbnailsView.setThumbnailLoadingEnabled(enable);
        }
    }

    public void setThumbnailsLoadingEnabled(boolean enabled) {
        this.enableThumbnailsLoading = enabled;
    }

    public boolean isThumbnailsLoadingEnabled() {
        return this.enableThumbnailsLoading;
    }

    public void addDocListener(DocListener dl) {
        this.docPrinter.addDocListener(dl);
    }

    public void removeDocListener(DocListener dl) {
        this.docPrinter.removeDocListener(dl);
    }

    public void removeAllDocListeners() {
        this.docPrinter.removeAllDocListeners();
    }

    public int getDocListenerCount() {
        return this.docPrinter.getDocListenerCount();
    }

    public DocListener[] getDocListeners() {
        return this.docPrinter.getDocListeners();
    }

    public void setResizeListenerEnabled(boolean resizeListenerEnabled) {
        if (resizeListenerEnabled) {
            if (!this.isResizeListenerEnabled()) {
                this.addComponentListener(this.resizeListener);
                this.addSplitPaneDivierResizeListener(this.resizeListener);
            }
        } else if (this.isResizeListenerEnabled()) {
            this.removeComponentListener(this.resizeListener);
            this.removeSplitPaneDivierResizeListener(this.resizeListener);
        }
    }

    protected void addSplitPaneDivierResizeListener(final ComponentListener l2) {
        SplitPaneUI ui = this.splitPane.getUI();
        if (ui instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI bui = (BasicSplitPaneUI)ui;
            final BasicSplitPaneDivider divider = bui.getDivider();
            divider.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    CursorUtil.setCursorToAllPanes(AbstractDocumentViewer.this.viewPane, CursorUtil.E_RESIZE_CURSOR);
                }

                public void mouseExited(MouseEvent e) {
                    CursorUtil.setCursorToAllPanes(AbstractDocumentViewer.this.viewPane, CursorUtil.DEFAULT_CURSOR);
                }

                public void mouseReleased(MouseEvent e) {
                    l2.componentResized(new ComponentEvent(divider, 1001));
                }
            });
        }
    }

    protected void removeSplitPaneDivierResizeListener(ComponentListener l2) {
        SplitPaneUI ui = this.splitPane.getUI();
        if (ui instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI bui = (BasicSplitPaneUI)ui;
            BasicSplitPaneDivider divider = bui.getDivider();
            divider.removeComponentListener(l2);
        }
    }

    public boolean isResizeListenerEnabled() {
        ComponentListener[] ls = this.pageView.getComponentListeners();
        for (int i = 0; ls != null && i < ls.length; ++i) {
            if (ls[i] != this.resizeListener) continue;
            return true;
        }
        return false;
    }

    protected StatusBarControl createStatusPane() {
        return new StatusBarControl();
    }

    public JComponent getViewerControl(String controlCommandName) {
        JComponent control = (JComponent)this.controlsMap.get(controlCommandName);
        return control;
    }

    public void setAllControlsVisible(boolean visible) {
        Iterator controlNames = this.getControlNames();
        this.makeVisible(controlNames, visible);
    }

    public void makeVisible(Iterator commands, boolean visible) {
        while (commands != null && commands.hasNext()) {
            String cmd = (String)commands.next();
            AtDebug.debug("makeVisible[" + cmd + "] - " + visible);
            this.setViewerControlVisible(cmd, visible);
        }
    }

    protected void setViewerControlVisible(String controlCommandName, boolean visible) {
        JComponent control = (JComponent)this.controlsMap.get(controlCommandName);
        if (control != null) {
            control.setVisible(visible);
            this.makeComponentPathVisible(control, visible);
        }
        if (controlCommandName.equalsIgnoreCase("THUMBNAILS_VIEW_BUTTON") || controlCommandName.equalsIgnoreCase("THUMBNAILS_VIEW_MI")) {
            this.thumbnailsVisible = !visible;
            ActionEvent evt = new ActionEvent(control, 1001, "THUMBNAILS_CMD");
            this.thumbnailsActionPerformed(evt);
            this.validate();
        }
    }

    protected void makeComponentPathVisible(JComponent comp, boolean visible) {
        if (!visible) {
            Container curr;
            if (comp instanceof JMenuItem && (curr = comp.getParent()) instanceof JPopupMenu) {
                this.makeSeparatorVisible(comp, (JPopupMenu)curr, visible);
            }
            return;
        }
        JComponent orgComp = comp;
        Component curr = comp;
        while (curr != null) {
            ((Component)curr).setVisible(visible);
            if (!((curr = curr.getParent()) instanceof JPopupMenu)) continue;
            this.makeSeparatorVisible(orgComp, (JPopupMenu)curr, visible);
            curr = ((JPopupMenu)curr).getInvoker();
        }
    }

    protected void makeSeparatorVisible(Component orgComp, JPopupMenu popop, boolean visible) {
        Component[] subs = popop.getComponents();
        int lastVisSepIdx = -1;
        Component lastSepComp = null;
        for (int i = 0; subs != null && i < subs.length; ++i) {
            Component curr = subs[i];
            if (!(curr instanceof JSeparator)) continue;
            int visCompCount = this.getVisibleComponentCountBetween(lastVisSepIdx, i, subs);
            boolean sepVisible = visCompCount > 0;
            curr.setVisible(sepVisible);
            if (!sepVisible) continue;
            lastVisSepIdx = i;
            lastSepComp = curr;
        }
        int visCountAfterLastSep = this.getVisibleComponentCountBetween(lastVisSepIdx, subs != null ? subs.length : 0, subs);
        if (visCountAfterLastSep == 0 && lastSepComp != null) {
            lastSepComp.setVisible(false);
        }
    }

    protected int getVisibleComponentCountBetween(int idx1, int idx2, Component[] subs) {
        int visCount = 0;
        for (int i = idx1 + 1; subs != null && i < idx2 && i < subs.length; ++i) {
            Component curr = subs[i];
            if (curr instanceof JSeparator || !curr.isVisible()) continue;
            ++visCount;
        }
        return visCount;
    }

    public void setViewerControlEnabled(String buttonName, boolean enable) {
        JMenuItem control = (JMenuItem)this.controlsMap.get(buttonName);
        if (control != null) {
            ((JComponent)control).setEnabled(enable);
        }
    }

    public void setViewerControlTooltipText(String buttonName, String tooltipText) {
        JComponent control = (JComponent)this.controlsMap.get(buttonName);
        if (control != null) {
            control.setToolTipText(tooltipText);
        }
    }

    public void setPreviewButtonImage(String buttonName, ImageIcon buttonImage) {
        JComponent control = (JComponent)this.controlsMap.get(buttonName);
        if (control != null) {
            if (control instanceof AtImageCellWidget) {
                AtImageCellWidget button = (AtImageCellWidget)control;
                button.setIcon(buttonImage);
                button.repaint();
            } else if (control instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)control;
                button.setIcon(buttonImage);
            }
        }
    }

    public void printCurrentPage(boolean showPrinterAndPageSelectionDialog) {
        this.printPageIndex(showPrinterAndPageSelectionDialog, this.getDisplayedPageIndex(), 1);
    }

    public void printPageIndex(boolean showPrinterAndPageSelectionDialog, int pageIndex, int copies) {
        if (showPrinterAndPageSelectionDialog) {
            AbstractPage[] pages = new AbstractPage[]{this.getDisplayedPage()};
            this.printPages(pages, false, copies);
        } else {
            this.printPageIndex(pageIndex, copies);
        }
    }

    public void printPages(AbstractPage[] allPages, boolean showPrinterAndPageSelectionDialog, int copies) {
        this.provider.theProvider.printPages(allPages, showPrinterAndPageSelectionDialog, copies);
    }

    public void printCurrentPage() {
        this.printCurrentPage(1);
    }

    public void printCurrentPage(int copies) {
        this.printPageIndex(this.getDisplayedPageIndex(), copies);
    }

    public void printPageIndex(int pageIndex, int copies) {
        PageFormat mediaPageFormat = this.getDefaultPrinterPageFormat();
        this.printPageIndex(mediaPageFormat, pageIndex, copies);
    }

    public void printPageIndex(PageFormat pageFormat, int pageIndex, int copies) {
        PrintService defaultPrinter = PrintServiceLookup.lookupDefaultPrintService();
        this.printPageIndex(defaultPrinter, pageFormat, pageIndex, copies);
    }

    public void printPageIndex(PrintService printerService, PageFormat mediaPageFormat, int pageIndex, int copies) {
        this.printPageIndex(printerService, mediaPageFormat, pageIndex, copies, true);
    }

    public void addControlActionListener(ActionListener l2) {
        if (!this.listeners.contains(l2)) {
            this.listeners.add(l2);
        }
    }

    public void removeControlActionListener(ActionListener l2) {
        this.listeners.remove(l2);
    }

    protected void notifyControlActionClients(ActionEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.get(i)).actionPerformed(evt);
        }
    }

    protected void setCurrentPageLabel(int pageIndex) {
        String pageInfoLabel = String.valueOf(pageIndex + 1);
        pageInfoLabel = pageInfoLabel + this.pageOf;
        pageInfoLabel = pageInfoLabel + String.valueOf(this.getPageCount());
        this.statusBar.setPageInfo(pageInfoLabel);
    }

    protected String getTotalPageLabel(int pageCount) {
        StringBuffer b = new StringBuffer("/" + String.valueOf(pageCount));
        for (int i = b.length(); i < 4; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    protected void setPrintFieldValue(String value) {
        this.printField.setText(value);
    }

    protected String getPrintFieldValue() {
        return this.printField.getText();
    }

    protected int getPageFieldValue() {
        String pageNoStr = this.pageField.getText();
        if (pageNoStr == null || pageNoStr.equals("")) {
            pageNoStr = AtCommonResource.MESSAGE_RESOURCE.getText("ZERO");
        }
        return Integer.parseInt(pageNoStr);
    }

    protected void setPageFieldValue(int pageNumber) {
        this.pageField.setText(String.valueOf(pageNumber));
    }

    protected JTextField getPageField() {
        return this.pageField;
    }

    protected AtImageCellWidget createFlatButton(String caption, ImageIcon image, ActionListener l2) {
        AtImageCellWidget button = new AtImageCellWidget(image);
        button.setActionCommand(caption);
        button.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getText(caption));
        button.setFocusEnabled(true);
        button.setFont(this.getFont());
        button.addActionListener(l2);
        return button;
    }

    protected AtImageCellWidget createFlatToggleButton(String caption, ImageIcon image, ActionListener l2) {
        AtToggleButton button = new AtToggleButton(image, false){

            protected void toggleSelection() {
            }
        };
        button.setActionCommand(caption);
        button.setToolTipText(AtCommonResource.MESSAGE_RESOURCE.getTooltip(caption));
        button.setFocusEnabled(true);
        button.setFont(this.getFont());
        button.addActionListener(l2);
        return button;
    }

    protected MenuAction createMenuAction(String caption, ImageIcon icon, ActionListener l2) {
        String displayName = AtCommonResource.MESSAGE_RESOURCE.getText(caption);
        char mnemonic = AtCommonResource.MESSAGE_RESOURCE.getMnemonic(caption);
        MenuAction action = new MenuAction(displayName, mnemonic, caption, icon, l2);
        return action;
    }

    protected void cacheGroupControls(String cmd, Component[] controls) {
        ArrayList<Component> group = new ArrayList<Component>();
        for (int i = 0; controls != null && i < controls.length; ++i) {
            Component aControl = controls[i];
            group.add(aControl);
        }
        this.cmdMap.put(cmd, group);
    }

    protected ImageOutputSetupDialog createSaveAsImageDialog(String title, String ext, String description) {
        Window dialog = null;
        Window window = AtComponentUtil.getWindowForComponent(this.viewPane);
        if (window != null) {
            if (window instanceof Frame) {
                dialog = new ImageOutputSetupDialog((Frame)window, title, ext, description, true);
            } else if (window instanceof Dialog) {
                dialog = new ImageOutputSetupDialog((Dialog)window, title, ext, description, true);
            }
        } else {
            dialog = new ImageOutputSetupDialog((Frame)null, title, ext, description, false);
        }
        dialog.pack();
        return dialog;
    }

    class Provider
    implements Serializable {
        TheProvider theProvider = new TheProvider();

        Provider() {
        }

        class TheProvider
        implements Serializable {
            TheProvider() {
            }

            void printPages(AbstractPage[] allPages, boolean showPrinterAndPageSelectionDialog, int copies) {
                boolean fitToMediaImgArea = true;
                boolean choosePaperSouceByPageSize = false;
                boolean isUsePrinterMargins = true;
                boolean collate = true;
                PrintQuality printQuality = PrintQuality.HIGH;
                Sides side = Sides.ONE_SIDED;
                PageFormat userPageFormat = MediaUtil.getDefaultPrinterPageFormat();
                PrintService ps = PrintServiceLookup.lookupDefaultPrintService();
                if (showPrinterAndPageSelectionDialog) {
                    Window window = AtComponentUtil.getWindowForComponent(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane);
                    ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog = AbstractDocumentViewer.this.createPrintDialog();
                    ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.setRange(AbstractDocumentViewer.this.getPageCount());
                    AtComponentUtil.centerOnContainer(window, (AtPrintDialog)((Provider)Provider.this).AbstractDocumentViewer.this.printDialog);
                    boolean print = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.showPrintDialog(true, false);
                    if (!print) {
                        return;
                    }
                    fitToMediaImgArea = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.isFitToPage();
                    choosePaperSouceByPageSize = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.isChoosePaperSourceByPageSize();
                    collate = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.isCollate();
                    userPageFormat = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.getSelectedPageFormat();
                    isUsePrinterMargins = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.isUsePrinterMargins();
                    ps = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.getSelectedPrintService();
                    printQuality = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.getPrintQuality();
                    side = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.getSideToPrint();
                }
                PrinterJob printer = PrinterJob.getPrinterJob();
                try {
                    printer.setPrintService(ps);
                }
                catch (Throwable t) {
                    AtDebug.debug(9, t);
                }
                Book book = new DocPageable();
                for (int i = 0; allPages != null && i < allPages.length; ++i) {
                    AbstractPage page = allPages[i];
                    AbstractPage clonedPage = page.newInstance();
                    clonedPage.setZoom(1.0);
                    PageFormat pfToUse = userPageFormat;
                    if (choosePaperSouceByPageSize) {
                        Rectangle2D printableArea = clonedPage.getPrintableArea();
                        AbstractPrinter cfr_ignored_0 = ((Provider)Provider.this).AbstractDocumentViewer.this.docPrinter;
                        PageFormat autoMatchedPf = AbstractPrinter.getPaperSourceByPageSize(printableArea);
                        if (autoMatchedPf != null) {
                            pfToUse = autoMatchedPf;
                        }
                    }
                    AbstractPrinter cfr_ignored_1 = ((Provider)Provider.this).AbstractDocumentViewer.this.docPrinter;
                    PageFormat validatedPf = AbstractPrinter.getPrinterValidatedPageFormat(printer, pfToUse, isUsePrinterMargins);
                    pfToUse = MediaUtil.getClonedPageFormat(validatedPf);
                    clonedPage.setPrinterPageFormat(pfToUse);
                    clonedPage.setFitToPrintableArea(fitToMediaImgArea);
                    book.append(clonedPage, pfToUse, copies);
                }
                book = MediaUtil.createCollatedCopiesForPrint(book, collate, copies);
                try {
                    printer.setPageable(book);
                }
                catch (Throwable ex) {
                    JOptionPane.showMessageDialog(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane, AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_SERVICE_SET_ERR_MSG"), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
                    return;
                }
                try {
                    String jobName = AbstractDocumentViewer.this.getDocumentName();
                    if (jobName == null) {
                        jobName = AtCommonResource.MESSAGE_RESOURCE.getText("ACTIVETREE_PRINT_JOB");
                    }
                    printer.setJobName(jobName);
                    int pageCount = book.getNumberOfPages();
                    MediaUtil.setRenderingReasonforPages(book, "PageRenderingReasonPrinting");
                    DocEvent printStartEvent = new DocEvent(null, 21, pageCount, printer.getPrintService());
                    ((Provider)Provider.this).AbstractDocumentViewer.this.docPrinter.notifyEvent(printStartEvent);
                    PrintRequestAttributeSet pSet = this.getPrintRequestAttributeSet(printQuality, side);
                    printer.print(pSet);
                    DocEvent printEndedEvent = new DocEvent(null, 22, pageCount, printer.getPrintService());
                    ((Provider)Provider.this).AbstractDocumentViewer.this.docPrinter.notifyEvent(printEndedEvent);
                }
                catch (Throwable e1) {
                    JOptionPane.showMessageDialog(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane, e1.getMessage(), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
                    return;
                }
            }

            PrintRequestAttributeSet getPrintRequestAttributeSet(PrintQuality printQuality, Sides side) {
                HashPrintRequestAttributeSet pSet = new HashPrintRequestAttributeSet();
                pSet.add(printQuality);
                pSet.add(side);
                return pSet;
            }

            void savePagesAsPNG() {
                if (((Provider)Provider.this).AbstractDocumentViewer.this.pages == null || ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length == 0) {
                    return;
                }
                String title = AtCommonResource.MESSAGE_RESOURCE.getText("CREATE_PNG_OUTPUT");
                String pngString = AtCommonResource.MESSAGE_RESOURCE.getText("PNG_EXTENSION");
                String description = AtCommonResource.MESSAGE_RESOURCE.getText("PNG_FILES");
                if (((Provider)Provider.this).AbstractDocumentViewer.this.pngFileDialog == null) {
                    ((Provider)Provider.this).AbstractDocumentViewer.this.pngFileDialog = AbstractDocumentViewer.this.createSaveAsImageDialog(title, pngString, description);
                }
                AbstractDocumentViewer.this.centerOnViewPane(((Provider)Provider.this).AbstractDocumentViewer.this.pngFileDialog);
                ((Provider)Provider.this).AbstractDocumentViewer.this.pngFileDialog.setFileSelectionMode(2);
                ((Provider)Provider.this).AbstractDocumentViewer.this.pngFileDialog.setVisible(true);
                if (!((Provider)Provider.this).AbstractDocumentViewer.this.pngFileDialog.isOkPressed()) {
                    ((Provider)Provider.this).AbstractDocumentViewer.this.pngFileDialog.setVisible(false);
                    return;
                }
                String pngFileName = ((Provider)Provider.this).AbstractDocumentViewer.this.pngFileDialog.getFileName();
                double resizeFactor = ((Provider)Provider.this).AbstractDocumentViewer.this.pngFileDialog.getResizeFactor();
                boolean autoMatchToPaperSize = false;
                int mode = ((Provider)Provider.this).AbstractDocumentViewer.this.pngFileDialog.getOuputMode();
                if (mode == 100) {
                    try {
                        AbstractPage page = AbstractDocumentViewer.this.getDisplayedPage();
                        if (page != null) {
                            page.setRenderingReason("PageRenderingReasonDataConversion");
                        }
                        ConversionFactory.saveAsPNG(AbstractDocumentViewer.this.getDisplayedPage(), pngFileName, resizeFactor, autoMatchToPaperSize);
                    }
                    catch (Throwable t) {
                        AtDebug.debug(9, t);
                    }
                } else if (mode == 101) {
                    Vector selectedPages = this.getSelectedPagesForSaveAs(((Provider)Provider.this).AbstractDocumentViewer.this.pages);
                    Vector<AbstractPage> outputPages = new Vector<AbstractPage>();
                    for (int i = 0; i < selectedPages.size(); ++i) {
                        Integer pageNo = (Integer)selectedPages.get(i);
                        int pageInt = pageNo;
                        if (pageInt > ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length || pageInt <= 0) continue;
                        AbstractPage page = ((Provider)Provider.this).AbstractDocumentViewer.this.pages[pageInt - 1];
                        if (page != null) {
                            page.setRenderingReason("PageRenderingReasonDataConversion");
                        }
                        outputPages.add(page);
                    }
                    String fileNamePrefix = this.getFileNamePrefix(pngFileName);
                    String outputDir = this.getOutputDir(pngFileName);
                    String ext = this.getFileExtension(pngFileName);
                    if (ext == null) {
                        ext = pngString;
                    }
                    this.saveAs(outputPages, outputDir, fileNamePrefix, ext, 1, resizeFactor, autoMatchToPaperSize);
                } else if (mode == 102) {
                    Vector<AbstractPage> outputPages = new Vector<AbstractPage>();
                    for (int i = 0; ((Provider)Provider.this).AbstractDocumentViewer.this.pages != null && i < ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length; ++i) {
                        outputPages.add(((Provider)Provider.this).AbstractDocumentViewer.this.pages[i]);
                    }
                    String fileNamePrefix = this.getFileNamePrefix(pngFileName);
                    String outputDir = this.getOutputDir(pngFileName);
                    String ext = this.getFileExtension(pngFileName);
                    if (ext == null) {
                        ext = pngString;
                    }
                    this.saveAs(outputPages, outputDir, fileNamePrefix, ext, 1, resizeFactor, autoMatchToPaperSize);
                }
            }

            void savePagesAsJPEG() {
                if (((Provider)Provider.this).AbstractDocumentViewer.this.pages == null || ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length == 0) {
                    return;
                }
                String title = AtCommonResource.MESSAGE_RESOURCE.getText("CREATE_JPEG_OUTPUT");
                String jpeg = AtCommonResource.MESSAGE_RESOURCE.getText("JPEG_EXTENSION");
                String description = AtCommonResource.MESSAGE_RESOURCE.getText("JPEG_FILES");
                if (((Provider)Provider.this).AbstractDocumentViewer.this.jpgFileDialog == null) {
                    ((Provider)Provider.this).AbstractDocumentViewer.this.jpgFileDialog = AbstractDocumentViewer.this.createSaveAsImageDialog(title, jpeg, description);
                }
                AbstractDocumentViewer.this.centerOnViewPane(((Provider)Provider.this).AbstractDocumentViewer.this.jpgFileDialog);
                ((Provider)Provider.this).AbstractDocumentViewer.this.jpgFileDialog.setFileSelectionMode(2);
                ((Provider)Provider.this).AbstractDocumentViewer.this.jpgFileDialog.setVisible(true);
                if (!((Provider)Provider.this).AbstractDocumentViewer.this.jpgFileDialog.isOkPressed()) {
                    ((Provider)Provider.this).AbstractDocumentViewer.this.jpgFileDialog.setVisible(false);
                    return;
                }
                String jpgFileName = ((Provider)Provider.this).AbstractDocumentViewer.this.jpgFileDialog.getFileName();
                double resizeFactor = ((Provider)Provider.this).AbstractDocumentViewer.this.jpgFileDialog.getResizeFactor();
                boolean autoMatchToPaperSize = false;
                int mode = ((Provider)Provider.this).AbstractDocumentViewer.this.jpgFileDialog.getOuputMode();
                if (mode == 100) {
                    try {
                        AbstractPage page = AbstractDocumentViewer.this.getDisplayedPage();
                        if (page != null) {
                            page.setRenderingReason("PageRenderingReasonDataConversion");
                        }
                        float qualityFactor = 1.0f;
                        ConversionFactory.saveAsJPEG(AbstractDocumentViewer.this.getDisplayedPage(), jpgFileName, qualityFactor, resizeFactor, autoMatchToPaperSize);
                    }
                    catch (Throwable t) {
                        AtDebug.debug(9, t);
                    }
                } else if (mode == 101) {
                    Vector selectedPages = this.getSelectedPagesForSaveAs(((Provider)Provider.this).AbstractDocumentViewer.this.pages);
                    Vector<AbstractPage> outputPages = new Vector<AbstractPage>();
                    for (int i = 0; i < selectedPages.size(); ++i) {
                        Integer pageNo = (Integer)selectedPages.get(i);
                        int pageInt = pageNo;
                        if (pageInt > ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length || pageInt <= 0) continue;
                        AbstractPage page = ((Provider)Provider.this).AbstractDocumentViewer.this.pages[pageInt - 1];
                        if (page != null) {
                            page.setRenderingReason("PageRenderingReasonDataConversion");
                        }
                        outputPages.add(page);
                    }
                    String fileNamePrefix = this.getFileNamePrefix(jpgFileName);
                    String outputDir = this.getOutputDir(jpgFileName);
                    String ext = this.getFileExtension(jpgFileName);
                    if (ext == null) {
                        ext = jpeg;
                    }
                    this.saveAs(outputPages, outputDir, fileNamePrefix, ext, 2, resizeFactor, autoMatchToPaperSize);
                } else if (mode == 102) {
                    Vector<AbstractPage> outputPages = new Vector<AbstractPage>();
                    for (int i = 0; ((Provider)Provider.this).AbstractDocumentViewer.this.pages != null && i < ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length; ++i) {
                        outputPages.add(((Provider)Provider.this).AbstractDocumentViewer.this.pages[i]);
                    }
                    String fileNamePrefix = this.getFileNamePrefix(jpgFileName);
                    String outputDir = this.getOutputDir(jpgFileName);
                    String ext = this.getFileExtension(jpgFileName);
                    if (ext == null) {
                        ext = jpeg;
                    }
                    this.saveAs(outputPages, outputDir, fileNamePrefix, ext, 2, resizeFactor, autoMatchToPaperSize);
                }
            }

            void savePagesAsBMP() {
                if (((Provider)Provider.this).AbstractDocumentViewer.this.pages == null || ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length == 0) {
                    return;
                }
                String title = AtCommonResource.MESSAGE_RESOURCE.getText("SAVE_AS_BMP_CMD");
                String bmpext = AtCommonResource.MESSAGE_RESOURCE.getText("BMP_EXTENSION");
                String description = AtCommonResource.MESSAGE_RESOURCE.getText("BMP_FILES");
                if (((Provider)Provider.this).AbstractDocumentViewer.this.bmpFileDialog == null) {
                    ((Provider)Provider.this).AbstractDocumentViewer.this.bmpFileDialog = AbstractDocumentViewer.this.createSaveAsImageDialog(title, bmpext, description);
                }
                AbstractDocumentViewer.this.centerOnViewPane(((Provider)Provider.this).AbstractDocumentViewer.this.bmpFileDialog);
                ((Provider)Provider.this).AbstractDocumentViewer.this.bmpFileDialog.setFileSelectionMode(2);
                ((Provider)Provider.this).AbstractDocumentViewer.this.bmpFileDialog.setVisible(true);
                if (!((Provider)Provider.this).AbstractDocumentViewer.this.bmpFileDialog.isOkPressed()) {
                    ((Provider)Provider.this).AbstractDocumentViewer.this.bmpFileDialog.setVisible(false);
                    return;
                }
                String bmpFileName = ((Provider)Provider.this).AbstractDocumentViewer.this.bmpFileDialog.getFileName();
                double resizeFactor = ((Provider)Provider.this).AbstractDocumentViewer.this.bmpFileDialog.getResizeFactor();
                boolean autoMatchToPaperSize = false;
                int mode = ((Provider)Provider.this).AbstractDocumentViewer.this.bmpFileDialog.getOuputMode();
                if (mode == 100) {
                    try {
                        AbstractPage page = AbstractDocumentViewer.this.getDisplayedPage();
                        if (page != null) {
                            page.setRenderingReason("PageRenderingReasonDataConversion");
                        }
                        float qualityFactor = 1.0f;
                        ConversionFactory.saveAsJPEG(AbstractDocumentViewer.this.getDisplayedPage(), bmpFileName, qualityFactor, resizeFactor, autoMatchToPaperSize);
                    }
                    catch (Throwable t) {
                        JOptionPane.showMessageDialog(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane, t.getMessage());
                        return;
                    }
                } else if (mode == 101) {
                    Vector selectedPages = this.getSelectedPagesForSaveAs(((Provider)Provider.this).AbstractDocumentViewer.this.pages);
                    Vector<AbstractPage> outputPages = new Vector<AbstractPage>();
                    for (int i = 0; i < selectedPages.size(); ++i) {
                        Integer pageNo = (Integer)selectedPages.get(i);
                        int pageInt = pageNo;
                        if (pageInt > ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length || pageInt <= 0) continue;
                        AbstractPage page = ((Provider)Provider.this).AbstractDocumentViewer.this.pages[pageInt - 1];
                        if (page != null) {
                            page.setRenderingReason("PageRenderingReasonDataConversion");
                        }
                        outputPages.add(page);
                    }
                    String fileNamePrefix = this.getFileNamePrefix(bmpFileName);
                    String outputDir = this.getOutputDir(bmpFileName);
                    String ext = this.getFileExtension(bmpFileName);
                    if (ext == null) {
                        ext = bmpext;
                    }
                    this.saveAs(outputPages, outputDir, fileNamePrefix, ext, 4, resizeFactor, autoMatchToPaperSize);
                } else if (mode == 102) {
                    Vector<AbstractPage> outputPages = new Vector<AbstractPage>();
                    for (int i = 0; ((Provider)Provider.this).AbstractDocumentViewer.this.pages != null && i < ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length; ++i) {
                        outputPages.add(((Provider)Provider.this).AbstractDocumentViewer.this.pages[i]);
                    }
                    String fileNamePrefix = this.getFileNamePrefix(bmpFileName);
                    String outputDir = this.getOutputDir(bmpFileName);
                    String ext = this.getFileExtension(bmpFileName);
                    if (ext == null) {
                        ext = bmpext;
                    }
                    this.saveAs(outputPages, outputDir, fileNamePrefix, ext, 4, resizeFactor, autoMatchToPaperSize);
                }
            }

            String getFileNamePrefix(String fileName) {
                try {
                    String fileSep = System.getProperty("file.separator");
                    int idx = fileName.lastIndexOf(46);
                    int fileSepIdx = fileName.lastIndexOf(fileSep);
                    if (fileSepIdx < 0) {
                        fileSepIdx = fileName.lastIndexOf(47);
                    }
                    String file = fileName.substring(fileSepIdx + 1, idx);
                    return file;
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane, t.getMessage());
                    return AtCommonResource.MESSAGE_RESOURCE.getText("PDF_FILE_PREFIX");
                }
            }

            String getFileExtension(String fileName) {
                try {
                    int idx = fileName.lastIndexOf(46);
                    String ext = fileName.substring(idx + 1);
                    return ext;
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane, t.getMessage());
                    return null;
                }
            }

            String getOutputDir(String fileName) {
                try {
                    String fileSep = System.getProperty("file.separator");
                    int fileSepIdx = fileName.lastIndexOf(fileSep);
                    if (fileSepIdx < 0) {
                        fileSepIdx = fileName.lastIndexOf(47);
                    }
                    String dir = fileName.substring(0, fileSepIdx);
                    return dir;
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane, t.getMessage());
                    return "";
                }
            }

            void saveAs(Vector outputPages, String outputDir, String fileNamePrefix, String ext, int outputType, double resizeFactor, boolean autoMatchToPaperSize) {
                AbstractPage[] allPages = new AbstractPage[outputPages.size()];
                for (int i = 0; outputPages != null && i < outputPages.size(); ++i) {
                    AbstractPage aPage;
                    allPages[i] = aPage = (AbstractPage)outputPages.get(i);
                }
                String fileSep = System.getProperty("file.separator");
                try {
                    for (int i = 0; allPages != null && i < allPages.length; ++i) {
                        String fileName = outputDir + fileSep + fileNamePrefix + (i + 1) + "." + ext;
                        float qualityFactor = 1.0f;
                        if (outputType == 2) {
                            ConversionFactory.saveAsJPEG(allPages[i], fileName, qualityFactor, resizeFactor, autoMatchToPaperSize);
                            continue;
                        }
                        if (outputType == 1) {
                            ConversionFactory.saveAsPNG(allPages[i], fileName, resizeFactor, autoMatchToPaperSize);
                            continue;
                        }
                        if (outputType != 4) continue;
                        ConversionFactory.saveAsBMP(allPages[i], fileName, resizeFactor, autoMatchToPaperSize);
                    }
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane, t.getMessage());
                    return;
                }
            }

            void goActionPerformed(ActionEvent evt) {
                if (((Provider)Provider.this).AbstractDocumentViewer.this.pages == null || ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length == 0) {
                    return;
                }
                int pageNo = AbstractDocumentViewer.this.getPageFieldValue() - 1;
                AtDebug.debug("page index to show: " + pageNo + ", pages.length=" + ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length);
                if (pageNo >= ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length) {
                    pageNo = ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length - 1;
                    AbstractDocumentViewer.this.setPageFieldValue(pageNo);
                } else if (pageNo < 0) {
                    pageNo = 0;
                }
                AbstractDocumentViewer.this.showPageIndex(pageNo);
            }

            void goToFirstPageActionPerformed(ActionEvent evt) {
                if (((Provider)Provider.this).AbstractDocumentViewer.this.pages == null || ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length == 0) {
                    return;
                }
                int pageIndex = 0;
                AbstractDocumentViewer.this.showPageIndex(pageIndex);
            }

            void goToLastPageActionPerformed(ActionEvent evt) {
                if (((Provider)Provider.this).AbstractDocumentViewer.this.pages == null || ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length == 0) {
                    return;
                }
                int pageIndex = ((Provider)Provider.this).AbstractDocumentViewer.this.pages.length - 1;
                AbstractDocumentViewer.this.showPageIndex(pageIndex);
            }

            Vector getSelectedPagesForSaveAs(AbstractPage[] pages) {
                String value = AbstractDocumentViewer.this.getPrintFieldValue();
                if (AbstractDocumentViewer.this.hasIllegalChars(value)) {
                    JOptionPane.showMessageDialog(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane, AtCommonResource.MESSAGE_RESOURCE.getText("STRING_HAS_ILLEGAL_CHARS"), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
                    return null;
                }
                String pageString = AbstractDocumentViewer.this.getFilteredPageString();
                Vector<Integer> allPages = new Vector<Integer>();
                StringTokenizer tk = new StringTokenizer(pageString, ",");
                while (tk.hasMoreTokens()) {
                    String token = tk.nextToken();
                    if (AbstractDocumentViewer.this.isRangeToken(token)) {
                        Vector rangePages = AbstractDocumentViewer.this.getPagesFromRange(token);
                        allPages.addAll(rangePages);
                        continue;
                    }
                    int pageNo = Integer.parseInt(token);
                    allPages.add(new Integer(pageNo));
                }
                Vector<Integer> pagesToPrint = allPages;
                int minPageNo = 1;
                int maxPageNo = pages.length;
                Vector<Integer> filteredPages = new Vector<Integer>();
                for (int i = 0; i < pagesToPrint.size(); ++i) {
                    Integer aPageNo = (Integer)pagesToPrint.get(i);
                    if (aPageNo < minPageNo || aPageNo > maxPageNo) continue;
                    filteredPages.add(aPageNo);
                }
                return filteredPages;
            }

            void printActionPerformed(AbstractPage[] allPages) {
                if (((Provider)Provider.this).AbstractDocumentViewer.this.pages == null) {
                    AtDebug.debug("null pages can not be printed.");
                    return;
                }
                boolean print = AbstractDocumentViewer.this.showPrintDialog();
                if (!print) {
                    return;
                }
                int[] range = ((AtPrintDialog)((Provider)Provider.this).AbstractDocumentViewer.this.printDialog).getRange(AbstractDocumentViewer.this.getPageCount(), AbstractDocumentViewer.this.getDisplayedPageIndex() + 1);
                if (range == null) {
                    AtDebug.debug("No pages to print....return.");
                    return;
                }
                for (int i = 0; range != null && i < range.length; ++i) {
                    AtDebug.debug("print page: " + range[i]);
                }
                int pageScaling = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.getPageScaling();
                boolean isAutoRotateAndCenter = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.isAutoRotateAndCenter();
                boolean choosePaperSouceByPageSize = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.isChoosePaperSourceByPageSize();
                PageFormat userPageFormat = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.getSelectedPageFormat();
                boolean isUsePrinterMargins = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.isUsePrinterMargins();
                PrintQuality printQuality = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.getPrintQuality();
                Sides side = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.getSideToPrint();
                PrintService ps = ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.getSelectedPrintService();
                PrinterJob printer = PrinterJob.getPrinterJob();
                try {
                    printer.setPrintService(ps);
                }
                catch (Throwable t) {
                    AtDebug.debug(9, t);
                }
                Book book = new DocPageable();
                for (int i = 0; i < range.length; ++i) {
                    int pageInt = range[i];
                    AbstractPage page = allPages[pageInt - 1];
                    AbstractPage clonedPage = page.newInstance();
                    clonedPage.setZoom(1.0);
                    PageFormat pfToUse = userPageFormat;
                    if (choosePaperSouceByPageSize) {
                        Rectangle2D printableArea = clonedPage.getPrintableArea();
                        AbstractPrinter cfr_ignored_0 = ((Provider)Provider.this).AbstractDocumentViewer.this.docPrinter;
                        PageFormat autoMatchedPf = AbstractPrinter.getPaperSourceByPageSize(printableArea);
                        if (autoMatchedPf != null) {
                            pfToUse = autoMatchedPf;
                        }
                    }
                    AbstractPrinter cfr_ignored_1 = ((Provider)Provider.this).AbstractDocumentViewer.this.docPrinter;
                    PageFormat validatedPf = AbstractPrinter.getPrinterValidatedPageFormat(printer, pfToUse, isUsePrinterMargins);
                    pfToUse = MediaUtil.getClonedPageFormat(validatedPf);
                    clonedPage.setPrinterPageFormat(pfToUse);
                    clonedPage.setPageScaling(pageScaling);
                    clonedPage.setAutoRotateAndCenter(isAutoRotateAndCenter);
                    clonedPage.setRenderingReason("PageRenderingReasonPrinting");
                    book.append(clonedPage, pfToUse);
                }
                book = MediaUtil.createCollatedCopiesForPrint(book, ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.isCollate(), ((Provider)Provider.this).AbstractDocumentViewer.this.printDialog.getCopies());
                try {
                    printer.setPageable(book);
                }
                catch (Throwable ex) {
                    JOptionPane.showMessageDialog(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane, AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_SERVICE_SET_ERR_MSG"), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
                    return;
                }
                try {
                    int pageCount = book.getNumberOfPages();
                    String title = AtCommonResource.MESSAGE_RESOURCE.getText("Progress");
                    AbstractDocumentViewer parent = ((Provider)Provider.this).AbstractDocumentViewer.this.viewPane;
                    String dn = AbstractDocumentViewer.this.getDocumentName();
                    if (dn != null) {
                        dn = URLDecoder.decode(dn);
                    }
                    String docName = dn;
                    int docLisCount = ((Provider)Provider.this).AbstractDocumentViewer.this.docPrinter.getDocListenerCount();
                    AtDebug.debug("DocLisCount=" + docLisCount);
                    ((Provider)Provider.this).AbstractDocumentViewer.this.docPrinter.addDocListener(((Provider)Provider.this).AbstractDocumentViewer.this.progressIndicator);
                    ((Provider)Provider.this).AbstractDocumentViewer.this.progressIndicator.start(parent, title, docName, true, true, true, pageCount);
                    Book tbook = book;
                    Runnable r = new Runnable(this, printer, tbook, docName, pageCount, printQuality, side){
                        private final /* synthetic */ PrinterJob val$printer;
                        private final /* synthetic */ Book val$tbook;
                        private final /* synthetic */ String val$docName;
                        private final /* synthetic */ int val$pageCount;
                        private final /* synthetic */ PrintQuality val$printQuality;
                        private final /* synthetic */ Sides val$side;
                        private final /* synthetic */ TheProvider this$2;
                        {
                            this.this$2 = this$2;
                            this.val$printer = val$printer;
                            this.val$tbook = val$tbook;
                            this.val$docName = val$docName;
                            this.val$pageCount = val$pageCount;
                            this.val$printQuality = val$printQuality;
                            this.val$side = val$side;
                        }

                        public void run() {
                            try {
                                this.val$printer.setJobName(Provider.access$700((Provider)TheProvider.access$800((TheProvider)this.this$2)).printDialog.getPrintJobName());
                                MediaUtil.setRenderingReasonforPages(this.val$tbook, "PageRenderingReasonPrinting");
                                DocEvent printStartEvent = new DocEvent(this.val$docName, 21, this.val$pageCount, this.val$printer.getPrintService());
                                Provider.access$700((Provider)TheProvider.access$800((TheProvider)this.this$2)).docPrinter.notifyEvent(printStartEvent);
                                PrintRequestAttributeSet pSet = this.this$2.getPrintRequestAttributeSet(this.val$printQuality, this.val$side);
                                this.val$printer.print(pSet);
                                DocEvent printEndedEvent = new DocEvent(this.val$docName, 22, this.val$pageCount, this.val$printer.getPrintService());
                                Provider.access$700((Provider)TheProvider.access$800((TheProvider)this.this$2)).docPrinter.notifyEvent(printEndedEvent);
                                Provider.access$700((Provider)TheProvider.access$800((TheProvider)this.this$2)).docPrinter.removeDocListener(Provider.access$700((Provider)TheProvider.access$800((TheProvider)this.this$2)).progressIndicator);
                            }
                            catch (Throwable t1) {
                                String stack = StringUtil.getStackTrace(t1, "\n");
                                AtDebug.debug(11, stack);
                                Provider.access$700((Provider)TheProvider.access$800((TheProvider)this.this$2)).docPrinter.removeDocListener(Provider.access$700((Provider)TheProvider.access$800((TheProvider)this.this$2)).progressIndicator);
                                this.val$printer.cancel();
                                boolean cancelled = Provider.access$700((Provider)TheProvider.access$800((TheProvider)this.this$2)).progressIndicator.isCancelled();
                                String msg = null;
                                msg = cancelled ? AtCommonResource.MESSAGE_RESOURCE.getText("PRINTING_CANCELLED") : t1.getMessage();
                                if (msg == null) {
                                    msg = t1.toString();
                                }
                                JOptionPane.showMessageDialog(Provider.access$700((Provider)TheProvider.access$800((TheProvider)this.this$2)).viewPane, msg, AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
                                return;
                            }
                        }
                    };
                    new Thread(r).start();
                }
                catch (Throwable e1) {
                    ((Provider)Provider.this).AbstractDocumentViewer.this.docPrinter.removeDocListener(((Provider)Provider.this).AbstractDocumentViewer.this.progressIndicator);
                    JOptionPane.showMessageDialog(((Provider)Provider.this).AbstractDocumentViewer.this.viewPane, StringUtil.getMessage(e1), AtCommonResource.MESSAGE_RESOURCE.getText("Error"), 0);
                    return;
                }
            }

            static /* synthetic */ Provider access$800(TheProvider x0) {
                return x0.Provider.this;
            }
        }
    }

    public class PercentComboActionListener
    implements ActionListener {
        double lastSelectedZoom = 1.0;

        public void actionPerformed(ActionEvent evt) {
            double currZoom = 1.0;
            int currLimit = 5;
            try {
                AbstractDocumentViewer.this.notifyViewerControlActionListeners(evt);
            }
            catch (AtUserActionVetoException ex) {
                AtDebug.debug("User action is vetowed by: " + ex.getClass().getName());
                return;
            }
            AbstractDocumentViewer.this.performToggleButtonSelection(evt);
            JComboBox zoomCombo = (JComboBox)evt.getSource();
            Object selectedItem = zoomCombo.getSelectedItem();
            if (selectedItem instanceof KeyValueObject) {
                KeyValueObject currSelItem = (KeyValueObject)selectedItem;
                double currSelZoom = currSelItem.getValue() / 100.0;
                if (currSelZoom == this.lastSelectedZoom) {
                    return;
                }
                currZoom = currSelZoom;
            } else {
                String percentStr;
                char percentChar;
                String zoomPercent = selectedItem.toString();
                int idx = zoomPercent.lastIndexOf(percentChar = (percentStr = AtCommonResource.MESSAGE_RESOURCE.getText("PERCENT_CHAR")).charAt(0));
                if (idx >= 0) {
                    zoomPercent = zoomPercent.substring(0, idx);
                } else {
                    char ch;
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; zoomPercent != null && i < zoomPercent.length() && Character.isDigit(ch = zoomPercent.charAt(i)); ++i) {
                        buf.append(ch);
                    }
                    zoomPercent = buf.toString();
                    if (zoomPercent == null || zoomPercent.equals("")) {
                        zoomPercent = "100";
                    }
                }
                zoomPercent = this.removeLeadingAndTrailingChars(zoomPercent);
                float percent = Float.parseFloat(zoomPercent);
                currZoom = (double)percent / 100.0;
            }
            if (currZoom < AbstractDocumentViewer.this.minZoom) {
                currLimit = 2;
            }
            if (currZoom > AbstractDocumentViewer.this.maxZoom) {
                currLimit = 1;
            }
            if (currLimit != 5) {
                AbstractDocumentViewer.this.showZoomLimitErrorMessage(currZoom, currLimit);
                AbstractDocumentViewer.this.resetZoomSelection(AbstractDocumentViewer.this.zoom);
                AbstractDocumentViewer.this.zoom = this.lastSelectedZoom;
                return;
            }
            this.lastSelectedZoom = AbstractDocumentViewer.this.zoom = currZoom;
            AbstractDocumentViewer.this.zoom(4);
            if (AbstractDocumentViewer.this.pageView != null) {
                AbstractDocumentViewer.this.pageView.cacheResizePreferences();
            }
            int pageIndex = AbstractDocumentViewer.this.getDisplayedPageIndex();
            if (!AbstractDocumentViewer.this.isStopping()) {
                AbstractDocumentViewer.this.show(pageIndex);
            }
            if (AbstractDocumentViewer.this.thumbnailsView != null) {
                AbstractDocumentViewer.this.thumbnailsView.setThumbnailSelectionIndex(pageIndex);
            }
            if (AbstractDocumentViewer.this.pageView != null) {
                Runnable r = new Runnable(this){
                    private final /* synthetic */ PercentComboActionListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        PercentComboActionListener.access$600((PercentComboActionListener)this.this$1).pageView.regainResizePreferences();
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }

        protected String removeLeadingAndTrailingChars(String zoomString) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; zoomString != null && i < zoomString.length(); ++i) {
                char ch = zoomString.charAt(i);
                if (!Character.isDigit(ch)) continue;
                buf.append(ch);
            }
            String retStr = buf.toString();
            if (retStr == null || retStr.equals("")) {
                retStr = "100";
            }
            return retStr;
        }

        static /* synthetic */ AbstractDocumentViewer access$600(PercentComboActionListener x0) {
            return x0.AbstractDocumentViewer.this;
        }
    }

    public class MenuAction
    extends AbstractAction {
        ActionListener l;

        public MenuAction(String displayName, char mnemonic, String cmd, ImageIcon icon, ActionListener l2) {
            this.l = l2;
            super.putValue("MnemonicKey", new Integer(mnemonic));
            super.putValue("Name", displayName);
            super.putValue("ActionCommandKey", cmd);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AbstractDocumentViewer.this.goToPageMenuItem) {
                AbstractDocumentViewer.this.pageField.grabFocus();
                AbstractDocumentViewer.this.pageField.selectAll();
            } else if (e.getSource() == AbstractDocumentViewer.this.locationMenuItem) {
                AbstractDocumentViewer.this.locationCombo.grabFocus();
                JTextComponent tf = (JTextComponent)AbstractDocumentViewer.this.locationCombo.getEditor().getEditorComponent();
                tf.grabFocus();
                tf.selectAll();
            } else {
                this.l.actionPerformed(e);
            }
        }
    }
}

