/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.viewer.AtStatusCell;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

public class AtMultiCellStatusBar
extends JPanel {
    ArrayList statusCells = new ArrayList();

    public AtMultiCellStatusBar(Collection statusCells) {
        this.setLayout(new GridBagLayout());
        if (statusCells != null) {
            this.statusCells.addAll(statusCells);
            this.recreate();
        }
    }

    protected void recreate() {
        this.removeAll();
        int gridx = 0;
        for (int i = 0; this.statusCells != null && i < this.statusCells.size(); ++i) {
            AtStatusCell cell = (AtStatusCell)this.statusCells.get(i);
            boolean weightx = false;
            if (cell.getPreferredWidth() == -1) {
                weightx = true;
            }
            this.add((Component)cell, new GridBagConstraints(gridx++, 0, 1, 1, (double)weightx, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.revalidate();
    }

    public void addStatusCell(AtStatusCell cell) {
        if (this.statusCells.contains(cell)) {
            this.statusCells.add(cell);
            this.recreate();
        }
    }

    public void removeStatusCell(AtStatusCell cell) {
        this.statusCells.remove(cell);
        this.recreate();
    }

    public void removeAllStatusCells() {
        this.statusCells.clear();
        this.recreate();
    }

    public int getStatusCellCount() {
        return this.statusCells.size();
    }

    public void addStatusCells(Collection statusCells) {
        statusCells.addAll(statusCells);
        this.recreate();
    }

    public AtStatusCell[] getStatusCells() {
        AtStatusCell[] cells = new AtStatusCell[this.statusCells.size()];
        for (int i = 0; this.statusCells != null && i < this.statusCells.size(); ++i) {
            AtStatusCell cell;
            cells[i] = cell = (AtStatusCell)this.statusCells.get(i);
        }
        return cells;
    }

    public AtStatusCell getStatusCellAt(int cellIndex) {
        AtStatusCell[] cells = this.getStatusCells();
        return cells[cellIndex];
    }
}

