/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.object.DefaultPasswordProvider;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtInsetsPanel;
import com.activetree.common.swing.LogonDialog;
import com.activetree.common.utils.AtComponentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class DocPasswordProviderDialog
extends DefaultPasswordProvider {
    protected Component viewPane;
    private Object doc;
    boolean documentChanged = true;

    public DocPasswordProviderDialog(Component vp, Object doc, String docPassword) {
        super(docPassword);
        this.viewPane = vp;
        this.doc = doc;
    }

    public DocPasswordProviderDialog(Component vp) {
        this.viewPane = vp;
    }

    public void setOwner(JComponent owner) {
        this.viewPane = owner;
    }

    public void setDocument(Object newDoc) {
        this.documentChanged = this.doc != newDoc;
        this.doc = newDoc;
    }

    public PasswordAuthentication getPasswordAuthentication() {
        if (!this.documentChanged) {
            return this.urlAuth;
        }
        String title = AtCommonResource.MESSAGE_RESOURCE.getText("CONNECT_TO");
        String[] message = new String[3];
        if (this.doc instanceof String) {
            message[0] = (String)this.doc;
        } else if (this.doc instanceof URL) {
            URL url = (URL)this.doc;
            String host = url.getHost();
            String protocol = url.getProtocol();
            String path = url.getPath();
            String ref = url.getRef();
            String prompt = super.getRequestingPrompt();
            String scheme = super.getRequestingScheme();
            InetAddress inetAddr = super.getRequestingSite();
            title = title + " ";
            title = title + host;
            String message1 = AtCommonResource.MESSAGE_RESOURCE.getText("THE_SERVER");
            message1 = message1 + " ";
            message1 = message1 + host;
            message1 = message1 + " ";
            message1 = message1 + AtCommonResource.MESSAGE_RESOURCE.getText("AT");
            String message2 = AtCommonResource.MESSAGE_RESOURCE.getText("REQUIRES_USER_NAME_AND_PASSWORD");
            message[0] = message1;
            message[1] = "\"" + prompt + "\"";
            message[2] = message2;
        }
        Window owner = AtComponentUtil.getWindowForComponent(this.viewPane);
        LogonDialog d = null;
        d = owner instanceof Frame ? new LogonDialog((Frame)owner, title, true, null, message) : (owner instanceof Dialog ? new LogonDialog((Dialog)owner, title, true, null, message) : new LogonDialog((Frame)owner, title, true, null, message));
        d.pack();
        AtComponentUtil.centerOnContainer(owner, d);
        d.setVisible(true);
        if (!d.isOkPressed()) {
            return null;
        }
        this.urlAuthUser = d.getUserName();
        this.urlAuthPassword = d.getPassword();
        char[] pwd = this.urlAuthPassword == null ? null : this.urlAuthPassword.toCharArray();
        this.urlAuth = new PasswordAuthentication(this.urlAuthUser, pwd);
        return this.urlAuth;
    }

    public String getPassword() {
        if (!this.documentChanged) {
            return this.password;
        }
        this.createDialog();
        String pswd = this.password;
        return pswd;
    }

    private void createDialog() {
        this.password = "";
        Window owner = AtComponentUtil.getWindowForComponent(this.viewPane);
        JDialog d = null;
        String title = AtCommonResource.MESSAGE_RESOURCE.getText("PASSWORD_INPUT_TITLE");
        d = owner instanceof Frame ? new JDialog((Frame)owner, title, true) : (owner instanceof Dialog ? new JDialog((Dialog)owner, title, true) : new JDialog((Frame)owner, title, true));
        String label = AtCommonResource.MESSAGE_RESOURCE.getText("PASSWORD_INPUT_MESSAGE");
        JLabel msg = new JLabel(label);
        final JPasswordField passwordEntry = new JPasswordField(20);
        JPanel topPane = new JPanel(new BorderLayout(5, 5));
        topPane.add((Component)msg, "West");
        topPane.add((Component)passwordEntry, "Center");
        JButton ok = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("Ok"));
        ok.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("Ok"));
        final JDialog myDialog = d;
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                char[] ch = passwordEntry.getPassword();
                if (ch != null && ch.length > 0) {
                    DocPasswordProviderDialog.this.password = new String(ch);
                }
                myDialog.setVisible(false);
            }
        });
        JButton cancel = new JButton(AtCommonResource.MESSAGE_RESOURCE.getText("Cancel"));
        cancel.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("Cancel"));
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                myDialog.setVisible(false);
            }
        });
        JPanel buttonPane = new JPanel(new FlowLayout(4, 5, 5));
        buttonPane.add(ok);
        buttonPane.add(cancel);
        AtInsetsPanel top = new AtInsetsPanel(new BorderLayout(5, 5));
        top.setInsets(new Insets(5, 5, 5, 5));
        JLabel help = new JLabel(AtCommonResource.MESSAGE_RESOURCE.getText("DOCUMENT_PASSWORD_PROTECTED_MESSAGE"));
        top.add((Component)help, "North");
        top.add((Component)topPane, "Center");
        top.add((Component)buttonPane, "South");
        d.setContentPane(top);
        top.getRootPane().setDefaultButton(ok);
        d.pack();
        AtComponentUtil.centerOnContainer(owner, d);
        passwordEntry.grabFocus();
        d.setVisible(true);
    }
}

