/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.page.AbstractPage;
import com.activetree.common.swing.CustomScrollPane;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.viewer.AbstractDocumentViewer;
import com.activetree.common.viewer.AbstractPageView;
import com.activetree.common.viewer.AbstractThumbnailsView;
import com.activetree.common.viewer.PagesGroupPane;
import com.activetree.common.viewer.ThumbnailData;
import com.activetree.common.viewer.ThumbnailView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public abstract class MultiPageView
extends JPanel {
    protected AbstractDocumentViewer docViewer;
    protected final Vector pageViews = new Vector();
    protected MouseListener loadListener;
    protected MouseMotionAdapter dragListener;
    protected Insets margins = null;
    protected boolean drawBorder = true;
    protected boolean antiAliased = true;
    Point lastViewPos = null;
    double lastViewPosFactor = -1.0;

    public MultiPageView(AbstractDocumentViewer docViewer) {
        this.docViewer = docViewer;
    }

    public void setAutoPageLoadingOnScrollingEnabled(boolean enable) {
        JScrollPane pagesScroller = this.docViewer.getPagesScroller();
        if (!(pagesScroller instanceof CustomScrollPane)) {
            return;
        }
        CustomScrollPane customScroller = (CustomScrollPane)pagesScroller;
        if (enable) {
            if (this.loadListener == null) {
                this.loadListener = new MouseAdapter(){

                    public void mousePressed(MouseEvent evt) {
                        MultiPageView.this.setPageLoadingEnabled(false);
                        AbstractThumbnailsView tnView = MultiPageView.this.docViewer.getThumbnailsView();
                        if (tnView != null) {
                            tnView.setThumbnailLoadingEnabled(false);
                        }
                    }

                    public void mouseReleased(MouseEvent evt) {
                        MultiPageView.this.setPageLoadingEnabled(true);
                        Runnable r = new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                1.access$000(this.this$1).updateControls();
                                if (1.access$000(this.this$1).docViewer.getThumbnailsView() != null) {
                                    1.access$000(this.this$1).docViewer.getThumbnailsView().setThumbnailLoadingEnabled(true);
                                }
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }

                    static /* synthetic */ MultiPageView access$000(1 x0) {
                        return x0.MultiPageView.this;
                    }
                };
            } else {
                customScroller.removeScrollChangeListener(this.loadListener);
            }
            if (this.dragListener == null) {
                this.dragListener = new MouseMotionAdapter(){

                    public void mouseDragged(MouseEvent e) {
                        Runnable r = new Runnable(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                3.access$100(this.this$1).updateControls();
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }

                    static /* synthetic */ MultiPageView access$100(3 x0) {
                        return x0.MultiPageView.this;
                    }
                };
            } else {
                customScroller.getVerticalScrollBar().removeMouseMotionListener(this.dragListener);
            }
            customScroller.addScrollChangeListener(this.loadListener);
            customScroller.getVerticalScrollBar().addMouseMotionListener(this.dragListener);
        } else {
            if (this.loadListener != null) {
                customScroller.removeScrollChangeListener(this.loadListener);
            }
            if (this.dragListener != null) {
                customScroller.removeMouseMotionListener(this.dragListener);
            }
        }
    }

    protected void setPageLoadingEnabled(boolean enable) {
        for (int i = 0; i < this.pageViews.size(); ++i) {
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(i);
            aPageView.setPageLoadingEnabled(enable);
        }
        this.repaint();
    }

    public void clean() {
        for (int page = 0; page < this.pageViews.size(); ++page) {
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(page);
            aPageView.clean();
        }
        this.pageViews.clear();
        this.removeAll();
        this.validate();
    }

    public void refreshUI(boolean singlePageMode) {
        if (this.docViewer.getPages() == null || this.docViewer.getPages().length <= 0) {
            return;
        }
        this.pageViews.removeAllElements();
        JPanel all = new JPanel(new GridBagLayout());
        all.setBackground(this.getBackground());
        PagesGroupPane aRowGroup = new PagesGroupPane(new GridBagLayout());
        aRowGroup.setBackground(this.getBackground());
        int rowCount = 0;
        int rowGroup = 0;
        AbstractPage[] pages = this.docViewer.getPages();
        int pageCount = pages.length;
        if (singlePageMode) {
            pageCount = 1;
        }
        for (int i = 0; pages != null && i < pageCount; ++i) {
            ++rowCount;
            AbstractPageView aPageView = this.createPageView(this, i, singlePageMode);
            if (this.margins != null) {
                aPageView.setMargins(this.margins);
            }
            aPageView.setDrawPageBorder(this.drawBorder);
            aPageView.setBackground(this.getBackground());
            aPageView.setAntiAliased(this.antiAliased);
            this.pageViews.add(aPageView);
            aRowGroup.add((Component)aPageView, new GridBagConstraints(0, rowCount - 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (rowCount < 512) continue;
            all.add((Component)aRowGroup, new GridBagConstraints(0, rowGroup, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            ++rowGroup;
            aRowGroup = new PagesGroupPane(new GridBagLayout());
            aRowGroup.setBackground(this.getBackground());
            rowCount = 0;
        }
        if (rowCount > 0 && rowCount < 512) {
            all.add((Component)aRowGroup, new GridBagConstraints(0, rowGroup, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)all, "North");
        this.validate();
    }

    public abstract AbstractPageView createPageView(MultiPageView var1, int var2, boolean var3);

    public AbstractPageView getDisplayedPageView() {
        if (this.docViewer.isSinglePageMode() && this.pageViews.size() > 0) {
            AbstractPageView singlePageView = (AbstractPageView)this.pageViews.get(0);
            return singlePageView;
        }
        int pageIndex = this.docViewer.getDisplayedPageIndex();
        AbstractPageView currPageView = null;
        if (pageIndex >= 0) {
            currPageView = (AbstractPageView)this.pageViews.get(pageIndex);
        }
        return currPageView;
    }

    public AbstractDocumentViewer getDocViewer() {
        return this.docViewer;
    }

    public void setDrawPageBorder(boolean pageBorder) {
        this.drawBorder = pageBorder;
        AbstractPageView currPageView = this.getDisplayedPageView();
        if (currPageView != null) {
            currPageView.setDrawPageBorder(pageBorder);
        }
    }

    public void setPageImage(BufferedImage pageImage) {
        if (!this.docViewer.isSinglePageMode()) {
            return;
        }
        AbstractPageView currPageView = this.getDisplayedPageView();
        if (currPageView != null) {
            currPageView.setPageImage(pageImage);
        }
    }

    public Image getPageImage() {
        AbstractPageView currPageView = this.getDisplayedPageView();
        if (currPageView != null) {
            return currPageView.getPageImage();
        }
        return null;
    }

    public void setZoom(double currZoom) {
        for (int page = 0; page < this.pageViews.size(); ++page) {
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(page);
            aPageView.resizeView(false);
            AbstractPage pageData = aPageView.getPage();
            double lastZoom = pageData.getZoom();
            pageData.setZoom(currZoom);
            if (lastZoom == currZoom) continue;
            aPageView.setPageImage(null);
        }
    }

    public void setPage(AbstractPage page, boolean updateView) {
        AbstractPageView pageView = this.getViewForPageData(page);
        if (pageView != null) {
            if (updateView) {
                pageView.setPageImage(null);
            }
            if (this.docViewer.isSinglePageMode()) {
                pageView.setPage(page, updateView);
                pageView.repaint();
            }
            Rectangle bbox = this.getAbsoluteBounds(pageView);
            try {
                this.docViewer.getPagesScroller().getViewport().setViewPosition(new Point(bbox.x, bbox.y));
            }
            catch (Throwable t) {
                // empty catch block
            }
            Runnable r = new Runnable(){

                public void run() {
                    if (!MultiPageView.this.docViewer.isSinglePageMode()) {
                        MultiPageView.this.unloadInvisiblePages();
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void cacheResizePreferences() {
        JScrollPane scroller = this.docViewer.getPagesScroller();
        this.lastViewPos = scroller.getViewport().getViewPosition();
        Dimension viewSize = scroller.getViewport().getViewSize();
        this.lastViewPosFactor = this.lastViewPos.getY() / viewSize.getHeight();
    }

    protected void regainResizePreferences() {
        JScrollPane scroller = this.docViewer.getPagesScroller();
        Dimension viewSize = scroller.getViewport().getViewSize();
        double newPosY = this.lastViewPosFactor * viewSize.getHeight();
        Point newPos = new Point((int)this.lastViewPos.getX(), (int)newPosY);
        scroller.getViewport().setViewPosition(newPos);
    }

    protected void updateControls() {
        if (this.docViewer.isSinglePageMode()) {
            return;
        }
        this.unloadInvisiblePages();
        AbstractPageView[] visiblePages = this.getVisiblePages();
        int selectionIndex = this.getBestSelectionIndex(visiblePages);
        if (selectionIndex >= 0) {
            AbstractThumbnailsView tnView = this.docViewer.getThumbnailsView();
            if (tnView != null) {
                tnView.unselectAll();
                tnView.updateControls();
            }
            this.setThumbnailSelected(selectionIndex);
            this.scrollThumbnailsForVisiblePages(visiblePages);
            this.docViewer.pageSelectionChanged(selectionIndex);
        }
    }

    protected int getBestSelectionIndex(AbstractPageView[] visiblePages) {
        int selectionIndex = -1;
        AbstractPageView fullyVisiblePage = this.getFirstFullyVisiblePage(visiblePages);
        if (fullyVisiblePage != null) {
            selectionIndex = fullyVisiblePage.getPage().getPageIndex();
        } else {
            AbstractPageView maxVisPage = this.getMaxVisiblePage(visiblePages);
            if (maxVisPage != null) {
                selectionIndex = maxVisPage.getPage().getPageIndex();
            }
        }
        return selectionIndex;
    }

    protected void scrollThumbnailsForVisiblePages(AbstractPageView[] visPages) {
        AbstractThumbnailsView tnView = this.docViewer.getThumbnailsView();
        if (visPages == null || visPages.length == 0 || tnView == null) {
            return;
        }
        int firstVisPageIdx = visPages[0].getPage().getPageIndex();
        int lastVisPageIdx = visPages[visPages.length - 1].getPage().getPageIndex();
        int tnTopY = 0;
        AbstractThumbnailsView thumbnailsView = this.docViewer.getThumbnailsView();
        for (int tnPageIdx = 0; thumbnailsView != null && tnPageIdx < firstVisPageIdx; ++tnPageIdx) {
            ThumbnailView tnPageView = thumbnailsView.getThumbnailView(tnPageIdx);
            if (tnPageView == null) continue;
            Dimension tnSize = tnPageView.getSize();
            tnTopY += tnSize.height;
        }
        int tnBottomY = tnTopY;
        for (int i = firstVisPageIdx; thumbnailsView != null && i <= lastVisPageIdx; ++i) {
            ThumbnailView tnPageView = thumbnailsView.getThumbnailView(i);
            if (tnPageView == null) continue;
            Dimension tnSize = tnPageView.getSize();
            tnBottomY += tnSize.height;
        }
        int deltaHeight = tnBottomY - tnTopY;
        int centerY = tnTopY + deltaHeight / 2;
        JScrollPane tnScroller = tnView.getViewer().getThumbnailsScroller();
        Dimension tnViewSize = tnScroller.getViewport().getViewSize();
        Rectangle tnViewRect = tnScroller.getViewport().getViewRect();
        int x = tnViewRect.x;
        int y = centerY;
        int remScrollHeight = tnViewSize.height - (y -= tnViewRect.height / 2);
        if (remScrollHeight < tnViewRect.height) {
            int adjustY = tnViewRect.height - remScrollHeight;
            y -= adjustY;
        }
        if (y < 0) {
            y = 0;
        }
        tnScroller.getViewport().setViewPosition(new Point(x, y));
    }

    protected void setThumbnailSelected(int index) {
        AbstractThumbnailsView thumbnailsView = this.docViewer.getThumbnailsView();
        if (thumbnailsView == null) {
            return;
        }
        ThumbnailView selectedThumbnailView = thumbnailsView.getThumbnailView(index);
        if (selectedThumbnailView == null) {
            return;
        }
        ThumbnailData data = selectedThumbnailView.getData();
        if (data != null) {
            data.setSelected(true);
        }
        thumbnailsView.repaint();
    }

    protected AbstractPageView[] getInvisiblePages() {
        AbstractPageView[] visPages = this.getVisiblePages();
        Vector allPages = (Vector)this.pageViews.clone();
        for (int i = 0; visPages != null && i < visPages.length; ++i) {
            allPages.remove(visPages[i]);
        }
        AbstractPageView[] retPages = new AbstractPageView[allPages.size()];
        for (int i = 0; i < allPages.size(); ++i) {
            retPages[i] = (AbstractPageView)allPages.get(i);
        }
        return retPages;
    }

    protected void unloadAllPages() {
        for (int i = 0; i < this.pageViews.size(); ++i) {
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(i);
            aPageView.setPageImage(null);
        }
    }

    protected void unloadInvisiblePages() {
        AbstractPageView[] invisPages = this.getInvisiblePages();
        for (int i = 0; invisPages != null && i < invisPages.length; ++i) {
            invisPages[i].setPageImage(null);
        }
    }

    protected AbstractPageView getFirstFullyVisiblePage(AbstractPageView[] visiblePages) {
        if (visiblePages == null || visiblePages.length == 0) {
            return null;
        }
        JScrollPane pageScroller = this.docViewer.getPagesScroller();
        Component pagesComp = pageScroller.getViewport().getView();
        Rectangle viewRect = pageScroller.getViewport().getViewRect();
        for (int page = 0; page < visiblePages.length; ++page) {
            AbstractPageView aPageView = visiblePages[page];
            Rectangle bbox = this.getAbsoluteBounds(aPageView);
            bbox.grow(-4, -4);
            if (!viewRect.contains(bbox)) continue;
            return aPageView;
        }
        return null;
    }

    protected Rectangle getAbsoluteBounds(Component source) {
        PagesGroupPane parentForPage = (PagesGroupPane)AtComponentUtil.getParentForComponent(source, PagesGroupPane.class, true);
        Rectangle parentBbox = null;
        if (parentForPage != null) {
            parentBbox = parentForPage.getBounds();
        }
        Rectangle selfBbox = source.getBounds();
        if (parentBbox == null) {
            return selfBbox;
        }
        int x = parentBbox.x + selfBbox.x;
        int y = parentBbox.y + selfBbox.y;
        Rectangle bbox = new Rectangle(x, y, selfBbox.width, selfBbox.height);
        return bbox;
    }

    protected AbstractPageView getMaxVisiblePage(AbstractPageView[] visiblePages) {
        if (visiblePages == null || visiblePages.length == 0) {
            return null;
        }
        JScrollPane pageScroller = this.docViewer.getPagesScroller();
        Component pagesComp = pageScroller.getViewport().getView();
        Rectangle viewRect = pageScroller.getViewport().getViewRect();
        int maxVisibleHeight = 0;
        AbstractPageView maxVisiblePage = null;
        for (int page = 0; page < visiblePages.length; ++page) {
            AbstractPageView aPageView = visiblePages[page];
            Rectangle bbox = this.getAbsoluteBounds(aPageView);
            bbox.grow(-4, -4);
            Rectangle ir = viewRect.intersection(bbox);
            if (ir.height <= maxVisibleHeight) continue;
            maxVisibleHeight = ir.height;
            maxVisiblePage = aPageView;
        }
        return maxVisiblePage;
    }

    protected AbstractPageView[] getVisiblePages() {
        ArrayList<AbstractPageView> list = new ArrayList<AbstractPageView>();
        JScrollPane pageScroller = this.docViewer.getPagesScroller();
        Component pagesComp = pageScroller.getViewport().getView();
        Rectangle visRect = pageScroller.getViewport().getVisibleRect();
        Rectangle viewRect = pageScroller.getViewport().getViewRect();
        Dimension viewSize = pageScroller.getViewport().getViewSize();
        int matchCount = 0;
        int unmatchCountAfter = 0;
        boolean unmatchCountBefore = false;
        for (int page = 0; page < this.pageViews.size(); ++page) {
            if (page >= 511) {
                int x = 10;
                ++x;
            }
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(page);
            Rectangle bbox = this.getAbsoluteBounds(aPageView);
            bbox.grow(-4, -4);
            if (viewRect.intersects(bbox)) {
                list.add(aPageView);
                ++matchCount;
            } else if (matchCount > 0) {
                ++unmatchCountAfter;
            }
            if (matchCount > 0 && unmatchCountAfter > 0) break;
        }
        AbstractPageView[] visPages = new AbstractPageView[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            visPages[i] = (AbstractPageView)list.get(i);
        }
        return visPages;
    }

    protected AbstractPageView getViewForPageData(AbstractPage page) {
        if (this.docViewer.isSinglePageMode()) {
            AbstractPageView currPageView = this.getDisplayedPageView();
            return currPageView;
        }
        return (AbstractPageView)this.pageViews.get(page.getPageIndex());
    }

    public String getPageSizeInfo(Point p) {
        AbstractPageView pageView = this.getPageViewAt(p);
        if (pageView != null) {
            return pageView.getPageSizeInfo();
        }
        return null;
    }

    public AbstractPageView getPageViewAt(Point p) {
        for (int page = 0; page < this.pageViews.size(); ++page) {
            Point tp;
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(page);
            if (!aPageView.contains(tp = SwingUtilities.convertPoint(this, p, aPageView))) continue;
            return aPageView;
        }
        return null;
    }

    public String getPageSizeInfoTooltip(Point p) {
        AbstractPageView pageView = this.getPageViewAt(p);
        if (pageView != null) {
            return pageView.getPageSizeInfoTooltip();
        }
        return null;
    }

    public void setTooltipEnabled(boolean enabled) {
        for (int page = 0; page < this.pageViews.size(); ++page) {
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(page);
            aPageView.setTooltipEnabled(enabled);
        }
    }

    public boolean isTooltipEnabled() {
        AbstractPageView currPageView = this.getDisplayedPageView();
        if (currPageView != null) {
            return currPageView.isTooltipEnabled();
        }
        return true;
    }

    public void setMargin(int margin) {
        this.setMargins(new Insets(margin, margin, margin, margin));
    }

    public int getMargin() {
        Insets margins = this.getMargins();
        if (margins != null) {
            return margins.left;
        }
        return -1;
    }

    public Insets getMargins() {
        AbstractPageView currPageView = this.getDisplayedPageView();
        if (currPageView != null) {
            return currPageView.getMargins();
        }
        return null;
    }

    public void setMargins(Insets margins) {
        if (margins == null) {
            return;
        }
        this.margins = margins;
        for (int page = 0; page < this.pageViews.size(); ++page) {
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(page);
            aPageView.setMargins(margins);
        }
    }

    public int getPageShadowMargin() {
        AbstractPageView currPageView = this.getDisplayedPageView();
        if (currPageView != null) {
            return currPageView.getPageShadowMargin();
        }
        return -1;
    }

    public void setPageShadowMargin(int pageShadowMargin) {
        for (int page = 0; page < this.pageViews.size(); ++page) {
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(page);
            aPageView.setPageShadowMargin(pageShadowMargin);
        }
    }

    public void rotate(int direction, int degrees, boolean isRelativeToPreviousRotation) {
        for (int page = 0; page < this.pageViews.size(); ++page) {
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(page);
            aPageView.rotate(direction, degrees, isRelativeToPreviousRotation);
        }
    }

    public double getFitZoom(int pageIndex) {
        if (this.docViewer.isFitPageToWidthOnViewResize()) {
            return this.getFitToWidthZoom(pageIndex);
        }
        if (this.docViewer.isFitPageToHeightOnViewResize()) {
            return this.getFitToHeightZoom(pageIndex);
        }
        if (this.docViewer.isFitPageToWindowOnViewResize()) {
            boolean widthFit = this.isWidthFit(pageIndex);
            if (!widthFit) {
                return this.getFitToHeightZoom(pageIndex);
            }
            return this.getFitToWidthZoom(pageIndex);
        }
        if (this.docViewer.isHundredPercentView()) {
            return 1.0;
        }
        return this.docViewer.getCurrentUserSelectedZoom();
    }

    public double getFitToWidthZoom() {
        AbstractPageView currPageView = this.getDisplayedPageView();
        int pageIndex = currPageView.getPage().getPageIndex();
        return this.getFitToWidthZoom(pageIndex);
    }

    public double getFitToWidthZoom(int pageIndex) {
        JScrollPane pageScroller = this.docViewer.getPagesScroller();
        Insets margins = this.getMargins();
        Rectangle visibleRect = pageScroller.getViewport().getVisibleRect();
        float pageViewWidth = visibleRect.width;
        pageViewWidth -= (float)(margins.left + margins.right);
        pageViewWidth -= (float)this.getPageShadowMargin();
        double verticalScrollBarWidth = 0.0;
        if (!pageScroller.getVerticalScrollBar().isVisible()) {
            verticalScrollBarWidth = pageScroller.getVerticalScrollBar().getWidth();
        }
        pageViewWidth = (float)((double)pageViewWidth - verticalScrollBarWidth);
        double actualPageWidth = this.getRotatedPageWidth(pageIndex);
        double zoom = (double)pageViewWidth / actualPageWidth;
        double zoomToUse = this.getZoomToUse(zoom);
        return zoomToUse;
    }

    public double getFitToHeightZoom() {
        AbstractPageView currPageView = this.getDisplayedPageView();
        int pageIndex = currPageView.getPage().getPageIndex();
        return this.getFitToHeightZoom(pageIndex);
    }

    public double getFitToHeightZoom(int pageIndex) {
        JScrollPane pageScroller = this.docViewer.getPagesScroller();
        Insets margins = this.getMargins();
        Rectangle visibleRect = pageScroller.getViewport().getVisibleRect();
        float pageViewHeight = visibleRect.height;
        pageViewHeight -= (float)(margins.top + margins.bottom);
        pageViewHeight -= (float)this.getPageShadowMargin();
        double hScrollBarHeight = 0.0;
        if (pageScroller.getHorizontalScrollBar().isVisible()) {
            hScrollBarHeight = pageScroller.getHorizontalScrollBar().getHeight();
        }
        pageViewHeight = (float)((double)pageViewHeight + hScrollBarHeight);
        double actualPageHeight = this.getRotatedPageHeight(pageIndex);
        double zoom = (double)pageViewHeight / actualPageHeight;
        return zoom;
    }

    public AbstractPageView getPageView(int pageIndex) {
        for (int i = 0; i < this.pageViews.size(); ++i) {
            AbstractPageView aPageView = (AbstractPageView)this.pageViews.get(i);
            if (aPageView.getPage().getPageIndex() != pageIndex) continue;
            return aPageView;
        }
        return null;
    }

    public double getRotatedPageWidth(int pageIndex) {
        AbstractPageView pageView = this.getPageView(pageIndex);
        if (pageView != null) {
            return pageView.getRotatedPageWidth();
        }
        return -1.0;
    }

    public double getRotatedPageHeight(int pageIndex) {
        AbstractPageView pageView = this.getPageView(pageIndex);
        if (pageView != null) {
            return pageView.getRotatedPageHeight();
        }
        return -1.0;
    }

    public boolean isWidthFit() {
        AbstractPageView currPageView = this.getDisplayedPageView();
        int pageIndex = currPageView.getPage().getPageIndex();
        return this.isWidthFit(pageIndex);
    }

    protected boolean isWidthFit(int pageIndex) {
        double pageHeight;
        double fy;
        JScrollPane pageScroller = this.docViewer.getPagesScroller();
        Rectangle visRect = pageScroller.getViewport().getViewRect();
        int viewWidth = visRect.width;
        int viewHeight = visRect.height;
        AbstractPageView pageView = this.getPageView(pageIndex);
        double pageWidth = pageView.getRotatedPageWidth();
        double fx = (double)viewWidth / pageWidth;
        return !(fx > (fy = (double)viewHeight / (pageHeight = pageView.getRotatedPageHeight())));
    }

    public double getZoomToUse(double zoom) {
        double maxZoomPercent = this.docViewer.getMaximumZoomPercent();
        double maxZoom = maxZoomPercent / 100.0;
        double minZoomPercent = this.docViewer.getMinimumZoomPercent();
        double minZoom = minZoomPercent / 100.0;
        double zoomToUse = zoom;
        if (zoom > maxZoom) {
            zoomToUse = maxZoom;
        } else if (zoom < minZoom) {
            zoomToUse = minZoom;
        }
        return zoomToUse;
    }
}

