/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.exception.AtException;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.resource.AtConstants;
import com.activetree.common.utils.GraphicsUtil;
import com.activetree.common.viewer.ThumbnailData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ThumbnailView
extends JPanel {
    protected Color selectionBackground = AtConstants.SELECTION_BACKGROUND;
    protected Color selectionForeground = AtConstants.SELECTION_FOREGROUND;
    protected int shadowThickness = 3;
    protected JComponent parentView;
    protected ThumbnailData data;
    protected Insets insets = new Insets(0, 0, 0, 0);
    protected Insets selectionInsets = new Insets(5, 5, 5, 5);
    protected int thumbnailWidth = 55;
    private int thumbnailHeight = 70;
    protected double scaleToUse = -1.0;
    private boolean thumbnailLoadingEnabled = true;
    private Object icon;
    private double widthHeightRatio;
    protected Rectangle pageIconBounds;
    protected Rectangle pageSelectionBbox;
    protected Rectangle pageNoBbox;

    public ThumbnailView(ThumbnailData data, JComponent owner) {
        this.data = data;
        this.parentView = owner;
        this.calculateSize();
    }

    public void clean() {
        this.parentView = null;
        this.data = null;
        this.icon = null;
    }

    public Rectangle2D getRotatedPrintableArea(AbstractPage pageData) {
        Rectangle2D printableArea = pageData.getPrintableArea();
        return printableArea;
    }

    protected void calculateSize() {
        AbstractPage page = this.data.getPage();
        Rectangle2D printableArea = this.getRotatedPrintableArea(page);
        double pageWidth = printableArea.getWidth();
        double pageHeight = printableArea.getHeight();
        this.widthHeightRatio = pageWidth / pageHeight;
        double newHeight = (double)this.thumbnailWidth / this.widthHeightRatio;
        this.thumbnailHeight = (int)newHeight;
        page.setPrinterPageFormat(null);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int fontHeight = fm.getHeight();
        int w = this.insets.left;
        w += this.selectionInsets.left;
        w += this.thumbnailWidth;
        w += this.shadowThickness;
        w += this.selectionInsets.right;
        w += this.insets.right;
        int h = this.insets.top;
        h += this.selectionInsets.top;
        h += this.thumbnailHeight;
        h += this.shadowThickness;
        h += this.selectionInsets.bottom;
        h += fontHeight / 4 * 3;
        double widthResizeFactor = (double)this.thumbnailWidth / pageWidth;
        double heightResizeFactor = (double)this.thumbnailHeight / pageHeight;
        this.scaleToUse = Math.min(widthResizeFactor, heightResizeFactor);
        this.setPreferredSize(new Dimension(w, h += this.insets.bottom));
        this.initBounds();
    }

    protected void initBounds() {
        Rectangle pageBbox;
        Insets insets = this.getInsets();
        int itop = 0;
        int ileft = 0;
        int ibottom = 0;
        int iright = 0;
        if (insets != null) {
            itop = insets.top;
            ileft = insets.left;
            ibottom = insets.bottom;
            iright = insets.right;
        }
        Dimension d = this.getSize();
        int w = d.width;
        int h = d.height;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        String pageNoStr = String.valueOf(this.data.pageIndex + 1);
        int labelWidth = GraphicsUtil.stringWidth(this.getFont(), pageNoStr);
        int labelHeight = fm.getHeight();
        Rectangle viewBbox = new Rectangle(itop, ileft, w - (ileft + iright) - 1, h - (itop + ibottom) - 1);
        this.pageSelectionBbox = new Rectangle(viewBbox.x, viewBbox.y, this.selectionInsets.left + this.thumbnailWidth + this.shadowThickness + this.selectionInsets.right, this.selectionInsets.top + this.thumbnailHeight + this.shadowThickness + this.selectionInsets.bottom);
        this.pageIconBounds = pageBbox = new Rectangle(this.pageSelectionBbox.x + this.selectionInsets.left, this.pageSelectionBbox.y + this.selectionInsets.top, this.thumbnailWidth, this.thumbnailHeight);
        int labelx = (int)pageBbox.getCenterX() - labelWidth / 2;
        int labelBboxY = this.pageSelectionBbox.y + this.pageSelectionBbox.height;
        this.pageNoBbox = new Rectangle(labelx - this.selectionInsets.left, labelBboxY, this.selectionInsets.left + labelWidth + this.selectionInsets.right, labelHeight / 4 * 3);
    }

    public double getPageWidthToHeightRatio() {
        return this.widthHeightRatio;
    }

    public void setThumbnailImage(Image tnImage) {
        this.icon = tnImage;
    }

    public Image getThumbnailImage() {
        if (this.icon instanceof Image) {
            return (Image)this.icon;
        }
        return null;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public double getScale() {
        return this.scaleToUse;
    }

    public void setThumbnailLoadingEnabled(boolean thumbnailLoadingEnabled) {
        this.thumbnailLoadingEnabled = thumbnailLoadingEnabled;
    }

    public boolean isThumbnailLoadingEnabled() {
        return this.thumbnailLoadingEnabled;
    }

    public void setSelectionColor(Color selectionBackground) {
        this.selectionBackground = selectionBackground;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color selectionForeground) {
        this.selectionForeground = selectionForeground;
    }

    public Insets getSelectionInsets() {
        return this.selectionInsets;
    }

    public void setSelectionInsets(Insets selectionInsets) {
        this.selectionInsets = selectionInsets;
    }

    public int getShadowThickness() {
        return this.shadowThickness;
    }

    public void setShadowThickness(int shadowThickness) {
        this.shadowThickness = shadowThickness;
    }

    public ThumbnailData getData() {
        return this.data;
    }

    public void setThumbnailWidth(int width) {
        this.thumbnailWidth = width;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public Rectangle getPageIconBounds() {
        return this.pageIconBounds;
    }

    public Rectangle getPageSelectionBBox() {
        return this.pageSelectionBbox;
    }

    public Rectangle getPageNumberSelectionBBox() {
        return this.pageNoBbox;
    }

    protected BufferedImage createThumbNailIcon() throws AtException {
        AbstractPage page = this.data.getPage();
        PageFormat pf = new PageFormat();
        pf.setOrientation(1);
        Paper p = new Paper();
        p.setSize(this.thumbnailWidth, this.thumbnailHeight);
        p.setImageableArea(0.0, 0.0, this.thumbnailWidth, this.thumbnailHeight);
        BufferedImage pageImage = null;
        pageImage = new BufferedImage(this.thumbnailWidth, this.thumbnailHeight, 1);
        pf.setPaper(p);
        page.setPrinterPageFormat(pf);
        page.setFitToPrintableArea(true);
        Graphics g = pageImage.getGraphics();
        g.setColor(SystemColor.white);
        g.fillRect(0, 0, pageImage.getWidth(), pageImage.getHeight());
        page.setZoom(this.scaleToUse);
        page.draw(g);
        return pageImage;
    }

    public void paintComponent(Graphics graphics) {
        Rectangle pageBbox;
        super.paintComponent(graphics);
        if (this.data == null) {
            return;
        }
        if (this.icon == null && this.isThumbnailLoadingEnabled()) {
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        ThumbnailView.this.icon = ThumbnailView.this.createThumbNailIcon();
                        ThumbnailView.this.repaint();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            this.icon = this.data;
            SwingUtilities.invokeLater(r);
        }
        Graphics2D g = (Graphics2D)graphics;
        Insets insets = this.getInsets();
        int itop = 0;
        int ileft = 0;
        int ibottom = 0;
        int iright = 0;
        if (insets != null) {
            itop = insets.top;
            ileft = insets.left;
            ibottom = insets.bottom;
            iright = insets.right;
        }
        Dimension d = this.getSize();
        int w = d.width;
        int h = d.height;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        String pageNoStr = String.valueOf(this.data.pageIndex + 1);
        int labelWidth = GraphicsUtil.stringWidth(this.getFont(), pageNoStr);
        int labelHeight = fm.getHeight();
        Rectangle viewBbox = new Rectangle(itop, ileft, w - (ileft + iright) - 1, h - (itop + ibottom) - 1);
        this.pageSelectionBbox = new Rectangle(viewBbox.x, viewBbox.y, this.selectionInsets.left + this.thumbnailWidth + this.shadowThickness + this.selectionInsets.right, this.selectionInsets.top + this.thumbnailHeight + this.shadowThickness + this.selectionInsets.bottom);
        this.pageIconBounds = pageBbox = new Rectangle(this.pageSelectionBbox.x + this.selectionInsets.left, this.pageSelectionBbox.y + this.selectionInsets.top, this.thumbnailWidth, this.thumbnailHeight);
        Rectangle shadowBbox = new Rectangle(pageBbox.x + this.shadowThickness, pageBbox.y + this.shadowThickness, pageBbox.width, pageBbox.height);
        int labelx = (int)pageBbox.getCenterX() - labelWidth / 2;
        int labelBboxY = this.pageSelectionBbox.y + this.pageSelectionBbox.height;
        this.pageNoBbox = new Rectangle(labelx - this.selectionInsets.left, labelBboxY, this.selectionInsets.left + labelWidth + this.selectionInsets.right, labelHeight / 4 * 3);
        g.setColor(this.getBackground());
        g.fill(viewBbox);
        if (this.data.selected) {
            g.setColor(this.getSelectionBackground());
            g.fill(this.pageSelectionBbox);
        }
        g.setColor(SystemColor.controlDkShadow);
        g.fill(shadowBbox);
        g.setColor(SystemColor.white);
        g.fill(pageBbox);
        if (this.icon != null && this.icon instanceof Image) {
            Image image = (Image)this.icon;
            g.drawImage(image, pageBbox.x, pageBbox.y, this);
        }
        if (this.data.selected) {
            g.setColor(this.getSelectionBackground());
            g.fill(this.pageNoBbox);
        }
        if (this.data.selected) {
            g.setColor(this.getSelectionForeground());
        } else {
            g.setColor(this.getForeground());
        }
        int labely = this.pageSelectionBbox.y + this.pageSelectionBbox.height + labelHeight - labelHeight / 4 * 2;
        g.drawString(pageNoStr, labelx, labely);
        g.setColor(SystemColor.black);
        g.draw(pageBbox);
    }

    protected void draw(Graphics g) {
        try {
            this.data.getPage().draw(g);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

