/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.web;

import com.activetree.common.attr.reader.CommonAttributeReader;
import com.activetree.common.attr.reader.DefaultCommonAttributeReader;
import com.activetree.common.doc.DocEvent;
import com.activetree.common.doc.DocListener;
import com.activetree.common.doc.PrintDialog;
import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.media.StandardPapers;
import com.activetree.common.print.AbstractPrinter;
import com.activetree.common.print.dialog.AtPrintDialog;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.resource.AtImageList;
import com.activetree.common.resource.AtResource;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.JreUtil;
import com.activetree.common.utils.MediaUtil;
import com.activetree.common.utils.PrintUtil;
import com.activetree.common.utils.ReferenceHolder;
import com.activetree.common.utils.WebUtil;
import com.activetree.common.web.BasicWebContextImpl;
import com.activetree.common.web.CallBackReply;
import com.activetree.common.web.WebContext;
import com.activetree.common.web.WebInterface;
import java.awt.Component;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;
import javax.swing.ImageIcon;

public abstract class WebDocAttributeParser
implements WebInterface,
Runnable {
    protected WebInterface docParamContext;
    protected DefaultCommonAttributeReader webDoc;
    protected WebContext webContext;
    protected PrintDialog printDialog;
    protected boolean inited = false;

    public WebDocAttributeParser(WebInterface docParamContext) {
        this.docParamContext = docParamContext;
    }

    public WebContext getWebContext() {
        return this.webContext;
    }

    public void run() {
    }

    public Component getContextOwner() {
        Component contextComp = this.docParamContext.getComponent();
        Component owner = BasicWebContextImpl.getWindowForComponent(contextComp);
        if (owner == null) {
            owner = contextComp;
        }
        return owner;
    }

    public Component getComponent() {
        return this.docParamContext.getComponent();
    }

    public String getParameter(String param) {
        return this.docParamContext.getParameter(param);
    }

    public Object getObjectParameter(String param) {
        return this.docParamContext.getObjectParameter(param);
    }

    public URL getCodeBase() {
        return this.docParamContext.getCodeBase();
    }

    public URL getDocumentBase() {
        return this.docParamContext.getDocumentBase();
    }

    public void init() {
        this.initResources();
        this.initContext();
        String debugStr = null;
        try {
            debugStr = this.getParameter("DEBUG");
            String jvmDebugArg = System.getProperty("SMARTJ_DEBUG");
            if (debugStr != null && jvmDebugArg == null) {
                if (debugStr.equalsIgnoreCase("true")) {
                    System.setProperty("SMARTJ_DEBUG", "true");
                } else if (debugStr.equalsIgnoreCase("false")) {
                    System.setProperty("SMARTJ_DEBUG", "false");
                }
            }
        }
        catch (Throwable t) {
            AtDebug.getLogStream().println("WARNING: Could not set debug system property " + debugStr);
        }
        String debugLevel = null;
        try {
            debugLevel = this.getParameter("DEBUG_LEVEL");
            if (debugLevel != null) {
                System.setProperty("SMARTJ_DEBUG_LEVEL", debugLevel);
            }
        }
        catch (Throwable t) {
            AtDebug.getLogStream().println("WARNING: Could not set debug level system property " + debugLevel);
        }
        AtDebug.resetDebug();
        String jobId = Integer.toHexString(this.hashCode());
        AtDebug.debug("%%% WebDoc [ID: " + jobId + "] %%% Input [DEBUG:" + debugStr + ", DEBUG_LEVEL=" + debugLevel + "] Application [debug=" + AtDebug.isDebug() + ", currDebugLevel=" + AtDebug.getCurrentDebugLevel() + "] System [" + "SMARTJ_DEBUG" + "=" + System.getProperty("SMARTJ_DEBUG") + ", " + "SMARTJ_DEBUG_LEVEL" + "=" + System.getProperty("SMARTJ_DEBUG_LEVEL") + "]");
        this.webDoc.setAttribute("ON_MESSAGE_JS_NAME", this.getStringParameter("ON_MESSAGE_JS_NAME", null));
        this.webDoc.setAttribute("ON_MESSAGE_JS_TARGET", this.getStringParameter("ON_MESSAGE_JS_TARGET", null));
        String successPage = this.getStringParameter("ON_SUCCESS_SHOW_PAGE", null);
        this.webDoc.setAttribute("ON_SUCCESS_SHOW_PAGE", WebUtil.getUrlString("ON_SUCCESS_SHOW_PAGE", successPage));
        this.webDoc.setAttribute("ON_SUCCESS_PAGE_TARGET", this.getStringParameter("ON_SUCCESS_PAGE_TARGET", null));
        String errorPage = this.getStringParameter("ON_FAILURE_SHOW_PAGE", null);
        this.webDoc.setAttribute("ON_FAILURE_SHOW_PAGE", WebUtil.getUrlString("ON_FAILURE_SHOW_PAGE", errorPage));
        this.webDoc.setAttribute("ON_FAILURE_PAGE_TARGET", this.getStringParameter("ON_FAILURE_PAGE_TARGET", null));
        String serverCallbackPage = this.getStringParameter("SERVER_CALL_BACK_URL", null);
        this.webDoc.setAttribute("SERVER_CALL_BACK_URL", WebUtil.getUrlString("SERVER_CALL_BACK_URL", serverCallbackPage));
        this.webDoc.setAttribute("DOC_ID", this.getStringParameter("DOC_ID", null));
        String jSessionId = this.getParameter("jsessionid");
        ReferenceHolder.setAttribute("jsessionid", jSessionId);
        this.webDoc.setAttribute("jsessionid", jSessionId);
        AtDebug.debug("jSessionId=\"" + jSessionId + '\"');
        AtDebug.debug("successPage=" + successPage);
        AtDebug.debug("errorPage=" + errorPage);
        AtDebug.debug("serverCallbackPage=" + serverCallbackPage);
        this.webDoc.setAttribute("JOB_ID", jobId);
        this.inited = this.initDocParams(this.webContext);
        Object docListener = this.webDoc.getAttribute("DOC_LISTENER");
        if (docListener != null && docListener instanceof DocListener) {
            Object docListStr = this.webDoc.getAttribute("DOC_LIST_OBJ");
            DocEvent evt = new DocEvent(docListStr, 26, -1, this.webDoc.getStringAttribute("JOB_NAME"));
            evt.setWebDoc(this.webDoc);
            ((DocListener)docListener).activityPerformed(evt);
        }
        String memory = JreUtil.getMemoryInfo();
        this.webContext.debug(memory);
    }

    protected void initResources() {
        try {
            ImageIcon sampleIcon = AtImageList.IMAGE_LIST.ACTIVETREE_ICON_30;
            AtResource atResource = AtCommonResource.MESSAGE_RESOURCE;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void initContext() {
        this.webDoc = this.createWebDoc();
        this.webContext = this.createWebContext(this.webDoc);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public Object getContext() {
        return this.docParamContext.getContext();
    }

    protected boolean initDocParams(WebContext context) {
        int idx;
        CommonAttributeReader webDoc = context.getWebDoc();
        Boolean debug = this.getBooleanParameter("DEBUG", null);
        webDoc.setAttribute("DEBUG", debug);
        context.debug("Params");
        URL docBaseUrl = null;
        try {
            docBaseUrl = this.getDocumentBase();
        }
        catch (Throwable t) {
            // empty catch block
        }
        String docBaseStr = docBaseUrl != null ? URLDecoder.decode(docBaseUrl.toString()) : null;
        this.webContext.debug("docBase: [" + docBaseStr + "]");
        String licenseKey = this.getStringParameter("LICENSE_KEY", null);
        webDoc.setAttribute("LICENSE_KEY", licenseKey);
        this.setLicenseKey(licenseKey);
        String docId = this.getStringParameter("DOC_ID", null);
        Object replyDocList = null;
        CallBackReply docIdReply = null;
        if (docId != null && docId.length() > 0) {
            docIdReply = this.webContext.callServer("POST", "DOC_ID");
            this.webContext.processCallBackReplyBefore(docIdReply);
            replyDocList = webDoc.getAttribute("DOC_LIST");
        }
        Object docs = null;
        if (replyDocList != null) {
            docs = "DOC_LIST=" + replyDocList;
            this.webContext.debug("Reply DOC_LIST instance of: " + replyDocList.getClass().getName());
            this.webContext.debug("Using...DOC_LIST...replyDocList [" + replyDocList + "]");
            this.webContext.debug("");
        } else {
            docs = this.getDocListObject("DOC_LIST");
            this.webContext.debug("");
            this.webContext.debug("Using...DOC_LIST...getDocListObject");
            this.webContext.debug("{" + docs + "}");
            this.webContext.debug("");
        }
        List docList = this.populateDocList(docs);
        webDoc.setAttribute("DOC_LIST_OBJ", docList);
        boolean hasDocList = this.hasDocList(docList);
        this.webContext.debug("hasDocList? " + hasDocList);
        String printerName = this.getStringParameter("PRINTER_NAME", null);
        Boolean printerNameSubstringMatch = this.getBooleanParameter("PRINTER_NAME_SUBSTRING_MATCH", null);
        String printerNameExcludePattern = this.getStringParameter("PRINTER_NAME_EXCLUDE_PATTERN", null);
        String inputPaperName = this.getStringParameter("PAPER", null);
        String paperName = this.getPaperName(inputPaperName);
        Integer pageScaling = this.getPageScalingParameter("PAGE_SCALING", null);
        Boolean autoRotateAndCenter = this.getBooleanParameter("AUTO_ROTATE_AND_CENTER", null);
        Boolean autoMatchPaper = this.getBooleanParameter("AUTO_MATCH_PAPER", null);
        Boolean isUsePrinterMargins = this.getBooleanParameter("IS_USE_PRINTER_MARGINS", null);
        Integer copies = this.getIntegerParameter("COPIES", null);
        Boolean collateCopies = this.getBooleanParameter("COLLATE_COPIES", null);
        String jobName = this.getStringParameter("JOB_NAME", null);
        Boolean showPrintDialog = this.getBooleanParameter("SHOW_PRINT_DIALOG", null);
        String printDialogTitle = this.getStringParameter("PRINT_DIALOG_TITLE", null);
        Boolean singlePrintJob = this.getBooleanParameter("SINGLE_PRINT_JOB", null);
        Boolean showErrorDialog = this.getBooleanParameter("SHOW_PRINT_ERROR_DIALOG", null);
        String password = this.getStringParameter("PASSWORD", "");
        String urlAuthId = this.getStringParameter("URL_AUTH_ID", null);
        String urlAuthPassword = this.getStringParameter("URL_AUTH_PASSWORD", null);
        String printQuality = this.getStringParameter("PRINT_QUALITY", null);
        String side = this.getStringParameter("SIDE_TO_PRINT", null);
        Boolean statusUpdateEnabled = this.getBooleanParameter("STATUS_UPDATE_ENABLED", null);
        DocListener docListener = this.loadDocListener("DOC_LISTENER");
        String viewerControls = this.getStringParameter("VIEWER_CONTROLS", null);
        String zoomComboValues = this.getStringParameter("ZOOM_COMBO_VALUES", null);
        Boolean isShowPrintPreview = this.getBooleanParameter("IS_SHOW_PRINT_PREVIEW", null);
        String viewerPage = this.getStringParameter("VIEWER_PAGE", null);
        String codeBase = docBaseStr;
        int n = idx = docBaseStr != null ? docBaseStr.indexOf(63) : -1;
        if (idx > 0) {
            codeBase = docBaseStr != null ? docBaseStr.substring(0, idx) : null;
        }
        int idx2 = codeBase != null ? codeBase.lastIndexOf(47) : -1;
        String baseUrl = codeBase != null ? codeBase.substring(0, idx2 + 1) : null;
        this.webContext.debug("CODE_BASE=" + baseUrl);
        webDoc.setAttribute("DOC_LISTENER", docListener);
        webDoc.setAttribute("DOC_LIST", docs);
        webDoc.setAttribute("DOC_LIST_OBJ", docList);
        webDoc.setAttribute("DEBUG", debug);
        webDoc.setAttribute("PRINTER_NAME", printerName);
        webDoc.setAttribute("PRINTER_NAME_SUBSTRING_MATCH", printerNameSubstringMatch);
        webDoc.setAttribute("PRINTER_NAME_EXCLUDE_PATTERN", printerNameExcludePattern);
        webDoc.setAttribute("PAPER", paperName);
        webDoc.setAttribute("PAGE_SCALING", pageScaling);
        webDoc.setAttribute("AUTO_ROTATE_AND_CENTER", autoRotateAndCenter);
        webDoc.setAttribute("AUTO_MATCH_PAPER", autoMatchPaper);
        webDoc.setAttribute("IS_USE_PRINTER_MARGINS", isUsePrinterMargins);
        webDoc.setAttribute("COPIES", copies);
        webDoc.setAttribute("COLLATE_COPIES", collateCopies);
        webDoc.setAttribute("JOB_NAME", jobName);
        webDoc.setAttribute("SHOW_PRINT_DIALOG", showPrintDialog);
        webDoc.setAttribute("PRINT_DIALOG_TITLE", printDialogTitle);
        webDoc.setAttribute("SINGLE_PRINT_JOB", singlePrintJob);
        webDoc.setAttribute("SHOW_PRINT_ERROR_DIALOG", showErrorDialog);
        webDoc.setAttribute("PASSWORD", password);
        webDoc.setAttribute("URL_AUTH_ID", urlAuthId);
        webDoc.setAttribute("URL_AUTH_PASSWORD", urlAuthPassword);
        webDoc.setAttribute("PRINT_QUALITY", printQuality);
        webDoc.setAttribute("SIDE_TO_PRINT", side);
        webDoc.setAttribute("STATUS_UPDATE_ENABLED", statusUpdateEnabled);
        webDoc.setAttribute("CODE_BASE", baseUrl);
        webDoc.setAttribute("IS_SHOW_PRINT_PREVIEW", isShowPrintPreview);
        webDoc.setAttribute("VIEWER_PAGE", viewerPage);
        webDoc.setAttribute("VIEWER_CONTROLS", viewerControls);
        webDoc.setAttribute("ZOOM_COMBO_VALUES", zoomComboValues);
        if (replyDocList != null) {
            this.webContext.debug("Reset....doc_id params received from server");
            this.webContext.processCallBackReplyBefore(docIdReply);
        }
        return true;
    }

    Map getHInfo() {
        int idx;
        String docBaseStr;
        URL docBaseUrl = null;
        try {
            docBaseUrl = this.getDocumentBase();
        }
        catch (Throwable t) {
            // empty catch block
        }
        String codeBase = docBaseStr = docBaseUrl != null ? URLDecoder.decode(docBaseUrl.toString()) : null;
        int n = idx = docBaseStr != null ? docBaseStr.indexOf(63) : -1;
        if (idx > 0) {
            codeBase = docBaseStr != null ? docBaseStr.substring(0, idx) : null;
        }
        int idx2 = codeBase != null ? codeBase.lastIndexOf(47) : -1;
        String baseUrl = codeBase != null ? codeBase.substring(0, idx2 + 1) : null;
        String hia = null;
        String hna = null;
        String hta = null;
        WebDocAttributeParser webCtx = this;
        if (webCtx != null && baseUrl != null && baseUrl.length() > 0) {
            String s;
            int idx3 = baseUrl.indexOf("//");
            String ts = baseUrl.substring(idx3 + 1);
            StringBuffer buf = new StringBuffer();
            boolean start = false;
            for (int i = 0; i < ts.length(); ++i) {
                char ch = ts.charAt(i);
                if (Character.isLetter(ch)) {
                    start = true;
                }
                if (start && (ch == '/' || ch == ':')) break;
                if (!start) continue;
                buf.append(ch);
            }
            if ((s = buf.toString()).length() == 0) {
                s = null;
            }
            hna = s;
            String host = null;
            String ip = null;
            try {
                InetAddress webInet = InetAddress.getByName(hna);
                host = webInet.getHostName();
                ip = webInet.getHostAddress();
                hia = webInet.getHostAddress();
                if (ip.equalsIgnoreCase("127.0.0.1")) {
                    InetAddress localWeb = InetAddress.getLocalHost();
                    hna = localWeb.getHostName();
                    hia = localWeb.getHostAddress();
                }
            }
            catch (Throwable t2) {
                String errMsg = "getHInfo [docBaseUrl=" + docBaseUrl + "] [hna=" + hna + "] [errMsg=" + t2.getMessage() + "]";
                this.webContext.debug(7, errMsg);
            }
            hta = "web";
        } else if (webCtx == null) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
                hna = inet.getHostName();
                hia = inet.getHostAddress();
                hta = "localhost";
            }
            catch (Throwable t) {
                String errMsg = "getHInfo [hna=" + hna + "] [hia=" + hia + "] [errMsg=" + t.getMessage() + "]";
                this.webContext.debug(7, errMsg);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hta", hta);
        map.put("hna", hna);
        map.put("hia", hia);
        return map;
    }

    protected String getPaperName(String inputPaperName) {
        double tm = this.webContext.getWebDoc().getPrimitiveDoubleAttribute("PAPER_TOP_MARGIN");
        double lm = this.webContext.getWebDoc().getPrimitiveDoubleAttribute("PAPER_LEFT_MARGIN");
        double bm = this.webContext.getWebDoc().getPrimitiveDoubleAttribute("PAPER_BOTTOM_MARGIN");
        double rm = this.webContext.getWebDoc().getPrimitiveDoubleAttribute("PAPER_RIGHT_MARGIN");
        double defaultPaperWidth = this.webContext.getWebDoc().getPrimitiveDoubleAttribute("PAPER_WIDTH");
        double defaultPaperHeight = this.webContext.getWebDoc().getPrimitiveDoubleAttribute("PAPER_HEIGHT");
        String paperName = inputPaperName;
        this.webContext.debug("paperName (before filtering)=" + paperName);
        paperName = MediaUtil.getFilteredPaper(paperName, tm, lm, bm, rm, defaultPaperWidth, defaultPaperHeight);
        this.webContext.debug("Replaced paperName=" + paperName);
        return paperName;
    }

    public List populateDocList(Object docs) {
        List documentList = null;
        boolean byteArrayDocList = this.isByteArrayDocList(docs);
        if (byteArrayDocList) {
            documentList = (List)docs;
        } else {
            docs = WebUtil.parseDocListParam("DOC_LIST", (String)docs);
            documentList = WebUtil.getDocListParameter((String)docs);
        }
        return documentList;
    }

    public boolean isByteArrayDocList(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            int byteDocCount = 0;
            for (int i = 0; i < list.size(); ++i) {
                Object aDoc = list.get(i);
                if (!(aDoc instanceof byte[])) continue;
                ++byteDocCount;
            }
            if (byteDocCount == list.size()) {
                return true;
            }
            throw new RuntimeException("Not all elements in the DOC_LIST are byte[] content.");
        }
        return false;
    }

    protected List getList(String listAttr) {
        String docs = this.getStringParameter(listAttr, null);
        docs = WebUtil.parseDocListParam(listAttr, docs);
        List values = WebUtil.getDocListParameter(docs);
        return values;
    }

    protected AtPrintDialog initPrintDialog(AtPrintDialog printDialog) {
        printDialog.setRangeSelectionType(1);
        printDialog.setPrintCurrentPageEnabled(false);
        printDialog.setPrintRangeOfPagesEnabled(false);
        printDialog.setCopies(this.webDoc.getPrimitiveIntegerAttribute("COPIES"));
        printDialog.setPrintJobName((String)this.webDoc.getAttribute("JOB_NAME"));
        printDialog.setPageScaling(this.webDoc.getPrimitiveIntegerAttribute("PAGE_SCALING"));
        printDialog.setAutoRotateAndCenterSelected(this.webDoc.getPrimitiveBooleanAttribute("AUTO_ROTATE_AND_CENTER"));
        printDialog.setCollate(this.webDoc.getPrimitiveBooleanAttribute("COLLATE_COPIES"));
        printDialog.setUsePrinterMargins(this.webDoc.getPrimitiveBooleanAttribute("IS_USE_PRINTER_MARGINS"));
        printDialog.setChoosePaperSourceByPageSize(this.webDoc.getPrimitiveBooleanAttribute("AUTO_MATCH_PAPER"));
        String pName = this.webDoc.getStringAttribute("PRINTER_NAME");
        boolean subStrMatch = this.webDoc.getPrimitiveBooleanAttribute("PRINTER_NAME_SUBSTRING_MATCH");
        PrintService[] printers = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, new HashPrintRequestAttributeSet());
        for (int i = 0; pName != null && printers != null && i < printers.length; ++i) {
            PrintService ps = printers[i];
            String aName = ps.getName();
            if (aName == null) continue;
            if (subStrMatch) {
                int idx = aName.indexOf(pName);
                if (idx < 0) continue;
                pName = aName;
                break;
            }
            if (!aName.equalsIgnoreCase(pName)) continue;
            pName = aName;
            break;
        }
        printDialog.setPrintServiceSelected(pName);
        printDialog.setPrintQuality(this.webDoc.getStringAttribute("PRINT_QUALITY"));
        printDialog.setMediaSide(this.webDoc.getStringAttribute("SIDE_TO_PRINT"));
        printDialog.setStatusPropertyEnabled(this.webDoc.getPrimitiveBooleanAttribute("IS_USE_PRINTER_MARGINS"));
        String paperName = (String)this.webContext.getWebDoc().getAttribute("PAPER");
        PageFormat userPageFormat = WebDocAttributeParser.getPageFormatForSelectedMediaName(paperName, this.webContext);
        printDialog.setMediaSizeSelected(userPageFormat);
        Component owner = this.webContext.getContextOwner();
        Window window = AtComponentUtil.getWindowForComponent(owner);
        this.webContext.debug("Window for print dialog null? " + window);
        AtComponentUtil.centerOnContainer(window, printDialog);
        printDialog.refresh();
        return printDialog;
    }

    protected void downloadPrintDialogParams() {
        double tm;
        double lm;
        PrintService printService = this.printDialog.getSelectedPrintService();
        this.webDoc.setAttribute("ATTR_PRINT_SERVICE", printService);
        PageFormat selPf = ((AtPrintDialog)this.printDialog).getSelectedPageFormat();
        double rm = lm = selPf.getImageableX();
        double bm = tm = selPf.getImageableY();
        double width = selPf.getWidth();
        double height = selPf.getHeight();
        String dialogPaperName = MediaUtil.getFilteredPaper("", tm, lm, bm, rm, width, height);
        this.webContext.debug("paperName (from print dialog)=" + dialogPaperName);
        this.webDoc.setAttribute("PAPER", dialogPaperName);
        PrintQuality pq = this.printDialog.getPrintQuality();
        String dialogQualityName = PrintUtil.getPrintQuality(pq);
        this.webDoc.setAttribute("PRINT_QUALITY", dialogQualityName);
        Sides sides = this.printDialog.getSideToPrint();
        String sideToPrint = MediaUtil.getMediaSide(sides);
        this.webDoc.setAttribute("SIDE_TO_PRINT", sideToPrint);
        boolean dialogAutoMatchPaper = this.printDialog.isChoosePaperSourceByPageSize();
        this.webDoc.setBooleanAttribute("AUTO_MATCH_PAPER", dialogAutoMatchPaper);
        int dialogCopies = this.printDialog.getCopies();
        this.webDoc.setAttribute("COPIES", new Integer(dialogCopies));
        boolean dialogCollateCopies = this.printDialog.isCollate();
        this.webDoc.setBooleanAttribute("COLLATE_COPIES", dialogCollateCopies);
        String dialogJobName = this.printDialog.getPrintJobName();
        this.webDoc.setAttribute("JOB_NAME", dialogJobName);
        int dialogPageScaling = this.printDialog.getPageScaling();
        this.webDoc.setAttribute("PAGE_SCALING", new Integer(dialogPageScaling));
        boolean dialogAutoRotateAndCenter = this.printDialog.isAutoRotateAndCenter();
        this.webDoc.setBooleanAttribute("AUTO_ROTATE_AND_CENTER", dialogAutoRotateAndCenter);
        boolean dialogUsePrinterMargins = this.printDialog.isUsePrinterMargins();
        this.webDoc.setBooleanAttribute("IS_USE_PRINTER_MARGINS", dialogUsePrinterMargins);
        this.downloadPrintDialogCustomParams();
    }

    protected Integer getIntegerParameter(String paramName, Integer defaultValue) {
        String orgValue = this.getParameter(paramName);
        Integer value = defaultValue;
        try {
            value = new Integer(Integer.parseInt(orgValue));
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.webContext.debug("getIntegerParameter(" + paramName + "), orgValue=\"" + orgValue + "\" -> retVal=\"" + value + "\"");
        return value;
    }

    protected Number getNumberParameter(String paramName, Number defaultValue) {
        String orgValue = this.getParameter(paramName);
        Number value = defaultValue;
        try {
            value = new Double(Double.parseDouble(orgValue));
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.webContext.debug("getNumberParameter(" + paramName + "), orgValue=\"" + orgValue + "\" -> retVal=\"" + value + "\"");
        return value;
    }

    protected Integer getPageScalingParameter(String paramName, Integer defailtValue) {
        Integer pageScaling = defailtValue;
        String orgValue = this.getStringParameter(paramName, null);
        if (orgValue != null && orgValue.equalsIgnoreCase("FIT_TO_PRINTABLE_AREA")) {
            pageScaling = new Integer(11);
        } else if (orgValue != null && orgValue.equalsIgnoreCase("SHRINK_TO_PRINTABLE_AREA")) {
            pageScaling = new Integer(12);
        } else if (orgValue != null && orgValue.equalsIgnoreCase("NONE")) {
            pageScaling = new Integer(10);
        }
        this.webContext.debug("getPageScalingParameter(" + paramName + "), orgValue=\"" + orgValue + "\" -> retVal=\"" + pageScaling + "\"");
        return pageScaling;
    }

    public Object getDocListObject(String param) {
        Object o = this.getObjectParameter(param);
        return o;
    }

    public DocListener loadDocListener(String param) {
        String docListenerCls = this.getParameter(param);
        boolean docListenerFound = this.isClassFound(docListenerCls);
        AtDebug.debug("docListenerFound? " + docListenerFound);
        DocListener docListener = null;
        if (docListenerFound) {
            try {
                Class cls = this.loadClass(docListenerCls);
                docListener = (DocListener)cls.newInstance();
            }
            catch (Throwable t) {
                AtDebug.debug(7, "WARNING: DocListener not found - " + t.getMessage());
            }
        }
        AtDebug.debug("loadDocListener() got DocListener=" + docListener);
        return docListener;
    }

    protected String getStringParameter(String paramName, String defaultValue) {
        String orgValue = this.getParameter(paramName);
        String value = orgValue;
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.equalsIgnoreCase("null") || value.length() == 0) {
            value = defaultValue;
        }
        if (!paramName.equalsIgnoreCase("LICENSE_KEY")) {
            this.webContext.debug("getStringParameter(" + paramName + "), orgValue=\"" + orgValue + "\" -> retVal=\"" + value + "\"");
        }
        return value;
    }

    protected Boolean getBooleanParameter(String paramName, Boolean defaultValue) {
        String orgValue = this.getParameter(paramName);
        Boolean value = defaultValue;
        try {
            if (orgValue != null && orgValue.equalsIgnoreCase(Boolean.TRUE.toString())) {
                value = Boolean.TRUE;
            } else if (orgValue != null && orgValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
                value = Boolean.FALSE;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.webContext.debug("getBooleanParameter(" + paramName + "), orgValue=\"" + orgValue + "\" -> retVal=\"" + value + "\"");
        return value;
    }

    protected boolean hasDocList(List docList) {
        return docList != null && docList.size() > 0;
    }

    protected void showNoDocError(WebContext webContext) {
    }

    protected String getDocListString(List docList) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; docList != null && i < docList.size(); ++i) {
            Object doc = docList.get(i);
            String aDoc = doc instanceof String ? (String)doc : doc.toString();
            buf.append('[');
            buf.append(aDoc);
            buf.append(']');
        }
        return buf.toString();
    }

    public Class loadClass(String clsName) throws ClassNotFoundException {
        Class<?> cls = Class.forName(clsName);
        return cls;
    }

    public boolean isClassFound(String clsName) {
        try {
            Class<?> cls = Class.forName(clsName);
            if (cls != null) {
                AtDebug.debug("\"" + clsName + "\" found in class path? - OK.");
                return true;
            }
        }
        catch (Throwable t) {
            AtDebug.debug("Class.forName(" + clsName + ") Got EXCEPTION=" + t.getMessage());
        }
        return false;
    }

    public void processPrinterError(Pageable pages, AbstractPrinter printer) {
        if (pages == null || pages.getNumberOfPages() == 0 || printer.hasError()) {
            String errMsg = printer.getErrorMessage();
            throw new RuntimeException(errMsg);
        }
    }

    protected abstract void setLicenseKey(String var1);

    protected abstract PrintDialog createPrintDialog();

    protected abstract void downloadPrintDialogCustomParams();

    protected abstract DefaultCommonAttributeReader createWebDoc();

    protected abstract WebContext createWebContext(DefaultCommonAttributeReader var1);

    public static PageFormat getPageFormatForSelectedMediaName(String paper, WebContext context) {
        ArrayList paperParams = WebDocAttributeParser.getPaperParams(paper, context);
        double topMargin = (Double)paperParams.get(0);
        double leftMargin = (Double)paperParams.get(1);
        double bottomMargin = (Double)paperParams.get(2);
        double rightMargin = (Double)paperParams.get(3);
        String width = (String)paperParams.get(4);
        String height = (String)paperParams.get(5);
        String paperSizePixelString = "(" + width + "," + height + ")";
        double tolerance = 1.0;
        double widthPixels = Double.parseDouble(width);
        double heightPixels = Double.parseDouble(height);
        if (widthPixels <= 0.0 || heightPixels <= 0.0) {
            PageFormat pf = new PageFormat();
            widthPixels = pf.getWidth();
            heightPixels = pf.getHeight();
        }
        Rectangle2D.Double printableArea = new Rectangle2D.Double(0.0, 0.0, widthPixels, heightPixels);
        AtMediaSizeObject foundMso = StandardPapers.getMatchedMediaSizeObject(printableArea, tolerance);
        PageFormat retPf = null;
        if (foundMso == null) {
            retPf = MediaUtil.getSelectedPageFormat(printableArea, 0.0, 0.0, 0.0, 0.0, 1);
            context.debug("No matched MediaSizeName for input PAPER=" + paperSizePixelString + " pixels.");
            context.debug("Using input PAPER size");
            MediaUtil.debugPageFormat(retPf);
        } else {
            context.debug("Input paper size " + paperSizePixelString + " matched with \"" + foundMso.getMediaSizeNameWithInchAndPixel() + "\".");
            MediaSizeName mediaSizeName = foundMso.getMediaSizeName();
            retPf = MediaUtil.getSelectedPageFormat(mediaSizeName, leftMargin, rightMargin, topMargin, bottomMargin);
        }
        String pfStr = MediaUtil.getDebugString(retPf);
        context.debug("Using PageFormat=" + pfStr);
        return retPf;
    }

    public static ArrayList getPaperParams(String paper, WebContext context) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tk = new StringTokenizer(paper, "(),");
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            tokens.add(token);
        }
        context.debug("tokens=" + tokens);
        if (tokens.size() < 6) {
            throw new RuntimeException("Invalid PAPER \"" + paper + "\". Valid format is \"(topMargin, leftMargin, bottomMargin, rightMargin, paperWidth, paperHeight)\".");
        }
        String tm = (String)tokens.get(0);
        tm = tm.trim();
        String lm = (String)tokens.get(1);
        lm = lm.trim();
        String bm = (String)tokens.get(2);
        bm = bm.trim();
        String rm = (String)tokens.get(3);
        rm = rm.trim();
        String widthStr = (String)tokens.get(4);
        widthStr = widthStr.trim();
        String heightStr = (String)tokens.get(5);
        heightStr = heightStr.trim();
        context.debug("input paper parsed to: (tm=" + tm + ",lm=" + lm + ",bm=" + bm + ",rm=" + rm + ") paper=" + paper);
        double topMargin = context.getWebDoc().getPrimitiveDoubleAttribute("PAPER_TOP_MARGIN");
        double leftMargin = context.getWebDoc().getPrimitiveDoubleAttribute("PAPER_LEFT_MARGIN");
        double bottomMargin = context.getWebDoc().getPrimitiveDoubleAttribute("PAPER_BOTTOM_MARGIN");
        double rightMargin = context.getWebDoc().getPrimitiveDoubleAttribute("PAPER_RIGHT_MARGIN");
        double paperWidth = context.getWebDoc().getPrimitiveDoubleAttribute("PAPER_WIDTH");
        double paperHeight = context.getWebDoc().getPrimitiveDoubleAttribute("PAPER_HEIGHT");
        try {
            topMargin = Double.parseDouble(tm);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            leftMargin = Double.parseDouble(lm);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            bottomMargin = Double.parseDouble(bm);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            rightMargin = Double.parseDouble(rm);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            paperWidth = Double.parseDouble(widthStr);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            paperHeight = Double.parseDouble(heightStr);
        }
        catch (Throwable t) {
            // empty catch block
        }
        context.debug("paper margins: " + topMargin + "," + leftMargin + "," + bottomMargin + "," + rightMargin);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(new Double(topMargin));
        params.add(new Double(leftMargin));
        params.add(new Double(bottomMargin));
        params.add(new Double(rightMargin));
        params.add("" + paperWidth);
        params.add("" + paperHeight);
        return params;
    }
}

