/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.xml;

import com.activetree.common.data.ColorData;
import com.activetree.common.data.FontData;
import com.activetree.common.data.InsetsData;
import com.activetree.common.data.PointData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlPropertyParser
implements Serializable {
    public static Node getProperty(String propertyName, NodeList propertiesList) {
        for (int i = 0; propertiesList != null && i < propertiesList.getLength(); ++i) {
            String nodeName;
            Node aProperty = propertiesList.item(i);
            if (!(aProperty instanceof Element) || (nodeName = aProperty.getNodeName()) == null || !(nodeName = nodeName.trim()).equalsIgnoreCase(propertyName)) continue;
            return aProperty;
        }
        return null;
    }

    public static String getPropertyValue(Node property) {
        if (property == null) {
            return null;
        }
        NodeList childs = property.getChildNodes();
        for (int i = 0; childs != null && i < childs.getLength(); ++i) {
            String value;
            Node aChildNode = childs.item(i);
            if (!(aChildNode instanceof Text) || (value = aChildNode.getNodeValue()) == null) continue;
            value = value.trim();
            return value;
        }
        return null;
    }

    public static String parseString(NamedNodeMap attrs, String propertyName) {
        if (attrs == null) {
            return null;
        }
        Node node = attrs.getNamedItem(propertyName);
        if (node == null) {
            return null;
        }
        String s = node.getNodeValue();
        if (s != null && (s = s.trim()).equalsIgnoreCase("")) {
            return null;
        }
        return s;
    }

    public static PointData parsePointFromString(String point) {
        PointData pd = null;
        try {
            StringTokenizer tk = new StringTokenizer(point, ",");
            ArrayList<String> items = new ArrayList<String>();
            while (tk.hasMoreTokens()) {
                String valueStr = tk.nextToken();
                if (valueStr == null) continue;
                valueStr = valueStr.trim();
                items.add(valueStr);
            }
            if (items.size() == 2) {
                double x = Double.parseDouble((String)items.get(0));
                double y = Double.parseDouble((String)items.get(1));
                pd = new PointData(x, y);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pd;
    }

    public static PointData parse2DNumber(NodeList childProperties, String propertyName) {
        String value = XmlPropertyParser.parseString(childProperties, propertyName);
        PointData pd = XmlPropertyParser.parsePointFromString(value);
        return pd;
    }

    public static String parseString(NodeList childProperties, String propertyName) {
        if (childProperties == null) {
            return null;
        }
        Node prop = XmlPropertyParser.getProperty(propertyName, childProperties);
        String value = XmlPropertyParser.getPropertyValue(prop);
        return value;
    }

    public static String getAttributeValue(NamedNodeMap attrs, String propertyName) {
        if (attrs == null) {
            return null;
        }
        Node insets = attrs.getNamedItem(propertyName);
        if (insets == null) {
            return null;
        }
        String s = insets.getNodeValue();
        return s;
    }

    public static Double parseNumber(NamedNodeMap attrs, String propertyName) {
        String s = XmlPropertyParser.getAttributeValue(attrs, propertyName);
        if (s != null) {
            s = s.trim();
            try {
                double num = Double.parseDouble(s);
                return new Double(num);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static Double parseNumber(NodeList childProperties, String propertyName) {
        String value = XmlPropertyParser.parseString(childProperties, propertyName);
        try {
            double d = Double.parseDouble(value);
            return new Double(d);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String[] parseStringArray(NodeList childProperties, String propertyName) {
        String value = XmlPropertyParser.parseString(childProperties, propertyName);
        try {
            StringTokenizer tk = new StringTokenizer(value, ",");
            ArrayList<String> items = new ArrayList<String>();
            while (tk.hasMoreTokens()) {
                String valueStr = tk.nextToken();
                if (valueStr == null) continue;
                valueStr = valueStr.trim();
                items.add(valueStr);
            }
            String[] retVal = new String[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                retVal[i] = (String)items.get(i);
            }
            return retVal;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static InsetsData parseInsets(NamedNodeMap attrs, String propertyName) {
        String s = XmlPropertyParser.getAttributeValue(attrs, propertyName);
        InsetsData id = XmlPropertyParser.parseInsetsFromString(s);
        return id;
    }

    public static InsetsData parseInsets(NodeList childProperties, String propertyName) {
        String value = XmlPropertyParser.parseString(childProperties, propertyName);
        if (value == null) {
            return null;
        }
        InsetsData id = XmlPropertyParser.parseInsetsFromString(value);
        return id;
    }

    public static InsetsData parseInsetsFromString(String insets) {
        InsetsData id = null;
        try {
            StringTokenizer tk = new StringTokenizer(insets, ",");
            ArrayList<Integer> items = new ArrayList<Integer>();
            while (tk.hasMoreTokens()) {
                String valueStr = tk.nextToken();
                if (valueStr == null) continue;
                valueStr = valueStr.trim();
                int value = Integer.parseInt(valueStr);
                items.add(new Integer(value));
            }
            if (items.size() == 4) {
                int top = (Integer)items.get(0);
                int left = (Integer)items.get(1);
                int bottom = (Integer)items.get(2);
                int right = (Integer)items.get(3);
                id = new InsetsData(top, left, bottom, right);
            }
            return id;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ColorData parseColor(NamedNodeMap attrs, String propertyName) {
        String s = XmlPropertyParser.getAttributeValue(attrs, propertyName);
        ColorData cd = XmlPropertyParser.parseColorFromString(s);
        return cd;
    }

    public static ColorData parseColor(NodeList childProperties, String propertyName) {
        String value = XmlPropertyParser.parseString(childProperties, propertyName);
        ColorData cd = XmlPropertyParser.parseColorFromString(value);
        return cd;
    }

    public static ColorData parseColorFromString(String color) {
        ColorData cd = null;
        try {
            StringTokenizer tk = new StringTokenizer(color, ",");
            ArrayList<Integer> items = new ArrayList<Integer>();
            while (tk.hasMoreTokens()) {
                String valueStr = tk.nextToken();
                valueStr = valueStr.trim();
                int i = Integer.parseInt(valueStr);
                items.add(new Integer(i));
            }
            if (items.size() == 4) {
                int red = (Integer)items.get(0);
                int green = (Integer)items.get(1);
                int blue = (Integer)items.get(2);
                int alpha = (Integer)items.get(3);
                cd = new ColorData(red, green, blue, alpha);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return cd;
    }

    public static FontData parseFont(NodeList childProperties, String propertyName) {
        String value = XmlPropertyParser.parseString(childProperties, propertyName);
        FontData fd = XmlPropertyParser.parseFontFromString(value);
        return fd;
    }

    public static FontData parseFont(NamedNodeMap attrs, String propertyName) {
        String s = XmlPropertyParser.getAttributeValue(attrs, propertyName);
        FontData fd = XmlPropertyParser.parseFontFromString(s);
        return fd;
    }

    public static FontData parseFontFromString(String font) {
        FontData fd = null;
        try {
            StringTokenizer tk = new StringTokenizer(font, ",");
            ArrayList<String> items = new ArrayList<String>();
            while (tk.hasMoreTokens()) {
                String valueStr = tk.nextToken();
                if (valueStr == null) continue;
                valueStr = valueStr.trim();
                items.add(valueStr);
            }
            if (items.size() == 3) {
                String fontName = (String)items.get(0);
                String fontStyle = (String)items.get(1);
                int fontSize = Integer.parseInt((String)items.get(2));
                fd = new FontData(fontName, fontStyle, fontSize);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return fd;
    }

    public static Boolean parseBoolean(NamedNodeMap attrs, String propertyName) {
        if (attrs == null) {
            return null;
        }
        Node node = attrs.getNamedItem(propertyName);
        if (node == null) {
            return null;
        }
        String s = node.getNodeValue();
        if (s != null) {
            s = s.trim();
        }
        if (s != null) {
            if (s.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (s.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static Boolean parseBoolean(NodeList childProperties, String propertyName) {
        if (childProperties == null) {
            return null;
        }
        Node prop = XmlPropertyParser.getProperty(propertyName, childProperties);
        String value = XmlPropertyParser.getPropertyValue(prop);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (value.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

