/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.tiff.viewer;

import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.resource.AtImageList;
import com.activetree.common.utils.AtDebug;
import com.activetree.tiff.viewer.TiffViewPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.JFrame;

public class TiffViewFrame
extends JFrame {
    protected TiffViewPane pdfViewPane;

    public TiffViewFrame() {
        this(true);
    }

    public TiffViewFrame(boolean bl) {
        this(bl, true);
    }

    public TiffViewFrame(boolean bl, boolean bl2) {
        this.pdfViewPane = this.createPdfViewPane(bl, bl2);
        this.setupContentPane();
        this.setIconImage(AtImageList.IMAGE_LIST.ACTIVETREE_ICON_SMALL.getImage());
        this.setWindowTitle();
    }

    protected void setWindowTitle() {
        String string = AtCommonResource.MESSAGE_RESOURCE.getText("SMARTJTIFF_VIEWER");
        String string2 = AtCommonResource.MESSAGE_RESOURCE.getText("COMPANY_NAME");
        this.setTitle(string);
    }

    protected TiffViewPane createPdfViewPane(boolean bl, boolean bl2) {
        TiffViewPane tiffViewPane = new TiffViewPane(bl, bl2);
        return tiffViewPane;
    }

    public TiffViewPane getTiffViewPane() {
        return this.pdfViewPane;
    }

    protected void setupContentPane() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)((Object)this.pdfViewPane), "Center");
        Rectangle rectangle = this.pdfViewPane.getUserPreferredViewSize();
        Dimension dimension = this.pdfViewPane.getDefaultViewSize();
        AtDebug.debug((String)("user pref bounds=" + rectangle));
        if (rectangle != null) {
            this.setBounds(rectangle);
        } else {
            this.setSize(dimension);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TiffViewFrame.this.pdfViewPane.destroy();
                TiffViewFrame.this.setVisible(false);
                TiffViewFrame.this.dispose();
            }
        });
    }

    public void showPdf(File file) {
        this.pdfViewPane.showDocument(file);
    }

    public void showPdf(URL uRL) {
        this.pdfViewPane.showDocument(uRL);
    }

    public void showPdf(byte[] byArray) {
        this.pdfViewPane.showDocument(byArray);
    }
}

